/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.mySVM.SVM;

import edu.udo.cs.mySVM.Examples.Example;
import edu.udo.cs.mySVM.Examples.ExampleSet;
import edu.udo.cs.mySVM.Kernel.Kernel;
import edu.udo.cs.mySVM.Optimizer.quadraticProblem;
import edu.udo.cs.mySVM.Optimizer.quadraticProblemSMO;
import edu.udo.cs.mySVM.SVM.SVMInterface;
import edu.udo.cs.mySVM.Util.MaxHeap;
import edu.udo.cs.mySVM.Util.MinHeap;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.tools.LogService;

public abstract class SVM
implements SVMInterface {
    private static final int[] YALE_VERBOSITY = new int[]{2, 2, 2, 0, 0};
    protected Kernel the_kernel;
    protected ExampleSet the_examples;
    double[] alphas;
    double[] ys;
    protected int examples_total;
    protected int target_count;
    protected double convergence_epsilon = 0.001;
    protected double lambda_factor;
    protected int[] at_bound;
    protected double[] sum;
    protected boolean[] which_alpha;
    protected int[] working_set;
    protected double[] primal;
    protected double sum_alpha;
    protected double lambda_eq;
    protected int to_shrink;
    protected double feasible_epsilon;
    protected double lambda_WS;
    protected boolean quadraticLossPos = false;
    protected boolean quadraticLossNeg = false;
    boolean shrinked;
    protected double epsilon_pos = 0.0;
    protected double epsilon_neg = 0.0;
    private int max_iterations = 100000;
    protected int working_set_size = 10;
    protected int parameters_working_set_size = 10;
    protected double is_zero = 1.0E-10;
    protected int shrink_const = 50;
    protected double C = 1.0;
    protected double[] Cpos;
    protected double[] Cneg;
    protected double descend = 1.0E-15;
    MinHeap heap_min;
    MaxHeap heap_max;
    protected quadraticProblem qp;

    public SVM() {
    }

    public SVM(Operator paramOperator, Kernel new_kernel, ExampleSet new_examples, edu.udo.cs.yale.example.ExampleSet yaleExamples) {
        this.the_examples = new_examples;
        this.max_iterations = paramOperator.getParameterAsInt("max_iterations");
        this.convergence_epsilon = paramOperator.getParameterAsDouble("convergence_epsilon");
        this.quadraticLossPos = paramOperator.getParameterAsBoolean("quadratic_loss_pos");
        this.quadraticLossNeg = paramOperator.getParameterAsBoolean("quadratic_loss_neg");
        this.Cpos = new double[yaleExamples.getSize()];
        this.Cneg = new double[yaleExamples.getSize()];
        Attribute weightAttribute = yaleExamples.getAttribute("weight");
        if (weightAttribute != null) {
            ExampleReader reader = yaleExamples.getExampleReader();
            int index = 0;
            while (reader.hasNext()) {
                edu.udo.cs.yale.example.Example example = reader.next();
                this.Cpos[index] = this.Cneg[index] = example.getValue(weightAttribute);
            }
            if (paramOperator.getParameterAsBoolean("balance_cost")) {
                this.logWarning("Since the example set contains a weight attribute, the parameter balance_cost will be ignored.");
            }
            this.logln(1, "Use defined weight attribute for example weights.");
        } else {
            Attribute weightPosAttribute = yaleExamples.getAttribute("weight_pos");
            Attribute weightNegAttribute = yaleExamples.getAttribute("weight_neg");
            if (weightPosAttribute != null && weightNegAttribute != null) {
                ExampleReader reader = yaleExamples.getExampleReader();
                int index = 0;
                while (reader.hasNext()) {
                    edu.udo.cs.yale.example.Example example = reader.next();
                    this.Cpos[index] = example.getValue(weightPosAttribute);
                    this.Cneg[index] = example.getValue(weightNegAttribute);
                    ++index;
                }
                if (paramOperator.getParameterAsBoolean("balance_cost")) {
                    this.logWarning("Since the example set contains a weight attribute, the parameter balance_cost will be ignored.");
                }
                this.logln(1, "Use defined weight_pos and weight_neg attributes for example weights.");
            } else {
                double generalCpos = paramOperator.getParameterAsDouble("L_pos");
                double generalCneg = paramOperator.getParameterAsDouble("L_neg");
                if (paramOperator.getParameterAsBoolean("balance_cost")) {
                    generalCpos *= (double)this.the_examples.count_examples() / (2.0 * (double)(this.the_examples.count_examples() - this.the_examples.count_pos_examples()));
                    generalCneg *= (double)this.the_examples.count_examples() / (2.0 * (double)this.the_examples.count_pos_examples());
                }
                for (int i = 0; i < this.Cpos.length; ++i) {
                    this.Cpos[i] = generalCpos;
                    this.Cneg[i] = generalCneg;
                }
            }
        }
        this.C = paramOperator.getParameterAsDouble("C");
        double epsilonValue = paramOperator.getParameterAsDouble("epsilon");
        if (epsilonValue != -1.0) {
            this.epsilon_pos = this.epsilon_neg = epsilonValue;
        } else {
            this.epsilon_pos = paramOperator.getParameterAsDouble("epsilon+");
            this.epsilon_neg = paramOperator.getParameterAsDouble("epsilon-");
        }
    }

    public void init(Kernel new_kernel, ExampleSet new_examples) {
        int i;
        this.the_kernel = new_kernel;
        this.the_examples = new_examples;
        this.examples_total = this.the_examples.count_examples();
        this.parameters_working_set_size = this.working_set_size;
        if (this.C <= 0.0) {
            this.C = 0.0;
            for (i = 0; i < this.examples_total; ++i) {
                this.C += this.the_kernel.calculate_K(i, i);
            }
            this.C = (double)this.examples_total / this.C;
            this.logln(3, "C set to " + this.C);
        }
        if (this.Cpos != null) {
            i = 0;
            while (i < this.Cpos.length) {
                int n = i;
                this.Cpos[n] = this.Cpos[n] * this.C;
                int n2 = i++;
                this.Cneg[n2] = this.Cneg[n2] * this.C;
            }
        }
        this.lambda_factor = 1.0;
        this.lambda_eq = 0.0;
        this.target_count = 0;
        this.sum_alpha = 0.0;
        this.feasible_epsilon = this.convergence_epsilon;
        this.alphas = this.the_examples.get_alphas();
        this.ys = this.the_examples.get_ys();
    }

    public void train() {
        int i;
        if (this.examples_total <= 0) {
            this.the_examples.set_b(Double.NaN);
            return;
        }
        if (this.examples_total == 1) {
            this.the_examples.set_b(this.ys[0]);
            return;
        }
        this.target_count = 0;
        this.shrinked = false;
        this.init_optimizer();
        this.init_working_set();
        int iteration = 0;
        boolean converged = false;
        while (iteration < this.max_iterations) {
            this.logln(4, "optimizer iteration " + ++iteration);
            this.optimize();
            this.put_optimizer_values();
            converged = this.convergence();
            if (converged) {
                this.logln(3, "");
                this.project_to_constraint();
                if (this.shrinked) {
                    this.logln(2, "***** Checking convergence for all variables");
                    this.reset_shrinked();
                    converged = this.convergence();
                }
                if (converged) {
                    this.logln(1, "*** Convergence");
                    break;
                }
                this.shrink_const += 10;
                this.target_count = 0;
                for (i = 0; i < this.examples_total; ++i) {
                    this.at_bound[i] = 0;
                }
            }
            this.shrink();
            this.calculate_working_set();
            this.update_working_set();
        }
        if (iteration >= this.max_iterations && !converged) {
            this.logln(1, "*** No convergence: Time up.");
            if (this.shrinked) {
                this.reset_shrinked();
            }
        }
        double new_b = 0.0;
        int new_b_count = 0;
        for (i = 0; i < this.examples_total; ++i) {
            if (this.alphas[i] - this.Cneg[i] < -this.is_zero && this.alphas[i] > this.is_zero) {
                new_b += this.ys[i] - this.sum[i] - this.epsilon_neg;
                ++new_b_count;
                continue;
            }
            if (!(this.alphas[i] + this.Cpos[i] > this.is_zero) || !(this.alphas[i] < -this.is_zero)) continue;
            new_b += this.ys[i] - this.sum[i] + this.epsilon_pos;
            ++new_b_count;
        }
        if (new_b_count > 0) {
            this.the_examples.set_b(new_b / (double)new_b_count);
        } else {
            for (i = 0; i < this.examples_total; ++i) {
                if (!(this.alphas[i] < this.is_zero) || !(this.alphas[i] > -this.is_zero)) continue;
                new_b += this.ys[i] - this.sum[i];
                ++new_b_count;
            }
            if (new_b_count > 0) {
                this.the_examples.set_b(new_b / (double)new_b_count);
            } else {
                for (i = 0; i < this.examples_total; ++i) {
                    new_b += this.ys[i] - this.sum[i];
                    ++new_b_count;
                }
                this.the_examples.set_b(new_b / (double)new_b_count);
            }
        }
        this.logln(2, "Done training: " + iteration + " iterations.");
        double now_target = 0.0;
        double now_target_dummy = 0.0;
        for (i = 0; i < this.examples_total; ++i) {
            now_target_dummy = this.sum[i] / 2.0 - this.ys[i];
            now_target_dummy = this.is_alpha_neg(i) ? (now_target_dummy += this.epsilon_pos) : (now_target_dummy -= this.epsilon_neg);
            now_target += this.alphas[i] * now_target_dummy;
        }
        this.logln(2, "Target function: " + now_target);
        this.print_statistics();
        this.exit_optimizer();
    }

    protected void print_statistics() {
        int j;
        double alpha;
        int i;
        int dim = this.the_examples.get_dim();
        int svs = 0;
        int bsv = 0;
        double mae = 0.0;
        double mse = 0.0;
        int countpos = 0;
        int countneg = 0;
        double min_lambda = Double.MAX_VALUE;
        double b = this.the_examples.get_b();
        for (i = 0; i < this.examples_total; ++i) {
            if (this.lambda(i) < min_lambda) {
                min_lambda = this.lambda(i);
            }
            double y = this.ys[i];
            double prediction = this.sum[i] + b;
            mae += Math.abs(y - prediction);
            mse += (y - prediction) * (y - prediction);
            alpha = this.alphas[i];
            if (y < prediction - this.epsilon_pos) {
                ++countpos;
            } else if (y > prediction + this.epsilon_neg) {
                ++countneg;
            }
            if (alpha == 0.0) continue;
            ++svs;
            if (alpha != this.Cpos[i] && alpha != -this.Cneg[i]) continue;
            ++bsv;
        }
        mae /= (double)this.examples_total;
        mse /= (double)this.examples_total;
        min_lambda = -min_lambda;
        this.logln(1, "Error on KKT is " + min_lambda);
        this.logln(1, svs + " SVs");
        this.logln(1, bsv + " BSVs");
        this.logln(1, "MAE " + mae);
        this.logln(1, "MSE " + mse);
        this.logln(1, countpos + " pos loss");
        this.logln(1, countneg + " neg loss");
        double[] w = new double[dim];
        for (j = 0; j < dim; ++j) {
            w[j] = 0.0;
        }
        for (i = 0; i < this.examples_total; ++i) {
            double[] x = this.the_examples.get_example(i).toDense(dim);
            alpha = this.alphas[i];
            for (j = 0; j < dim; ++j) {
                int n = j;
                w[n] = w[n] + alpha * x[j];
            }
        }
        for (j = 0; j < dim; ++j) {
            this.logln(2, "w[" + j + "] = " + w[j]);
        }
        this.logln(2, "b = " + b);
        if (dim == 1) {
            this.logln(2, "y = " + w[0] + "*x+" + b);
        }
    }

    public double[] getWeights() {
        int dim = this.the_examples.get_dim();
        double[] w = new double[dim];
        for (int j = 0; j < dim; ++j) {
            w[j] = 0.0;
        }
        for (int i = 0; i < this.examples_total; ++i) {
            double[] x = this.the_examples.get_example(i).toDense(dim);
            double alpha = this.alphas[i];
            for (int j = 0; j < dim; ++j) {
                int n = j;
                w[n] = w[n] + alpha * x[j];
            }
        }
        return w;
    }

    public double getB() {
        return this.the_examples.get_b();
    }

    public double getC() {
        return this.C;
    }

    protected void init_optimizer() {
        int i;
        this.which_alpha = new boolean[this.working_set_size];
        this.primal = new double[this.working_set_size];
        this.sum = new double[this.examples_total];
        this.at_bound = new int[this.examples_total];
        if (this.working_set_size > this.examples_total) {
            this.working_set_size = this.examples_total;
        }
        this.qp = new quadraticProblemSMO(this.is_zero / 100.0, this.convergence_epsilon / 100.0, this.working_set_size * this.working_set_size);
        this.qp.set_n(this.working_set_size);
        this.working_set = new int[this.working_set_size];
        this.heap_max = new MaxHeap(0);
        this.heap_min = new MinHeap(0);
        for (i = 0; i < this.working_set_size; ++i) {
            this.qp.l[i] = 0.0;
        }
        if (this.quadraticLossPos) {
            for (i = 0; i < this.Cpos.length; ++i) {
                this.Cpos[i] = Double.MAX_VALUE;
            }
        }
        if (this.quadraticLossNeg) {
            for (i = 0; i < this.Cneg.length; ++i) {
                this.Cneg[i] = Double.MAX_VALUE;
            }
        }
        for (i = 0; i < this.examples_total; ++i) {
            this.alphas[i] = 0.0;
        }
        this.lambda_WS = 0.0;
        this.to_shrink = 0;
        this.qp.set_n(this.working_set_size);
    }

    protected void exit_optimizer() {
        this.qp = null;
    }

    protected void shrink() {
        if (this.to_shrink > this.examples_total / 10) {
            int last_pos = this.examples_total;
            if (last_pos > this.working_set_size) {
                for (int i = 0; i < last_pos; ++i) {
                    if (this.at_bound[i] < this.shrink_const) continue;
                    this.sum_alpha += this.alphas[i];
                    this.the_examples.swap(i, --last_pos);
                    this.the_kernel.swap(i, last_pos);
                    this.sum[i] = this.sum[last_pos];
                    this.at_bound[i] = this.at_bound[last_pos];
                    if (last_pos <= this.working_set_size) break;
                }
                this.to_shrink = 0;
                this.shrinked = true;
                if (last_pos < this.examples_total) {
                    this.examples_total = last_pos;
                    this.the_kernel.set_examples_size(this.examples_total);
                }
            }
            this.logln(4, "shrinked to " + this.examples_total + " variables");
        }
    }

    protected void reset_shrinked() {
        int i;
        int old_ex_tot = this.examples_total;
        this.target_count = 0;
        this.examples_total = this.the_examples.count_examples();
        this.the_kernel.set_examples_size(this.examples_total);
        for (i = old_ex_tot; i < this.examples_total; ++i) {
            this.sum[i] = 0.0;
            this.at_bound[i] = 0;
        }
        for (i = 0; i < this.examples_total; ++i) {
            double alpha = this.alphas[i];
            if (alpha == 0.0) continue;
            double[] kernel_row = this.the_kernel.get_row(i);
            for (int j = old_ex_tot; j < this.examples_total; ++j) {
                int n = j;
                this.sum[n] = this.sum[n] + alpha * kernel_row[j];
            }
        }
        this.sum_alpha = 0.0;
        this.shrinked = false;
        this.logln(5, "Resetting shrinked from " + old_ex_tot + " to " + this.examples_total);
    }

    protected void project_to_constraint() {
        double alpha;
        int i;
        double alpha_sum = this.sum_alpha;
        int SVcount = 0;
        for (i = 0; i < this.examples_total; ++i) {
            alpha = this.alphas[i];
            alpha_sum += alpha;
            if (!(alpha > this.is_zero && alpha - this.Cneg[i] < -this.is_zero) && (!(alpha < -this.is_zero) || !(alpha + this.Cpos[i] > this.is_zero))) continue;
            ++SVcount;
        }
        if (SVcount > 0) {
            alpha_sum /= (double)SVcount;
            for (i = 0; i < this.examples_total; ++i) {
                alpha = this.alphas[i];
                if (!(alpha > this.is_zero && alpha - this.Cneg[i] < -this.is_zero) && (!(alpha < -this.is_zero) || !(alpha + this.Cpos[i] > this.is_zero))) continue;
                int n = i;
                this.alphas[n] = this.alphas[n] - alpha_sum;
            }
        }
    }

    protected void calculate_working_set() {
        int i;
        if (this.working_set_size < this.parameters_working_set_size) {
            this.working_set_size = this.parameters_working_set_size;
            if (this.working_set_size > this.examples_total) {
                this.working_set_size = this.examples_total;
            }
        }
        this.heap_min.init(this.working_set_size / 2);
        this.heap_max.init(this.working_set_size / 2 + this.working_set_size % 2);
        for (i = 0; i < this.examples_total; ++i) {
            boolean is_feasible = this.feasible(i);
            if (!is_feasible) continue;
            double the_nabla = this.nabla(i);
            double sort_value = this.is_alpha_neg(i) ? -the_nabla : the_nabla;
            this.heap_min.add(sort_value, i);
            this.heap_max.add(sort_value, i);
        }
        int[] new_ws = this.heap_min.get_values();
        this.working_set_size = 0;
        int j = this.heap_min.size();
        for (i = 0; i < j; ++i) {
            this.working_set[this.working_set_size] = new_ws[i];
            ++this.working_set_size;
        }
        int pos = this.working_set_size;
        new_ws = this.heap_max.get_values();
        j = this.heap_max.size();
        for (i = 0; i < j; ++i) {
            this.working_set[this.working_set_size] = new_ws[i];
            ++this.working_set_size;
        }
        if (!this.heap_min.empty() && !this.heap_max.empty() && this.heap_min.top_value() >= this.heap_max.top_value()) {
            j = 0;
            i = 0;
            while (i < pos) {
                for (j = pos; j < this.working_set_size && this.working_set[j] != this.working_set[i]; ++j) {
                }
                if (j < this.working_set_size) {
                    this.working_set[j] = this.working_set[this.working_set_size - 1];
                    --this.working_set_size;
                    continue;
                }
                ++i;
            }
        }
        if (this.target_count > 0) {
            int max_pos;
            double max_lambda;
            double alpha;
            int pos_abs;
            boolean bounded_pos = true;
            boolean bounded_neg = true;
            for (pos = 0; pos < this.working_set_size && (bounded_pos || bounded_neg); ++pos) {
                pos_abs = this.working_set[pos];
                alpha = this.alphas[pos_abs];
                if (this.is_alpha_neg(pos_abs)) {
                    if (alpha - this.Cneg[pos_abs] < -this.is_zero) {
                        bounded_pos = false;
                    }
                    if (!(alpha > this.is_zero)) continue;
                    bounded_neg = false;
                    continue;
                }
                if (alpha + this.Cneg[pos_abs] > this.is_zero) {
                    bounded_neg = false;
                }
                if (!(alpha < -this.is_zero)) continue;
                bounded_pos = false;
            }
            if (bounded_pos) {
                max_lambda = Double.MAX_VALUE;
                max_pos = this.examples_total;
                for (pos_abs = 0; pos_abs < this.examples_total; ++pos_abs) {
                    alpha = this.alphas[pos_abs];
                    if (this.is_alpha_neg(pos_abs)) {
                        if (!(alpha - this.Cneg[pos_abs] < -this.is_zero) || !(this.lambda(pos_abs) < max_lambda)) continue;
                        max_lambda = this.lambda(pos_abs);
                        max_pos = pos_abs;
                        continue;
                    }
                    if (!(alpha < -this.is_zero) || !(this.lambda(pos_abs) < max_lambda)) continue;
                    max_lambda = this.lambda(pos_abs);
                    max_pos = pos_abs;
                }
                if (max_pos < this.examples_total) {
                    if (this.working_set_size < this.parameters_working_set_size) {
                        ++this.working_set_size;
                    }
                    this.working_set[this.working_set_size - 1] = max_pos;
                }
            } else if (bounded_neg) {
                max_lambda = Double.MAX_VALUE;
                max_pos = this.examples_total;
                for (pos_abs = 0; pos_abs < this.examples_total; ++pos_abs) {
                    alpha = this.alphas[pos_abs];
                    if (this.is_alpha_neg(pos_abs)) {
                        if (!(alpha > this.is_zero) || !(this.lambda(pos_abs) < max_lambda)) continue;
                        max_lambda = this.lambda(pos_abs);
                        max_pos = pos_abs;
                        continue;
                    }
                    if (!(alpha + this.Cneg[pos_abs] > this.is_zero) || !(this.lambda(pos_abs) < max_lambda)) continue;
                    max_lambda = this.lambda(pos_abs);
                    max_pos = pos_abs;
                }
                if (max_pos < this.examples_total) {
                    if (this.working_set_size < this.parameters_working_set_size) {
                        ++this.working_set_size;
                    }
                    this.working_set[this.working_set_size - 1] = max_pos;
                }
            }
        }
        if (this.working_set_size < this.parameters_working_set_size && this.working_set_size < this.examples_total) {
            pos = (int)(Math.random() * (double)this.examples_total);
            while (this.working_set_size < this.parameters_working_set_size && this.working_set_size < this.examples_total) {
                boolean ok = true;
                for (i = 0; i < this.working_set_size; ++i) {
                    if (this.working_set[i] != pos) continue;
                    ok = false;
                    i = this.working_set_size;
                }
                if (ok) {
                    this.working_set[this.working_set_size] = pos;
                    ++this.working_set_size;
                }
                pos = (pos + 1) % this.examples_total;
            }
        }
        for (int ipos = 0; ipos < this.working_set_size; ++ipos) {
            this.which_alpha[ipos] = this.is_alpha_neg(this.working_set[ipos]);
        }
    }

    protected void update_working_set() {
        int i;
        int pos_i;
        boolean[] my_which_alpha = this.which_alpha;
        for (pos_i = 0; pos_i < this.working_set_size; ++pos_i) {
            int j;
            int pos_j;
            i = this.working_set[pos_i];
            double[] kernel_row = this.the_kernel.get_row(i);
            double sum_WS = 0.0;
            for (pos_j = 0; pos_j < pos_i; ++pos_j) {
                j = this.working_set[pos_j];
                if (!my_which_alpha[pos_j] && !my_which_alpha[pos_i] || my_which_alpha[pos_j] && my_which_alpha[pos_i]) {
                    this.qp.H[pos_i * this.working_set_size + pos_j] = kernel_row[j];
                    this.qp.H[pos_j * this.working_set_size + pos_i] = kernel_row[j];
                    continue;
                }
                this.qp.H[pos_i * this.working_set_size + pos_j] = -kernel_row[j];
                this.qp.H[pos_j * this.working_set_size + pos_i] = -kernel_row[j];
            }
            for (pos_j = 0; pos_j < this.working_set_size; ++pos_j) {
                j = this.working_set[pos_j];
                sum_WS += this.alphas[j] * kernel_row[j];
            }
            this.qp.H[pos_i * this.working_set_size + pos_i] = kernel_row[i];
            if (!my_which_alpha[pos_i]) {
                this.qp.A[pos_i] = -1.0;
                this.qp.c[pos_i] = this.ys[i] + this.epsilon_pos - this.sum[i] + sum_WS;
                this.primal[pos_i] = -this.alphas[i];
                this.qp.u[pos_i] = this.Cpos[i];
                continue;
            }
            this.qp.A[pos_i] = 1.0;
            this.qp.c[pos_i] = -this.ys[i] + this.epsilon_neg + this.sum[i] - sum_WS;
            this.primal[pos_i] = this.alphas[i];
            this.qp.u[pos_i] = this.Cneg[i];
        }
        if (this.quadraticLossNeg) {
            for (pos_i = 0; pos_i < this.working_set_size; ++pos_i) {
                i = this.working_set[pos_i];
                if (!my_which_alpha[pos_i]) continue;
                int n = pos_i * (this.working_set_size + 1);
                this.qp.H[n] = this.qp.H[n] + 1.0 / this.Cneg[i];
                this.qp.u[pos_i] = Double.MAX_VALUE;
            }
        }
        if (this.quadraticLossPos) {
            for (pos_i = 0; pos_i < this.working_set_size; ++pos_i) {
                i = this.working_set[pos_i];
                if (my_which_alpha[pos_i]) continue;
                int n = pos_i * (this.working_set_size + 1);
                this.qp.H[n] = this.qp.H[n] + 1.0 / this.Cpos[i];
                this.qp.u[pos_i] = Double.MAX_VALUE;
            }
        }
    }

    protected void init_working_set() {
        int i;
        this.project_to_constraint();
        for (i = 0; i < this.examples_total; ++i) {
            this.sum[i] = 0.0;
            this.at_bound[i] = 0;
        }
        int j = 0;
        for (i = 0; i < this.working_set_size && j < this.examples_total; ++i, ++j) {
            this.working_set[i] = j;
            this.which_alpha[i] = this.is_alpha_neg(j);
        }
        this.update_working_set();
    }

    protected abstract void optimize();

    protected void put_optimizer_values() {
        int i = 0;
        int j = 0;
        double[] my_sum = this.sum;
        int pos_i = this.working_set_size;
        while (pos_i > 0) {
            double the_new_alpha = this.which_alpha[--pos_i] ? this.primal[pos_i] : -this.primal[pos_i];
            i = this.working_set[pos_i];
            double alpha_diff = the_new_alpha - this.alphas[i];
            this.alphas[i] = the_new_alpha;
            if (alpha_diff == 0.0) continue;
            double[] kernel_row = this.the_kernel.get_row(i);
            for (j = this.examples_total - 1; j >= 0; --j) {
                int n = j;
                my_sum[n] = my_sum[n] + alpha_diff * kernel_row[j];
            }
        }
    }

    protected boolean convergence() {
        int i;
        double the_lambda_eq = 0.0;
        int total = 0;
        double alpha_sum = 0.0;
        double alpha = 0.0;
        boolean result = true;
        total = 0;
        alpha_sum = 0.0;
        for (i = 0; i < this.examples_total; ++i) {
            alpha = this.alphas[i];
            alpha_sum += alpha;
            if (alpha > this.is_zero && alpha - this.Cneg[i] < -this.is_zero) {
                the_lambda_eq += -this.nabla(i);
                ++total;
                continue;
            }
            if (!(alpha < -this.is_zero) || !(alpha + this.Cpos[i] > this.is_zero)) continue;
            the_lambda_eq += this.nabla(i);
            ++total;
        }
        this.logln(4, "lambda_eq = " + the_lambda_eq / (double)total);
        if (total > 0) {
            this.lambda_eq = the_lambda_eq / (double)total;
        } else {
            this.lambda_eq = this.lambda_WS;
            this.logln(4, "*** no SVs in convergence(), lambda_eq = " + this.lambda_eq + ".");
        }
        if (this.target_count > 2) {
            if (this.target_count > 20) {
                this.lambda_eq = ((double)(40 - this.target_count) * this.lambda_eq + (double)(this.target_count - 20) * this.lambda_WS) / 20.0;
                this.logln(5, "Re-Re-calculated lambda from WS: " + this.lambda_eq);
                if (this.target_count > 40) {
                    i = this.working_set[this.target_count % this.working_set_size];
                    this.lambda_eq = this.is_alpha_neg(i) ? -this.nabla(i) : this.nabla(i);
                    this.logln(5, "set lambda_eq to nabla(" + i + "): " + this.lambda_eq);
                }
            } else {
                this.lambda_eq = this.lambda_WS;
                this.logln(5, "Re-calculated lambda_eq from WS: " + this.lambda_eq);
            }
        }
        if (Math.abs(alpha_sum + this.sum_alpha) > this.convergence_epsilon) {
            this.logln(4, "No convergence: equality constraint violated: |" + (alpha_sum + this.sum_alpha) + "| >> 0");
            this.project_to_constraint();
            result = false;
        }
        i = 0;
        while (i < this.examples_total && result) {
            if (this.lambda(i) >= -this.convergence_epsilon) {
                ++i;
                continue;
            }
            result = false;
        }
        return result;
    }

    protected abstract double nabla(int var1);

    protected double lambda(int i) {
        double result = this.is_alpha_neg(i) ? -Math.abs(this.nabla(i) + this.lambda_eq) : -Math.abs(this.nabla(i) - this.lambda_eq);
        double alpha = this.alphas[i];
        if (alpha > this.is_zero) {
            if (alpha - this.Cneg[i] >= -this.is_zero) {
                result = -this.lambda_eq - this.nabla(i);
            }
        } else if (alpha >= -this.is_zero) {
            result = this.is_alpha_neg(i) ? this.nabla(i) + this.lambda_eq : this.nabla(i) - this.lambda_eq;
        } else if (alpha + this.Cpos[i] <= this.is_zero) {
            result = this.lambda_eq - this.nabla(i);
        }
        return result;
    }

    protected boolean feasible(int i) {
        boolean is_feasible = true;
        double alpha = this.alphas[i];
        double the_lambda = this.lambda(i);
        if (alpha - this.Cneg[i] >= -this.is_zero) {
            if (the_lambda >= 0.0) {
                int n = i;
                this.at_bound[n] = this.at_bound[n] + 1;
                if (this.at_bound[i] == this.shrink_const) {
                    ++this.to_shrink;
                }
            } else {
                this.at_bound[i] = 0;
            }
        } else if (alpha <= this.is_zero && alpha >= -this.is_zero) {
            if (the_lambda >= 0.0) {
                int n = i;
                this.at_bound[n] = this.at_bound[n] + 1;
                if (this.at_bound[i] == this.shrink_const) {
                    ++this.to_shrink;
                }
            } else {
                this.at_bound[i] = 0;
            }
        } else if (alpha + this.Cpos[i] <= this.is_zero) {
            if (the_lambda >= 0.0) {
                int n = i;
                this.at_bound[n] = this.at_bound[n] + 1;
                if (this.at_bound[i] == this.shrink_const) {
                    ++this.to_shrink;
                }
            } else {
                this.at_bound[i] = 0;
            }
        } else {
            this.at_bound[i] = 0;
        }
        if (the_lambda >= this.feasible_epsilon || this.at_bound[i] >= this.shrink_const) {
            is_feasible = false;
        }
        return is_feasible;
    }

    protected abstract boolean is_alpha_neg(int var1);

    protected void logln(int level, String message) {
        LogService.logMessage(message, YALE_VERBOSITY[level - 1]);
    }

    protected void logWarning(String message) {
        LogService.logMessage(message, 4);
    }

    public void predict(ExampleSet to_predict) {
        int size = to_predict.count_examples();
        for (int i = 0; i < size; ++i) {
            Example example = to_predict.get_example(i);
            double prediction = this.predict(example);
            to_predict.set_y(i, prediction);
        }
        this.logln(4, "Prediction generated");
    }

    private double predict(int i) {
        return this.predict(this.the_examples.get_example(i));
    }

    protected double predict(Example example) {
        double the_sum = this.the_examples.get_b();
        for (int i = 0; i < this.examples_total; ++i) {
            double alpha = this.alphas[i];
            if (alpha == 0.0) continue;
            int[] sv_index = this.the_examples.index[i];
            double[] sv_att = this.the_examples.atts[i];
            the_sum += alpha * this.the_kernel.calculate_K(sv_index, sv_att, example.index, example.att);
        }
        return the_sum;
    }

    protected void check() {
        double s = 0.0;
        for (int i = 0; i < this.examples_total; ++i) {
            s += this.alphas[i];
            double tsum = 0.0;
            for (int j = 0; j < this.the_examples.count_examples(); ++j) {
                tsum += this.alphas[j] * this.the_kernel.calculate_K(i, j);
            }
            if (!(Math.abs(tsum - this.sum[i]) > this.is_zero)) continue;
            this.logln(1, "ERROR: sum[" + i + "] off by " + (tsum - this.sum[i]));
        }
        if (Math.abs(s + this.sum_alpha) > this.is_zero) {
            this.logln(1, "ERROR: sum_alpha is off by " + (s + this.sum_alpha));
        }
    }

    public double[] getXiAlphaEstimation(Kernel kernel) {
        double r_delta = 0.0;
        for (int j = 0; j < this.examples_total; ++j) {
            double norm_x = kernel.calculate_K(j, j);
            for (int i = 0; i < this.examples_total; ++i) {
                double r_current = norm_x - kernel.calculate_K(i, j);
                if (!(r_current > r_delta)) continue;
                r_delta = r_current;
            }
        }
        int total_pos = 0;
        int total_neg = 0;
        int estim_pos = 0;
        int estim_neg = 0;
        double xi = 0.0;
        for (int i = 0; i < this.examples_total; ++i) {
            double alpha = this.the_examples.get_alpha(i);
            double prediction = this.predict(i);
            double y = this.the_examples.get_y(i);
            if (y > 0.0) {
                xi = prediction > 1.0 ? 0.0 : 1.0 - prediction;
                if (2.0 * alpha * r_delta + xi >= 1.0) {
                    ++estim_pos;
                }
                ++total_pos;
                continue;
            }
            xi = prediction < -1.0 ? 0.0 : 1.0 + prediction;
            if (2.0 * -alpha * r_delta + xi >= 1.0) {
                ++estim_neg;
            }
            ++total_neg;
        }
        double[] result = new double[]{1.0 - (double)(estim_pos + estim_neg) / (double)(total_pos + total_neg), (double)(total_pos - estim_pos) / (double)(total_pos - estim_pos + estim_neg), 1.0 - (double)estim_pos / (double)total_pos};
        return result;
    }
}

