/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.util;

import edu.udo.cs.jvito.JViTo;
import edu.udo.cs.jvito.exception.KeyException;
import edu.udo.cs.jvito.parameter.ParameterObject;
import edu.udo.cs.jvito.util.Preferences;
import edu.udo.cs.yale.tools.FormattedPrintStream;
import edu.udo.cs.yale.tools.StreamMultiplier;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Date;

public class Logger {
    private static FormattedPrintStream logOut;
    private static StringBuffer buffer;
    private static String lastMessage;
    private static int equalMessageCount;
    private static File logFile;
    private static final String[] VERBOSITYLEVEL;
    public static final int MINIMUM = 0;
    public static final int TASK = 1;
    public static final int INIT = 2;
    public static final int PROJECT = 3;
    public static final int STATUS = 4;
    public static final int WARNING = 5;
    public static final int EXCEPTION = 6;
    public static final int ERROR = 7;
    public static final int FATAL = 8;
    public static final int MAXIMUM = 9;
    public static final int DEFAULT = 1;
    private static int minVerbosityLevel;
    public static final int OFF = 10;
    public static final String[] LOG_VERBOSITY_NAMES;

    public static void init(Preferences pref) {
        int verbosityLevel = 1;
        try {
            verbosityLevel = pref.getInt("logverbosity");
        }
        catch (KeyException error) {
            pref.setInt("logverbosity", verbosityLevel);
        }
        String filename = null;
        try {
            filename = pref.getString("logfile");
            if (filename.equals("")) {
                filename = null;
            }
        }
        catch (KeyException error) {
            // empty catch block
        }
        boolean format = true;
        if (filename == null) {
            Logger.logMessage("Logfile not set, using stderr", 5);
            logFile = null;
            Logger.init(System.err, verbosityLevel, format, -1);
        } else if (filename.equals("stderr")) {
            logFile = null;
            Logger.init(System.err, verbosityLevel, format, -1);
        } else if (filename.equals("stdout")) {
            logFile = null;
            Logger.init(System.out, verbosityLevel, format, -1);
        } else {
            OutputStream out = null;
            logFile = new File(filename);
            try {
                out = new FileOutputStream(logFile);
            }
            catch (IOException e) {
                Logger.logMessage("Cannot create logfile '" + filename + "': " + e.getClass() + ":" + e.getMessage(), 9);
                Logger.logMessage("using stderr", 9);
                out = System.err;
            }
            Logger.init(out, verbosityLevel, format, -1);
        }
    }

    public static void init(OutputStream out, int verbosityLevel, boolean format, int linewidth) {
        logOut = new FormattedPrintStream(out, format, 20, linewidth);
        minVerbosityLevel = verbosityLevel;
        Logger.logMessage("Started logging", 2);
        lastMessage = "";
        equalMessageCount = 0;
    }

    public static void initGUI() {
        OutputStream out = null;
        if (logOut != null && logFile != null) {
            try {
                out = new StreamMultiplier(new OutputStream[]{new FileOutputStream(logFile), JViTo.getApplication().logviewer.outputStream});
                JViTo.getApplication().logviewer.outputStream.write(Logger.getText().getBytes());
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot create log file: " + e);
            }
        } else {
            out = JViTo.getApplication().logviewer.outputStream;
        }
        Logger.setOutputStream(out);
        Logger.logMessage("Log verbosity is: " + LOG_VERBOSITY_NAMES[minVerbosityLevel], 9);
    }

    public static void setOutputStream(OutputStream out) {
        logOut = new FormattedPrintStream(out, false, 0, -1);
    }

    public static void close() {
        Logger.logMessage("Ended logging", 2);
        logOut.close();
    }

    public static void setVerbosityLevel(int level) {
        minVerbosityLevel = level;
        Logger.logMessage("Log verbosity changed to: " + LOG_VERBOSITY_NAMES[minVerbosityLevel], 9);
    }

    public static void logMessage(String message, int verbosityLevel) {
        if (message == null) {
            return;
        }
        if (verbosityLevel < minVerbosityLevel) {
            return;
        }
        if (message.equals(lastMessage)) {
            ++equalMessageCount;
            return;
        }
        if (equalMessageCount > 0) {
            logOut.println("Last message repeated " + equalMessageCount + " times.");
            buffer.append("Last message repeated " + equalMessageCount + " times.\n");
            equalMessageCount = 0;
        }
        lastMessage = message;
        logOut.println(Logger.getTime() + " " + VERBOSITYLEVEL[verbosityLevel] + message);
        buffer.append(Logger.getTime() + " " + VERBOSITYLEVEL[verbosityLevel] + message + "\n");
        try {
            JViTo.getApplication().logviewer.refresh();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static void logMessageWithTree(String message, int verbosityLevel, ParameterObject object) {
        if (verbosityLevel < minVerbosityLevel) {
            return;
        }
        logOut.setIndented(true);
        logOut.setIndented(false);
        Logger.logMessage(message, verbosityLevel);
        try {
            JViTo.getApplication().logviewer.refresh();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static void logException(String message, Throwable exception) {
        if (6 < minVerbosityLevel) {
            return;
        }
        Logger.logMessage(exception.getClass().getName() + " occured.", 6);
        Logger.logMessage(exception.getMessage(), 6);
        if (message != null) {
            Logger.logMessage(message, 6);
        }
        exception.printStackTrace(logOut);
        try {
            JViTo.getApplication().logviewer.refresh();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static void clear() {
        buffer = new StringBuffer();
    }

    public static String getText() {
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveLogFile(File file) {
        try {
            FileOutputStream o = new FileOutputStream(file);
            o.write(Logger.getText().getBytes());
            o.close();
        }
        catch (IOException error) {
            Logger.logException("Can't save the LogFile.", error);
        }
        finally {
            Logger.logMessage("LogFile saved.", 1);
        }
    }

    private static String getTime() {
        return DateFormat.getDateTimeInstance().format(new Date()) + ":";
    }

    static String zweistellig(int i) {
        return (i < 10 ? "0" : "") + i;
    }

    private static void fatal() {
        Logger.logMessage("JViTo terminates not successful", 9);
        System.err.println("JViTo terminates not successful");
        System.exit(0);
    }

    public static File getLogFile() {
        return logFile;
    }

    public static void setLogFile(File file) {
        OutputStream out;
        if (file == null) {
            out = System.out;
            logFile = null;
        } else {
            logFile = file;
            out = null;
            try {
                out = new FileOutputStream(logFile);
            }
            catch (IOException e) {
                Logger.logMessage("Cannot create logfile '" + file.toString() + "': " + e.getClass() + ":" + e.getMessage(), 9);
                Logger.logMessage("using stderr", 9);
                out = System.err;
            }
        }
        logOut = new FormattedPrintStream(out, true, 20, -1);
        Logger.initGUI();
    }

    public static int getVerbosityLevel() {
        return minVerbosityLevel;
    }

    static {
        buffer = new StringBuffer();
        logFile = null;
        VERBOSITYLEVEL = new String[]{"", "", "", "", "", "[Warning] ", " [Exception] ", "[Error] ", "[Fatal] ", ""};
        minVerbosityLevel = 1;
        LOG_VERBOSITY_NAMES = new String[]{"minimum", "task", "init", "project", "status", "warning", "exception", "error", "fatal", "maximum"};
        minVerbosityLevel = 0;
        logOut = new FormattedPrintStream(System.err);
    }
}

