/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.plot.svm;

import edu.udo.cs.jvito.exception.CompilerException;
import edu.udo.cs.jvito.plot.ColorPanel;
import edu.udo.cs.jvito.plot.MovingListener;
import edu.udo.cs.jvito.plot.SimplePlot;
import edu.udo.cs.jvito.plot.ZoomingListener;
import edu.udo.cs.jvito.plot.svm.FuncValueHistPanel;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class FunctionValueHistogram
extends SimplePlot {
    private JPanel display;
    private JScrollPane scrollpane;
    private Attribute attribut;
    private String[] attr_names = new String[0];
    private int number_atts = 0;
    private int number_of_samples = 0;
    private float[] labelvalues;
    private float[] predvalues;
    private String[] classes;

    public FunctionValueHistogram() {
    }

    public FunctionValueHistogram(String name) {
        this.setName(name);
    }

    private void initComponents() {
        this.display = new JPanel();
        this.display.setLayout(new BorderLayout(10, 10));
        JPanel settings = new JPanel();
        settings.setPreferredSize(new Dimension(125, settings.getHeight()));
        settings.setLayout(new BorderLayout());
        if (!this.source.isCompiled()) {
            return;
        }
        ExampleSet set = this.source.getExampleSet();
        this.initPlotPanel();
        this.display.add((Component)this.plotpanel, "Center");
        this.display.add((Component)settings, "East");
        this.initClassNames();
        Color[] colors = new Color[set.getLabel().getValues().size()];
        Collection values = set.getLabel().getValues();
        Object[] valuesstr = values.toArray();
        for (int i = 0; i < valuesstr.length; ++i) {
            colors[i] = this.source.getExampleColoring().getColorOfLabelValue(set.getLabel(), (String)valuesstr[i]);
        }
        ColorPanel colorpanel = new ColorPanel(set.getLabel(), colors, this.getParameterAsColor("foreground"), this.getParameterAsColor("background"));
        settings.add(colorpanel);
    }

    private void initClassNames() {
        this.classes = new String[this.source.getExampleSet().getLabel().getNumberOfValues()];
        Collection col = this.source.getExampleSet().getLabel().getValues();
        Iterator iter = col.iterator();
        int index = 0;
        while (iter.hasNext()) {
            this.classes[index] = (String)iter.next();
            ++index;
        }
    }

    protected void initPlotPanel() {
        ExampleSet set = this.source.getExampleSet();
        if (set.getPredictedLabel().isNumerical()) {
            this.plotpanel = new FuncValueHistPanel(this.source.getExampleColoring(), set.getLabel(), set.getPredictedLabel(), this.labelvalues, this.predvalues);
            this.plotpanel.setTitle(this.getParameterAsString("title"));
            this.plotpanel.setDrawTitle(this.getParameterAsBoolean("show title"));
            this.plotpanel.setBackgroundColor(this.getParameterAsColor("background"));
            this.plotpanel.setForegroundColor(this.getParameterAsColor("foreground"));
            ((FuncValueHistPanel)this.plotpanel).setIntervalsManually(this.getParameterAsBoolean("interval_manual"));
            ((FuncValueHistPanel)this.plotpanel).setNumberOfIntervals(this.getParameterAsInt("intervals"));
            MovingListener movinglistener = new MovingListener(this.plotpanel);
            ZoomingListener zoominlistener = new ZoomingListener(this.plotpanel);
            this.plotpanel.addMouseListener(movinglistener);
            this.plotpanel.addMouseMotionListener(movinglistener);
            this.plotpanel.addMouseListener(zoominlistener);
            this.plotpanel.addMouseMotionListener(zoominlistener);
        }
    }

    public JPanel getPlotPanel() {
        return this.display;
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeBoolean("interval_manual", "Calculate the histogram with the specified number of imtervals, else calculate number of intervals.", false);
        types.add(type);
        type = new ParameterTypeInt("intervals", "Number of intervals.", 1, 1000, 5);
        types.add(type);
        return types;
    }

    public void compile() throws CompilerException {
        boolean haspredlabel;
        this.iscompiling = true;
        if (this.source == null) {
            throw new CompilerException("Cannot compile FunctionValueHistogram.");
        }
        ExampleSet set = this.source.getExampleSet();
        this.number_of_samples = set.getSize();
        this.number_atts = set.getNumberOfAttributes();
        if (set.getLabel() != null) {
            ++this.number_atts;
        }
        if (set.getPredictedLabel() != null) {
            ++this.number_atts;
        }
        this.attr_names = new String[this.number_atts];
        for (int att = 0; att < set.getNumberOfAttributes(); ++att) {
            this.attr_names[att] = set.getAttribute(att).getName();
        }
        this.labelvalues = new float[this.number_of_samples];
        this.predvalues = new float[this.number_of_samples];
        boolean haslabel = set.getLabel() != null;
        boolean bl = haspredlabel = set.getPredictedLabel() != null;
        if (!haslabel && !haspredlabel) {
            throw new CompilerException("The ExampleSet must have a label and a prediction. The prediction must be a numerical attribute!");
        }
        if (!set.getPredictedLabel().isNumerical()) {
            throw new CompilerException("The prediction must be numeric!");
        }
        ExampleReader reader = set.getExampleReader();
        for (int sample = 0; sample < this.number_of_samples; ++sample) {
            Example example = reader.next();
            if (haslabel) {
                this.labelvalues[sample] = (float)example.getLabel();
            }
            if (!haslabel && haspredlabel) {
                this.predvalues[sample] = (float)example.getPredictedLabel();
            }
            if (!haslabel || !haspredlabel) continue;
            this.predvalues[sample] = (float)example.getPredictedLabel();
        }
        this.initComponents();
        this.iscompiling = false;
        this.iscompiled = true;
    }
}

