/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.plot.svm;

import edu.udo.cs.jvito.data.ExampleColoring;
import edu.udo.cs.jvito.plot.PlotPanel;
import edu.udo.cs.yale.example.Attribute;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;

public class FuncValueHistPanel
extends PlotPanel
implements MouseListener {
    private ExampleColoring coloring;
    private Attribute label;
    private Attribute prediction;
    private float[] labelvalues;
    private float[] predvalues;
    private float min;
    private float max;
    private int[][] labelcounter;
    private int[][] pos_frequencies;
    private int[][] neg_frequencies;
    private int max_true_freq;
    private int max_false_freq;
    private int pos_intervals;
    private int neg_intervals;
    private int ursprung_x;
    private int ursprung_y;
    private int width;
    private int height;
    private int pixelgesamt;
    private float pos_pixelchart;
    private float neg_pixelchart;
    private boolean manual = false;
    private boolean calculated = false;
    private int number_of_intervals = 5;
    private boolean mousepressed = false;
    private boolean drawBounds;
    private boolean drawValue;
    private float value;

    public FuncValueHistPanel(ExampleColoring coloring, Attribute label, Attribute prediction, float[] labelvalues, float[] predvalues) {
        this.coloring = coloring;
        this.label = label;
        this.prediction = prediction;
        this.labelvalues = labelvalues;
        this.predvalues = predvalues;
        this.drawBounds = true;
        this.drawValue = false;
        this.orderValues();
        this.calculateMinMax();
        this.addMouseListener(this);
        this.addMouseMotionListener(new MyMouseMotionListener());
    }

    public void setDrawBounds(boolean draw) {
        this.drawBounds = draw;
    }

    public void setDrawLineForValue(float value) {
        this.drawValue = true;
        this.value = value;
    }

    private void calculateMinMax() {
        this.min = Float.POSITIVE_INFINITY;
        this.max = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < this.predvalues.length; ++i) {
            this.min = Math.min(this.min, this.predvalues[i]);
            this.max = Math.max(this.max, this.predvalues[i]);
        }
        this.min = Math.min(this.min, 0.0f);
        this.max = Math.max(this.max, 0.0f);
    }

    public void setValues(float[] labelvalues, float[] predvalues) {
        this.labelvalues = labelvalues;
        this.predvalues = predvalues;
        this.orderValues();
        this.calculateMinMax();
        this.repaint();
    }

    public void quickSort(float[] array, int links, int rechts) {
        int left = links;
        int right = rechts;
        float pivot = array[(links + rechts) / 2];
        while (true) {
            if (array[left] < pivot) {
                ++left;
                continue;
            }
            while (array[right] > pivot) {
                --right;
            }
            if (left <= right) {
                float temp = array[left];
                array[left] = array[right];
                array[right] = temp;
                temp = this.labelvalues[left];
                this.labelvalues[left] = this.labelvalues[right];
                this.labelvalues[right] = temp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (links < right) {
            this.quickSort(array, links, right);
        }
        if (left < rechts) {
            this.quickSort(array, left, rechts);
        }
    }

    public void orderValues() {
        this.quickSort(this.predvalues, 0, this.predvalues.length - 1);
    }

    public void setIntervalsManually(boolean manual) {
        this.manual = manual;
    }

    public void setNumberOfIntervals(int number) {
        this.number_of_intervals = number;
    }

    public int calculateNumberOfIntervals() {
        if (this.calculated) {
            return this.number_of_intervals;
        }
        if (this.manual) {
            return this.number_of_intervals;
        }
        int w = this.width - 120;
        return (this.width - 120) / 10;
    }

    public void calculateFrequencies() {
        int i;
        float delta = (this.max - this.min) / (float)this.number_of_intervals;
        int nullindex = 0;
        while (this.predvalues[nullindex] < 0.0f && ++nullindex != this.predvalues.length) {
        }
        this.pos_intervals = 0;
        this.neg_intervals = 0;
        if (nullindex == this.predvalues.length) {
            this.neg_intervals = this.number_of_intervals;
        } else {
            this.neg_intervals = (int)(Math.abs(this.min) / delta);
            this.pos_intervals = (int)(Math.abs(this.max) / delta);
        }
        this.pos_frequencies = new int[this.pos_intervals][2];
        this.neg_frequencies = new int[this.neg_intervals][2];
        for (i = 0; i < this.pos_intervals; ++i) {
            this.pos_frequencies[i][0] = 0;
            this.pos_frequencies[i][1] = 0;
        }
        for (i = 0; i < this.neg_intervals; ++i) {
            this.neg_frequencies[i][0] = 0;
            this.neg_frequencies[i][1] = 0;
        }
        for (int index = 0; index < this.predvalues.length; ++index) {
            int count_index;
            float value = this.predvalues[index] / delta;
            int labelindex = this.labelvalues[index] == (float)this.label.getPositiveIndex() ? 1 : 0;
            if (value < 0.0f) {
                value = Math.abs(value);
                count_index = (int)Math.floor(value);
                count_index = Math.min(count_index, this.neg_intervals - 1);
                int[] nArray = this.neg_frequencies[count_index];
                int n = labelindex;
                nArray[n] = nArray[n] + 1;
                continue;
            }
            count_index = (int)Math.floor(value);
            count_index = Math.min(count_index, this.pos_intervals - 1);
            int[] nArray = this.pos_frequencies[count_index];
            int n = labelindex;
            nArray[n] = nArray[n] + 1;
        }
    }

    public void paint(Graphics g) {
        int ry;
        int chartheight;
        int chart;
        int i;
        super.paint(g);
        this.width = this.dimension.width;
        this.height = this.dimension.height;
        this.number_of_intervals = this.calculateNumberOfIntervals();
        int max_intervals = (this.width - 100) / 2;
        this.number_of_intervals = Math.min(this.number_of_intervals, max_intervals);
        if (this.number_of_intervals % 2 == 1) {
            ++this.number_of_intervals;
        }
        this.calculateFrequencies();
        this.max_true_freq = this.pos_frequencies[0][1];
        this.max_false_freq = this.pos_frequencies[0][0];
        for (i = 0; i < this.pos_intervals; ++i) {
            this.max_true_freq = Math.max(this.max_true_freq, this.pos_frequencies[i][1]);
            this.max_false_freq = Math.max(this.max_false_freq, this.pos_frequencies[i][0]);
        }
        for (i = 0; i < this.neg_intervals; ++i) {
            this.max_true_freq = Math.max(this.max_true_freq, this.neg_frequencies[i][1]);
            this.max_false_freq = Math.max(this.max_false_freq, this.neg_frequencies[i][0]);
        }
        g.setColor(this.foreground);
        this.ursprung_y = 70 + (this.height - 140) * this.max_true_freq / (this.max_true_freq + this.max_false_freq);
        this.ursprung_x = 70 + (int)(((float)this.width - 140.0f) * -1.0f * this.min / (this.max - this.min));
        int x_minus = 70 + (int)(((float)this.width - 140.0f) * (-1.0f - this.min) / (this.max - this.min));
        int x_plus = 70 + (int)(((float)this.width - 140.0f) * (1.0f - this.min) / (this.max - this.min));
        g.drawLine(this.getX(50), this.getY(this.ursprung_y), this.getX(this.width - 50), this.getY(this.ursprung_y));
        g.drawLine(this.getX(this.width - 65), this.getY(this.ursprung_y + 3), this.getX(this.width - 50), this.getY(this.ursprung_y));
        g.drawLine(this.getX(this.width - 65), this.getY(this.ursprung_y - 3), this.getX(this.width - 50), this.getY(this.ursprung_y));
        g.drawLine(this.getX(this.width - 70), this.getY(this.ursprung_y - 5), this.getX(this.width - 70), this.getY(this.ursprung_y + 5));
        g.drawLine(this.getX(70), this.getY(this.ursprung_y - 5), this.getX(70), this.getY(this.ursprung_y + 5));
        g.drawLine(this.getX(this.ursprung_x), this.getY(50), this.getX(this.ursprung_x), this.getY(this.height - 50));
        g.drawLine(this.getX(this.ursprung_x), this.getY(50), this.getX(this.ursprung_x - 3), this.getY(65));
        g.drawLine(this.getX(this.ursprung_x), this.getY(50), this.getX(this.ursprung_x + 3), this.getY(65));
        g.drawLine(this.getX(this.ursprung_x - 5), this.getY(70), this.getX(this.ursprung_x + 5), this.getY(70));
        g.drawLine(this.getX(this.ursprung_x - 5), this.getY(this.height - 70), this.getX(this.ursprung_x + 5), this.getY(this.height - 70));
        g.drawLine(this.getX(this.ursprung_x), this.getY(this.height - 50), this.getX(this.ursprung_x - 3), this.getY(this.height - 65));
        g.drawLine(this.getX(this.ursprung_x), this.getY(this.height - 50), this.getX(this.ursprung_x + 3), this.getY(this.height - 65));
        if (this.drawValue) {
            int x_value = 70 + (int)(((float)this.width - 140.0f) * (this.value - this.min) / (this.max - this.min));
            g.drawLine(this.getX(x_value), this.getY(50), this.getX(x_value), this.getY(this.height - 50));
        }
        if (this.drawBounds) {
            if (x_minus >= 70) {
                this.drawScatteredLine(g, x_minus);
            }
            if (x_plus <= this.width - 70) {
                this.drawScatteredLine(g, x_plus);
            }
        }
        Font font = new Font("Monospaced", 0, 15);
        g.setFont(font);
        g.drawString(Integer.toString(this.max_true_freq), this.getX(this.ursprung_x + 7), this.getY(70));
        g.drawString(Integer.toString(this.max_false_freq), this.getX(this.ursprung_x + 7), this.getY(this.height - 55));
        font = new Font("SansSerif", 0, 30);
        g.setFont(font);
        FontMetrics fm = g.getFontMetrics();
        int slen = fm.stringWidth(this.prediction.getName());
        g.drawString(this.prediction.getName(), this.getX((this.width - slen) / 2), this.getY(this.height - 7));
        this.pixelgesamt = this.width - 140;
        this.pos_pixelchart = (float)(this.width - 70 - this.ursprung_x) / (float)this.pos_intervals;
        this.neg_pixelchart = (float)(this.ursprung_x - 70) / (float)this.neg_intervals;
        int pixelheight_true = this.ursprung_y - 70;
        int pixelheight_false = this.height - 70 - this.ursprung_y;
        Color pos_color = Color.blue;
        Color neg_color = Color.red;
        pos_color = this.coloring.getColorOfLabelValue(this.label, this.label.getPositiveIndex());
        neg_color = this.coloring.getColorOfLabelValue(this.label, this.label.getNegativeIndex());
        int rx = 50;
        for (chart = 0; chart < this.pos_frequencies.length; ++chart) {
            rx = (int)((float)this.ursprung_x + (float)chart * this.pos_pixelchart);
            chartheight = Math.round((float)pixelheight_true * ((float)this.pos_frequencies[chart][1] / (float)this.max_true_freq));
            ry = this.ursprung_y - chartheight;
            g.setColor(pos_color);
            g.fillRect(this.getX(rx), this.getY(ry), (int)Math.ceil((double)this.pos_pixelchart - 1.0E-7), chartheight);
            g.setColor(this.foreground);
            g.drawRect(this.getX(rx), this.getY(ry), (int)Math.ceil((double)this.pos_pixelchart - 1.0E-7), chartheight);
            chartheight = Math.round((float)pixelheight_false * ((float)this.pos_frequencies[chart][0] / (float)this.max_false_freq));
            g.setColor(neg_color);
            g.fillRect(this.getX(rx), this.getY(this.ursprung_y), (int)Math.ceil((double)this.pos_pixelchart - 1.0E-6), chartheight);
            g.setColor(this.foreground);
            g.drawRect(this.getX(rx), this.getY(this.ursprung_y), (int)Math.ceil((double)this.pos_pixelchart - 1.0E-6), chartheight);
        }
        for (chart = 0; chart < this.neg_frequencies.length; ++chart) {
            rx = (int)((float)this.ursprung_x - (float)(chart + 1) * this.neg_pixelchart);
            chartheight = Math.round((float)pixelheight_true * ((float)this.neg_frequencies[chart][1] / (float)this.max_true_freq));
            ry = this.ursprung_y - chartheight;
            g.setColor(pos_color);
            g.fillRect(this.getX(rx), this.getY(ry), (int)Math.ceil((double)this.neg_pixelchart - 1.0E-7), chartheight);
            g.setColor(this.foreground);
            g.drawRect(this.getX(rx), this.getY(ry), (int)Math.ceil((double)this.neg_pixelchart - 1.0E-7), chartheight);
            chartheight = Math.round((float)pixelheight_false * ((float)this.neg_frequencies[chart][0] / (float)this.max_false_freq));
            g.setColor(neg_color);
            g.fillRect(this.getX(rx), this.getY(this.ursprung_y), (int)Math.ceil((double)this.neg_pixelchart - 1.0E-6), chartheight);
            g.setColor(this.foreground);
            g.drawRect(this.getX(rx), this.getY(this.ursprung_y), (int)Math.ceil((double)this.neg_pixelchart - 1.0E-6), chartheight);
        }
        font = new Font("Monospaced", 0, 15);
        g.setFont(font);
        g.setColor(this.foreground);
        g.drawString(Float.toString(this.min), this.getX(60), this.getY(this.ursprung_y + 20));
        g.drawString(Float.toString(this.max), this.getX(this.width - 70), this.getY(this.ursprung_y + 20));
        this.paintMouseInfo(null);
    }

    private void drawScatteredLine(Graphics g, int x) {
        for (int y = 70; y < this.height - 70; y += 20) {
            int y_end = Math.min(y + 10, this.height - 70);
            g.drawLine(this.getX(x), this.getY(y), this.getX(x), this.getY(y_end));
        }
    }

    public void paintMouseInfo(MouseEvent event) {
        if (this.mousepressed && event != null) {
            int x = event.getX();
            int y = event.getY();
            Graphics g = this.getGraphics();
            g.setColor(this.background);
            g.fillRect(0, 0, this.width, 15);
            g.setColor(this.foreground);
            Font font = new Font("Monospaced", 0, 15);
            g.setFont(font);
            g.drawString(this.prediction.getName() + ": " + this.getValue(super.getOrigin().x * -1 + x) + "    Frequency: " + this.getFrequency(super.getOrigin().x * -1 + x), 5, 11);
        }
    }

    public float getValue(int x) {
        if (x < 70) {
            return this.min;
        }
        if (x > this.width - 70) {
            return this.max;
        }
        float breite = this.max - this.min;
        float value = breite / (float)this.pixelgesamt * (float)(x -= 70) + this.min;
        return value;
    }

    public String getBounds(int x) {
        String bounds = "";
        x -= 50;
        float delta = (this.predvalues[this.predvalues.length - 1] - this.predvalues[0]) / (float)this.number_of_intervals;
        int r = 0;
        float l = this.neg_pixelchart;
        for (int i = 0; i < this.number_of_intervals; ++i) {
            if (r < x && (float)x <= l) {
                float rechts = this.getValue(r + 50);
                float links = this.getValue((int)(l + 50.0f));
                return new String(Float.toString(rechts) + " - " + Float.toString(links));
            }
            r = (int)l;
            l += this.neg_pixelchart;
        }
        return bounds;
    }

    public String getFrequency(int x) {
        if (x < 70) {
            return this.neg_frequencies[this.neg_intervals - 1][1] + ":" + this.neg_frequencies[this.neg_intervals - 1][0];
        }
        if (x > this.width - 70) {
            return this.pos_frequencies[this.pos_intervals - 1][1] + ":" + this.pos_frequencies[this.pos_intervals - 1][0];
        }
        int freq = 0;
        float delta = (this.max - this.min) / (float)this.number_of_intervals;
        if (x >= this.ursprung_x) {
            int r = this.ursprung_x;
            float l = (float)this.ursprung_x + this.pos_pixelchart;
            for (int i = 0; i < this.pos_intervals; ++i) {
                if (r < x && (float)x <= l) {
                    return this.pos_frequencies[freq][1] + ":" + this.pos_frequencies[freq][0];
                }
                r = (int)l;
                l += this.pos_pixelchart;
                ++freq;
            }
            freq = Math.min(this.pos_intervals - 1, freq);
            return this.pos_frequencies[freq][1] + ":" + this.pos_frequencies[freq][0];
        }
        float r = (float)this.ursprung_x - this.neg_pixelchart;
        int l = this.ursprung_x;
        for (int i = 0; i < this.neg_intervals; ++i) {
            if (r < (float)x && x <= l) {
                return this.neg_frequencies[freq][1] + ":" + this.neg_frequencies[freq][0];
            }
            l = (int)r;
            r -= this.neg_pixelchart;
            ++freq;
        }
        freq = Math.min(this.neg_intervals - 1, freq);
        return this.neg_frequencies[freq][1] + ":" + this.neg_frequencies[freq][0];
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
        if (event.getButton() == 2) {
            this.mousepressed = true;
            this.paintMouseInfo(event);
        }
    }

    public void mouseReleased(MouseEvent event) {
        this.mousepressed = false;
        this.repaint();
    }

    private class MyMouseMotionListener
    extends MouseMotionAdapter {
        private MyMouseMotionListener() {
        }

        public void mouseDragged(MouseEvent event) {
            FuncValueHistPanel.this.paintMouseInfo(event);
        }
    }
}

