/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.plot;

import edu.udo.cs.jvito.data.ExampleColoring;
import edu.udo.cs.jvito.plot.PlotPanel;
import edu.udo.cs.yale.example.ExampleSet;
import java.awt.Font;
import java.awt.Graphics;

public class PolyVizPanel
extends PlotPanel {
    private String attrname;
    private float[][] samples;
    private float[] attributvektorx;
    private float[] attributvektory;
    private float[][] midatts;
    private float[][] midaxis;
    private float[][][] axis;
    private float[] samplex;
    private float[] sampley;
    private float[] angles;
    private int width;
    private int height;
    private int pixelgesamt;
    private int radius = 1;
    private int midx;
    private int midy;
    private int pointsize = 1;
    private boolean mousepressed = false;
    private boolean labelaxis;
    private ExampleSet set;
    private ExampleColoring coloring;
    private int[] attribute_index;
    private int number_atts;
    private double scale;

    public PolyVizPanel(ExampleSet set, ExampleColoring coloring, float[][] samples, double pointsize, boolean labelaxis, int[] attribute_index, int number_atts, double scale) {
        this.set = set;
        this.coloring = coloring;
        this.samples = samples;
        this.pointsize = (int)pointsize;
        this.labelaxis = labelaxis;
        this.attribute_index = attribute_index;
        this.number_atts = number_atts;
        this.scale = scale;
        this.calculateAngles();
    }

    public void calculateSamplePoints() {
        this.samplex = new float[this.samples[0].length];
        this.sampley = new float[this.samples[0].length];
        float dim = this.number_atts;
        float[] w = new float[this.number_atts];
        for (int sample = 0; sample < this.samples[0].length; ++sample) {
            int d;
            this.samplex[sample] = 0.0f;
            this.sampley[sample] = 0.0f;
            float sumx = 0.0f;
            float summex = 0.0f;
            float summey = 0.0f;
            for (d = 0; d < this.number_atts; ++d) {
                sumx += this.samples[this.attribute_index[d]][sample];
            }
            for (d = 0; d < this.number_atts; ++d) {
                w[d] = this.samples[this.attribute_index[d]][sample] / sumx;
            }
            for (d = 0; d < this.number_atts; ++d) {
                int n = sample;
                this.samplex[n] = this.samplex[n] + w[d] * this.attributvektorx[d];
                int n2 = sample;
                this.sampley[n2] = this.sampley[n2] + w[d] * this.attributvektory[d];
            }
            this.samplex[sample] = (float)((double)this.samplex[sample] * this.scale);
            this.sampley[sample] = (float)((double)this.sampley[sample] * this.scale);
        }
    }

    public void calculateAttributeVectors() {
        this.attributvektorx = new float[this.number_atts];
        this.attributvektory = new float[this.number_atts];
        float x = 0.0f;
        float y = 0.0f;
        for (int dimindex = 0; dimindex < this.number_atts; ++dimindex) {
            int winkel = (int)this.angles[dimindex];
            float angle = this.angles[dimindex];
            if (winkel / 90 == 0) {
                x = this.sin(angle) * (float)this.radius;
                y = this.sin(90.0f - angle) * (float)this.radius;
            } else if (winkel / 90 == 1) {
                x = this.sin(90.0f - (angle -= 90.0f)) * (float)this.radius;
                y = this.sin(angle) * (float)this.radius;
                y = -y;
            } else if (winkel / 90 == 2) {
                x = this.sin(angle -= 180.0f) * (float)this.radius;
                y = this.sin(90.0f - angle) * (float)this.radius;
                x = -x;
                y = -y;
            } else if (winkel / 90 == 3) {
                x = this.sin(90.0f - (angle -= 270.0f)) * (float)this.radius;
                y = this.sin(angle) * (float)this.radius;
                x = -x;
            }
            this.attributvektorx[dimindex] = x;
            this.attributvektory[dimindex] = y;
        }
    }

    private void calculateMiddleOfAttributeVectors() {
        this.midatts = new float[2][this.angles.length];
        float hwinkel = this.angles[1] / 2.0f;
        float x = 0.0f;
        float y = 0.0f;
        for (int dimindex = 0; dimindex < this.number_atts; ++dimindex) {
            float angle = this.angles[dimindex] + hwinkel;
            int winkel = (int)angle;
            if (winkel / 90 == 0) {
                x = this.sin(angle) * (float)this.radius;
                y = this.sin(90.0f - angle) * (float)this.radius;
            } else if (winkel / 90 == 1) {
                x = this.sin(90.0f - (angle -= 90.0f)) * (float)this.radius;
                y = this.sin(angle) * (float)this.radius;
                y = -y;
            } else if (winkel / 90 == 2) {
                x = this.sin(angle -= 180.0f) * (float)this.radius;
                y = this.sin(90.0f - angle) * (float)this.radius;
                x = -x;
                y = -y;
            } else if (winkel / 90 == 3) {
                x = this.sin(90.0f - (angle -= 270.0f)) * (float)this.radius;
                y = this.sin(angle) * (float)this.radius;
                x = -x;
            }
            this.midatts[0][dimindex] = x;
            this.midatts[1][dimindex] = y;
        }
    }

    private void calculateMiddleOfAxis() {
        this.midaxis = new float[2][this.angles.length];
        for (int i = 0; i < this.angles.length; ++i) {
            this.midaxis[0][i] = 0.0f;
            this.midaxis[1][i] = 0.0f;
            float[] fArray = this.midaxis[0];
            int n = i;
            fArray[n] = (float)((double)fArray[n] + ((double)this.attributvektorx[i] + (double)(this.attributvektorx[i] / (float)this.radius) * 50.0));
            float[] fArray2 = this.midaxis[1];
            int n2 = i;
            fArray2[n2] = (float)((double)fArray2[n2] + ((double)this.attributvektory[i] + (double)(this.attributvektory[i] / (float)this.radius) * 50.0));
        }
    }

    private void calculateAxisPoints() {
        this.axis = new float[2][2][this.angles.length];
        for (int i = 0; i < this.angles.length; ++i) {
            int li = i - 1;
            if (li < 0) {
                li = this.angles.length - 1;
            }
            float x = (this.midatts[0][li] - this.midatts[0][i]) / 2.0f;
            float y = (this.midatts[1][li] - this.midatts[1][i]) / 2.0f;
            this.axis[0][0][i] = this.midaxis[0][i] + x;
            this.axis[0][1][i] = this.midaxis[1][i] + y;
            this.axis[1][0][i] = this.midaxis[0][i] - x;
            this.axis[1][1][i] = this.midaxis[1][i] - y;
        }
    }

    public void calculateAngles() {
        float anglegesamt = 360.0f;
        float delta = anglegesamt / (float)this.number_atts;
        float angle = 0.0f;
        this.angles = new float[this.number_atts];
        for (int i = 0; i < this.number_atts; ++i) {
            this.angles[i] = angle;
            angle += delta;
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.width = this.dimension.width;
        this.height = this.dimension.height;
        g.setColor(this.foreground);
        this.midx = this.width / 2;
        this.midy = this.height / 2;
        this.pixelgesamt = Math.min(this.width, this.height) - 220;
        this.radius = this.pixelgesamt / 2;
        this.calculateAttributeVectors();
        this.calculateMiddleOfAttributeVectors();
        this.calculateMiddleOfAxis();
        this.calculateAxisPoints();
        g.setColor(this.foreground);
        int x1 = this.midx;
        int y1 = this.midy;
        int x2 = this.midx;
        int y2 = this.midx;
        for (int i = 0; i < this.angles.length; ++i) {
            x1 = this.midx;
            y1 = this.midy;
            x2 = this.midx;
            y2 = this.midy;
            g.drawLine(this.getX(x1 += (int)this.axis[0][0][i]), this.getY(y1 -= (int)this.axis[0][1][i]), this.getX(x2 += (int)this.axis[1][0][i]), this.getY(y2 -= (int)this.axis[1][1][i]));
        }
        if (this.labelaxis) {
            g.setColor(this.foreground);
            Font font = new Font("Monospaced", 0, 15);
            g.setFont(font);
            for (int i = 0; i < this.angles.length; ++i) {
                int x = this.midx;
                int y = this.midy;
                x = (int)((float)x + this.attributvektorx[i]);
                y = (int)((float)y - this.attributvektory[i]);
                if (this.angles[i] >= 0.0f && this.angles[i] <= 90.0f) {
                    x = (int)((float)x + this.attributvektorx[i] / (float)this.radius * 55.0f);
                    y = (int)((float)y - this.attributvektory[i] / (float)this.radius * 55.0f);
                } else if (this.angles[i] >= 90.0f && this.angles[i] < 180.0f) {
                    x = (int)((float)x + this.attributvektorx[i] / (float)this.radius * 60.0f);
                    y = (int)((float)y - this.attributvektory[i] / (float)this.radius * 60.0f);
                } else if (this.angles[i] >= 180.0f && this.angles[i] < 270.0f) {
                    x = (int)((float)x + this.attributvektorx[i] / (float)this.radius * 65.0f);
                    y = (int)((float)y - this.attributvektory[i] / (float)this.radius * 65.0f);
                } else if (this.angles[i] >= 270.0f && this.angles[i] < 360.0f) {
                    x = (int)((float)x + this.attributvektorx[i] / (float)this.radius * 60.0f);
                    y = (int)((float)y - this.attributvektory[i] / (float)this.radius * 60.0f);
                }
                g.drawString(Integer.toString(i + 1), this.getX(x), this.getY(y));
            }
        }
        g.setColor(this.foreground);
        this.calculateSamplePoints();
        for (int sample = 0; sample < this.samplex.length; ++sample) {
            this.drawPointAndLines(g, sample);
        }
    }

    public void drawPointAndLines(Graphics g, int sample) {
        int x = this.midx;
        int y = this.midy;
        float r = this.radius;
        x += (int)this.samplex[sample];
        y -= (int)this.sampley[sample];
        if (this.colorbyattribute) {
            if (this.set.getLabel() != null && this.set.getLabel().getName().equals(this.colorattr.getName())) {
                g.setColor(this.coloring.getColorOfLabelValue(this.colorattr, this.colorvalues[sample]));
            } else if (this.set.getPredictedLabel() != null && this.set.getPredictedLabel().getName().equals(this.colorattr.getName())) {
                if (this.colorattr.isNominal()) {
                    g.setColor(this.colortable[(int)this.colorvalues[sample]]);
                } else {
                    int index = (int)(((double)this.colorvalues[sample] - this.colorattr.getMinimum()) / (this.colorattr.getMaximum() - this.colorattr.getMinimum()) * 99.0);
                    if (index < 0) {
                        index = 0;
                    }
                    if (index > 99) {
                        index = 99;
                    }
                    g.setColor(this.colortable[index]);
                }
            } else {
                if (this.colorattr.isNominal()) {
                    float max = this.colorattr.getNumberOfValues() - 1;
                    int index = (int)(this.colorvalues[sample] * max);
                    g.setColor(this.colortable[index]);
                }
                if (this.colorattr.isNumerical()) {
                    int index = (int)(this.colorvalues[sample] * 99.0f);
                    if (index < 0) {
                        index = 0;
                    }
                    if (index > 99) {
                        index = 99;
                    }
                    g.setColor(this.colortable[index]);
                }
            }
        }
        g.fillRect(this.getX(x - this.pointsize / 2), this.getY(y - this.pointsize / 2), this.pointsize, this.pointsize);
        for (int d = 0; d < this.number_atts; ++d) {
            float dimx = this.axis[1][0][d] - this.axis[0][0][d];
            float dimy = this.axis[1][1][d] - this.axis[0][1][d];
            float s = this.samples[d][sample];
            x = (int)(this.axis[0][0][d] + (dimx *= s));
            y = (int)(this.axis[0][1][d] + (dimy *= s));
            float linex = this.samplex[sample] - (float)x;
            float liney = this.sampley[sample] - (float)y;
            float distance = (float)Math.sqrt(linex * linex + liney * liney);
            linex /= distance;
            liney /= distance;
            distance = distance / ((float)this.radius * 2.0f + 100.0f) * 50.0f;
            linex *= distance;
            liney *= distance;
            linex = (float)x + linex;
            liney = (float)y + liney;
            x = this.midx + x;
            y = this.midy - y;
            linex = (float)this.midx + linex;
            liney = (float)this.midy - liney;
            g.drawLine(this.getX(x), this.getY(y), this.getX((int)linex), this.getY((int)liney));
        }
    }

    public float sin(float angle) {
        while (angle >= 180.0f) {
            angle = (float)((double)angle - 180.0);
        }
        double value = (double)(angle / 180.0f) * Math.PI;
        return (float)Math.sin(value);
    }
}

