/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.plot;

import edu.udo.cs.jvito.JViTo;
import edu.udo.cs.jvito.Project;
import edu.udo.cs.jvito.XMLDocument;
import edu.udo.cs.jvito.compile.Compileable;
import edu.udo.cs.jvito.data.Source;
import edu.udo.cs.jvito.exception.CompilerException;
import edu.udo.cs.jvito.exception.XMLException;
import edu.udo.cs.jvito.parameter.ParameterObject;
import edu.udo.cs.jvito.parameter.ParameterTypeColor;
import edu.udo.cs.jvito.util.Resources;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class Plot
extends ParameterObject
implements XMLDocument,
Compileable {
    protected boolean iscompiling = false;
    protected boolean iscompiled = false;
    protected String name;
    protected String oldname;
    protected Project project;
    protected Source source;
    protected JInternalFrame frame;
    protected Image image = Resources.getImage("TREE_PLOT");

    public String getName() {
        return this.name;
    }

    public String getOldName() {
        return this.oldname;
    }

    public void setName(String name) {
        this.oldname = this.name == null ? name : this.name;
        this.name = name;
        JViTo.getApplication().setDirty();
    }

    public void setJInternalFrame(JInternalFrame frame) {
        this.frame = frame;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public Source getSource() {
        return this.source;
    }

    public String getClassName() {
        String classname = this.getClass().getName();
        return classname.substring(classname.lastIndexOf(".") + 1);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image != null ? image : Resources.getImage("TREE_PLOT");
    }

    public abstract JPanel getPlotPanel();

    public abstract Component getSaveableComponent();

    public List getParameterTypes() {
        LinkedList<ParameterTypeColor> types = new LinkedList<ParameterTypeColor>();
        ParameterTypeSingle type = new ParameterTypeColor("background", "The background-color.", Color.WHITE);
        types.add((ParameterTypeColor)type);
        type = new ParameterTypeColor("foreground", "The foreground-color.", Color.DARK_GRAY);
        types.add((ParameterTypeColor)type);
        type = new ParameterTypeString("title", "Title of the plot.", "");
        types.add((ParameterTypeColor)type);
        type = new ParameterTypeBoolean("show title", "Show th etitle in the plot.", true);
        types.add((ParameterTypeColor)type);
        return types;
    }

    public String getXML(String indent) {
        StringBuffer result = new StringBuffer();
        result.append(indent + "<plot " + "name=\"" + this.name + "\" " + "class=\"" + this.getClass().getName() + "\">\n");
        result.append(indent + "  <description text=\"" + this.getDescription() + "\"/>\n");
        result.append(this.parameters.getXML(indent + "\t"));
        LinkedList childs = this.getXMLDocChilds();
        Iterator iter = childs.iterator();
        while (iter.hasNext()) {
            XMLDocument doc = (XMLDocument)iter.next();
            result.append(doc.getXML(indent + "\t"));
        }
        result.append(indent + "</plot>\n");
        return result.toString();
    }

    public LinkedList getXMLDocChilds() {
        return new LinkedList();
    }

    private String createDescriptionFromXML(Element element) throws XMLException {
        Attr textAttr = element.getAttributeNode("text");
        if (textAttr == null) {
            throw new XMLException("Attribute 'text' of <description> tag is not set.");
        }
        if (element.getChildNodes().getLength() > 0) {
            throw new XMLException("No inner tags allowed for <description>");
        }
        return textAttr.getValue();
    }

    private Object[] createParameterFromXML(Element element) throws XMLException {
        Attr keyAttr = element.getAttributeNode("key");
        Attr valueAttr = element.getAttributeNode("value");
        if (keyAttr == null) {
            throw new XMLException("Attribute 'key' of <parameter> tag is not set.");
        }
        if (valueAttr == null) {
            throw new XMLException("Attribute 'value' of <parameter> tag is not set.");
        }
        if (element.getChildNodes().getLength() > 0) {
            throw new XMLException("No inner tags allowed for <parameter>");
        }
        return new Object[]{keyAttr.getValue(), valueAttr.getValue()};
    }

    public void loadXMLDocument(Element element) throws XMLException {
        if (!element.getTagName().toLowerCase().equals("plot")) {
            throw new XMLException("<plot> expected!");
        }
        String className = null;
        String name = null;
        Attr classAttr = element.getAttributeNode("class");
        if (classAttr == null) {
            throw new XMLException("Attribute 'class' of <plot> tag is not defined! ");
        }
        className = classAttr.getValue();
        Attr nameAttr = element.getAttributeNode("name");
        if (nameAttr == null) {
            throw new XMLException("Attribute 'name' of <plot> tag is not defined! ");
        }
        name = nameAttr.getValue();
        this.setName(name);
        NodeList innerTags = element.getChildNodes();
        for (int i = 0; i < innerTags.getLength(); ++i) {
            Node node = innerTags.item(i);
            if (!(node instanceof Element)) continue;
            Element inner = (Element)node;
            if (inner.getTagName().toLowerCase().equals("parameter")) {
                Object[] parameter = this.createParameterFromXML(inner);
                this.getParameters().setParameter((String)parameter[0], parameter[1]);
                continue;
            }
            if (inner.getTagName().toLowerCase().equals("description")) {
                String description = this.createDescriptionFromXML(inner);
                this.setDescription(description);
                continue;
            }
            throw new XMLException("Ilegal inner tag for <plot>: " + inner.getTagName());
        }
    }

    public void writeXML(PrintWriter out, String indent) {
    }

    public void compile() throws CompilerException {
    }

    public Compileable getCompileableChild(int index) {
        return null;
    }

    public int getCompileableChildCount() {
        return 0;
    }

    public Compileable getParentCompileableObject() {
        return this.source;
    }

    public boolean isCompiled() {
        return this.iscompiled;
    }

    public boolean isCompiling() {
        return this.iscompiling;
    }

    public void parentIsCompiled() {
    }

    public void fireIsCompiled() {
    }

    public void refreshParameter() {
    }
}

