/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.plot;

import edu.udo.cs.jvito.exception.CompilerException;
import edu.udo.cs.jvito.parameter.ParameterTypeDynamicCategory;
import edu.udo.cs.jvito.plot.ColorPanel;
import edu.udo.cs.jvito.plot.HistogramNominal;
import edu.udo.cs.jvito.plot.HistogramNumeric;
import edu.udo.cs.jvito.plot.MovingListener;
import edu.udo.cs.jvito.plot.SimplePlot;
import edu.udo.cs.jvito.plot.ZoomingListener;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class Histogram
extends SimplePlot {
    private int attr = 0;
    private JPanel display;
    private JScrollPane scrollpane;
    private Attribute attribut;
    private String[] attr_names = new String[0];
    private int number_atts = 0;
    private int number_of_samples = 0;
    private float[][] samples;
    private float[] labelvalues;
    private float[] predvalues;
    private String[] classes2;

    public Histogram() {
    }

    public Histogram(String name) {
        this.setName(name);
    }

    private void initComponents() {
        this.display = new JPanel();
        this.display.setLayout(new BorderLayout(10, 10));
        JPanel settings = new JPanel();
        settings.setPreferredSize(new Dimension(125, settings.getHeight()));
        settings.setLayout(new BorderLayout());
        if (!this.source.isCompiled()) {
            return;
        }
        ExampleSet set = this.source.getExampleSet();
        this.initPlotPanel();
        this.display.add((Component)this.plotpanel, "Center");
        this.display.add((Component)settings, "East");
        if (this.getParameterAsInt("color_attribute") != 0) {
            JPanel colorpanel = this.plotpanel.getColorPanel();
            if (this.getParameterAsInt("color_attribute") > set.getNumberOfAttributes()) {
                if (set.getLabel() != null && set.getLabel().isNominal() && this.getParameterAsInt("color_attribute") == set.getNumberOfAttributes() + 1) {
                    Color[] colors = new Color[set.getLabel().getValues().size()];
                    Collection values = set.getLabel().getValues();
                    Object[] valuesstr = values.toArray();
                    for (int i = 0; i < valuesstr.length; ++i) {
                        colors[i] = this.source.getExampleColoring().getColorOfLabelValue(set.getLabel(), (String)valuesstr[i]);
                    }
                    colorpanel = new ColorPanel(set.getLabel(), colors, this.getParameterAsColor("foreground"), this.getParameterAsColor("background"));
                } else if (set.getPredictedLabel() != null && set.getPredictedLabel().isNominal()) {
                    Collection values = set.getPredictedLabel().getValues();
                    Object[] valuesstr = values.toArray();
                    Color[] colors = new Color[set.getPredictedLabel().getValues().size() * set.getPredictedLabel().getValues().size()];
                    String[] valuestring = new String[valuesstr.length * valuesstr.length];
                    for (int i = 0; i < valuesstr.length; ++i) {
                        for (int j = 0; j < valuesstr.length; ++j) {
                            valuestring[i * valuesstr.length + j] = new String((String)valuesstr[i] + " - " + (String)valuesstr[j]);
                            colors[i * valuesstr.length + j] = this.source.getExampleColoring().getColorOfLabelvsPred(set.getLabel(), set.getPredictedLabel(), (String)valuesstr[i], (String)valuesstr[j]);
                        }
                    }
                    colorpanel = new ColorPanel(set.getPredictedLabel(), valuestring, colors, this.getParameterAsColor("foreground"), this.getParameterAsColor("background"));
                }
            }
            colorpanel.setPreferredSize(new Dimension(125, colorpanel.getHeight()));
            settings.add(colorpanel);
        }
    }

    protected void initPlotPanel() {
        ZoomingListener zoominlistener;
        int i;
        int j;
        Color[] colors;
        Object[] valuesstr;
        Collection values;
        ExampleSet set = this.source.getExampleSet();
        this.attr = this.getParameterAsInt("attribute");
        Attribute a = null;
        if (this.attr >= set.getNumberOfAttributes()) {
            int attri = this.attr + 1 - set.getNumberOfAttributes();
            if (attri == 1 && set.getLabel() != null) {
                a = set.getLabel();
            } else if (attri == 1 && set.getPredictedLabel() != null) {
                a = set.getPredictedLabel();
            }
            if (attri == 2 && set.getPredictedLabel() != null) {
                a = set.getPredictedLabel();
            }
        } else {
            a = set.getAttribute(this.attr);
        }
        if (a == null) {
            return;
        }
        String color_attribute = ((ParameterTypeDynamicCategory)this.getParameterType("color_attribute")).getValues()[this.getParameterAsInt("color_attribute")];
        Color start_color = Color.red;
        Color end_color = Color.blue;
        if (!color_attribute.equals("<None>")) {
            if (set.getLabel() != null && set.getLabel().getName().equals(color_attribute)) {
                start_color = this.source.getExampleColoring().getStartColorOfLabel(set.getLabel());
                end_color = this.source.getExampleColoring().getEndColorOfLabel(set.getLabel());
            } else if (set.getPredictedLabel() != null && set.getPredictedLabel().getName().equals(color_attribute)) {
                start_color = this.source.getExampleColoring().getStartColorOfPredLabel(set.getPredictedLabel());
                end_color = this.source.getExampleColoring().getEndColorOfPredLabel(set.getPredictedLabel());
            } else {
                start_color = this.source.getExampleColoring().getStartColorOfAttribute(set.getAttribute(color_attribute));
                end_color = this.source.getExampleColoring().getEndColorOfAttribute(set.getAttribute(color_attribute));
            }
        }
        if (a.isNumerical()) {
            this.plotpanel = new HistogramNumeric(this.source.getExampleSet(), this.source.getExampleColoring(), a, this.samples[this.attr]);
            if (color_attribute.equals("<None>")) {
                ((HistogramNumeric)this.plotpanel).orderValues();
            } else if (set.getLabel() != null && color_attribute.equals(set.getLabel().getName())) {
                this.plotpanel.colorByAttribute(set.getLabel(), this.labelvalues);
                this.plotpanel.setStartColor(start_color);
                this.plotpanel.setEndColor(end_color);
                this.plotpanel.initColorTable();
            } else if (set.getPredictedLabel() != null && color_attribute.equals(set.getPredictedLabel().getName())) {
                values = set.getPredictedLabel().getValues();
                valuesstr = values.toArray();
                colors = new Color[set.getPredictedLabel().getValues().size() * set.getPredictedLabel().getValues().size()];
                for (int i2 = 0; i2 < valuesstr.length; ++i2) {
                    for (j = 0; j < valuesstr.length; ++j) {
                        colors[i2 * valuesstr.length + j] = this.source.getExampleColoring().getColorOfLabelvsPred(set.getLabel(), set.getPredictedLabel(), (String)valuesstr[i2], (String)valuesstr[j]);
                    }
                }
                float[] pvalues = new float[this.number_of_samples];
                for (i = 0; i < this.predvalues.length; ++i) {
                    pvalues[i] = this.labelvalues[i] * (float)valuesstr.length + this.predvalues[i];
                }
                ((HistogramNumeric)this.plotpanel).setColorByPrediction(true);
                this.plotpanel.colorByAttribute(this.source.getExampleSet().getPredictedLabel(), pvalues, colors);
                this.plotpanel.setStartColor(this.source.getExampleColoring().getStartColorOfPredLabel(this.source.getExampleSet().getPredictedLabel()));
                this.plotpanel.setEndColor(this.source.getExampleColoring().getEndColorOfPredLabel(this.source.getExampleSet().getPredictedLabel()));
            } else if (!color_attribute.equals("")) {
                this.plotpanel.colorByAttribute(set.getAttribute(color_attribute), this.samples[this.getParameterAsInt("color_attribute") - 1]);
                this.plotpanel.setStartColor(start_color);
                this.plotpanel.setEndColor(end_color);
                this.plotpanel.initColorTable();
            }
            this.plotpanel.setTitle(this.getParameterAsString("title"));
            this.plotpanel.setDrawTitle(this.getParameterAsBoolean("show title"));
            this.plotpanel.setBackgroundColor(this.getParameterAsColor("background"));
            this.plotpanel.setForegroundColor(this.getParameterAsColor("foreground"));
            ((HistogramNumeric)this.plotpanel).setIntervalsManually(this.getParameterAsBoolean("interval_manual"));
            ((HistogramNumeric)this.plotpanel).setNumberOfIntervals(this.getParameterAsInt("intervals"));
            MovingListener movinglistener = new MovingListener(this.plotpanel);
            zoominlistener = new ZoomingListener(this.plotpanel);
            this.plotpanel.addMouseListener(movinglistener);
            this.plotpanel.addMouseMotionListener(movinglistener);
            this.plotpanel.addMouseListener(zoominlistener);
            this.plotpanel.addMouseMotionListener(zoominlistener);
        }
        if (a.isNominal()) {
            this.plotpanel = new HistogramNominal(this.source.getExampleSet(), this.source.getExampleColoring(), a, this.samples[this.attr]);
            if (color_attribute.equals("<None>")) {
                ((HistogramNominal)this.plotpanel).orderValues();
            } else if (set.getLabel() != null && color_attribute.equals(set.getLabel().getName())) {
                if (set.getLabel().isNominal()) {
                    int nr_values = set.getLabel().getNumberOfValues();
                    Color[] colors2 = new Color[nr_values];
                    for (int i3 = 0; i3 < nr_values; ++i3) {
                        colors2[i3] = this.source.getExampleColoring().getColorOfLabelValue(set.getLabel(), i3);
                    }
                    this.plotpanel.colorByAttribute(set.getLabel(), this.labelvalues, colors2);
                }
            } else if (set.getPredictedLabel() != null && color_attribute.equals(set.getPredictedLabel().getName())) {
                values = set.getPredictedLabel().getValues();
                valuesstr = values.toArray();
                colors = new Color[set.getPredictedLabel().getValues().size() * set.getPredictedLabel().getValues().size()];
                for (int i4 = 0; i4 < valuesstr.length; ++i4) {
                    for (j = 0; j < valuesstr.length; ++j) {
                        colors[i4 * valuesstr.length + j] = this.source.getExampleColoring().getColorOfLabelvsPred(set.getLabel(), set.getPredictedLabel(), (String)valuesstr[i4], (String)valuesstr[j]);
                    }
                }
                float[] pvalues = new float[this.number_of_samples];
                for (i = 0; i < this.predvalues.length; ++i) {
                    pvalues[i] = this.labelvalues[i] * (float)valuesstr.length + this.predvalues[i];
                }
                ((HistogramNominal)this.plotpanel).setColorByPrediction(true);
                this.plotpanel.colorByAttribute(this.source.getExampleSet().getPredictedLabel(), pvalues, colors);
                this.plotpanel.setStartColor(this.source.getExampleColoring().getStartColorOfPredLabel(this.source.getExampleSet().getPredictedLabel()));
                this.plotpanel.setEndColor(this.source.getExampleColoring().getEndColorOfPredLabel(this.source.getExampleSet().getPredictedLabel()));
            } else if (!color_attribute.equals("")) {
                this.plotpanel.colorByAttribute(set.getAttribute(color_attribute), this.samples[this.getParameterAsInt("color_attribute") - 1]);
                this.plotpanel.setStartColor(start_color);
                this.plotpanel.setEndColor(end_color);
                this.plotpanel.initColorTable();
            }
            this.plotpanel.setTitle(this.getParameterAsString("title"));
            this.plotpanel.setDrawTitle(this.getParameterAsBoolean("show title"));
            this.plotpanel.setBackgroundColor(this.getParameterAsColor("background"));
            this.plotpanel.setForegroundColor(this.getParameterAsColor("foreground"));
            MovingListener movinglistener = new MovingListener(this.plotpanel);
            zoominlistener = new ZoomingListener(this.plotpanel);
            this.plotpanel.addMouseListener(movinglistener);
            this.plotpanel.addMouseMotionListener(movinglistener);
            this.plotpanel.addMouseListener(zoominlistener);
            this.plotpanel.addMouseMotionListener(zoominlistener);
        }
    }

    public JPanel getPlotPanel() {
        return this.display;
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeDynamicCategory("attribute", "Attribute for the x-axis.", this.getAttributes(), 0);
        types.add(type);
        type = new ParameterTypeBoolean("interval_manual", "Calculate the histogram with the specified number of imtervals, else calculate number of intervals.", false);
        types.add(type);
        type = new ParameterTypeInt("intervals", "Number of intervals.", 1, 1000, 5);
        types.add(type);
        type = new ParameterTypeDynamicCategory("color_attribute", "The histogram is colored with this attribute.", new String[]{"<None>"}, 0);
        types.add(type);
        return types;
    }

    public void compile() throws CompilerException {
        this.iscompiling = true;
        if (this.source == null) {
            throw new CompilerException("Can't compile IrregularSet. This operator must be achild of a data-operator.");
        }
        ExampleSet set = this.source.getExampleSet();
        this.number_of_samples = set.getSize();
        this.number_atts = set.getNumberOfAttributes();
        if (set.getLabel() != null) {
            ++this.number_atts;
        }
        if (set.getPredictedLabel() != null) {
            ++this.number_atts;
        }
        this.attr_names = new String[this.number_atts];
        for (int att = 0; att < set.getNumberOfAttributes(); ++att) {
            this.attr_names[att] = set.getAttribute(att).getName();
        }
        this.samples = new float[this.number_atts][this.number_of_samples];
        this.labelvalues = new float[this.number_of_samples];
        this.predvalues = new float[this.number_of_samples];
        boolean haslabel = set.getLabel() != null;
        boolean haspredlabel = set.getPredictedLabel() != null;
        ExampleReader reader = set.getExampleReader();
        for (int sample = 0; sample < this.number_of_samples; ++sample) {
            Example example = reader.next();
            for (int d = 0; d < set.getNumberOfAttributes(); ++d) {
                this.samples[d][sample] = (float)example.getValue(d);
            }
            if (haslabel) {
                this.labelvalues[sample] = (float)example.getLabel();
                this.samples[set.getNumberOfAttributes()][sample] = (float)example.getLabel();
            }
            if (!haslabel && haspredlabel) {
                this.predvalues[sample] = (float)example.getPredictedLabel();
                this.samples[set.getNumberOfAttributes()][sample] = (float)example.getPredictedLabel();
            }
            if (!haslabel || !haspredlabel) continue;
            this.predvalues[sample] = (float)example.getPredictedLabel();
            this.samples[set.getNumberOfAttributes() + 1][sample] = (float)example.getPredictedLabel();
        }
        this.initComponents();
        this.iscompiling = false;
        this.iscompiled = true;
    }

    public void parentIsCompiled() {
        ((ParameterTypeDynamicCategory)this.getParameterType("color_attribute")).setValues(this.getColorAttributes());
        ((ParameterTypeDynamicCategory)this.getParameterType("attribute")).setValues(this.getAttributes());
    }

    public void refreshParameter() {
        ((ParameterTypeDynamicCategory)this.getParameterType("color_attribute")).setValues(this.getColorAttributes());
        ((ParameterTypeDynamicCategory)this.getParameterType("attribute")).setValues(this.getAttributes());
    }

    public String[] getAttributes() {
        if (this.source == null) {
            return new String[]{""};
        }
        ExampleSet set = this.source.getExampleSet();
        if (set == null) {
            return new String[]{""};
        }
        int count = 0;
        count += set.getNumberOfAttributes();
        if (set.getLabel() != null) {
            ++count;
        }
        if (set.getPredictedLabel() != null) {
            ++count;
        }
        String[] categories = new String[count];
        for (int i = 0; i < set.getNumberOfAttributes(); ++i) {
            categories[i] = set.getAttribute(i).getName();
        }
        int index = set.getNumberOfAttributes();
        if (set.getLabel() != null) {
            categories[index] = set.getLabel().getName();
            ++index;
        }
        if (set.getPredictedLabel() != null) {
            categories[index] = set.getPredictedLabel().getName();
        }
        return categories;
    }

    public String[] getColorAttributes() {
        if (this.source == null) {
            return new String[]{"<None>"};
        }
        if (!this.source.isCompiled()) {
            return new String[]{"<None>"};
        }
        ExampleSet set = this.source.getExampleSet();
        if (set == null) {
            return new String[]{"<None>"};
        }
        int count = 1;
        count += set.getNumberOfAttributes();
        if (set.getLabel() != null) {
            ++count;
        }
        if (set.getPredictedLabel() != null) {
            ++count;
        }
        String[] categories = new String[count];
        categories[0] = "<None>";
        for (int i = 1; i <= set.getNumberOfAttributes(); ++i) {
            categories[i] = set.getAttribute(i - 1).getName();
        }
        int index = set.getNumberOfAttributes() + 1;
        if (set.getLabel() != null) {
            categories[index] = set.getLabel().getName();
            ++index;
        }
        if (set.getPredictedLabel() != null) {
            categories[index] = set.getPredictedLabel().getName();
            ++index;
        }
        return categories;
    }
}

