/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.plot;

import edu.udo.cs.jvito.data.ExampleColoring;
import edu.udo.cs.jvito.plot.PlotPanel;
import edu.udo.cs.yale.example.ExampleSet;
import java.awt.Font;
import java.awt.Graphics;

public class CircVizPanel
extends PlotPanel {
    private String attrname;
    private float[][] samples;
    private float[] attributvektorx;
    private float[] attributvektory;
    private float[] samplex;
    private float[] sampley;
    private float[] angles;
    private int width;
    private int height;
    private int pixelgesamt;
    private int radius = 1;
    private int midx;
    private int midy;
    private int pointsize = 1;
    private boolean mousepressed = false;
    private boolean labelaxis;
    private boolean draw_axis;
    private ExampleSet set;
    private ExampleColoring coloring;
    private int[] attribute_index;
    private int number_atts;
    private double scale;
    private double[] weights;
    private double[] min;
    private double[] max;

    public CircVizPanel(ExampleSet set, ExampleColoring coloring, boolean draw_axis, float[][] samples, double[] weights, double[] min, double[] max, double pointsize, boolean labelaxis, int[] attribute_index, int number_atts, double scale) {
        this.set = set;
        this.coloring = coloring;
        this.draw_axis = draw_axis;
        this.samples = samples;
        this.weights = weights;
        this.min = min;
        this.max = max;
        this.pointsize = (int)pointsize;
        this.labelaxis = labelaxis;
        this.attribute_index = attribute_index;
        this.number_atts = number_atts;
        this.scale = scale;
        this.calculateAngles();
        this.calculateAttributeVectors();
        this.calculateSamplePoints();
    }

    public void calculateSamplePoints() {
        this.samplex = new float[this.samples[0].length];
        this.sampley = new float[this.samples[0].length];
        float dim = this.number_atts;
        for (int sample = 0; sample < this.samples[0].length; ++sample) {
            int d;
            this.samplex[sample] = 0.0f;
            this.sampley[sample] = 0.0f;
            double sumw = 0.0;
            for (d = 0; d < this.number_atts; ++d) {
                sumw += Math.abs(this.weights[this.attribute_index[d]]);
            }
            for (d = 0; d < this.number_atts; ++d) {
                double weightedvalue = Math.abs(this.weights[this.attribute_index[d]]) * (((double)this.samples[this.attribute_index[d]][sample] - this.min[this.attribute_index[d]]) / (this.max[this.attribute_index[d]] - this.min[this.attribute_index[d]]));
                int n = sample;
                this.samplex[n] = (float)((double)this.samplex[n] + (weightedvalue /= sumw) * (double)this.attributvektorx[d]);
                int n2 = sample;
                this.sampley[n2] = (float)((double)this.sampley[n2] + weightedvalue * (double)this.attributvektory[d]);
            }
            this.samplex[sample] = (float)((double)this.samplex[sample] * this.scale);
            this.sampley[sample] = (float)((double)this.sampley[sample] * this.scale);
        }
    }

    public void calculateAttributeVectors() {
        this.attributvektorx = new float[this.number_atts];
        this.attributvektory = new float[this.number_atts];
        float radius = 1.0f;
        float x = 0.0f;
        float y = 0.0f;
        for (int dimindex = 0; dimindex < this.number_atts; ++dimindex) {
            int winkel = (int)this.angles[dimindex];
            float angle = this.angles[dimindex];
            if (winkel / 90 == 0) {
                x = this.sin(angle) * radius;
                y = this.sin(90.0f - angle) * radius;
            } else if (winkel / 90 == 1) {
                x = this.sin(90.0f - (angle -= 90.0f)) * radius;
                y = this.sin(angle) * radius;
                y = -y;
            } else if (winkel / 90 == 2) {
                x = this.sin(angle -= 180.0f) * radius;
                y = this.sin(90.0f - angle) * radius;
                x = -x;
                y = -y;
            } else if (winkel / 90 == 3) {
                x = this.sin(90.0f - (angle -= 270.0f)) * radius;
                y = this.sin(angle) * radius;
                x = -x;
            }
            this.attributvektorx[dimindex] = x;
            this.attributvektory[dimindex] = y;
        }
    }

    public void calculateAngles() {
        float anglegesamt = 360.0f;
        float delta = anglegesamt / (float)this.number_atts;
        float angle = 0.0f;
        this.angles = new float[this.number_atts];
        for (int i = 0; i < this.number_atts; ++i) {
            this.angles[i] = angle;
            angle += delta;
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.width = this.dimension.width;
        this.height = this.dimension.height;
        g.setColor(this.foreground);
        this.midx = this.width / 2;
        this.midy = this.height / 2;
        this.pixelgesamt = Math.min(this.width, this.height) - 120;
        this.radius = this.pixelgesamt / 2;
        g.drawOval(this.getX(this.midx - this.radius), this.getY(this.midy - this.radius), this.pixelgesamt, this.pixelgesamt);
        if (this.draw_axis) {
            int x = this.midx;
            int y = this.midy;
            for (int i = 0; i < this.angles.length; ++i) {
                x = this.midx;
                y = this.midy;
                x = (int)((float)x + this.attributvektorx[i] * (float)this.radius);
                y = (int)((float)y - this.attributvektory[i] * (float)this.radius);
                g.drawLine(this.getX(this.midx), this.getY(this.midy), this.getX(x), this.getY(y));
            }
            if (this.labelaxis) {
                g.setColor(this.foreground);
                Font font = new Font("Monospaced", 0, 15);
                g.setFont(font);
                for (int i = 0; i < this.angles.length; ++i) {
                    x = this.midx;
                    y = this.midy;
                    x = (int)((float)x + this.attributvektorx[i] * (float)this.radius);
                    y = (int)((float)y - this.attributvektory[i] * (float)this.radius);
                    if (this.angles[i] >= 0.0f && this.angles[i] <= 90.0f) {
                        x = (int)((float)x + this.attributvektorx[i] * 5.0f);
                        y = (int)((float)y - this.attributvektory[i] * 5.0f);
                    } else if (this.angles[i] >= 90.0f && this.angles[i] < 180.0f) {
                        x = (int)((float)x + this.attributvektorx[i] * 10.0f);
                        y = (int)((float)y - this.attributvektory[i] * 10.0f);
                    } else if (this.angles[i] >= 180.0f && this.angles[i] < 270.0f) {
                        x = (int)((float)x + this.attributvektorx[i] * 15.0f);
                        y = (int)((float)y - this.attributvektory[i] * 15.0f);
                    } else if (this.angles[i] >= 270.0f && this.angles[i] < 360.0f) {
                        x = (int)((float)x + this.attributvektorx[i] * 10.0f);
                        y = (int)((float)y - this.attributvektory[i] * 10.0f);
                    }
                    g.drawString(Integer.toString(i + 1), this.getX(x), this.getY(y));
                }
            }
        }
        g.setColor(this.foreground);
        for (int sample = 0; sample < this.samplex.length; ++sample) {
            this.drawPoint(g, sample);
        }
    }

    public void drawPoint(Graphics g, int sample) {
        int x = this.midx;
        int y = this.midy;
        x += (int)(this.samplex[sample] * (float)this.radius);
        y -= (int)(this.sampley[sample] * (float)this.radius);
        if (this.colorbyattribute) {
            if (this.set.getLabel() != null && this.set.getLabel().getName().equals(this.colorattr.getName())) {
                g.setColor(this.coloring.getColorOfLabelValue(this.colorattr, this.colorvalues[sample]));
            } else if (this.set.getPredictedLabel() != null && this.set.getPredictedLabel().getName().equals(this.colorattr.getName())) {
                if (this.colorattr.isNominal()) {
                    g.setColor(this.colortable[(int)this.colorvalues[sample]]);
                } else {
                    int index = (int)(((double)this.colorvalues[sample] - this.colorattr.getMinimum()) / (this.colorattr.getMaximum() - this.colorattr.getMinimum()) * 99.0);
                    if (index < 0) {
                        index = 0;
                    }
                    if (index > 99) {
                        index = 99;
                    }
                    g.setColor(this.colortable[index]);
                }
            } else {
                if (this.colorattr.isNominal()) {
                    float max = this.colorattr.getNumberOfValues() - 1;
                    int index = (int)(this.colorvalues[sample] * max);
                    g.setColor(this.colortable[index]);
                }
                if (this.colorattr.isNumerical()) {
                    int index = (int)(this.colorvalues[sample] * 99.0f);
                    if (index < 0) {
                        index = 0;
                    }
                    if (index > 99) {
                        index = 99;
                    }
                    g.setColor(this.colortable[index]);
                }
            }
        }
        g.fillRect(this.getX(x - this.pointsize / 2), this.getY(y - this.pointsize / 2), this.pointsize, this.pointsize);
    }

    public float sin(float angle) {
        while (angle >= 180.0f) {
            angle = (float)((double)angle - 180.0);
        }
        double value = (double)(angle / 180.0f) * Math.PI;
        return (float)Math.sin(value);
    }
}

