/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.gui.attributeeditor;

import edu.udo.cs.jvito.JViTo;
import edu.udo.cs.jvito.data.Source;
import edu.udo.cs.jvito.gui.JViToMenu;
import edu.udo.cs.jvito.gui.attributeeditor.AttributeEditor;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.gui.SwingTools;
import edu.udo.cs.yale.operator.UserError;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public class AttributeEditorWindow
extends JDialog {
    private AttributeEditor attributeEditor;

    public AttributeEditorWindow(JFrame owner, Source source, File file) {
        this(owner, source);
        try {
            if (file != null) {
                this.attributeEditor.openAttributeFile(file);
            }
        }
        catch (UserError e) {
            // empty catch block
        }
    }

    public AttributeEditorWindow(JFrame owner, Source source) {
        super(owner, "Attribute Editor", true);
        this.attributeEditor = new AttributeEditor(source);
        this.getContentPane().add((Component)new JScrollPane(this.attributeEditor), "Center");
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.add(new OpenAttributeFileAction());
        fileMenu.add(new SaveAttributeFileAction());
        fileMenu.add(new LoadDataAction());
        fileMenu.add(new SaveDataAction());
        menuBar.add(fileMenu);
        JMenu tableMenu = new JMenu("Table");
        tableMenu.add(this.attributeEditor.GUESS_TYPE_ACTION);
        tableMenu.add(this.attributeEditor.REMOVE_COLUMN_ACTION);
        tableMenu.add(new ClearAction());
        menuBar.add(tableMenu);
        this.setJMenuBar(menuBar);
        this.pack();
    }

    public AttributeEditorWindow(JFrame owner, ExampleSet set) {
        super(owner, "Attribute Editor", true);
        this.attributeEditor = new AttributeEditor(set);
        this.getContentPane().add((Component)new JScrollPane(this.attributeEditor), "Center");
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.add(new OpenAttributeFileAction());
        fileMenu.add(new SaveAttributeFileAction());
        fileMenu.add(new LoadDataAction());
        fileMenu.add(new SaveDataAction());
        menuBar.add(fileMenu);
        JMenu tableMenu = new JMenu("Table");
        tableMenu.add(this.attributeEditor.GUESS_TYPE_ACTION);
        tableMenu.add(this.attributeEditor.REMOVE_COLUMN_ACTION);
        tableMenu.add(new ClearAction());
        menuBar.add(tableMenu);
        this.setJMenuBar(menuBar);
        this.pack();
        if (set != null) {
            this.attributeEditor.showExampleSet();
        }
    }

    public void dispose() {
        super.dispose();
        JViTo.getApplication().getPreferences().setInt("attributeeditor_x", this.getLocation().x);
        JViTo.getApplication().getPreferences().setInt("attributeeditor_y", this.getLocation().y);
        JViTo.getApplication().getPreferences().setInt("attributeeditor_width", this.getWidth());
        JViTo.getApplication().getPreferences().setInt("attributeeditor_height", this.getHeight());
        ((JViToMenu)JViTo.getApplication().getJMenuBar()).updateWindowMenu();
    }

    private void loadData() {
        File file = SwingTools.chooseFile(this, null, true);
        if (file != null) {
            try {
                this.attributeEditor.readFile(file);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, e.toString(), "Error loading " + file, 0);
            }
        }
    }

    private void saveAttributes() {
        this.attributeEditor.saveAttributeFile();
    }

    private void saveData() {
        File file = SwingTools.chooseFile(this, null, false);
        if (file != null) {
            try {
                this.attributeEditor.writeData(file);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, e.toString(), "Error saving data file " + file, 0);
            }
        }
    }

    private void clear() {
        this.attributeEditor.clear();
    }

    public File getFile() {
        return this.attributeEditor.getFile();
    }

    private class ClearAction
    extends AbstractAction {
        private ClearAction() {
            super("Clear");
            this.putValue("ShortDescription", "Clear the table.");
            this.putValue("MnemonicKey", new Integer(67));
        }

        public void actionPerformed(ActionEvent e) {
            AttributeEditorWindow.this.clear();
        }
    }

    private class SaveDataAction
    extends AbstractAction {
        private SaveDataAction() {
            super("Save data...");
            this.putValue("ShortDescription", "Save the contents of the table to a single data file.");
            this.putValue("MnemonicKey", new Integer(86));
        }

        public void actionPerformed(ActionEvent e) {
            AttributeEditorWindow.this.saveData();
        }
    }

    private class LoadDataAction
    extends AbstractAction {
        private LoadDataAction() {
            super("Load data...");
            this.putValue("ShortDescription", "Open data file and append additional columns to table.");
            this.putValue("MnemonicKey", new Integer(68));
        }

        public void actionPerformed(ActionEvent e) {
            AttributeEditorWindow.this.loadData();
        }
    }

    private class SaveAttributeFileAction
    extends AbstractAction {
        private SaveAttributeFileAction() {
            super("Save attribute description file...");
            this.putValue("ShortDescription", "Save current attribute descriptions to XML file.");
            this.putValue("MnemonicKey", new Integer(83));
        }

        public void actionPerformed(ActionEvent e) {
            AttributeEditorWindow.this.saveAttributes();
        }
    }

    private class OpenAttributeFileAction
    extends AbstractAction {
        private OpenAttributeFileAction() {
            super("Open attribute description file...");
            this.putValue("ShortDescription", "Open an existing XML attribute description file.");
            this.putValue("MnemonicKey", new Integer(79));
        }

        public void actionPerformed(ActionEvent e) {
            AttributeEditorWindow.this.attributeEditor.openAttributeFile();
        }
    }
}

