/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.gui;

import edu.udo.cs.jvito.JViTo;
import edu.udo.cs.jvito.data.ExampleColoring;
import edu.udo.cs.jvito.gui.ValueColoringTable;
import edu.udo.cs.jvito.util.Resources;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import java.awt.Color;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.table.AbstractTableModel;

public class ValueColoringTableModel
extends AbstractTableModel {
    private ExampleSet exampleset;
    private ExampleColoring coloring;
    private LinkedList objects;
    private ValueColoringTable table;

    public ValueColoringTableModel(ExampleSet exampleset, ExampleColoring coloring, ValueColoringTable table) {
        this.exampleset = exampleset;
        this.coloring = coloring;
        this.table = table;
        this.objects = new LinkedList();
    }

    public LinkedList getValueRangeObjects() {
        return this.objects;
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int index) {
        if (index == 0) {
            return Resources.getString("EXAMPLECOLORING_ATTRIBUTE");
        }
        if (index == 1) {
            return Resources.getString("EXAMPLECOLORING_RANGE");
        }
        return Resources.getString("EXAMPLECOLORING_COLOR");
    }

    public int getRowCount() {
        int size = 0;
        for (int i = 0; i < this.exampleset.getNumberOfAttributes(); ++i) {
            Attribute att = this.exampleset.getAttribute(i);
            if (att.isNominal()) {
                Object[] values = att.getValues().toArray();
                for (int j = 0; j < values.length; ++j) {
                    if (!this.coloring.hasColorForAttributeValue(att, (String)values[j])) continue;
                    ++size;
                    this.objects.add(new AttValueColor(att, (String)values[j], this.coloring.getColorForAttributeValue(att, (String)values[j])));
                }
            }
            if (!att.isNumerical()) continue;
            LinkedList llist = this.coloring.getRangeForAttribute(att);
            size += llist.size();
            Iterator iter = llist.iterator();
            while (iter.hasNext()) {
                ExampleColoring.MinMaxRangeColor minmax = (ExampleColoring.MinMaxRangeColor)iter.next();
                this.objects.add(new AttValueColor(att, minmax.min, minmax.max, minmax.color));
            }
        }
        return size;
    }

    public Object getValueAt(int row, int column) {
        AttValueColor obj = (AttValueColor)this.objects.get(row);
        if (!obj.isRange()) {
            if (column == 0) {
                return obj.attribute.getName();
            }
            if (column == 1) {
                return obj.value;
            }
            if (column == 2) {
                return obj.color;
            }
        } else {
            if (column == 0) {
                return obj.attribute.getName();
            }
            if (column == 1) {
                return obj.min + "," + obj.max;
            }
            if (column == 2) {
                return obj.color;
            }
        }
        return "";
    }

    public boolean isCellEditable(int row, int column) {
        return column != 0;
    }

    public void setValueAt(Object aValue, int row, int column) {
        AttValueColor obj = (AttValueColor)this.objects.get(row);
        if (column == 2) {
            obj.delete();
            obj.color = (Color)aValue;
            obj.save();
            JViTo.getApplication().setDirty();
        }
        if (column == 1) {
            if (!obj.isRange()) {
                obj.delete();
                StringTokenizer st = new StringTokenizer((String)aValue, ",");
                try {
                    obj.min = Double.parseDouble(st.nextToken());
                    obj.max = Double.parseDouble(st.nextToken());
                }
                catch (NumberFormatException error) {
                    error.printStackTrace();
                }
                obj.value = (String)aValue;
                obj.save();
                this.fireTableDataChanged();
            } else {
                obj.delete();
                StringTokenizer st = new StringTokenizer((String)aValue, ",");
                double mi = obj.min;
                double ma = obj.max;
                try {
                    mi = Double.parseDouble(st.nextToken());
                    ma = Double.parseDouble(st.nextToken());
                }
                catch (Exception error) {
                    error.printStackTrace();
                    mi = obj.min;
                    ma = obj.max;
                }
                obj.min = mi;
                obj.max = ma;
                obj.save();
                this.fireTableDataChanged();
            }
            JViTo.getApplication().setDirty();
        }
    }

    public void removeRow(int index) {
        ((AttValueColor)this.objects.remove(index)).delete();
        JViTo.getApplication().setDirty();
        this.fireTableDataChanged();
    }

    public boolean insertRow(Attribute attribute, int index, String value) {
        if (!attribute.isNominal()) {
            return false;
        }
        if (this.coloring.hasColorForAttributeValue(attribute, value)) {
            return false;
        }
        AttValueColor attvalue = new AttValueColor(attribute, value, ExampleColoring.DEFAULT_COLOR);
        attvalue.save();
        this.objects.add(index, attvalue);
        JViTo.getApplication().setDirty();
        return true;
    }

    public boolean insertRow(Attribute attribute, int index, double min, double max) {
        if (!attribute.isNumerical()) {
            return false;
        }
        if (this.coloring.conflictsWithAttributeRange(attribute, min, max)) {
            return false;
        }
        AttValueColor attvalue = new AttValueColor(attribute, min, max, ExampleColoring.DEFAULT_COLOR);
        attvalue.save();
        this.objects.add(index, attvalue);
        JViTo.getApplication().setDirty();
        return true;
    }

    public class AttValueColor {
        public Attribute attribute;
        public String value;
        public Color color;
        public double min;
        public double max;
        private boolean range;

        public AttValueColor(Attribute attribute, String value, Color color) {
            this.attribute = attribute;
            this.value = value;
            this.color = color;
            this.range = false;
        }

        public AttValueColor(Attribute attribute, ExampleColoring.MinMaxRangeColor minmax) {
            this.attribute = attribute;
            this.color = minmax.color;
            this.min = minmax.min;
            this.max = minmax.max;
            this.range = true;
        }

        public AttValueColor(Attribute attribute, double min, double max, Color color) {
            this.attribute = attribute;
            this.color = color;
            this.min = min;
            this.max = max;
            this.range = true;
        }

        public boolean isRange() {
            return this.range;
        }

        public void save() {
            if (this.range) {
                ValueColoringTableModel.this.coloring.setColorForAttributeRange(this.attribute, this.min, this.max, this.color);
            } else {
                ValueColoringTableModel.this.coloring.setColorForAttributeValue(this.attribute, this.value, this.color);
            }
        }

        public void delete() {
            if (this.range) {
                ValueColoringTableModel.this.coloring.removeAttributeRange(this.attribute, this.min, this.max);
            } else {
                ValueColoringTableModel.this.coloring.removeColorForAttributeValue(this.attribute, this.value);
            }
        }
    }
}

