/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.gui;

import edu.udo.cs.jvito.GroupTree;
import edu.udo.cs.jvito.JViTo;
import edu.udo.cs.jvito.OperatorDescription;
import edu.udo.cs.jvito.OperatorsReader;
import edu.udo.cs.jvito.exception.KeyException;
import edu.udo.cs.jvito.gui.AboutDialog;
import edu.udo.cs.jvito.gui.Application;
import edu.udo.cs.jvito.gui.Browser;
import edu.udo.cs.jvito.gui.ExecutableMenuItem;
import edu.udo.cs.jvito.gui.OperatorMenuItem;
import edu.udo.cs.jvito.gui.PreferencesDialog;
import edu.udo.cs.jvito.gui.ShowWindowListener;
import edu.udo.cs.jvito.util.Logger;
import edu.udo.cs.jvito.util.RecentFiles;
import edu.udo.cs.jvito.util.Resources;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class JViToMenu
extends JMenuBar {
    private static Vector menu_items;
    private Vector menus;
    private Application app;
    private JMenu recentfiles;
    private JMenu operatorsmenu;
    private JMenu windowmenu;
    private ExecutableMenuItem preferencesitem;
    private RecentFiles recentFiles;

    public JViToMenu(Application app) {
        this.app = app;
        menu_items = new Vector();
        this.menus = new Vector();
        this.initComponents();
        this.initRecentFiles();
        this.setRecentFilesMenu();
        this.enableClose();
    }

    public RecentFiles getRecentFiles() {
        return this.recentFiles;
    }

    public JMenu getOperatorsMenu() {
        return this.operatorsmenu;
    }

    private void initRecentFiles() {
        String recent;
        this.recentFiles = new RecentFiles(8);
        try {
            recent = this.app.getPreferences().getString("recent_files");
        }
        catch (KeyException error) {
            return;
        }
        StringTokenizer st = new StringTokenizer(recent, ";");
        int pos = 1;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!new File(token).exists()) continue;
            this.recentFiles.setRecentFile(token, pos);
            ++pos;
        }
    }

    public void setRecentFilesMenu() {
        this.recentfiles.removeAll();
        for (int i = 0; i < this.recentFiles.getSize(); ++i) {
            String name = this.recentFiles.getFile(i);
            ExecutableMenuItem recent = new ExecutableMenuItem(name, true){

                public void execute() {
                    JViToMenu.this.recentFiles.setRecentFile(this.getRealName());
                    JViToMenu.this.setRecentFilesMenu();
                    JViToMenu.this.app.promptOpen(new File(this.getRealName()));
                }
            };
            this.recentfiles.add(recent);
        }
        this.revalidate();
        this.repaint();
    }

    public void setMenuEnabled(String key, boolean bool) {
        String name = Resources.getString(key);
        for (int i = 0; i < this.menus.size(); ++i) {
            JMenu comp = (JMenu)this.menus.get(i);
            if (!comp.getName().equals(name)) continue;
            comp.setEnabled(bool);
            return;
        }
    }

    public boolean isMenuEnabled(String key) {
        String name = Resources.getString(key);
        for (int i = 0; i < this.menus.size(); ++i) {
            JMenu comp = (JMenu)this.menus.get(i);
            if (!comp.getName().equals(name)) continue;
            return comp.isEnabled();
        }
        return false;
    }

    public void setMenuItemEnabled(String key, boolean bool) {
        String name = Resources.getString(key);
        for (int i = 0; i < menu_items.size(); ++i) {
            JMenuItem comp = (JMenuItem)menu_items.get(i);
            if (!comp.getName().equals(name)) continue;
            comp.setEnabled(bool);
            return;
        }
    }

    public boolean isMenuItemEnabled(String key) {
        String name = Resources.getString(key);
        for (int i = 0; i < menu_items.size(); ++i) {
            JMenuItem comp = (JMenuItem)menu_items.get(i);
            if (!comp.getName().equals(name)) continue;
            return comp.isEnabled();
        }
        return false;
    }

    public void enableNew() {
        this.setMenuEnabled(Resources.getString("MENU_EDIT"), true);
        this.setMenuEnabled(Resources.getString("MENU_PROJECT"), true);
        this.setMenuItemEnabled(Resources.getString("MENU_FILE_SAVE"), true);
        this.setMenuItemEnabled(Resources.getString("MENU_FILE_SAVEAS"), true);
        this.setMenuItemEnabled(Resources.getString("MENU_FILE_CLOSE"), true);
    }

    public void enableClose() {
        this.setMenuEnabled(Resources.getString("MENU_EDIT"), false);
        this.setMenuEnabled(Resources.getString("MENU_PROJECT"), false);
        this.setMenuItemEnabled(Resources.getString("MENU_FILE_SAVE"), false);
        this.setMenuItemEnabled(Resources.getString("MENU_FILE_SAVEAS"), false);
        this.setMenuItemEnabled(Resources.getString("MENU_FILE_CLOSE"), false);
    }

    private void initComponents() {
        this.createFileMenu();
        this.createEditMenu();
        this.createProjectMenu();
        this.createWindowMenu();
        this.createHelpMenu();
    }

    private void createFileMenu() {
        JMenu menu = new JMenu(Resources.getString("MENU_FILE"));
        menu.setMnemonic(Resources.getChar("MNEMOMIC_MENU_FILE"));
        menu.setName(Resources.getString("MENU_FILE"));
        this.menus.add(menu);
        ExecutableMenuItem item = new ExecutableMenuItem(menu, "MENU_FILE_NEW"){

            public void execute() {
                JViToMenu.this.app.promptNew();
            }
        };
        item = new ExecutableMenuItem(menu, "MENU_FILE_OPEN"){

            public void execute() {
                JViToMenu.this.app.promptOpen();
                if (JViToMenu.this.app.getProjectFile() != null) {
                    JViToMenu.this.getRecentFiles().setRecentFile(JViToMenu.this.app.getProjectFile().toString());
                    JViToMenu.this.setRecentFilesMenu();
                }
            }
        };
        this.recentfiles = new JMenu(Resources.getString("MENU_FILE_RECENT"));
        this.recentfiles.setMnemonic(Resources.getChar("MNEMONIC_MENU_FILE_RECENT"));
        this.recentfiles.setName(Resources.getString("MENU_FILE_RECENT"));
        this.recentfiles.setIcon(Resources.getImageIcon("MENU_FILE_RECENT"));
        menu.add(this.recentfiles);
        this.menus.add(this.recentfiles);
        item = new ExecutableMenuItem(menu, "MENU_FILE_SAVE"){

            public void execute() {
                JViToMenu.this.app.promptSave();
                ((JViToMenu)JViToMenu.this.app.getJMenuBar()).getRecentFiles().setRecentFile(JViToMenu.this.app.getProjectFile().toString());
                ((JViToMenu)JViToMenu.this.app.getJMenuBar()).setRecentFilesMenu();
            }
        };
        menu_items.add(item);
        item = new ExecutableMenuItem(menu, "MENU_FILE_SAVEAS"){

            public void execute() {
                JViToMenu.this.app.promptSaveAs();
                ((JViToMenu)JViToMenu.this.app.getJMenuBar()).getRecentFiles().setRecentFile(JViToMenu.this.app.getProjectFile().toString());
                ((JViToMenu)JViToMenu.this.app.getJMenuBar()).setRecentFilesMenu();
            }
        };
        menu_items.add(item);
        item = new ExecutableMenuItem(menu, "MENU_FILE_CLOSE"){

            public void execute() {
                JViToMenu.this.app.promptClose();
            }
        };
        menu_items.add(item);
        menu.addSeparator();
        item = new ExecutableMenuItem(menu, "MENU_FILE_EXIT"){

            public void execute() {
                JViToMenu.this.app.promptExit();
            }
        };
        menu_items.add(item);
        this.add(menu);
    }

    private void createEditMenu() {
        JMenu menu = new JMenu(Resources.getString("MENU_EDIT"));
        menu.setMnemonic(Resources.getChar("MNEMOMIC_MENU_EDIT"));
        menu.setName(Resources.getString("MENU_EDIT"));
        this.menus.add(menu);
        ExecutableMenuItem item = new ExecutableMenuItem(menu, "MENU_EDIT_CUT"){

            public void execute() {
            }
        };
        menu_items.add(item);
        item = new ExecutableMenuItem(menu, "MENU_EDIT_COPY"){

            public void execute() {
            }
        };
        menu_items.add(item);
        item = new ExecutableMenuItem(menu, "MENU_EDIT_PASTE"){

            public void execute() {
            }
        };
        menu_items.add(item);
        menu.addSeparator();
        item = new ExecutableMenuItem(menu, "MENU_EDIT_DELETE"){

            public void execute() {
            }
        };
        menu_items.add(item);
        this.add(menu);
    }

    private void createProjectMenu() {
        JMenu menu = new JMenu(Resources.getString("MENU_PROJECT"));
        menu.setMnemonic(Resources.getChar("MNEMOMIC_MENU_PROJECT"));
        menu.setName(Resources.getString("MENU_PROJECT"));
        this.menus.add(menu);
        this.operatorsmenu = new JMenu(Resources.getString("OPERATORS"));
        menu.add(this.operatorsmenu);
        JViToMenu.createOperatorsMenu(this.operatorsmenu, OperatorsReader.getGroups());
        menu.addSeparator();
        ExecutableMenuItem item = new ExecutableMenuItem(menu, "MENU_PROJECT_INPUT"){

            public void execute() {
                JViToMenu.this.app.showInputDialog();
            }
        };
        menu_items.add(item);
        item = new ExecutableMenuItem(menu, "MENU_PROJECT_REMOVESOURCE"){

            public void execute() {
                if (((JViToMenu)JViToMenu.this).app.navigator.removeSource()) {
                    Logger.logMessage("Removed Source.", 3);
                }
            }
        };
        menu_items.add(item);
        item = new ExecutableMenuItem(menu, "MENU_PROJECT_REMOVEPLOT"){

            public void execute() {
                if (((JViToMenu)JViToMenu.this).app.navigator.removePlot()) {
                    Logger.logMessage("Removed Plot.", 3);
                }
            }
        };
        menu_items.add(item);
        menu.addSeparator();
        item = new ExecutableMenuItem(menu, "MENU_PROJECT_COMPILESELECTED"){

            public void execute() {
                JViToMenu.this.app.promptCompile(0);
            }
        };
        menu_items.add(item);
        item = new ExecutableMenuItem(menu, "MENU_PROJECT_COMPILEALL"){

            public void execute() {
                JViToMenu.this.app.promptCompile(1);
            }
        };
        menu_items.add(item);
        item = new ExecutableMenuItem(menu, "MENU_PROJECT_COMPILECHILDS"){

            public void execute() {
                JViToMenu.this.app.promptCompile(2);
            }
        };
        menu_items.add(item);
        item = new ExecutableMenuItem(menu, "MENU_PROJECT_COMPILEPARENTS"){

            public void execute() {
                JViToMenu.this.app.promptCompile(3);
            }
        };
        menu_items.add(item);
        menu.addSeparator();
        item = new ExecutableMenuItem(menu, "MENU_PROJECT_SHOW_DATA"){

            public void execute() {
                JViToMenu.this.app.promptShowData();
            }
        };
        menu_items.add(item);
        item = new ExecutableMenuItem(menu, "MENU_PROJECT_SHOW_EXAMPLECOLORING"){

            public void execute() {
                JViToMenu.this.app.promptShowExampleColoring();
            }
        };
        menu_items.add(item);
        item = new ExecutableMenuItem(menu, "MENU_PROJECT_SHOW_VISCOMP"){

            public void execute() {
                JViToMenu.this.app.promptShowVisualizationComponent();
            }
        };
        menu_items.add(item);
        item = new ExecutableMenuItem(menu, "MENU_PROJECT_SHOW_PLOT"){

            public void execute() {
                JViToMenu.this.app.promptShowPlot();
            }
        };
        menu_items.add(item);
        item = new ExecutableMenuItem(menu, "MENU_PROJECT_SAVE_PLOT"){

            public void execute() {
                JViToMenu.this.app.promptSavePlot();
            }
        };
        menu_items.add(item);
        this.add(menu);
    }

    public static void createOperatorsMenu(JMenu menu, GroupTree group) {
        Collection subgroups = group.getSubGroups();
        Iterator iter = subgroups.iterator();
        while (iter.hasNext()) {
            GroupTree subgroup = (GroupTree)iter.next();
            JMenu submenu = new JMenu(subgroup.getName());
            menu.add(submenu);
            JViToMenu.createOperatorsMenu(submenu, subgroup);
        }
        Set set = group.getOperators();
        iter = set.iterator();
        while (iter.hasNext()) {
            String opname = (String)iter.next();
            OperatorDescription desc = OperatorsReader.getOperatorDescription(opname);
            OperatorMenuItem item = new OperatorMenuItem(menu, desc);
            menu_items.add(item);
        }
    }

    private void createWindowMenu() {
        this.windowmenu = new JMenu(Resources.getString("MENU_WINDOW"));
        this.windowmenu.setMnemonic(Resources.getChar("MNEMOMIC_MENU_WINDOW"));
        this.windowmenu.setName(Resources.getString("MENU_WINDOW"));
        this.menus.add(this.windowmenu);
        this.preferencesitem = new ExecutableMenuItem(this.windowmenu, "MENU_WINDOW_PREFERENCES"){

            public void execute() {
                PreferencesDialog d = new PreferencesDialog(JViToMenu.this.app);
            }
        };
        menu_items.add(this.preferencesitem);
        this.add(this.windowmenu);
    }

    public void updateWindowMenu() {
        this.windowmenu.removeAll();
        this.windowmenu.add(this.preferencesitem);
        JInternalFrame[] frames = this.app.getJDesktopPane().getAllFrames();
        if (frames.length > 0) {
            this.windowmenu.addSeparator();
        }
        for (int f = 0; f < frames.length; ++f) {
            JCheckBoxMenuItem frameitem = new JCheckBoxMenuItem(frames[f].getTitle(), frames[f].isSelected());
            frameitem.addItemListener(new ShowWindowListener(frames[f]));
            this.windowmenu.add(frameitem);
        }
    }

    private void createHelpMenu() {
        JMenu menu = new JMenu(Resources.getString("MENU_HELP"));
        menu.setMnemonic(Resources.getChar("MNEMOMIC_MENU_HELP"));
        menu.setName(Resources.getString("MENU_HELP"));
        this.menus.add(menu);
        ExecutableMenuItem item = new ExecutableMenuItem(menu, "MENU_HELP_WELCOME"){

            public void execute() {
            }
        };
        menu_items.add(item);
        item = new ExecutableMenuItem(menu, "MENU_HELP_HELP"){

            public void execute() {
            }
        };
        menu_items.add(item);
        item = new ExecutableMenuItem(menu, "MENU_HELP_WEB"){

            public void execute() {
                Browser.showDialog(Resources.getURL("BROWSER_WWW_URL"));
            }
        };
        menu_items.add(item);
        menu.addSeparator();
        item = new ExecutableMenuItem(menu, "MENU_HELP_ABOUT"){

            public void execute() {
                AboutDialog about = new AboutDialog(JViTo.getApplication());
                about.setVisible(true);
            }
        };
        menu_items.add(item);
        item = new ExecutableMenuItem(menu, "MENU_HELP_LICENCE"){

            public void execute() {
                Browser.showDialog(Resources.getURLByClassLoader("BROWSER_LICENCE_URL"));
            }
        };
        menu_items.add(item);
        this.add(menu);
    }
}

