/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.data;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import edu.udo.cs.jvito.data.Source;
import edu.udo.cs.jvito.exception.CompilerException;
import edu.udo.cs.jvito.util.Logger;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.DoubleArrayDataRow;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ListDataRowReader;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import java.util.LinkedList;
import java.util.List;

public class PCA
extends Source {
    private double[][] data;
    private Matrix dataMatrix;
    private double[][] covarianz;
    private Matrix covMatrix;
    private double[] eigenvalues;
    private Matrix eigenvalueMatrix;
    private double[][] eigenvectors;
    private Matrix eigenvectorMatrix;
    private double[][] finaldata;
    private Matrix finaldataMatrix;
    private ExampleSet set;
    private boolean haslabel;
    private boolean haspredlabel;
    private Attribute label;
    private Attribute prediction;
    private double[] labelvalues;
    private double[] predvalues;
    private ExampleSet pca_set;

    public List getParameterTypes() {
        LinkedList<ParameterTypeDouble> list = new LinkedList<ParameterTypeDouble>();
        ParameterTypeSingle type = new ParameterTypeDouble("variance_of_components", "Keep the number of components having this cumulative proportion of variance.", 0.0, 1.0, 0.95);
        list.add((ParameterTypeDouble)type);
        type = new ParameterTypeBoolean("manual_number", "Keep a fixed number of components entered in 'keep_components'.", false);
        list.add((ParameterTypeDouble)type);
        type = new ParameterTypeInt("keep_components", "Keep this number of components. If '-1' then keep all components.'", -1, Integer.MAX_VALUE, -1);
        list.add((ParameterTypeDouble)type);
        type = new ParameterTypeBoolean("show_component_properties", "Shows properties of the components.", true);
        list.add((ParameterTypeDouble)type);
        return list;
    }

    public void setParameter(String key, Object object) {
        if (key.equals("keep_components")) {
            if (object instanceof String && ((String)object).equals("0")) {
                this.setParameter(key, (Object)"-1");
            } else {
                super.setParameter(key, object);
            }
        } else {
            super.setParameter(key, object);
        }
    }

    public void compile() throws CompilerException {
        this.iscompiling = true;
        this.set = this.getSource().getExampleSet();
        this.set.recalculateAllAttributeStatistics();
        Attribute[] att = new Attribute[this.set.getNumberOfAttributes()];
        for (int a = 0; a < this.set.getNumberOfAttributes(); ++a) {
            att[a] = this.set.getAttribute(a);
            if (att[a].isNumerical()) continue;
            this.iscompiling = false;
            throw new CompilerException("All attributes must be numeric.");
        }
        this.data = new double[this.set.getSize()][this.set.getNumberOfAttributes()];
        this.haslabel = this.set.getLabel() != null;
        boolean bl = this.haspredlabel = this.set.getPredictedLabel() != null;
        if (this.haslabel) {
            this.label = this.set.getLabel();
            this.labelvalues = new double[this.set.getSize()];
        }
        if (this.haspredlabel) {
            this.prediction = this.set.getPredictedLabel();
            this.predvalues = new double[this.set.getSize()];
        }
        ExampleReader reader = this.set.getExampleReader();
        for (int sample = 0; sample < this.set.getSize(); ++sample) {
            Example example = reader.next();
            for (int d = 0; d < this.set.getNumberOfAttributes(); ++d) {
                this.data[sample][d] = example.getValue(d) - att[d].getAverage();
                if (this.haslabel) {
                    this.labelvalues[sample] = example.getLabel();
                }
                if (!this.haspredlabel) continue;
                this.predvalues[sample] = example.getPredictedLabel();
            }
        }
        this.dataMatrix = new Matrix(this.data);
        this.covarianz = new double[this.set.getNumberOfAttributes()][this.set.getNumberOfAttributes()];
        for (int i = 0; i < this.set.getNumberOfAttributes(); ++i) {
            for (int j = 0; j < this.set.getNumberOfAttributes(); ++j) {
                double cov = this.getCovarianz(i, j);
                if (i != j) {
                    this.covarianz[i][j] = cov;
                    this.covarianz[j][i] = cov;
                    continue;
                }
                this.covarianz[i][j] = cov;
            }
        }
        this.covMatrix = new Matrix(this.covarianz);
        EigenvalueDecomposition eig = this.covMatrix.eig();
        this.eigenvalues = eig.getRealEigenvalues();
        this.eigenvectorMatrix = eig.getV();
        this.eigenvectors = this.eigenvectorMatrix.getArray();
        this.quickSort(this.eigenvalues, 0, this.eigenvalues.length - 1);
        double sumvariance = 0.0;
        for (int e = 0; e < this.eigenvalues.length; ++e) {
            sumvariance += this.eigenvalues[e];
        }
        double cumulative = 0.0;
        double proportion = 0.0;
        double[] cumvariance = new double[this.eigenvalues.length];
        String props = new String("");
        props = props + "\n";
        props = props + "\n";
        props = props + this.getString("Comp", 6, 0);
        props = props + "| ";
        props = props + this.getString("standard deviation", 25, 0);
        props = props + "| ";
        props = props + this.getString("proportion of variance", 25, 0);
        props = props + "| ";
        props = props + this.getString("cumulative proportion", 25, 0);
        props = props + "\n";
        props = props + "------+--------------------------+--------------------------+--------------------------\n";
        for (int e = 0; e < this.eigenvalues.length; ++e) {
            props = props + this.getString(Integer.toString(e + 1), 6, 0);
            props = props + "| ";
            props = props + this.getString(Double.toString(Math.sqrt(this.eigenvalues[e])), 25, 1);
            props = props + "| ";
            proportion = this.eigenvalues[e] / sumvariance;
            cumvariance[e] = cumulative += proportion;
            props = props + this.getString(Double.toString(proportion), 25, 1);
            props = props + "| ";
            props = props + this.getString(Double.toString(cumulative), 25, 1);
            props = props + "\n";
        }
        props = props + "\n";
        props = props + "\n";
        if (this.getParameterAsBoolean("show_component_properties")) {
            Logger.logMessage(props, 3);
        }
        this.eigenvectorMatrix = new Matrix(this.eigenvectors);
        this.eigenvectorMatrix = this.eigenvectorMatrix.transpose();
        this.finaldataMatrix = this.eigenvectorMatrix.times(this.dataMatrix.transpose()).transpose();
        int components = -1;
        if (this.getParameterAsBoolean("manual_number")) {
            components = this.getParameterAsInt("keep_components");
        } else {
            double variance = this.getParameterAsDouble("variance_of_components");
            if (variance == 0.0) {
                components = -1;
            } else {
                components = 0;
                while (cumvariance[components] < variance) {
                    ++components;
                }
                if (++components == this.eigenvalues.length) {
                    --components;
                }
            }
        }
        if (components == -1) {
            components = this.set.getNumberOfAttributes();
        }
        Logger.logMessage("Kept the first " + components + " components.", 3);
        this.finaldataMatrix = new Matrix(this.finaldataMatrix.getArray(), this.set.getSize(), components);
        this.finaldata = this.finaldataMatrix.getArray();
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        for (int i = 0; i < components; ++i) {
            attributes.add(AttributeFactory.createAttribute("pc_" + (i + 1), 4));
        }
        if (this.haslabel) {
            attributes.add(this.label);
        }
        if (this.haspredlabel) {
            attributes.add(this.prediction);
        }
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        LinkedList<DoubleArrayDataRow> data = null;
        data = new LinkedList<DoubleArrayDataRow>();
        int nr = components;
        if (this.haslabel) {
            ++nr;
        }
        if (this.haspredlabel) {
            ++nr;
        }
        for (int n = 0; n < this.set.getSize(); ++n) {
            double[] samples = new double[nr];
            System.arraycopy(this.finaldata[n], 0, samples, 0, components);
            if (this.haslabel) {
                samples[components] = this.labelvalues[n];
            }
            if (this.haspredlabel) {
                samples[nr - 1] = this.predvalues[n];
            }
            data.add(new DoubleArrayDataRow(samples));
        }
        table.readExamples(new ListDataRowReader(data.iterator()));
        this.pca_set = table.createCompleteExampleSet(this.label, this.prediction, null, null);
        this.pca_set.recalculateAllAttributeStatistics();
        if (this.pca_set.getSize() == 0) {
            this.iscompiling = false;
            throw new CompilerException("Size of the ExampleSet is null.");
        }
        this.iscompiled = true;
        this.iscompiling = false;
    }

    public String getString(String string, int length, int align) {
        if (string.length() >= length) {
            return string;
        }
        for (int count = length - string.length(); count > 0; --count) {
            if (align == 0) {
                string = string + " ";
            }
            if (align != 1) continue;
            string = " " + string;
        }
        return string;
    }

    public void quickSort(double[] array, int links, int rechts) {
        int left = links;
        int right = rechts;
        double pivot = array[(links + rechts) / 2];
        while (true) {
            if (array[left] > pivot) {
                ++left;
                continue;
            }
            while (array[right] < pivot) {
                --right;
            }
            if (left <= right) {
                double temp = array[left];
                array[left] = array[right];
                array[right] = temp;
                for (int n = 0; n < this.eigenvectors.length; ++n) {
                    temp = this.eigenvectors[n][left];
                    this.eigenvectors[n][left] = this.eigenvectors[n][right];
                    this.eigenvectors[n][right] = temp;
                }
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (links < right) {
            this.quickSort(array, links, right);
        }
        if (left < rechts) {
            this.quickSort(array, left, rechts);
        }
    }

    private double getCovarianz(int dim1, int dim2) {
        double cov = 0.0;
        for (int sample = 0; sample < this.set.getSize(); ++sample) {
            cov += this.data[sample][dim1] * this.data[sample][dim2];
        }
        return cov /= (double)(this.set.getSize() - 1);
    }

    public ExampleSet getExampleSet() {
        return this.pca_set;
    }
}

