/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.data;

import edu.udo.cs.jvito.data.Source;
import edu.udo.cs.jvito.exception.CompilerException;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.DataRowFactory;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ExampleTable;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.example.ResultSetDataRowReader;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.io.KDBExampleSource;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.tools.DatabaseHandler;
import edu.udo.cs.yale.tools.LogService;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.kobjects.jdbc.TableManager;
import org.kobjects.jdbc.util.AbstractResultSet;

public class KDExampleSource
extends Source {
    private KDBExampleSource ex_source;
    private static final String[] FORMAT_TYPES = new String[]{"arff", "csv", "dbase", "bibtex"};

    public KDExampleSource() {
        this.plots = new LinkedList();
        this.sources = new LinkedList();
        this.initExampleSource();
    }

    public KDExampleSource(String name) {
        this.name = name;
        this.plots = new LinkedList();
        this.sources = new LinkedList();
        this.initExampleSource();
    }

    public void initExampleSource() {
        if (this.ex_source == null) {
            // empty if block
        }
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        if (this.ex_source == null) {
            this.initExampleSource();
        }
        List types_source = this.ex_source.getParameterTypes();
        Iterator iter = types_source.iterator();
        while (iter.hasNext()) {
            ParameterType type = (ParameterType)iter.next();
            types.add(type);
        }
        return types;
    }

    public void compile() throws CompilerException {
        this.iscompiling = true;
        int dataRowType = this.getParameterAsInt("datamanagement");
        ResultSet resultSet = this.getResultSet();
        List attributeList = null;
        try {
            attributeList = DatabaseHandler.createAttributes(resultSet);
        }
        catch (SQLException e) {
            this.iscompiling = false;
            throw new CompilerException("Can not create attribute list.", e);
        }
        try {
            this.setNominalValues(attributeList, resultSet, KDExampleSource.find(attributeList, this.getParameterAsString("label_attribute")));
        }
        catch (OperatorException e) {
            this.iscompiling = false;
            throw new CompilerException(e.getMessage(), e);
        }
        ResultSetDataRowReader reader = new ResultSetDataRowReader(new DataRowFactory(dataRowType), attributeList, resultSet);
        MemoryExampleTable table = new MemoryExampleTable(attributeList, reader);
        try {
            this.exampleset = this.createExampleSet(table);
        }
        catch (OperatorException e) {
            this.iscompiling = false;
            throw new CompilerException(e.getMessage(), e);
        }
        this.iscompiling = false;
        this.iscompiled = true;
    }

    private static Attribute find(List attributeList, String name) throws OperatorException {
        if (name == null) {
            return null;
        }
        Iterator i = attributeList.iterator();
        while (i.hasNext()) {
            Attribute attribute = (Attribute)i.next();
            if (!attribute.getName().equals(name)) continue;
            return attribute;
        }
        throw new UserError(null, 111, name);
    }

    protected ExampleSet createExampleSet(ExampleTable table) throws OperatorException {
        String labelName = this.getParameterAsString("label_attribute");
        String weightName = this.getParameterAsString("weight_attribute");
        String idName = this.getParameterAsString("id_attribute");
        Attribute label = table.findAttribute(labelName);
        Attribute weight = table.findAttribute(weightName);
        Attribute id = table.findAttribute(idName);
        return table.createCompleteExampleSet(label, null, weight, id);
    }

    public ResultSet getResultSet() {
        String dataFile = this.getParameterAsString("data_file");
        int format = this.getParameterAsInt("format");
        String dataFileAbsolutePath = new File(dataFile).getAbsolutePath();
        return TableManager.getResultSet((String)(FORMAT_TYPES[format] + ":" + dataFileAbsolutePath), (int)1);
    }

    public void setNominalValues(List attributeList, ResultSet resultSet, Attribute label) {
        if (resultSet instanceof AbstractResultSet) {
            AbstractResultSet ars = (AbstractResultSet)resultSet;
            Iterator i = attributeList.iterator();
            int j = 0;
            while (i.hasNext()) {
                Attribute attribute = (Attribute)i.next();
                Object[] values = ars.getColumnSet().getColumn(++j).getValues();
                if (!attribute.isNominal()) continue;
                if (values == null) {
                    LogService.logMessage("Information about class values is null!", 4);
                    continue;
                }
                for (int k = 0; k < values.length; ++k) {
                    attribute.mapString(values[k].toString());
                }
            }
        } else {
            LogService.logMessage("Result set does not provide information about class values!", 4);
        }
    }
}

