/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.data;

import edu.udo.cs.jvito.data.Source;
import edu.udo.cs.jvito.exception.CompilerException;
import edu.udo.cs.mySVM.Examples.ExampleSet;
import edu.udo.cs.mySVM.SVM.SVMInterface;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.DoubleArrayDataRow;
import edu.udo.cs.yale.example.ListDataRowReader;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.Model;
import edu.udo.cs.yale.operator.learner.kernel.JMySVMModel;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class JMySVMModelLoader
extends Source {
    private JMySVMModel jmysvmmodel;
    private AttributeWeights weights;

    public JMySVMModelLoader() {
        this.plots = new LinkedList();
        this.sources = new LinkedList();
    }

    public JMySVMModelLoader(String name) {
        this.name = name;
        this.plots = new LinkedList();
        this.sources = new LinkedList();
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeFile("model_file", "Filename of the JMySVM model file.", false));
        types.add(new ParameterTypeBoolean("alpha", "Add the alpha values as an attribute.", false));
        types.add(new ParameterTypeString("classes", "The string representation of the classes. Note: Specify the negative class first!", "negative positive"));
        return types;
    }

    public void compile() throws CompilerException {
        boolean scaled;
        this.iscompiling = true;
        this.readModel();
        ExampleSet modelSet = this.jmysvmmodel.getExampleSet();
        double[][] atts = modelSet.atts;
        int[][] index = modelSet.index;
        double[] y = modelSet.get_ys();
        double[] alphas = modelSet.get_alphas();
        boolean addalpha = this.getParameterAsBoolean("alpha");
        Map meanvariances = modelSet.getMeanVariances();
        boolean bl = scaled = meanvariances != null;
        if (meanvariances != null) {
            scaled = !meanvariances.isEmpty();
        }
        int dim = modelSet.get_dim();
        int size = modelSet.count_examples();
        Attribute label = AttributeFactory.createAttribute("class", 1);
        StringTokenizer st = new StringTokenizer(this.getParameterAsString("classes"), " ");
        String pos = "p";
        String neg = "n";
        if (st.hasMoreTokens()) {
            pos = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            neg = st.nextToken();
        }
        label.mapString(pos);
        label.mapString(neg);
        Attribute alpha = AttributeFactory.createAttribute("alpha", 4);
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        for (int i = 0; i < dim; ++i) {
            attributes.add(AttributeFactory.createAttribute("att_" + (i + 1), 4));
        }
        if (addalpha) {
            attributes.add(alpha);
        }
        attributes.add(label);
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        LinkedList<DoubleArrayDataRow> data = null;
        data = new LinkedList<DoubleArrayDataRow>();
        int nr = dim + 1;
        if (addalpha) {
            ++nr;
        }
        for (int n = 0; n < size; ++n) {
            int i;
            double[] samples = new double[nr];
            for (i = 0; i < dim; ++i) {
                samples[i] = 0.0;
            }
            for (i = 0; i < atts[n].length; ++i) {
                samples[index[n][i]] = atts[n][i];
            }
            if (scaled) {
                for (i = 0; i < dim; ++i) {
                    ExampleSet.MeanVariance meanvariance = (ExampleSet.MeanVariance)meanvariances.get(new Integer(i));
                    if (meanvariance == null) continue;
                    samples[i] = samples[i] * Math.sqrt(meanvariance.getVariance()) + meanvariance.getMean();
                }
            }
            if (addalpha) {
                samples[nr - 2] = alphas[n];
            }
            samples[nr - 1] = y[n] == 1.0 ? (double)label.getPositiveIndex() : (double)label.getNegativeIndex();
            data.add(new DoubleArrayDataRow(samples));
        }
        table.readExamples(new ListDataRowReader(data.iterator()));
        this.exampleset = table.createCompleteExampleSet(label, null, null, null);
        this.exampleset.recalculateAllAttributeStatistics();
        SVMInterface svm2 = this.jmysvmmodel.createSVM();
        svm2.init(this.jmysvmmodel.getKernel(), this.jmysvmmodel.getExampleSet());
        double[] w = svm2.getWeights();
        this.weights = new AttributeWeights();
        for (int i = 0; i < w.length; ++i) {
            this.weights.setWeight(this.exampleset.getAttribute(i).getName(), w[i]);
        }
        this.iscompiling = false;
        this.iscompiled = true;
    }

    private void readModel() throws CompilerException {
        String filename = this.getParameterAsString("model_file");
        File modelFile = new File(filename);
        Model model = null;
        try {
            model = Model.readModel(modelFile);
        }
        catch (IOException e) {
            throw new CompilerException(e.getMessage(), e);
        }
        catch (OperatorException e) {
            throw new CompilerException(e.getMessage(), e);
        }
        if (!(model instanceof JMySVMModel)) {
            throw new CompilerException("Only JMySVMModels can be loaded!");
        }
        this.jmysvmmodel = (JMySVMModel)model;
    }

    public Component getVisualisationComponent() {
        if (!this.iscompiled) {
            return new JPanel();
        }
        JTabbedPane tabpane = new JTabbedPane();
        JScrollPane scrollpane = new JScrollPane(this.jmysvmmodel.getVisualisationComponent());
        tabpane.addTab("JMySVMModel", scrollpane);
        scrollpane = new JScrollPane(this.exampleset.getVisualisationComponent());
        tabpane.addTab("ExampleSet", scrollpane);
        scrollpane = new JScrollPane(this.weights.getVisualisationComponent());
        tabpane.addTab("AttributeWeights", scrollpane);
        return tabpane;
    }
}

