/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.data;

import edu.udo.cs.jvito.JViTo;
import edu.udo.cs.jvito.XMLDocument;
import edu.udo.cs.jvito.data.Source;
import edu.udo.cs.jvito.exception.CompilerException;
import edu.udo.cs.jvito.exception.XMLException;
import edu.udo.cs.mySVM.Examples.ExampleSet;
import edu.udo.cs.mySVM.SVM.SVMInterface;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.DoubleArrayDataRow;
import edu.udo.cs.yale.example.ListDataRowReader;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.operator.learner.kernel.JMySVMModel;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.w3c.dom.Element;

public class GivenJMySVMModel
extends Source {
    private JMySVMModel jmysvmmodel;
    private AttributeWeights weights;

    public GivenJMySVMModel(JMySVMModel model) {
        this.name = JViTo.getApplication().navigator.getValidTreeNodeName("JMySVMModel");
        this.jmysvmmodel = model;
    }

    public GivenJMySVMModel(JMySVMModel model, String name) {
        this.name = JViTo.getApplication().navigator.getValidTreeNodeName(name);
        this.jmysvmmodel = model;
    }

    public void compile() throws CompilerException {
        boolean scaled;
        this.iscompiling = true;
        boolean output = this.getParameterAsBoolean("output");
        if (output) {
            String modelFileName = this.getParameterAsString("model_file");
            File modelFile = new File(modelFileName);
            try {
                this.jmysvmmodel.writeModel(modelFile);
            }
            catch (IOException e) {
                throw new CompilerException("Couldn't write the model: " + e.getMessage());
            }
        }
        ExampleSet modelSet = this.jmysvmmodel.getExampleSet();
        double[][] atts = modelSet.atts;
        int[][] index = modelSet.index;
        double[] y = modelSet.get_ys();
        double[] alphas = modelSet.get_alphas();
        boolean addalpha = this.getParameterAsBoolean("alpha");
        Map meanvariances = modelSet.getMeanVariances();
        boolean bl = scaled = meanvariances != null;
        if (meanvariances != null) {
            scaled = !meanvariances.isEmpty();
        }
        int dim = modelSet.get_dim();
        int size = modelSet.count_examples();
        Attribute label = AttributeFactory.createAttribute("class", 1);
        StringTokenizer st = new StringTokenizer(this.getParameterAsString("classes"), " ");
        String pos = "p";
        String neg = "n";
        if (st.hasMoreTokens()) {
            pos = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            neg = st.nextToken();
        }
        label.mapString(pos);
        label.mapString(neg);
        Attribute alpha = AttributeFactory.createAttribute("alpha", 4);
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        for (int i = 0; i < dim; ++i) {
            attributes.add(AttributeFactory.createAttribute("att_" + (i + 1), 4));
        }
        if (addalpha) {
            attributes.add(alpha);
        }
        attributes.add(label);
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        LinkedList<DoubleArrayDataRow> data = null;
        data = new LinkedList<DoubleArrayDataRow>();
        int nr = dim + 1;
        if (addalpha) {
            ++nr;
        }
        for (int n = 0; n < size; ++n) {
            int i;
            double[] samples = new double[nr];
            for (i = 0; i < dim; ++i) {
                samples[i] = 0.0;
            }
            for (i = 0; i < atts[n].length; ++i) {
                samples[index[n][i]] = atts[n][i];
            }
            if (scaled) {
                for (i = 0; i < dim; ++i) {
                    ExampleSet.MeanVariance meanvariance = (ExampleSet.MeanVariance)meanvariances.get(new Integer(i));
                    if (meanvariance == null) continue;
                    samples[i] = samples[i] * Math.sqrt(meanvariance.getVariance()) + meanvariance.getMean();
                }
            }
            if (addalpha) {
                samples[nr - 2] = alphas[n];
            }
            samples[nr - 1] = y[n] == 1.0 ? (double)label.getPositiveIndex() : (double)label.getNegativeIndex();
            data.add(new DoubleArrayDataRow(samples));
        }
        table.readExamples(new ListDataRowReader(data.iterator()));
        this.exampleset = table.createCompleteExampleSet(label, null, null, null);
        this.exampleset.recalculateAllAttributeStatistics();
        SVMInterface svm2 = this.jmysvmmodel.createSVM();
        svm2.init(this.jmysvmmodel.getKernel(), this.jmysvmmodel.getExampleSet());
        double[] w = svm2.getWeights();
        this.weights = new AttributeWeights();
        for (int i = 0; i < w.length; ++i) {
            this.weights.setWeight(this.exampleset.getAttribute(i).getName(), w[i]);
        }
        this.iscompiling = false;
        this.iscompiled = true;
    }

    public String getXML(String indent) {
        String xml = new String("");
        xml = xml + indent + "<source name=\"" + this.name + "\" class=\"edu.udo.cs.jvito.data.JMySVMModelLoader\">\n";
        xml = xml + indent + "\t" + "<description text=\"\"/>\n";
        xml = xml + indent + "\t" + "<parameter key=\"model_file\"\tvalue=\"" + this.getParameterAsString("model_file") + "\"/>\n";
        xml = xml + indent + "\t" + "<parameter key=\"alpha\"\tvalue=\"" + this.getParameterAsBoolean("alpha") + "\"/>\n";
        LinkedList childs = this.getXMLDocChilds();
        Iterator iter = childs.iterator();
        while (iter.hasNext()) {
            XMLDocument doc = (XMLDocument)iter.next();
            xml = xml + doc.getXML(indent + "\t");
        }
        xml = xml + indent + "</source>\n";
        return xml;
    }

    public void loadXMLDocument(Element element) throws XMLException {
        throw new XMLException("You never could load the operator 'GivenJMySVMModel'.");
    }

    public List getParameterTypes() {
        LinkedList<ParameterTypeSingle> list = new LinkedList<ParameterTypeSingle>();
        list.add(new ParameterTypeBoolean("alpha", "Add the alpha values as an attribute.", false));
        list.add(new ParameterTypeString("classes", "The string representation of the classes. Note: Specify the negative class first!", "negative positive"));
        list.add(new ParameterTypeBoolean("output", "Writes the model to the specified model file.", false));
        list.add(new ParameterTypeFile("model_file", "Filename of the JMySVM model file.", false));
        return list;
    }

    public Component getVisualisationComponent() {
        if (!this.iscompiled) {
            return new JPanel();
        }
        JTabbedPane tabpane = new JTabbedPane();
        JScrollPane scrollpane = new JScrollPane(this.jmysvmmodel.getVisualisationComponent());
        tabpane.addTab("JMySVMModel", scrollpane);
        scrollpane = new JScrollPane(this.exampleset.getVisualisationComponent());
        tabpane.addTab("ExampleSet", scrollpane);
        scrollpane = new JScrollPane(this.weights.getVisualisationComponent());
        tabpane.addTab("AttributeWeights", scrollpane);
        return tabpane;
    }
}

