/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito;

import edu.udo.cs.jvito.GroupTree;
import edu.udo.cs.jvito.OperatorDescription;
import edu.udo.cs.jvito.exception.XMLException;
import edu.udo.cs.jvito.util.Logger;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class OperatorsReader {
    private static Map classnameMap = new HashMap();
    private static Map nameMap = new HashMap();
    private static Map operatorDescriptions = new HashMap();
    private static GroupTree groupTree = new GroupTree("");

    public static void registerOperators(String xmlfile, InputStream operatorsXML) {
        Logger.logMessage("Loading operators from '" + xmlfile + "'.", 2);
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(operatorsXML);
            if (!document.getDocumentElement().getTagName().toLowerCase().equals("operators")) {
                Logger.logMessage("Operator description file '" + xmlfile + "': outermost operator must be <operators>!", 7);
                return;
            }
            NodeList operatorTags = document.getDocumentElement().getElementsByTagName("operator");
            for (int i = 0; i < operatorTags.getLength(); ++i) {
                OperatorsReader.registerOperator((Element)operatorTags.item(i));
            }
        }
        catch (Throwable e) {
            Logger.logException("Cannot read operator description file '" + xmlfile + "'", e);
        }
    }

    private static void registerOperator(Element operatorTag) {
        try {
            OperatorDescription description = new OperatorDescription(operatorTag);
            classnameMap.put(description.getName(), description.getOperatorClass());
            nameMap.put(description.getOperatorClass(), description.getName());
            operatorDescriptions.put(description.getName(), description);
            String groupString = description.getGroup();
            String[] groupNames = groupString.split("\\.");
            GroupTree currentGroup = groupTree;
            for (int j = 0; j < groupNames.length; ++j) {
                GroupTree subGroup = currentGroup.getSubGroup(groupNames[j]);
                if (subGroup == null) {
                    subGroup = new GroupTree(groupNames[j]);
                    currentGroup.addSubGroup(subGroup);
                }
                currentGroup = subGroup;
            }
            currentGroup.addOperator(description.getName());
        }
        catch (ClassNotFoundException e) {
            Logger.logMessage("Class '" + operatorTag.getAttribute("class") + "' not found!", 7);
        }
        catch (XMLException e) {
            Logger.logMessage("XML-Exception" + e.getMessage(), 7);
        }
    }

    public static OperatorDescription getOperatorDescription(String name) {
        return (OperatorDescription)operatorDescriptions.get(name);
    }

    public static OperatorDescription getOperatorDescription(Class clazz) {
        return (OperatorDescription)operatorDescriptions.get(OperatorsReader.getOperatorClassName(clazz));
    }

    public static Class getOperatorClass(String name) {
        return (Class)classnameMap.get(name);
    }

    public static String getOperatorClassName(Class operatorClass) {
        return (String)nameMap.get(operatorClass);
    }

    public static Set getOperatorNames() {
        return classnameMap.keySet();
    }

    public static Set getOperatorClasses() {
        return nameMap.keySet();
    }

    public static GroupTree getGroups() {
        return groupTree;
    }
}

