/*
 * Decompiled with CFR 0.152.
 */
package org.musoft.limo.navigator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.musoft.limo.application.Application;
import org.musoft.limo.application.ApplicationListener;
import org.musoft.limo.application.Resource;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelAssociationEnd;
import org.musoft.limo.model.ModelConnectionElement;
import org.musoft.limo.model.ModelElement;
import org.musoft.limo.model.ModelFigureElement;
import org.musoft.limo.model.ModelListener;
import org.musoft.limo.model.ModelPrimitiveAttribute;
import org.musoft.limo.navigator.RessourceTreeNode;
import org.musoft.limo.navigator.TreeRenderer;
import org.musoft.limo.util.LogFile;

public class RessourceTree
extends JPanel
implements ApplicationListener,
ModelListener {
    public static final int BAUMBREITE = 400;
    public static final int BAUMHOEHE = 2000;
    private Application parent;
    private JTree tree;
    private RessourceTreeNode activeElement;
    private JScrollPane panel;
    private DefaultTreeModel treemodel;
    private TreePath actualPath;
    private TreeRenderer tRenderer = new TreeRenderer();
    private RessourceTreeNode root;
    private Hashtable treeHashing;
    private TreeSelectionListener tsl = new TreeSelectionListener(){

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            try {
                RessourceTree.this.actualPath = treeSelectionEvent.getPath();
            }
            catch (Exception exception) {
                LogFile.log("Treelistener - Fehler");
            }
        }
    };
    private MouseListener mel = new MouseAdapter(){

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                RessourceTreeNode ressourceTreeNode = (RessourceTreeNode)RessourceTree.this.actualPath.getLastPathComponent();
                if (ressourceTreeNode.getElement() instanceof ModelFigureElement) {
                    RessourceTree.this.parent.scrollToFigure((ModelFigureElement)ressourceTreeNode.getUserObject());
                } else if (ressourceTreeNode.getElement() instanceof ModelConnectionElement) {
                    RessourceTree.this.parent.scrollToFigure((ModelConnectionElement)ressourceTreeNode.getUserObject());
                }
                if (mouseEvent.getClickCount() == 1) {
                    RessourceTree.this.parent.fireModelSelectionChanged(new ModelElement[]{(ModelElement)ressourceTreeNode.getUserObject()});
                }
            }
        }
    };

    public RessourceTreeNode getNodeOfElement(ModelElement modelElement) {
        return (RessourceTreeNode)this.treeHashing.get(modelElement);
    }

    public void addNodeToHashtable(ModelElement modelElement, RessourceTreeNode ressourceTreeNode) {
        this.treeHashing.put(modelElement, ressourceTreeNode);
    }

    public boolean isNodeInHashtable(ModelElement modelElement) {
        return this.treeHashing.containsKey(modelElement);
    }

    public void deleteNodeFromHashtable(ModelElement modelElement) {
        this.treeHashing.remove(modelElement);
    }

    public RessourceTree(Application application) {
        this.parent = application;
        this.setLayout(new BorderLayout());
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Sam'n'Udo");
        this.tree = new JTree(defaultMutableTreeNode);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.panel = new JScrollPane(this.tree);
        this.add((Component)this.panel, "Center");
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setRootVisible(false);
        this.parent.addListener(this);
    }

    public void switchPath(TreePath treePath) {
        this.resetTree();
        this.tree.setSelectionPath(treePath);
        this.actualPath = treePath;
        this.scrollToPath(treePath);
    }

    public void scrollToPath(TreePath treePath) {
        this.tree.scrollPathToVisible(treePath);
        this.panel.getHorizontalScrollBar().setValue(0);
    }

    public void resetTree() {
        this.tree.clearSelection();
        for (int i = this.tree.getRowCount(); i >= 0; --i) {
            this.tree.collapseRow(i);
        }
    }

    public RessourceTreeNode getRoot() {
        return this.root;
    }

    public void initRessourceTree() {
        this.removeAll();
        this.treeHashing = new Hashtable();
        Model model = this.parent.getModel();
        this.root = this.createNode(model);
        this.treemodel = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.treemodel){

            public void setBackground(Color color) {
                super.setBackground(Color.white);
            }
        };
        this.tree.setCellRenderer(this.tRenderer);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.setRootVisible(true);
        this.tree.addMouseListener(this.mel);
        this.panel = new JScrollPane(this.tree);
        this.add((Component)this.panel, "Center");
        this.actualPath = new TreePath(this.treemodel.getPathToRoot(this.root));
        this.tree.addTreeSelectionListener(this.tsl);
        this.switchPath(this.actualPath);
        this.tree.setShowsRootHandles(true);
    }

    public DefaultTreeModel getTreeModel() {
        return this.treemodel;
    }

    public JTree getTree() {
        return this.tree;
    }

    public void onModelCreated(Application application, Model model) {
        this.initRessourceTree();
        if (this.getRootPane() != null) {
            this.getRootPane().repaint();
        }
    }

    public void onModelDestroying(Application application, Model model) {
        this.removeAll();
    }

    public void onModelLoaded(Application application, Model model) {
        this.initRessourceTree();
        RessourceTreeNode ressourceTreeNode = this.getRoot();
        this.setIgnoreRepaint(true);
        this.fireTraverseModel(model);
        this.fireTraverseModel2(model);
        this.setIgnoreRepaint(false);
        if (ressourceTreeNode.getChildCount() > 0) {
            this.switchPath(new TreePath(this.getTreeModel().getPathToRoot(ressourceTreeNode.getChildAt(0))));
        }
    }

    public void onModelSaved(Application application, Model model) {
    }

    public void onModelSelectionChanged(Application application, Model model, ModelElement[] modelElementArray) {
        ModelElement modelElement = (ModelElement)((RessourceTreeNode)this.actualPath.getLastPathComponent()).getUserObject();
        if (modelElementArray == null || modelElementArray.length == 0) {
            this.switchPath(new TreePath(this.getTreeModel().getPathToRoot(this.getNodeOfElement(model))));
        } else if (modelElementArray.length == 1 && modelElementArray[0] != modelElement && Resource.getChar(modelElementArray[0].getType()) != 'X') {
            this.switchPath(new TreePath(this.getTreeModel().getPathToRoot(this.getNodeOfElement(modelElementArray[0]))));
        }
    }

    public void onStateChanged(Application application) {
    }

    private void fireTraverseModel(ModelFigureElement modelFigureElement) {
        for (int i = 0; i < modelFigureElement.getChildCount(); ++i) {
            ModelFigureElement modelFigureElement2 = modelFigureElement.getChild(i);
            this.onCreateChild(modelFigureElement, modelFigureElement2);
            this.fireTraverseModel(modelFigureElement2);
        }
    }

    private void fireTraverseModel2(ModelFigureElement modelFigureElement) {
        if (modelFigureElement instanceof Model) {
            Model model = (Model)modelFigureElement;
            for (int i = 0; i < model.getConnectionCount(); ++i) {
                ModelConnectionElement modelConnectionElement = model.getConnection(i);
                this.onCreateConnection(model, modelConnectionElement);
            }
        }
        for (int i = 0; i < modelFigureElement.getChildCount(); ++i) {
            ModelFigureElement modelFigureElement2 = modelFigureElement.getChild(i);
            this.fireTraverseModel2(modelFigureElement2);
        }
    }

    public String toString() {
        return Resource.getString("COMP_NAVIGATOR");
    }

    private RessourceTreeNode createNode(ModelElement modelElement) {
        if (this.treeHashing.containsKey(modelElement)) {
            return null;
        }
        RessourceTreeNode ressourceTreeNode = new RessourceTreeNode(modelElement, modelElement.getName(), this, this.parent);
        modelElement.addListener(this);
        this.addNodeToHashtable(modelElement, ressourceTreeNode);
        return ressourceTreeNode;
    }

    public void onAddAssociate(ModelElement modelElement, ModelAssociationEnd modelAssociationEnd, ModelElement modelElement2) {
    }

    public void onAddChild(ModelFigureElement modelFigureElement, ModelElement modelElement) {
    }

    public void onCreateChild(ModelFigureElement modelFigureElement, ModelElement modelElement) {
        ModelFigureElement modelFigureElement2;
        RessourceTreeNode ressourceTreeNode = this.createNode(modelElement);
        if (modelElement instanceof ModelFigureElement && ressourceTreeNode != null && (modelFigureElement2 = (ModelFigureElement)modelElement).getParent() != null) {
            this.onSetParent(modelFigureElement2);
        }
    }

    public void onCreateConnection(Model model, ModelConnectionElement modelConnectionElement) {
        RessourceTreeNode ressourceTreeNode = this.getNodeOfElement(model);
        RessourceTreeNode ressourceTreeNode2 = this.createNode(modelConnectionElement);
        if (Resource.getChar(modelConnectionElement.getType()) != 'X') {
            if (ressourceTreeNode2 != null) {
                this.getTreeModel().insertNodeInto(ressourceTreeNode2, ressourceTreeNode, ressourceTreeNode.getChildCount());
                this.switchPath(new TreePath(this.getTreeModel().getPathToRoot(ressourceTreeNode2)));
            } else {
                this.deleteNodeFromHashtable(modelConnectionElement);
            }
        }
    }

    public void onDestroy(ModelElement modelElement) {
        RessourceTreeNode ressourceTreeNode = this.getNodeOfElement(modelElement);
        RessourceTreeNode ressourceTreeNode2 = (RessourceTreeNode)ressourceTreeNode.getParent();
        if (ressourceTreeNode2 != null) {
            this.getTreeModel().removeNodeFromParent(ressourceTreeNode);
            if (ressourceTreeNode2.isLeaf()) {
                this.switchPath(new TreePath(this.getTreeModel().getPathToRoot(ressourceTreeNode2)));
            } else {
                this.switchPath(new TreePath(this.getTreeModel().getPathToRoot(ressourceTreeNode2.getChildAt(0))));
            }
        }
        modelElement.removeListener(this);
        this.deleteNodeFromHashtable(modelElement);
    }

    public void onRemoveAssociate(ModelElement modelElement, ModelAssociationEnd modelAssociationEnd, ModelElement modelElement2) {
    }

    public void onRemoveChild(ModelFigureElement modelFigureElement, ModelElement modelElement) {
    }

    public void onSetAttribute(ModelElement modelElement, ModelPrimitiveAttribute modelPrimitiveAttribute) {
    }

    public void onSetAttribute(ModelElement modelElement, String string, Object object) {
    }

    public void onSetBounds(ModelFigureElement modelFigureElement) {
    }

    public void onSetConnectionEnd(ModelConnectionElement modelConnectionElement) {
    }

    public void onSetConnectionStart(ModelConnectionElement modelConnectionElement) {
    }

    public void onSetConnectionPoints(ModelConnectionElement modelConnectionElement) {
    }

    public void onSetName(ModelElement modelElement) {
        RessourceTreeNode ressourceTreeNode = this.getNodeOfElement(modelElement);
        ressourceTreeNode.setUserObject(modelElement);
        ressourceTreeNode.updateLabels(modelElement);
        this.switchPath(new TreePath(this.getTreeModel().getPathToRoot(ressourceTreeNode)));
    }

    public void onSetParent(ModelFigureElement modelFigureElement) {
        RessourceTreeNode ressourceTreeNode = this.getNodeOfElement(modelFigureElement.getParent());
        RessourceTreeNode ressourceTreeNode2 = this.getNodeOfElement(modelFigureElement);
        if (ressourceTreeNode2.getParent() != null) {
            this.getTreeModel().removeNodeFromParent(ressourceTreeNode2);
        }
        if (ressourceTreeNode != null) {
            this.getTreeModel().insertNodeInto(ressourceTreeNode2, ressourceTreeNode, ressourceTreeNode.getChildCount());
            this.switchPath(new TreePath(this.getTreeModel().getPathToRoot(ressourceTreeNode2)));
        }
    }

    public void onSetPosition(ModelFigureElement modelFigureElement, int n, int n2) {
    }

    public void onSetDirty() {
    }
}

