/*
 * Decompiled with CFR 0.152.
 */
package org.musoft.limo.model;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.kxml2.io.KXmlSerializer;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelAssociationEnd;
import org.musoft.limo.model.ModelAttribute;
import org.musoft.limo.model.ModelConnectionElement;
import org.musoft.limo.model.ModelElement;
import org.musoft.limo.model.ModelFigureElement;
import org.musoft.limo.model.ModelPrimitiveAttribute;
import org.musoft.limo.util.LogFile;
import org.xmlpull.v1.XmlSerializer;

public class ModelSaver {
    private Model model;
    private XmlSerializer xml;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HH:mm:ss");

    public ModelSaver(Model model) {
        this.model = model;
    }

    private void traverse(ModelElement modelElement) throws IOException {
        Point[] pointArray;
        Rectangle rectangle;
        String string = modelElement.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        this.xml.startTag(null, string);
        this.xml.attribute(null, "name", modelElement.getName());
        this.xml.attribute(null, "id", "" + modelElement.hashCode());
        if (modelElement instanceof ModelFigureElement && (rectangle = (pointArray = (Point[])modelElement).getBounds()) != null) {
            this.xml.attribute(null, "x", "" + rectangle.x);
            this.xml.attribute(null, "y", "" + rectangle.y);
            this.xml.attribute(null, "width", "" + rectangle.width);
            this.xml.attribute(null, "height", "" + rectangle.height);
        }
        this.saveAttributes(modelElement);
        if (modelElement instanceof ModelFigureElement) {
            pointArray = (ModelFigureElement)modelElement;
            for (int i = 0; i < pointArray.getChildCount(); ++i) {
                this.traverse(pointArray.getChild(i));
            }
            if (modelElement instanceof Model) {
                Model model = (Model)modelElement;
                for (int i = 0; i < model.getConnectionCount(); ++i) {
                    this.traverse(model.getConnection(i));
                }
            }
        } else if (modelElement instanceof ModelConnectionElement && (pointArray = ((ModelConnectionElement)modelElement).getPoints()) != null) {
            for (int i = 1; i < pointArray.length - 1; ++i) {
                this.xml.startTag(null, "Point");
                this.xml.attribute(null, "x", "" + pointArray[i].x);
                this.xml.attribute(null, "y", "" + pointArray[i].y);
                this.xml.endTag(null, "Point");
            }
        }
        this.xml.endTag(null, string);
    }

    private void saveAttributes(ModelElement modelElement) throws IOException {
        for (int i = 0; i < modelElement.getAttributeCount(); ++i) {
            ModelAttribute modelAttribute;
            ModelAttribute modelAttribute2 = modelElement.getAttribute(i);
            if (modelAttribute2.isEmpty() || "".equals(modelAttribute2.getValue())) continue;
            this.xml.startTag(null, "Attribute");
            this.xml.attribute(null, "name", modelAttribute2.getName());
            if (modelAttribute2 instanceof ModelPrimitiveAttribute) {
                modelAttribute = (ModelPrimitiveAttribute)modelAttribute2;
                if (!((ModelPrimitiveAttribute)modelAttribute).isEmpty()) {
                    if (((ModelPrimitiveAttribute)modelAttribute).getType() == ModelPrimitiveAttribute.TYPE_DATE) {
                        String string = dateFormat.format(((ModelPrimitiveAttribute)modelAttribute).getDate(), new StringBuffer(), new FieldPosition(0)).toString();
                        this.xml.text(string);
                    } else {
                        this.xml.text(((ModelPrimitiveAttribute)modelAttribute).getString());
                    }
                }
            } else if (modelAttribute2 instanceof ModelAssociationEnd) {
                modelAttribute = (ModelAssociationEnd)modelAttribute2;
                if (((ModelAssociationEnd)modelAttribute).isMultiple()) {
                    for (int j = 0; j < ((ModelAssociationEnd)modelAttribute).getAssociateCount(); ++j) {
                        this.xml.startTag(null, "Item");
                        this.xml.attribute(null, "href", "#" + ((ModelAssociationEnd)modelAttribute).getAssociate(j).hashCode());
                        this.xml.endTag(null, "Item");
                    }
                } else {
                    this.xml.attribute(null, "href", "#" + ((ModelAssociationEnd)modelAttribute).getAssociate(0).hashCode());
                }
            }
            this.xml.endTag(null, "Attribute");
        }
    }

    public void save(String string) throws IOException {
        LogFile.log("Saving model \"" + string + "\"...");
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
        this.xml = new KXmlSerializer();
        this.xml.setOutput(bufferedOutputStream, "utf-8");
        this.xml.comment("Created " + new Date() + " by " + System.getProperty("user.name"));
        this.xml.ignorableWhitespace("\r\n");
        this.xml.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        this.traverse(this.model);
        this.xml.flush();
        ((OutputStream)bufferedOutputStream).close();
        LogFile.log("Ok.");
    }
}

