/*
 * Decompiled with CFR 0.152.
 */
package org.musoft.limo.model;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelConnectionElement;
import org.musoft.limo.model.ModelElement;
import org.musoft.limo.model.ModelEnumeration;
import org.musoft.limo.model.ModelException;
import org.musoft.limo.util.LogFile;

public class ModelFigureElement
extends ModelElement {
    private ModelFigureElement parent;
    private Vector children = new Vector();
    private Rectangle bounds;

    public ModelFigureElement(String string, Rectangle rectangle, ModelFigureElement modelFigureElement) {
        super(string);
        if (rectangle != null) {
            this.setBounds(rectangle);
        }
        if (modelFigureElement != null) {
            this.setParent(modelFigureElement);
        }
    }

    public void destroy() {
        super.destroy();
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            this.getChild(i).destroy();
        }
        if (this.parent != null) {
            this.setParent(null);
        }
    }

    public void clear() {
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            this.getChild(i).destroy();
        }
        super.clear();
    }

    public String getFullName() {
        if (this.parent == null) {
            return "";
        }
        String string = this.parent.getFullName();
        if (string == null) {
            return this.getName();
        }
        return string.equals("") ? this.getName() : string + "." + this.getName();
    }

    public String getValidChildName(String string) {
        for (int i = 1; i < 10000; ++i) {
            String string2 = string + i;
            if (this.getChild(string2) != null) continue;
            return string2;
        }
        throw new ModelException("Kein Name mehr frei - zuviele Kinder");
    }

    public Model getModel() {
        ModelFigureElement modelFigureElement;
        for (modelFigureElement = this.parent; modelFigureElement != null && !(modelFigureElement instanceof Model); modelFigureElement = modelFigureElement.getParent()) {
        }
        return (Model)modelFigureElement;
    }

    public boolean canSetName(String string) {
        ModelElement modelElement;
        if (string == null) {
            return false;
        }
        return this.parent == null || (modelElement = this.parent.getChildOrConnection(string)) == null || modelElement == this;
    }

    public ModelFigureElement getParent() {
        return this.parent;
    }

    public void setParent(ModelFigureElement modelFigureElement) {
        int n;
        if (modelFigureElement == this) {
            throw new ModelException("Eigener Parent\"" + this.getName() + "\" in \"" + modelFigureElement.getName() + "\"");
        }
        if (modelFigureElement != null && (n = modelFigureElement.indexOfChild(this.getName())) != -1 && modelFigureElement.getChild(n) != this) {
            throw new ModelException("Doppeltes Element \"" + this.getName() + "\" in \"" + modelFigureElement.getName() + "\"");
        }
        if (this.parent != null) {
            this.parent.fireRemoveChild(this);
            this.parent.children.removeElement(this);
        }
        this.parent = modelFigureElement;
        this.fireSetParent();
        if (this.parent != null) {
            this.parent.children.addElement(this);
            this.parent.fireAddChild(this);
        }
        this.changed();
    }

    public void setIndex(int n) {
        if (this.parent != null) {
            if (0 <= n && n <= this.parent.children.size()) {
                this.parent.children.remove(this);
                this.parent.children.insertElementAt(this, n);
            } else {
                LogFile.log("MFE.setIndex: Wrong index value: " + n);
            }
        }
    }

    protected void fireRemoveChild(ModelFigureElement modelFigureElement) {
        for (int i = 0; i < this.getListenerCount(); ++i) {
            this.getListener(i).onRemoveChild(this, modelFigureElement);
        }
    }

    protected void fireAddChild(ModelFigureElement modelFigureElement) {
        for (int i = 0; i < this.getListenerCount(); ++i) {
            this.getListener(i).onAddChild(this, modelFigureElement);
        }
    }

    protected void fireSetParent() {
        for (int i = 0; i < this.getListenerCount(); ++i) {
            this.getListener(i).onSetParent(this);
        }
    }

    public int getChildCount() {
        return this.children.size();
    }

    public ModelFigureElement getChild(int n) {
        return (ModelFigureElement)this.children.elementAt(n);
    }

    public ModelFigureElement getChild(String string) {
        int n;
        String string2 = null;
        int n2 = string.indexOf(46);
        if (n2 != -1) {
            string2 = string.substring(n2 + 1);
            string = string.substring(0, n2);
        }
        if ((n = this.indexOfChild(string)) == -1) {
            return null;
        }
        ModelFigureElement modelFigureElement = this.getChild(n);
        if (string2 != null) {
            return modelFigureElement.getChild(string2);
        }
        return modelFigureElement;
    }

    public ModelElement getElement(String string) {
        int n;
        String string2 = null;
        int n2 = string.indexOf(46);
        if (n2 != -1) {
            string2 = string.substring(n2 + 1);
            string = string.substring(0, n2);
        }
        if ((n = this.indexOfChild(string)) == -1) {
            return null;
        }
        ModelFigureElement modelFigureElement = this.getChild(n);
        if (string2 != null) {
            return modelFigureElement.getElement(string2);
        }
        return modelFigureElement;
    }

    public int addChild(ModelFigureElement modelFigureElement) {
        modelFigureElement.setParent(this);
        this.layout();
        return this.children.size();
    }

    public void removeChild(ModelFigureElement modelFigureElement) {
        modelFigureElement.setParent(null);
        this.children.remove(modelFigureElement);
        this.layout();
    }

    public int indexOfChild(ModelFigureElement modelFigureElement) {
        return this.children.indexOf(modelFigureElement);
    }

    public int indexOfChild(String string) {
        if (string != null) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                if (!string.equals(this.getChild(i).getName())) continue;
                return i;
            }
        }
        return -1;
    }

    public ModelEnumeration getChildren(Class clazz) {
        return this.getChildren(clazz, false);
    }

    public ModelEnumeration getChildren(Class clazz, boolean bl) {
        Vector vector = new Vector();
        this.getChildren(vector, clazz, bl);
        return new ModelEnumeration(vector.elements());
    }

    protected void getChildren(Vector vector, Class clazz, boolean bl) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            ModelFigureElement modelFigureElement = this.getChild(i);
            if (clazz == null || clazz.isInstance(modelFigureElement)) {
                vector.addElement(modelFigureElement);
            }
            if (!bl) continue;
            modelFigureElement.getChildren(vector, clazz, bl);
        }
    }

    public boolean canSetParent(ModelFigureElement modelFigureElement) {
        return false;
    }

    public boolean canAddChild(ModelFigureElement modelFigureElement) {
        return false;
    }

    public boolean canRemoveChild(ModelFigureElement modelFigureElement) {
        return false;
    }

    public Rectangle getBounds() {
        return this.bounds == null ? null : new Rectangle(this.bounds);
    }

    public void setBounds(Rectangle rectangle) {
        this.bounds = new Rectangle(rectangle);
        for (int i = 0; i < this.getListenerCount(); ++i) {
            this.getListener(i).onSetBounds(this);
        }
        this.layout();
        this.changed();
    }

    public void setBounds(Point point, Point point2) {
        Rectangle rectangle = new Rectangle(point);
        rectangle.add(point2);
        this.setBounds(rectangle);
    }

    public Point getPosition() {
        if (this.bounds == null) {
            return null;
        }
        return new Point(this.bounds.x, this.bounds.y);
    }

    public Point getCorner() {
        if (this.bounds == null) {
            return null;
        }
        return new Point(this.bounds.x + this.bounds.width, this.bounds.y + this.bounds.height);
    }

    public Point getCenter() {
        if (this.bounds == null) {
            return null;
        }
        return new Point(this.bounds.x + this.bounds.width / 2, this.bounds.y + this.bounds.height / 2);
    }

    public void setCenter(Point point) {
        if (this.bounds != null) {
            this.setPosition(point.x - this.bounds.width / 2 - this.bounds.x, point.y - this.bounds.height / 2 - this.bounds.y);
        } else {
            this.setBounds(new Rectangle(point.x - this.bounds.width / 2, point.y - this.bounds.height / 2, this.bounds.width, this.bounds.height));
        }
    }

    public void setPosition(Point point) {
        this.setPosition(point.x - this.bounds.x, point.y - this.bounds.y);
    }

    public void setPosition(int n, int n2) {
        int n3;
        this.bounds.setLocation(this.bounds.x + n, this.bounds.y + n2);
        for (n3 = 0; n3 < this.getListenerCount(); ++n3) {
            this.getListener(n3).onSetPosition(this, n, n2);
        }
        if (!(this instanceof Model)) {
            for (n3 = 0; n3 < this.getChildCount(); ++n3) {
                this.getChild(n3).setPosition(n, n2);
            }
        }
        this.changed();
    }

    public Rectangle getMinimumBounds() {
        int n;
        Rectangle rectangle = null;
        for (n = 0; n < this.getChildCount() && rectangle == null; ++n) {
            rectangle = this.getChild(n).getBounds();
        }
        while (n < this.getChildCount()) {
            if (this.getChild(n).getBounds() != null) {
                rectangle.add(this.getChild(n).getBounds());
            }
            ++n;
        }
        return rectangle;
    }

    public Rectangle getNeededBounds() {
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = this.getMinimumBounds();
        if (rectangle == null) {
            return rectangle2;
        }
        if (rectangle2 == null) {
            return rectangle;
        }
        rectangle.add(rectangle2);
        return rectangle;
    }

    public Rectangle getMaximumBounds() {
        if (this.parent != null && this.parent.getBounds() != null) {
            return this.parent.getBounds();
        }
        return null;
    }

    public boolean canSetBounds(Rectangle rectangle) {
        return true;
    }

    public boolean canSetPosition(int n, int n2) {
        return true;
    }

    private void dump(String string) {
        int n;
        String string2 = "." + this.getClass().getName();
        string2 = string2.substring(string2.lastIndexOf(46) + 1);
        System.out.println(string + "[" + this.getName() + ": " + string2 + "]");
        if (this.bounds != null) {
            System.out.println(string + "x=" + this.bounds.x + ", y=" + this.bounds.y + ", width=" + this.bounds.width + ", height=" + this.bounds.height);
        }
        for (n = 0; n < this.getAttributeCount(); ++n) {
            System.out.println(string + this.getAttribute(n).toString());
        }
        if (this.getListenerCount() != 0) {
            System.out.println();
            for (n = 0; n < this.getListenerCount(); ++n) {
                System.out.println(string + "listener-" + n + "=" + this.getListener(n));
            }
        }
        for (n = 0; n < this.getChildCount(); ++n) {
            System.out.println();
            this.getChild(n).dump("  " + string);
        }
    }

    public void fireCreateChild(ModelFigureElement modelFigureElement, ModelFigureElement modelFigureElement2) {
        for (int i = 0; i < this.getListenerCount(); ++i) {
            this.getListener(i).onCreateChild(modelFigureElement, modelFigureElement2);
        }
    }

    public void fireCreateConnection(Model model, ModelConnectionElement modelConnectionElement) {
        for (int i = 0; i < this.getListenerCount(); ++i) {
            this.getListener(i).onCreateConnection(model, modelConnectionElement);
        }
    }

    public void layout() {
    }

    public boolean isChildOf(ModelFigureElement modelFigureElement) {
        ModelFigureElement modelFigureElement2 = this.getParent();
        return modelFigureElement2 != null && (modelFigureElement == modelFigureElement2 || modelFigureElement2.isChildOf(modelFigureElement));
    }

    public ModelElement getChildOrConnection(String string) {
        return this.getChild(string);
    }
}

