/*
 * Decompiled with CFR 0.152.
 */
package org.musoft.limo.model;

import org.musoft.limo.application.Resource;
import org.musoft.limo.model.ModelElement;

public abstract class ModelAttribute {
    public static final int ACCESS_NONE = 0;
    public static final int ACCESS_READ = 1;
    public static final int ACCESS_WRITE = 2;
    public static final int ACCESS_READWRITE = 3;
    protected ModelElement parent;
    protected String name;
    protected int access;
    private String label;

    public ModelAttribute(ModelElement modelElement, String string, int n) {
        this.parent = modelElement;
        this.name = string;
        this.access = n;
        if (modelElement != null) {
            modelElement.addAttributeNew(this);
        }
    }

    public ModelElement getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public boolean canRead() {
        return (this.access & 1) != 0;
    }

    public boolean canWrite() {
        return (this.access & 2) != 0;
    }

    public abstract boolean isEmpty();

    public abstract void clear();

    public abstract Object getValue();

    protected void changed() {
        if (this.parent != null) {
            this.parent.changed();
        }
    }

    public String getLabel() {
        String string = "ATTR_" + this.getName().toUpperCase();
        String string2 = Resource.getString(string);
        if (string2 == string) {
            string2 = Character.toUpperCase(this.getName().charAt(0)) + this.getName().substring(1);
        }
        return string2;
    }

    public void setAccess(int n) {
        this.access = n;
    }
}

