/*
 * Decompiled with CFR 0.152.
 */
package org.musoft.limo.inspector;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.musoft.limo.application.Application;
import org.musoft.limo.inspector.ColorEditor;
import org.musoft.limo.inspector.ColorRenderer;
import org.musoft.limo.inspector.PropertyModel;
import org.musoft.limo.inspector.PropertyRenderer;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelAssociationEnd;
import org.musoft.limo.model.ModelAttribute;
import org.musoft.limo.model.ModelConnectionElement;
import org.musoft.limo.model.ModelElement;
import org.musoft.limo.model.ModelFigureElement;
import org.musoft.limo.model.ModelListener;
import org.musoft.limo.model.ModelPrimitiveAttribute;

public class PropertyTable
extends JTable
implements ModelListener {
    private Application application;
    private ModelElement element;
    private Vector attributes = new Vector();

    public PropertyTable(Application application, ModelElement modelElement, boolean bl) {
        this.application = application;
        this.element = modelElement;
        modelElement.addListener(this);
        for (int i = 0; i < modelElement.getAttributeCount(); ++i) {
            ModelAttribute modelAttribute = modelElement.getAttribute(i);
            if (!modelAttribute.canRead()) continue;
            this.attributes.addElement(modelAttribute);
        }
        this.setModel(new PropertyModel(application, modelElement, this.attributes, bl));
        this.setSelectionMode(0);
        this.getTableHeader().setReorderingAllowed(false);
    }

    public ModelElement getElement() {
        return this.element;
    }

    public int getRowHeight() {
        return super.getRowHeight() + 2;
    }

    public void dispose() {
        this.element.removeListener(this);
        this.attributes.removeAllElements();
        this.repaint();
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        ModelPrimitiveAttribute modelPrimitiveAttribute;
        ModelAttribute modelAttribute;
        if (n2 == 1 && n > 2 && (modelAttribute = (ModelAttribute)this.attributes.elementAt(n - 3)) instanceof ModelPrimitiveAttribute && (modelPrimitiveAttribute = (ModelPrimitiveAttribute)modelAttribute).getType() == ModelPrimitiveAttribute.TYPE_COLOR) {
            return new ColorRenderer(true);
        }
        boolean bl = n2 == 1 && n != 0 && (n <= 2 || !((ModelAttribute)this.attributes.elementAt(n - 3)).canWrite()) || this.application.getInspector().getReadOnly();
        return new PropertyRenderer(bl);
    }

    public TableCellEditor getCellEditor(int n, int n2) {
        if (n2 == 1) {
            ModelAttribute modelAttribute;
            if (n == 0) {
                JTextField jTextField = new JTextField(this.element.getName());
                return new DefaultCellEditor(jTextField);
            }
            if (n > 2 && (modelAttribute = (ModelAttribute)this.attributes.elementAt(n - 3)).canWrite()) {
                ModelAssociationEnd modelAssociationEnd;
                if (modelAttribute instanceof ModelPrimitiveAttribute) {
                    ModelPrimitiveAttribute modelPrimitiveAttribute = (ModelPrimitiveAttribute)modelAttribute;
                    Object[] objectArray = modelPrimitiveAttribute.getPossibleValues();
                    if (objectArray != null) {
                        return new DefaultCellEditor(new JComboBox<Object>(objectArray));
                    }
                    if (modelPrimitiveAttribute.getType() == ModelPrimitiveAttribute.TYPE_BOOLEAN) {
                        return new DefaultCellEditor(new JComboBox<String>(new String[]{"false", "true"}));
                    }
                    if (modelPrimitiveAttribute.getType() == ModelPrimitiveAttribute.TYPE_COLOR) {
                        return new ColorEditor(modelPrimitiveAttribute.getColor());
                    }
                    return new DefaultCellEditor(new JTextField(modelPrimitiveAttribute.getString()));
                }
                if (modelAttribute instanceof ModelAssociationEnd && !(modelAssociationEnd = (ModelAssociationEnd)modelAttribute).isMultiple()) {
                    JComboBox<ModelElement> jComboBox = new JComboBox<ModelElement>(modelAssociationEnd.getPossibleValues());
                    return new DefaultCellEditor(jComboBox);
                }
            }
        }
        return null;
    }

    public void onAddAssociate(ModelElement modelElement, ModelAssociationEnd modelAssociationEnd, ModelElement modelElement2) {
        this.repaint();
    }

    public void onAddChild(ModelFigureElement modelFigureElement, ModelElement modelElement) {
        this.repaint();
    }

    public void onCreateChild(ModelFigureElement modelFigureElement, ModelElement modelElement) {
        this.repaint();
    }

    public void onCreateConnection(Model model, ModelConnectionElement modelConnectionElement) {
        this.repaint();
    }

    public void onDestroy(ModelElement modelElement) {
        this.repaint();
    }

    public void onRemoveAssociate(ModelElement modelElement, ModelAssociationEnd modelAssociationEnd, ModelElement modelElement2) {
        this.dispose();
    }

    public void onRemoveChild(ModelFigureElement modelFigureElement, ModelElement modelElement) {
        this.repaint();
    }

    public void onSetAttribute(ModelElement modelElement, ModelPrimitiveAttribute modelPrimitiveAttribute) {
        this.repaint();
    }

    public void onSetAttribute(ModelElement modelElement, String string, Object object) {
        this.repaint();
    }

    public void onSetBounds(ModelFigureElement modelFigureElement) {
        this.repaint();
    }

    public void onSetConnectionEnd(ModelConnectionElement modelConnectionElement) {
        this.repaint();
    }

    public void onSetConnectionStart(ModelConnectionElement modelConnectionElement) {
        this.repaint();
    }

    public void onSetName(ModelElement modelElement) {
        this.repaint();
    }

    public void onSetParent(ModelFigureElement modelFigureElement) {
        this.repaint();
    }

    public void onSetPosition(ModelFigureElement modelFigureElement, int n, int n2) {
        this.repaint();
    }

    public void onSetDirty() {
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        int n = this.rowAtPoint(point);
        int n2 = this.columnAtPoint(point);
        if (n2 == 0) {
            return null;
        }
        Object object = this.getModel().getValueAt(n, n2);
        if (object == null) {
            return null;
        }
        String string = object.toString();
        if (string.startsWith("[") && string.endsWith("]")) {
            if (string.length() == 2) {
                return null;
            }
            return "<html>" + string.substring(1, string.length() - 1).replaceAll(",", ",<br>") + "</html>";
        }
        return string;
    }

    public void onSetConnectionPoints(ModelConnectionElement modelConnectionElement) {
    }
}

