/*
 * Decompiled with CFR 0.152.
 */
package org.musoft.limo.inspector;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.musoft.limo.application.Application;
import org.musoft.limo.application.ApplicationListener;
import org.musoft.limo.application.Resource;
import org.musoft.limo.inspector.PropertyTable;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelElement;

public class PropertyPanel
extends JPanel
implements ApplicationListener {
    private Application parent;
    private PropertyTable table;
    private boolean readOnly;

    public PropertyPanel(Application application) {
        super(new BorderLayout());
        this.parent = application;
        application.addListener(this);
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
        this.setElement(this.getElement());
    }

    public ModelElement getElement() {
        return this.table == null ? null : this.table.getElement();
    }

    public void setElement(ModelElement modelElement) {
        if (this.table != null) {
            this.removeAll();
            if (this.table != null) {
                this.table.dispose();
                this.table = null;
            }
        }
        if (modelElement != null) {
            this.table = new PropertyTable(this.parent, modelElement, this.readOnly);
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setViewportView(this.table);
            this.add((Component)jScrollPane, "Center");
            this.parent.repaint();
        }
    }

    public void onModelCreated(Application application, Model model) {
        this.setElement(model);
        this.onModelSelectionChanged(application, model, new ModelElement[0]);
    }

    public void onModelDestroying(Application application, Model model) {
        this.setElement(null);
    }

    public void onModelLoaded(Application application, Model model) {
        this.setElement(model);
    }

    public void onModelSaved(Application application, Model model) {
    }

    public void onModelSelectionChanged(Application application, Model model, ModelElement[] modelElementArray) {
        if (modelElementArray == null || modelElementArray.length == 0) {
            this.setElement(model);
        } else if (modelElementArray.length == 1) {
            this.setElement(modelElementArray[0]);
        } else {
            this.setElement(model);
        }
    }

    public void onStateChanged(Application application) {
    }

    public String toString() {
        return Resource.getString("COMP_INSPECTOR");
    }
}

