/*
 * Decompiled with CFR 0.152.
 */
package org.musoft.limo.inspector;

import java.awt.Rectangle;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.musoft.limo.application.Application;
import org.musoft.limo.application.Resource;
import org.musoft.limo.model.ModelAssociationEnd;
import org.musoft.limo.model.ModelAttribute;
import org.musoft.limo.model.ModelElement;
import org.musoft.limo.model.ModelFigureElement;
import org.musoft.limo.model.ModelPrimitiveAttribute;
import org.musoft.limo.util.LogFile;

public class PropertyModel
implements TableModel {
    private Application application;
    private ModelElement element;
    private boolean readOnly;
    private DateFormat formatter = DateFormat.getDateInstance(3);
    private Vector labels = new Vector();
    private Vector attributes;
    private String[] headings = new String[2];
    static /* synthetic */ Class class$java$lang$Object;

    PropertyModel(Application application, ModelElement modelElement, Vector vector, boolean bl) {
        this.application = application;
        this.element = modelElement;
        this.attributes = vector;
        this.readOnly = bl;
        this.labels.add(this.getPropertyLabel("name"));
        this.labels.add(this.getPropertyLabel("type"));
        this.labels.add(this.getPropertyLabel("bounds"));
        for (int i = 0; i < vector.size(); ++i) {
            ModelAttribute modelAttribute = (ModelAttribute)vector.elementAt(i);
            this.labels.add(this.getPropertyLabel(modelAttribute.getName()));
        }
        this.headings[0] = Resource.getString("LABEL_NAME");
        this.headings[1] = Resource.getString("LABEL_VALUE");
    }

    public String getPropertyLabel(String string) {
        String string2 = "ATTR_" + string.toUpperCase();
        String string3 = Resource.getString(string2);
        if (string3 == string2) {
            string3 = Character.toUpperCase(string.charAt(0)) + string.substring(1);
        }
        return string3;
    }

    public int getRowCount() {
        return this.attributes.size() + 3;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int n) {
        return this.headings[n];
    }

    public Class getColumnClass(int n) {
        return class$java$lang$Object == null ? (class$java$lang$Object = PropertyModel.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public boolean isCellEditable(int n, int n2) {
        return !this.readOnly && (n2 == 1 && n == 0 && this.element.canSetName("") || n > 2 && ((ModelAttribute)this.attributes.elementAt(n - 3)).canWrite());
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.labels.elementAt(n);
        }
        if (n == 0) {
            return this.element.getName();
        }
        if (n == 1) {
            String string = Resource.getString(this.element.getType() + "_TYPE");
            return !string.endsWith("_TYPE") ? string : this.element.getType();
        }
        if (n == 2) {
            if (this.element instanceof ModelFigureElement) {
                ModelFigureElement modelFigureElement = (ModelFigureElement)this.element;
                Rectangle rectangle = modelFigureElement.getBounds();
                if (rectangle == null) {
                    return "";
                }
                return "(" + rectangle.x + ", " + rectangle.y + ", " + rectangle.width + ", " + rectangle.height + ")";
            }
            return "";
        }
        ModelAttribute modelAttribute = (ModelAttribute)this.attributes.elementAt(n - 3);
        if (modelAttribute instanceof ModelPrimitiveAttribute) {
            ModelPrimitiveAttribute modelPrimitiveAttribute = (ModelPrimitiveAttribute)modelAttribute;
            if (modelPrimitiveAttribute.getType() == ModelPrimitiveAttribute.TYPE_DATE) {
                Date date = modelPrimitiveAttribute.getDate();
                return date == null ? "" : this.formatter.format(date);
            }
            return modelPrimitiveAttribute.getValue();
        }
        if (modelAttribute instanceof ModelAssociationEnd) {
            ModelAssociationEnd modelAssociationEnd = (ModelAssociationEnd)modelAttribute;
            if (modelAssociationEnd.isMultiple()) {
                Vector vector = new Vector(){

                    public String toString() {
                        String string = "[";
                        for (int i = 0; i < this.size(); ++i) {
                            if (i != 0) {
                                string = string + ", ";
                            }
                            string = string + ((ModelElement)this.elementAt(i)).getName();
                        }
                        string = string + "]";
                        return string;
                    }
                };
                for (int i = 0; i < modelAssociationEnd.getAssociateCount(); ++i) {
                    vector.addElement(modelAssociationEnd.getAssociate(i));
                }
                return vector;
            }
            return modelAssociationEnd.isEmpty() ? "" : modelAssociationEnd.getAssociate(0).getName();
        }
        Object object = modelAttribute.getValue();
        return object == null ? "" : object.toString();
    }

    public void setValueAt(Object object, int n, int n2) {
        if ("".equals(object)) {
            object = null;
        }
        try {
            if (n2 == 1) {
                if (n == 0) {
                    String string;
                    String string2 = string = object == null ? null : object.toString();
                    if (this.element.canSetName(string)) {
                        this.element.setName(string);
                    } else {
                        this.application.getToolkit().beep();
                    }
                } else if (n > 2) {
                    ModelAttribute modelAttribute = (ModelAttribute)this.attributes.elementAt(n - 3);
                    if (modelAttribute instanceof ModelPrimitiveAttribute) {
                        ModelPrimitiveAttribute modelPrimitiveAttribute = (ModelPrimitiveAttribute)modelAttribute;
                        if (modelPrimitiveAttribute.canSetValue(object)) {
                            modelPrimitiveAttribute.setValue(object);
                        } else {
                            this.application.getToolkit().beep();
                        }
                    } else if (modelAttribute instanceof ModelAssociationEnd) {
                        ModelAssociationEnd modelAssociationEnd = (ModelAssociationEnd)modelAttribute;
                        modelAssociationEnd.setValue(object);
                    }
                }
            }
            this.application.repairDamage();
        }
        catch (Exception exception) {
            LogFile.log(exception);
        }
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
    }

    public void removeTableModelListener(TableModelListener tableModelListener) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

