/*
 * Decompiled with CFR 0.152.
 */
package org.musoft.limo.hypertext;

import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.musoft.limo.application.Application;
import org.musoft.limo.application.ApplicationListener;
import org.musoft.limo.application.Resource;
import org.musoft.limo.hypertext.HyperlinkInterpreter;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelElement;
import org.musoft.limo.model.ModelPrimitiveAttribute;
import org.musoft.limo.print.PrinterSource;
import org.musoft.limo.util.ComponentPane;
import org.musoft.limo.util.LogFile;

public class HypertextViewer
extends JPanel
implements ApplicationListener,
PrinterSource {
    public final String STYLES = "padding-top: 0px; padding-bottom: 0px; padding-left: 0px; padding-right: 0px; margin: 0px";
    public final String NOTE_BEGIN = "<center><table width=\"95%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr height=\"20\"><td width=\"20\" background=\"" + this.getPicURL("POSTIT_OL") + "\" style=\"background-repeat: no-repeat" + "padding-top: 0px; padding-bottom: 0px; padding-left: 0px; padding-right: 0px; margin: 0px" + "\" border=\"0\"></td>" + "<td width=\"*\" background=\"" + this.getPicURL("POSTIT_OM") + "\" style=\"background-repeat: no-repeat" + "padding-top: 0px; padding-bottom: 0px; padding-left: 0px; padding-right: 0px; margin: 0px" + "\" border=\"0\"></td>" + "<td width=\"20\" background=\"" + this.getPicURL("POSTIT_OR") + "\" style=\"background-repeat: no-repeat" + "padding-top: 0px; padding-bottom: 0px; padding-left: 0px; padding-right: 0px; margin: 0px" + "\" border=\"0\"></td>" + "</tr>" + "<tr>" + "<td background=\"" + this.getPicURL("POSTIT_ML") + "\" style=\"background-repeat: no-repeat" + "padding-top: 0px; padding-bottom: 0px; padding-left: 0px; padding-right: 0px; margin: 0px" + "\" border=\"0\"></td>" + "<td background=\"" + this.getPicURL("POSTIT_MM") + "\" style=\"background-repeat: repeat" + "padding-top: 0px; padding-bottom: 0px; padding-left: 0px; padding-right: 0px; margin: 0px" + "\">" + "<font size=\"3\" face='Courier' color='#000000'>";
    public final String NOTE_END = "</font></td><td background=\"" + this.getPicURL("POSTIT_MR") + "\" style=\"background-repeat: no-repeat" + "padding-top: 0px; padding-bottom: 0px; padding-left: 0px; padding-right: 0px; margin: 0px" + "\" border=\"0\"></td>" + "</tr>" + "<tr height=\"20\">" + "<td background=\"" + this.getPicURL("POSTIT_UL") + "\" style=\"background-repeat: no-repeat" + "padding-top: 0px; padding-bottom: 0px; padding-left: 0px; padding-right: 0px; margin: 0px" + "\" border=\"0\"></td>" + "<td background=\"" + this.getPicURL("POSTIT_UM") + "\" style=\"background-repeat: no-repeat" + "padding-top: 0px; padding-bottom: 0px; padding-left: 0px; padding-right: 0px; margin: 0px" + "\" border=\"0\"></td>" + "<td background=\"" + this.getPicURL("POSTIT_UR") + "\" style=\"background-repeat: no-repeat" + "padding-top: 0px; padding-bottom: 0px; padding-left: 0px; padding-right: 0px; margin: 0px" + "\" border=\"0\"></td>" + "</tr>" + "</table>" + "</center>";
    private String tabString;
    private JEditorPane editorpane;
    private JScrollPane scrollpane;
    private Application parent;
    private Vector history;
    private boolean listenSelectionChanged;
    private boolean updateTitle;

    private String getPicURL(String string) {
        URL uRL = this.getClass().getResource(Resource.getString(string));
        return uRL.toString();
    }

    public HypertextViewer(Application application, String string) {
        this(application, string, true);
    }

    public HypertextViewer(Application application, String string, boolean bl) {
        super(new GridLayout());
        this.parent = application;
        this.listenSelectionChanged = bl;
        application.addListener(this);
        this.history = new Vector();
        this.editorpane = new JEditorPane();
        this.editorpane.setEditable(false);
        this.editorpane.addHyperlinkListener(new HyperlinkInterpreter(this));
        this.scrollpane = new JScrollPane(this.editorpane);
        this.add(this.scrollpane);
        this.tabString = string;
        this.updateTitle = false;
    }

    public void setPage(ModelElement modelElement) {
        Object object;
        URL uRL = null;
        if (modelElement != null) {
            if (this.updateTitle && (object = (ComponentPane)this.parent.getComponentsPanes().get(this)) != null) {
                ((ComponentPane)object).renameTab(this, modelElement.getName());
            }
            uRL = ((ModelPrimitiveAttribute)modelElement.getAttribute("Hyperlink")).getURL();
        }
        this.editorpane.setEditorKit(new HTMLEditorKit());
        object = this.editorpane.getEditorKit().createDefaultDocument();
        this.editorpane.setDocument((Document)object);
        if (uRL != null) {
            try {
                if (uRL.getProtocol().equals("file") && uRL.getFile().charAt(0) != '/') {
                    uRL = new URL(this.parent.getHypertextLocation() + uRL.getFile());
                }
                this.setPage(uRL);
            }
            catch (Exception exception) {
                this.parent.showStatus(exception.getMessage());
                LogFile.log(exception);
            }
        }
        if (!modelElement.getAttribute("notes").isEmpty()) {
            this.insertNotice(modelElement);
        }
    }

    public boolean setPage(URL uRL) {
        try {
            String string = uRL.getFile();
            if (!uRL.getProtocol().equals("http") && string.endsWith(".html") || string.endsWith(".htm") || string.endsWith(".txt") || string.endsWith(".rtf") || string.indexOf("#") > -1) {
                this.editorpane.setPage(uRL);
            } else {
                this.parent.openURLInBrowser(uRL.toString());
            }
        }
        catch (Exception exception) {
            this.parent.showStatus(exception.getMessage());
            return false;
        }
        this.history.add(uRL);
        return true;
    }

    private void insertNotice(ModelElement modelElement) {
        if (!(this.editorpane.getDocument() instanceof HTMLDocument)) {
            return;
        }
        String string = (String)modelElement.getAttribute("notes").getValue();
        if (string == null || string.trim().length() == 0) {
            return;
        }
        this.editorpane.setVisible(false);
        String string2 = "<b>" + modelElement.getName() + "</b><p>" + string;
        HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
        try {
            hTMLEditorKit.insertHTML((HTMLDocument)this.editorpane.getDocument(), 0, this.NOTE_BEGIN + string2 + this.NOTE_END, 1, 0, HTML.Tag.BODY);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.editorpane.setVisible(true);
    }

    public URL getPage() {
        return this.editorpane.getPage();
    }

    public Application getApplication() {
        return this.parent;
    }

    public String toString() {
        return this.tabString;
    }

    public void goBack() {
        if (this.history.size() > 1) {
            this.history.remove(this.history.size() - 1);
            URL uRL = (URL)this.history.elementAt(this.history.size() - 1);
            this.history.remove(this.history.size() - 1);
            this.setPage(uRL);
        }
    }

    public void setUpdateTitle(boolean bl) {
        this.updateTitle = bl;
    }

    public boolean getUpdateTitle() {
        return this.updateTitle;
    }

    public void onModelCreated(Application application, Model model) {
        this.add(this.scrollpane);
    }

    public void onModelDestroying(Application application, Model model) {
        this.remove(this.scrollpane);
    }

    public void onModelLoaded(Application application, Model model) {
        this.add(this.scrollpane);
        if (this.listenSelectionChanged) {
            this.setPage(model);
        }
    }

    public void onModelSaved(Application application, Model model) {
    }

    public void onModelSelectionChanged(Application application, Model model, ModelElement[] modelElementArray) {
        if (!this.listenSelectionChanged) {
            return;
        }
        if (modelElementArray.length == 1) {
            this.setPage(modelElementArray[0]);
        } else {
            this.setPage(model);
        }
    }

    public void onStateChanged(Application application) {
    }

    public String getPrintTitle() {
        return this.tabString;
    }

    public void doPrintComponent(Graphics2D graphics2D) {
        this.print(graphics2D);
    }

    public Rectangle getPrintBounds() {
        return new Rectangle(0, 0, this.editorpane.getWidth(), this.editorpane.getHeight());
    }
}

