/*
 * Decompiled with CFR 0.152.
 */
package org.musoft.limo.hypertext;

import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import org.jhotdraw.framework.JHotDrawRuntimeException;
import org.jhotdraw.framework.Tool;
import org.jhotdraw.standard.ToolButton;
import org.jhotdraw.util.Iconkit;
import org.jhotdraw.util.PaletteListener;
import org.musoft.limo.application.Resource;
import org.musoft.limo.application.StaticJButton;
import org.musoft.limo.hypertext.HypertextEditor;

public class HypertextToolBar
extends JToolBar {
    public static final int ACTIVE = 0;
    public static final int INACTIVE = 1;
    public static final int INVISIBLE = 2;
    private HypertextEditor parent;
    private Hashtable groupButtons;
    private Hashtable groupState;

    public HypertextToolBar(HypertextEditor hypertextEditor) {
        this.parent = hypertextEditor;
        this.setOrientation(0);
        this.groupButtons = new Hashtable();
        this.groupState = new Hashtable();
        this.createGeneralTools();
        this.addGroup("general");
        this.showGroup("general", 0);
    }

    public void addButton(String string, JButton jButton) {
        if (this.groupButtons.containsKey(string)) {
            ((Vector)this.groupButtons.get(string)).add(jButton);
        } else {
            Vector<JButton> vector = new Vector<JButton>();
            vector.add(jButton);
            this.groupState.put(string, new Integer(0));
            this.groupButtons.put(string, vector);
        }
    }

    public void showGroup(String string, int n) {
        if (!this.groupButtons.containsKey(string)) {
            return;
        }
        if (n != 2) {
            Vector vector = (Vector)this.groupButtons.get(string);
            boolean bl = n == 0;
            for (int i = 0; i < vector.size(); ++i) {
                ((JButton)vector.get(i)).setVisible(true);
                ((JButton)vector.get(i)).setEnabled(bl);
            }
        } else {
            Vector vector = (Vector)this.groupButtons.get(string);
            boolean bl = false;
            for (int i = 0; i < vector.size(); ++i) {
                ((JButton)vector.get(i)).setVisible(bl);
            }
        }
    }

    public void addGroup(String string) {
        if (!this.groupButtons.containsKey(string)) {
            return;
        }
        Vector vector = (Vector)this.groupButtons.get(string);
        for (int i = 0; i < vector.size(); ++i) {
            this.add((JButton)vector.get(i));
            ((JButton)vector.get(i)).setEnabled(true);
        }
        this.add(new JToolBar.Separator());
    }

    protected void createGeneralTools() {
        Iconkit iconkit = Iconkit.instance();
        if (iconkit == null) {
            throw new JHotDrawRuntimeException("Iconkit instance isn't set");
        }
        StaticJButton staticJButton = new StaticJButton(Resource.getString("HTML_NEW"), new ImageIcon(iconkit.loadImageResource(Resource.getString("TOOLIMG_NEWPROJECT") + ".png"))){

            public void mouseClicked(MouseEvent mouseEvent) {
                HypertextToolBar.this.parent.promptNew();
            }
        };
        this.addButton("general", staticJButton);
        staticJButton = new StaticJButton(Resource.getString("HTML_LOAD"), new ImageIcon(iconkit.loadImageResource(Resource.getString("TOOLIMG_LOAD") + ".png"))){

            public void mouseClicked(MouseEvent mouseEvent) {
                HypertextToolBar.this.parent.promptOpen();
            }
        };
        this.addButton("general", staticJButton);
        staticJButton = new StaticJButton(Resource.getString("HTML_SAVE"), new ImageIcon(iconkit.loadImageResource(Resource.getString("TOOLIMG_SAVE") + ".png"))){

            public void mouseClicked(MouseEvent mouseEvent) {
                HypertextToolBar.this.parent.promptSaveAs();
            }
        };
        this.addButton("general", staticJButton);
        staticJButton = new StaticJButton(Resource.getString("HTML_PREVIEW"), new ImageIcon(iconkit.loadImageResource(Resource.getString("TOOLIMG_PREVIEW") + ".png"))){

            public void mouseClicked(MouseEvent mouseEvent) {
                HypertextToolBar.this.parent.preview();
            }
        };
        this.addButton("general", staticJButton);
    }

    public class MyToolButton
    extends ToolButton {
        public MyToolButton(PaletteListener paletteListener, String string, String string2, Tool tool) {
            super(paletteListener, string, string2, tool);
        }

        public Dimension getMaximumSize() {
            return new Dimension(40, 40);
        }

        public void setBorder(Border border) {
            super.setBorder(null);
        }
    }
}

