/*
 * Decompiled with CFR 0.152.
 */
package org.musoft.limo.hypertext;

import java.net.URL;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.musoft.limo.hypertext.HypertextViewer;
import org.musoft.limo.util.LogFile;

public class HyperlinkInterpreter
implements HyperlinkListener {
    protected HypertextViewer parent;
    public static final String COMMANDPREFIX = "limo-";
    public static final String COMMAND_BACK = "limo-back:";
    public static final String COMMAND_LOAD = "limo-load:";

    public HyperlinkInterpreter(HypertextViewer hypertextViewer) {
        this.parent = hypertextViewer;
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            if (hyperlinkEvent.getURL() == null) {
                this.parent.getApplication().showStatus(hyperlinkEvent.getDescription());
            } else {
                this.parent.getApplication().showStatus(hyperlinkEvent.getURL().toString());
            }
        } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
            this.parent.getApplication().showStatus(" ");
        } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (hyperlinkEvent.getDescription().startsWith(COMMAND_BACK)) {
                this.parent.goBack();
            } else if (hyperlinkEvent.getDescription().startsWith(COMMAND_LOAD)) {
                this.parent.getApplication().getModel().clear();
                try {
                    this.parent.getApplication().loadModel(this.parent.getApplication().getHypertextLocation().substring(5) + hyperlinkEvent.getDescription().substring(9));
                }
                catch (Exception exception) {
                    LogFile.log(exception);
                }
            } else if (hyperlinkEvent.getURL() != null) {
                URL uRL = hyperlinkEvent.getURL();
                if (uRL.getProtocol().equals("http")) {
                    this.parent.getApplication().openURLInBrowser(uRL.toString());
                } else if (!(!uRL.getProtocol().equals("file") || uRL.toString().endsWith(".html") || uRL.toString().endsWith(".htm") || uRL.toString().endsWith(".txt") || uRL.toString().endsWith(".rtf") || uRL.toString().indexOf("#") > -1)) {
                    this.parent.getApplication().openURLInBrowser(uRL.toString());
                } else {
                    try {
                        this.parent.setPage(hyperlinkEvent.getURL());
                    }
                    catch (Exception exception) {
                        LogFile.log(exception);
                    }
                }
            } else {
                try {
                    this.parent.setPage(hyperlinkEvent.getURL());
                }
                catch (Exception exception) {
                    LogFile.log(exception);
                }
            }
        }
    }
}

