/*
 * Decompiled with CFR 0.152.
 */
package org.musoft.limo.drawing;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import org.jhotdraw.figures.LineConnection;
import org.jhotdraw.figures.TextFigure;
import org.jhotdraw.framework.Connector;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.HandleEnumeration;
import org.jhotdraw.standard.HandleEnumerator;
import org.jhotdraw.standard.NullHandle;
import org.jhotdraw.standard.RelativeLocator;
import org.jhotdraw.util.CollectionsFactory;
import org.musoft.limo.drawing.ModelDrawing;
import org.musoft.limo.drawing.ModelFigure;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelAssociationEnd;
import org.musoft.limo.model.ModelConnectionElement;
import org.musoft.limo.model.ModelElement;
import org.musoft.limo.model.ModelFigureElement;
import org.musoft.limo.model.ModelListener;
import org.musoft.limo.model.ModelPrimitiveAttribute;

public class ModelConnection
extends LineConnection
implements ModelListener {
    public static final int LABEL_HIDDEN = 0;
    public static final int LABEL_CENTER = 16;
    public static final int LABEL_FREE = 32;
    private ModelDrawing drawing;
    private ModelConnectionElement element;
    private String labelText;
    private int labelPosition;
    private Label labelFigure;
    private ModelPrimitiveAttribute labelX;
    private ModelPrimitiveAttribute labelY;
    private Point savedLabelPosition;

    public ModelConnection(ModelDrawing modelDrawing, ModelConnectionElement modelConnectionElement) {
        this.drawing = modelDrawing;
        this.element = modelConnectionElement;
        this.labelX = (ModelPrimitiveAttribute)modelConnectionElement.getAttribute("labelX");
        this.labelY = (ModelPrimitiveAttribute)modelConnectionElement.getAttribute("labelY");
        this.savedLabelPosition = new Point(this.labelX.getInteger(), this.labelY.getInteger());
        modelDrawing.putConnectionFigure(modelConnectionElement, this);
        modelConnectionElement.addListener(this);
        this.setStartDecoration(null);
        this.setEndDecoration(null);
        Point[] pointArray = modelConnectionElement.getPoints();
        this.onSetConnectionStart(modelConnectionElement);
        this.onSetConnectionEnd(modelConnectionElement);
        if (pointArray != null && pointArray.length != 0) {
            for (int i = 1; i < pointArray.length - 1; ++i) {
                Point point = pointArray[i];
                super.insertPointAt(point, i);
            }
        } else if (modelConnectionElement.getStart() == modelConnectionElement.getEnd()) {
            Rectangle rectangle = modelConnectionElement.getStart().getBounds();
            Point point = new Point(rectangle.x + rectangle.width / 2, rectangle.y - 40);
            Point point2 = new Point(rectangle.x + rectangle.width + 40, rectangle.y - 40);
            Point point3 = new Point(rectangle.x + rectangle.width + 40, rectangle.y + rectangle.height / 2);
            this.insertPointAt(point, 1);
            this.insertPointAt(point2, 1);
            this.insertPointAt(point3, 1);
        }
    }

    public ModelConnectionElement getElement() {
        return this.element;
    }

    public boolean canConnect(Figure figure, Figure figure2) {
        if (!(figure instanceof ModelFigure) || !(figure2 instanceof ModelFigure)) {
            return false;
        }
        return this.element.canConnect(((ModelFigure)figure).getElement(), ((ModelFigure)figure2).getElement());
    }

    public void onSetConnectionStart(ModelConnectionElement modelConnectionElement) {
        ModelFigure modelFigure;
        ModelFigureElement modelFigureElement = modelConnectionElement.getStart();
        ModelFigure modelFigure2 = modelFigure = modelFigureElement == null ? null : this.drawing.getElementFigure(modelFigureElement);
        if (modelFigure != null) {
            int n = modelFigure.center().x;
            int n2 = modelFigure.center().y;
            Connector connector = modelFigure.connectorAt(n, n2);
            super.connectStart(connector);
            this.startPoint(n, n2);
        }
    }

    public void onSetConnectionEnd(ModelConnectionElement modelConnectionElement) {
        ModelFigure modelFigure;
        ModelFigureElement modelFigureElement = modelConnectionElement.getEnd();
        ModelFigure modelFigure2 = modelFigure = modelFigureElement == null ? null : this.drawing.getElementFigure(modelFigureElement);
        if (modelFigure != null) {
            int n = modelFigure.center().x;
            int n2 = modelFigure.center().y;
            Connector connector = modelFigure.connectorAt(n, n2);
            super.connectEnd(connector);
            this.endPoint(n, n2);
        }
    }

    public void onAddAssociate(ModelElement modelElement, ModelAssociationEnd modelAssociationEnd, ModelElement modelElement2) {
    }

    public void onAddChild(ModelFigureElement modelFigureElement, ModelElement modelElement) {
    }

    public void onCreateChild(ModelFigureElement modelFigureElement, ModelElement modelElement) {
    }

    public void onCreateConnection(Model model, ModelConnectionElement modelConnectionElement) {
    }

    public void onDestroy(ModelElement modelElement) {
        if (modelElement == this.element) {
            if (this.element != null) {
                this.drawing.putConnectionFigure(this.element, null);
                this.element = null;
            }
            if (this.labelFigure != null) {
                this.labelFigure.setCanDelete(true);
                this.drawing.remove(this.labelFigure);
                this.labelFigure.release();
                this.labelFigure = null;
            }
            this.setLabelPosition(0);
            if (this.drawing.includes(this)) {
                this.drawing.remove(this);
            }
            this.release();
        }
    }

    public void onRemoveAssociate(ModelElement modelElement, ModelAssociationEnd modelAssociationEnd, ModelElement modelElement2) {
    }

    public void onRemoveChild(ModelFigureElement modelFigureElement, ModelElement modelElement) {
    }

    public void onSetAttribute(ModelElement modelElement, String string, Object object) {
    }

    public void onSetBounds(ModelFigureElement modelFigureElement) {
    }

    public void onSetName(ModelElement modelElement) {
    }

    public void onSetParent(ModelFigureElement modelFigureElement) {
    }

    public void onSetPosition(ModelFigureElement modelFigureElement, int n, int n2) {
    }

    public void onSetAttribute(ModelElement modelElement, ModelPrimitiveAttribute modelPrimitiveAttribute) {
        if (this.labelY == modelPrimitiveAttribute && this.labelFigure != null) {
            Dimension dimension = this.labelFigure.size();
            Point point = new Point(this.labelX.getInteger() - dimension.width / 2, this.labelY.getInteger() - dimension.height / 2);
            Point point2 = new Point(point);
            point2.translate(dimension.width, dimension.height);
            this.labelFigure.displayBox(point, point2);
        }
    }

    public void onSetConnectionPoints(ModelConnectionElement modelConnectionElement) {
    }

    public void connectEnd(Connector connector) {
        this.element.setEnd(((ModelFigure)connector.owner()).getElement());
    }

    public void connectStart(Connector connector) {
        this.element.setStart(((ModelFigure)connector.owner()).getElement());
    }

    public void disconnectEnd() {
        super.disconnectEnd();
        if (this.getStartConnector() == null) {
            this.element.destroy();
        }
    }

    public void disconnectStart() {
        super.disconnectStart();
        if (this.getEndConnector() == null) {
            this.element.destroy();
        }
    }

    private void transferPoints() {
        Point[] pointArray = new Point[this.pointCount()];
        for (int i = 0; i < this.pointCount(); ++i) {
            pointArray[i] = new Point(this.pointAt(i));
        }
        this.element.setPoints(pointArray);
    }

    public String getLabel() {
        return this.labelText;
    }

    public void setLabel(String string) {
        this.labelText = string;
        this.updateLabel();
    }

    public int getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(int n) {
        this.labelPosition = n;
        this.updateLabel();
    }

    public void setLabelFont(Font font) {
        if (this.labelFigure != null) {
            this.labelFigure.setFont(font);
        }
    }

    private void updateLabel() {
        if (this.labelFigure != null && (this.labelPosition & 0xFF) == 0) {
            this.labelFigure.setCanDelete(true);
            this.drawing.remove(this.labelFigure);
            this.labelFigure.release();
            this.labelFigure = null;
        } else {
            if (this.labelFigure == null && (this.labelPosition & 0xFF) != 0) {
                this.labelFigure = new Label();
                this.labelFigure.setReadOnly(true);
                this.labelFigure.setFont(new Font("Helvetica", 0, 12));
                this.drawing.add(this.labelFigure);
            }
            if (this.labelFigure != null) {
                this.labelFigure.setText(this.labelText == null ? "(null)" : this.labelText);
                Dimension dimension = this.labelFigure.size();
                Point point = new Point(this.labelX.getInteger() - dimension.width / 2, this.labelY.getInteger() - dimension.height / 2);
                Point point2 = new Point(point);
                point2.translate(dimension.width, dimension.height);
                this.labelFigure.displayBox(point, point2);
            }
        }
    }

    public void bringToFront() {
        this.drawing.bringToFront(this);
        if (this.labelFigure != null) {
            this.drawing.bringToFront(this.labelFigure);
        }
    }

    public void checkPoint(Point point) {
        for (int i = 1; i < this.pointCount() - 1; ++i) {
            Point point2 = this.pointAt(i);
            if (!point2.equals(point) || !this.areClose(point, this.pointAt(i - 1)) && !this.areClose(point, this.pointAt(i + 1))) continue;
            this.removePointAt(i);
            return;
        }
    }

    private boolean areClose(Point point, Point point2) {
        int n = Math.abs(point.x - point2.x);
        int n2 = Math.abs(point.y - point2.y);
        return n < 5 && n2 < 5;
    }

    public void onSetDirty() {
    }

    public TextFigure getLabelFigure() {
        return this.labelFigure;
    }

    public void changed() {
        super.changed();
        this.transferPoints();
    }

    public void restoreLabelPosition() {
        if (this.savedLabelPosition != null) {
            this.labelX.setInteger(this.savedLabelPosition.x);
            this.labelY.setInteger(this.savedLabelPosition.y);
            this.savedLabelPosition = null;
        }
    }

    public class Label
    extends TextFigure {
        private boolean canDelete;

        public ModelConnection getFigure() {
            return ModelConnection.this;
        }

        public void setCanDelete(boolean bl) {
            this.canDelete = bl;
        }

        public boolean canDelete() {
            return this.canDelete;
        }

        public HandleEnumeration handles() {
            List list = CollectionsFactory.current().createList();
            list.add(new NullHandle(this, RelativeLocator.northWest()));
            list.add(new NullHandle(this, RelativeLocator.northEast()));
            list.add(new NullHandle(this, RelativeLocator.southEast()));
            list.add(new NullHandle(this, RelativeLocator.southWest()));
            return new HandleEnumerator(list);
        }

        public void moveBy(int n, int n2) {
            int n3 = ModelConnection.this.labelX.getInteger();
            int n4 = ModelConnection.this.labelY.getInteger();
            ModelConnection.this.labelX.setInteger(n3 + n);
            ModelConnection.this.labelY.setInteger(n4 + n2);
        }

        public void doMoveBy(int n, int n2) {
            if (n != 0 || n2 != 0) {
                this.willChange();
                this.basicMoveBy(n, n2);
                this.changed();
            }
        }
    }
}

