/*
 * Decompiled with CFR 0.152.
 */
package org.musoft.limo.application;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.ImageIcon;
import javax.swing.border.BevelBorder;
import org.jhotdraw.framework.JHotDrawRuntimeException;
import org.jhotdraw.framework.Tool;
import org.jhotdraw.framework.ToolListener;
import org.jhotdraw.util.Iconkit;
import org.jhotdraw.util.PaletteButton;
import org.jhotdraw.util.PaletteIcon;
import org.jhotdraw.util.PaletteListener;

public class MyToolButton
extends PaletteButton
implements ToolListener {
    private boolean isDefault;
    private boolean isPermanent;
    private boolean isTouched;
    private boolean isActive;
    private Tool myTool;
    private PaletteIcon myIcon;
    private Image[] im = new Image[3];

    public MyToolButton(PaletteListener paletteListener, String string, String string2, boolean bl) {
        super(paletteListener);
        this.isDefault = bl;
        this.setBorder(null);
        this.setEnabled(true);
        Iconkit iconkit = Iconkit.instance();
        if (iconkit == null) {
            throw new JHotDrawRuntimeException("Iconkit instance isn't set");
        }
        Image image = iconkit.loadImageResource(string + "1.png");
        if (image == null) {
            image = iconkit.loadImageResource(string + "1.gif");
        }
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setName(string2);
        this.setToolTipText(string2);
        this.setContentAreaFilled(false);
        this.setIcon(new ImageIcon(image));
    }

    public MyToolButton(PaletteListener paletteListener, String string, String string2, Tool tool, boolean bl) {
        super(paletteListener);
        this.isDefault = bl;
        tool.addToolListener(this);
        this.setEnabled(tool.isUsable());
        this.setBorder(null);
        Iconkit iconkit = Iconkit.instance();
        if (iconkit == null) {
            throw new JHotDrawRuntimeException("Iconkit instance isn't set");
        }
        Image image = iconkit.loadImageResource(string + ".png");
        if (image == null && (image = iconkit.loadImageResource(string + "1.png")) == null) {
            image = iconkit.loadImageResource(string + "1.gif");
        }
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setTool(tool);
        this.setName(string2);
        this.setToolTipText(string2);
        this.setContentAreaFilled(false);
        this.setIcon(new ImageIcon(image));
    }

    public Tool tool() {
        return this.myTool;
    }

    public String name() {
        return this.getName();
    }

    public Object attributeValue() {
        return this.tool();
    }

    public Dimension getMinimumSize() {
        return new Dimension(40, 40);
    }

    public Dimension getPreferredSize() {
        return new Dimension(40, 40);
    }

    public Dimension getMaximumSize() {
        return new Dimension(40, 40);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.isEnabled() && !this.isDefault) {
            this.isPermanent = mouseEvent.getClickCount() == 2;
        }
        super.mouseClicked(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        super.mouseEntered(mouseEvent);
        this.isTouched = true;
        this.updateDecoration();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        super.mouseExited(mouseEvent);
        this.isTouched = false;
        this.updateDecoration();
    }

    public boolean isPermanent() {
        return this.isPermanent;
    }

    public void paint(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = this.getWidth();
        int n2 = this.getHeight();
        super.paint(graphics);
        if (this.isPermanent) {
            graphics.setColor(Color.white);
            graphics.fillRect(n - 10, n2 - 12, 8, 8);
            graphics.setColor(Color.darkGray);
            graphics.drawRect(n - 10, n2 - 12, 8, 8);
            graphics.drawLine(n - 8, n2 - 8, n - 4, n2 - 8);
            graphics.drawLine(n - 6, n2 - 10, n - 6, n2 - 6);
        }
    }

    public void toolDeactivated(EventObject eventObject) {
        this.isPermanent = false;
        this.isActive = false;
        this.updateDecoration();
    }

    public void toolDisabled(EventObject eventObject) {
        this.isPermanent = false;
        this.isActive = false;
        this.setEnabled(false);
        this.updateDecoration();
    }

    public void toolUsable(EventObject eventObject) {
        this.setEnabled(true);
        this.updateDecoration();
    }

    public void toolUnusable(EventObject eventObject) {
        this.setEnabled(false);
        this.setSelected(false);
        this.updateDecoration();
    }

    public void toolActivated(EventObject eventObject) {
        this.isActive = true;
        this.updateDecoration();
    }

    public void toolEnabled(EventObject eventObject) {
        this.setEnabled(true);
        this.updateDecoration();
    }

    private PaletteIcon getPaletteIcon() {
        return this.myIcon;
    }

    private void setPaletteIcon(PaletteIcon paletteIcon) {
        this.myIcon = paletteIcon;
    }

    private void setTool(Tool tool) {
        this.myTool = tool;
    }

    public void updateUI() {
        super.updateUI();
        this.updateDecoration();
    }

    private void updateDecoration() {
        this.setContentAreaFilled(this.isTouched && this.isEnabled());
        if (this.isActive && this.isEnabled()) {
            this.setBorder(new BevelBorder(1));
        } else if (this.isTouched && this.isEnabled()) {
            this.setBorder(new BevelBorder(0));
        } else {
            this.setBorder(null);
        }
    }
}

