/*
 * Decompiled with CFR 0.152.
 */
package org.musoft.limo.application;

import java.awt.Component;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import org.jhotdraw.standard.AbstractCommand;
import org.jhotdraw.standard.ToggleGridCommand;
import org.jhotdraw.util.CommandMenu;
import org.jhotdraw.util.Iconkit;
import org.musoft.limo.application.Application;
import org.musoft.limo.application.ApplicationListener;
import org.musoft.limo.application.IconCommandMenu;
import org.musoft.limo.application.Resource;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelElement;

public class MenuBar
extends JMenuBar
implements ApplicationListener {
    private ToggleGridCommand gridCmd;
    protected Application parent;
    private JMenu viewmodeMenu;
    protected CommandMenu rescentFilesMenu;
    public static final String GTK_LOOK_AND_FEEL = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";

    public MenuBar(Application application) {
        this.parent = application;
        this.parent.addListener(this);
        this.createMenus();
    }

    protected void createMenus() {
        this.addMenu(this.createFileMenu());
        this.addMenu(this.createWindowMenu());
        this.addMenu(this.createHelpMenu());
        this.addMenuIfPossible(this.createDebugMenu());
    }

    protected Application getApplication() {
        return this.parent;
    }

    protected void addMenu(JMenu jMenu) {
        if (jMenu != null) {
            this.add(jMenu);
        }
    }

    protected void addMenuIfPossible(JMenu jMenu) {
        if (jMenu != null) {
            this.add((Component)jMenu, this.getMenuCount() - 1);
        }
    }

    public void setItemState(String string, boolean bl) {
        String string2 = "";
        int n = string.indexOf(46);
        if (n != -1) {
            string2 = string.substring(0, n);
            string = n + 1 < string.length() ? string.substring(n + 1) : "";
        }
        block0: for (int i = 0; i < this.getMenuCount(); ++i) {
            if (!this.getMenu(i).getText().equals(string2)) continue;
            if (!string.equals("")) {
                for (int j = 0; j < this.getMenu(i).getItemCount(); ++j) {
                    JMenuItem jMenuItem = this.getMenu(i).getItem(j);
                    if (jMenuItem == null || !jMenuItem.getText().equals(string)) continue;
                    this.getMenu(i).getItem(j).setEnabled(bl);
                    break block0;
                }
                break;
            }
            this.getMenu(i).setEnabled(bl);
            break;
        }
    }

    public void setRadioItemState(String string, boolean bl) {
        String string2 = "";
        int n = string.indexOf(46);
        if (n != -1) {
            string2 = string.substring(0, n);
            string = n + 1 < string.length() ? string.substring(n + 1) : "";
        }
        block0: for (int i = 0; i < this.getMenuCount(); ++i) {
            if (!this.getMenu(i).getText().equals(string2)) continue;
            for (int j = 0; j < this.getMenu(i).getItemCount(); ++j) {
                if (!this.getMenu(i).getItem(j).getText().equals(string)) continue;
                ((JRadioButtonMenuItem)this.getMenu(i).getItem(j)).setSelected(bl);
                continue block0;
            }
        }
    }

    protected JMenu createFileMenu() {
        Iconkit iconkit = Iconkit.instance();
        IconCommandMenu iconCommandMenu = new IconCommandMenu(Resource.getString("MNU_FILE"));
        iconCommandMenu.setMnemonic(Resource.getChar("MNUM_FILE"));
        AbstractCommand abstractCommand = new AbstractCommand(Resource.getString("MNU_FILE_NEW"), this.parent, false){

            public void execute() {
                MenuBar.this.parent.promptNew();
            }
        };
        iconCommandMenu.add(abstractCommand, new MenuShortcut(Resource.getChar("MNUM_FILE_NEW")), new ImageIcon(iconkit.loadImageResource(Resource.getString("NEWPROJECT_ICON"))));
        abstractCommand = new AbstractCommand(Resource.getString("MNU_FILE_OPEN"), this.parent, false){

            public void execute() {
                MenuBar.this.parent.promptOpen();
            }
        };
        iconCommandMenu.add(abstractCommand, new MenuShortcut(Resource.getChar("MNUM_FILE_OPEN")), new ImageIcon(iconkit.loadImageResource(Resource.getString("LOAD_ICON"))));
        abstractCommand = new AbstractCommand(Resource.getString("MNU_FILE_SAVE"), this.parent, true){

            public void execute() {
                MenuBar.this.parent.saveModel();
            }
        };
        iconCommandMenu.add(abstractCommand, new MenuShortcut(Resource.getChar("MNUM_FILE_SAVE")), new ImageIcon(iconkit.loadImageResource(Resource.getString("SAVE_ICON"))));
        abstractCommand = new AbstractCommand(Resource.getString("MNU_FILE_SAVEAS"), this.parent, true){

            public void execute() {
                MenuBar.this.parent.promptSaveAs();
            }
        };
        iconCommandMenu.add(abstractCommand, new MenuShortcut(Resource.getChar("MNUM_FILE_SAVEAS")), new ImageIcon(iconkit.loadImageResource(Resource.getString("SAVEAS_ICON"))));
        iconCommandMenu.addSeparator();
        abstractCommand = new AbstractCommand(Resource.getString("MNU_FILE_EXPORT"), this.parent, true){

            public void execute() {
                MenuBar.this.parent.promptExport();
            }
        };
        iconCommandMenu.add(abstractCommand, new MenuShortcut(Resource.getChar("MNUM_FILE_EXPORT")), new ImageIcon(iconkit.loadImageResource(Resource.getString("EXPORT_ICON"))));
        abstractCommand = new AbstractCommand(Resource.getString("MNU_FILE_PRINT"), this.parent, true){

            public void execute() {
                MenuBar.this.parent.promptPrint(true);
            }
        };
        iconCommandMenu.add(abstractCommand, new MenuShortcut(Resource.getChar("MNUM_FILE_PRINT")), new ImageIcon(iconkit.loadImageResource(Resource.getString("PRINT_ICON"))));
        iconCommandMenu.addSeparator();
        this.rescentFilesMenu = new CommandMenu(Resource.getString("MNU_FILE_RESCENT"));
        this.rescentFilesMenu.setMnemonic(Resource.getChar("MNUM_FILE_RESCENT"));
        this.rescentFilesMenu.setIcon(new ImageIcon(iconkit.loadImageResource(Resource.getString("RECENTFILES_ICON"))));
        iconCommandMenu.add(this.rescentFilesMenu);
        iconCommandMenu.addSeparator();
        abstractCommand = new AbstractCommand(Resource.getString("MNU_FILE_CLOSE"), this.parent, true){

            public void execute() {
                MenuBar.this.parent.promptClose();
            }
        };
        iconCommandMenu.add(abstractCommand, new MenuShortcut(Resource.getChar("MNUM_FILE_CLOSE")), new ImageIcon(iconkit.loadImageResource(Resource.getString("CLOSE_ICON"))));
        abstractCommand = new AbstractCommand(Resource.getString("MNU_FILE_EXIT"), this.parent, true){

            public void execute() {
                MenuBar.this.parent.exit();
            }
        };
        iconCommandMenu.add(abstractCommand, new MenuShortcut(Resource.getChar("MNUM_FILE_EXIT")), new ImageIcon(iconkit.loadImageResource(Resource.getString("EXIT_ICON"))));
        return iconCommandMenu;
    }

    public JMenu createWindowMenu() {
        Iconkit iconkit = Iconkit.instance();
        IconCommandMenu iconCommandMenu = new IconCommandMenu(Resource.getString("MNU_WINDOW"));
        IconCommandMenu iconCommandMenu2 = new IconCommandMenu(Resource.getString("MNU_WINDOW_GRID"));
        iconCommandMenu2.setIcon(new ImageIcon(iconkit.loadImageResource("/images/Menus/Grid.png")));
        iconCommandMenu.add(iconCommandMenu2);
        AbstractCommand abstractCommand = new AbstractCommand(Resource.getString("MNU_WINDOW_GRID_ON"), this.parent){

            public void execute() {
                boolean bl = !MenuBar.this.parent.getMainPane().getGrid();
                MenuBar.this.parent.getMainPane().setGrid(true);
            }
        };
        iconCommandMenu2.add(abstractCommand);
        AbstractCommand abstractCommand2 = new AbstractCommand(Resource.getString("MNU_WINDOW_GRID_OFF"), this.parent){

            public void execute() {
                boolean bl = !MenuBar.this.parent.getMainPane().getGrid();
                MenuBar.this.parent.getMainPane().setGrid(false);
            }
        };
        iconCommandMenu2.add(abstractCommand2);
        IconCommandMenu iconCommandMenu3 = new IconCommandMenu(Resource.getString("Look'n'Feel"));
        iconCommandMenu3.setIcon(new ImageIcon(iconkit.loadImageResource("/images/Menus/LooknFeel.png")));
        iconCommandMenu.add(iconCommandMenu3);
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        String string = System.getProperty("java.version");
        boolean bl = "1.5.0".compareTo(string) <= 0;
        boolean bl2 = false;
        for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
            AbstractCommand abstractCommand3;
            final String string2 = lookAndFeelInfoArray[i].getClassName();
            if (GTK_LOOK_AND_FEEL.equals(string2)) {
                bl2 = true;
            }
            if ("Metal".equals(lookAndFeelInfoArray[i].getName()) && bl) {
                abstractCommand3 = new AbstractCommand("Metal", this.parent, false){

                    public void execute() {
                        MenuBar.this.parent.setLookAndFeel(string2, "javax.swing.plaf.metal.OceanTheme");
                    }
                };
                iconCommandMenu3.add(abstractCommand3);
                abstractCommand3 = new AbstractCommand("Metal Classic", this.parent, false){

                    public void execute() {
                        MenuBar.this.parent.setLookAndFeel(string2, "javax.swing.plaf.metal.DefaultMetalTheme");
                    }
                };
                iconCommandMenu3.add(abstractCommand3);
                continue;
            }
            abstractCommand3 = new AbstractCommand(lookAndFeelInfoArray[i].getName(), this.parent, false){

                public void execute() {
                    MenuBar.this.parent.setLookAndFeel(string2, null);
                }
            };
            iconCommandMenu3.add(abstractCommand3);
        }
        if (!bl2) {
            try {
                Class.forName(GTK_LOOK_AND_FEEL);
                AbstractCommand abstractCommand4 = new AbstractCommand("GTK+", this.parent, false){

                    public void execute() {
                        MenuBar.this.parent.setLookAndFeel(MenuBar.GTK_LOOK_AND_FEEL, null);
                    }
                };
                iconCommandMenu3.add(abstractCommand4);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        JMenuItem jMenuItem = new JMenuItem(Resource.getString("MNU_VIEW_FULLSCREEN"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuBar.this.parent.setViewMode(2);
            }
        });
        jMenuItem.setMnemonic(Resource.getChar("MNUM_VIEW_FULLSCREEN"));
        jMenuItem.setIcon(new ImageIcon(iconkit.loadImageResource("/images/Menus/FullScreen.png")));
        iconCommandMenu.add(jMenuItem);
        return iconCommandMenu;
    }

    public JMenu createHelpMenu() {
        Iconkit iconkit = Iconkit.instance();
        IconCommandMenu iconCommandMenu = new IconCommandMenu(Resource.getString("MNU_HELP"));
        iconCommandMenu.setMnemonic(Resource.getChar("MNUM_HELP"));
        AbstractCommand abstractCommand = new AbstractCommand(Resource.getString("MNU_HELP_HELP"), this.parent, false){

            public void execute() {
                MenuBar.this.parent.showHelp();
            }
        };
        iconCommandMenu.add(abstractCommand, new MenuShortcut(Resource.getChar("MNUM_HELP_HELP")), new ImageIcon(iconkit.loadImageResource(Resource.getString("HELP_ICON"))));
        abstractCommand = new AbstractCommand(Resource.getString("MNU_HELP_MUSOFT"), this.parent, false){

            public void execute() {
                MenuBar.this.parent.openURLInBrowser(Resource.getString("URL_MUSOFT"));
            }
        };
        iconCommandMenu.add(abstractCommand, new MenuShortcut(Resource.getChar("MNU_HELP_MUSOFT")), new ImageIcon(iconkit.loadImageResource(Resource.getString("MUSOFT_ICON"))));
        abstractCommand = new AbstractCommand(Resource.getString("MNU_HELP_BUG"), this.parent, false){

            public void execute() {
                MenuBar.this.parent.openURLInBrowser(Resource.getString("URL_BUGREPORT"));
            }
        };
        iconCommandMenu.add(abstractCommand, new MenuShortcut(Resource.getChar("MNUM_HELP_BUG")), new ImageIcon(iconkit.loadImageResource(Resource.getString("BUG_ICON"))));
        abstractCommand = new AbstractCommand(Resource.getString("MNU_HELP_INFO"), this.parent, false){

            public void execute() {
                MenuBar.this.parent.showAboutDialog();
            }
        };
        iconCommandMenu.add(abstractCommand, new MenuShortcut(Resource.getChar("MNUM_HELP_INFO")), new ImageIcon(iconkit.loadImageResource(Resource.getString("INFO_ICON"))));
        return iconCommandMenu;
    }

    public void setRecentFiles(Vector vector) {
        this.rescentFilesMenu.removeAll();
        for (int i = 1; i <= vector.size(); ++i) {
            RescentCommand rescentCommand = new RescentCommand((String)vector.get(i - 1), this.parent, i);
            this.rescentFilesMenu.add(rescentCommand, new MenuShortcut(new String("" + i).charAt(0)));
        }
    }

    protected JMenu createDebugMenu() {
        CommandMenu commandMenu = new CommandMenu("Test & Debug");
        commandMenu.setMnemonic('T');
        commandMenu.insert(new AbstractAction("Dump Model"){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuBar.this.getApplication().getModel().dump();
            }
        }, 1);
        return commandMenu;
    }

    public void onModelCreated(Application application, Model model) {
    }

    public void onModelDestroying(Application application, Model model) {
    }

    public void onModelLoaded(Application application, Model model) {
    }

    public void onModelSaved(Application application, Model model) {
    }

    public void onModelSelectionChanged(Application application, Model model, ModelElement[] modelElementArray) {
    }

    public void onStateChanged(Application application) {
    }

    public class RescentCommand
    extends AbstractCommand {
        private String file;

        public RescentCommand(String string, Application application, int n) {
            super("" + n + ". " + string, application, true);
            this.file = string;
        }

        public void execute() {
            MenuBar.this.parent.promptOpen(this.file);
        }
    }
}

