/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.Locator;
import org.jhotdraw.standard.AbstractLocator;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public class RelativeLocator
extends AbstractLocator {
    private static final long serialVersionUID = 2619148876087898602L;
    private int relativeLocatorSerializedDataVersion = 1;
    double fRelativeX;
    double fRelativeY;

    public RelativeLocator() {
        this.fRelativeX = 0.0;
        this.fRelativeY = 0.0;
    }

    public boolean equals(Object object) {
        if (RelativeLocator.class.isInstance(object)) {
            RelativeLocator relativeLocator = (RelativeLocator)object;
            if (relativeLocator.fRelativeX == this.fRelativeX && relativeLocator.fRelativeY == this.fRelativeY) {
                return true;
            }
        }
        return false;
    }

    public RelativeLocator(double d, double d2) {
        this.fRelativeX = d;
        this.fRelativeY = d2;
    }

    public Point locate(Figure figure) {
        Rectangle rectangle = figure.displayBox();
        return new Point(rectangle.x + (int)((double)rectangle.width * this.fRelativeX), rectangle.y + (int)((double)rectangle.height * this.fRelativeY));
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeDouble(this.fRelativeX);
        storableOutput.writeDouble(this.fRelativeY);
    }

    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        this.fRelativeX = storableInput.readDouble();
        this.fRelativeY = storableInput.readDouble();
    }

    public static Locator east() {
        return new RelativeLocator(1.0, 0.5);
    }

    public static Locator north() {
        return new RelativeLocator(0.5, 0.0);
    }

    public static Locator west() {
        return new RelativeLocator(0.0, 0.5);
    }

    public static Locator northEast() {
        return new RelativeLocator(1.0, 0.0);
    }

    public static Locator northWest() {
        return new RelativeLocator(0.0, 0.0);
    }

    public static Locator south() {
        return new RelativeLocator(0.5, 1.0);
    }

    public static Locator southEast() {
        return new RelativeLocator(1.0, 1.0);
    }

    public static Locator southWest() {
        return new RelativeLocator(0.0, 1.0);
    }

    public static Locator center() {
        return new RelativeLocator(0.5, 0.5);
    }
}

