/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib.dnd;

import java.awt.Component;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.io.Serializable;
import javax.swing.JComponent;
import org.jhotdraw.contrib.dnd.DNDFigures;
import org.jhotdraw.contrib.dnd.DNDFiguresTransferable;
import org.jhotdraw.contrib.dnd.DNDHelper;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.FigureVisitor;
import org.jhotdraw.standard.DeleteFromDrawingVisitor;
import org.jhotdraw.standard.FigureEnumerator;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

public class JHDDragSourceListener
implements DragSourceListener {
    private Undoable sourceUndoable;
    private Boolean autoscrollState;
    private DrawingEditor editor;

    public JHDDragSourceListener(DrawingEditor drawingEditor, DrawingView drawingView) {
        this.editor = drawingEditor;
    }

    protected DrawingEditor editor() {
        return this.editor;
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        Object object;
        Serializable serializable;
        DrawingView drawingView = (DrawingView)((Object)dragSourceDropEvent.getDragSourceContext().getComponent());
        JHDDragSourceListener.log("DragSourceDropEvent-dragDropEnd");
        if (dragSourceDropEvent.getDropSuccess()) {
            if (dragSourceDropEvent.getDropAction() == 2) {
                JHDDragSourceListener.log("DragSourceDropEvent-ACTION_MOVE");
                this.setSourceUndoActivity(this.createSourceUndoActivity(drawingView));
                serializable = (DNDFigures)DNDHelper.processReceivedData(DNDFiguresTransferable.DNDFiguresFlavor, dragSourceDropEvent.getDragSourceContext().getTransferable());
                this.getSourceUndoActivity().setAffectedFigures(((DNDFigures)serializable).getFigures());
                object = new DeleteFromDrawingVisitor(drawingView.drawing());
                FigureEnumeration figureEnumeration = this.getSourceUndoActivity().getAffectedFigures();
                while (figureEnumeration.hasNextFigure()) {
                    figureEnumeration.nextFigure().visit((FigureVisitor)object);
                }
                drawingView.clearSelection();
                drawingView.checkDamage();
                this.editor().getUndoManager().pushUndo(this.getSourceUndoActivity());
                this.editor().getUndoManager().clearRedos();
                this.editor().figureSelectionChanged(drawingView);
            } else if (dragSourceDropEvent.getDropAction() == 1) {
                JHDDragSourceListener.log("DragSourceDropEvent-ACTION_COPY");
            }
        }
        if (this.autoscrollState != null && JComponent.class.isInstance(serializable = dragSourceDropEvent.getDragSourceContext().getComponent())) {
            object = (JComponent)serializable;
            ((JComponent)object).setAutoscrolls(this.autoscrollState);
            this.autoscrollState = null;
        }
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        Component component;
        JHDDragSourceListener.log("DragSourceDragEvent-dragEnter");
        if (this.autoscrollState == null && JComponent.class.isInstance(component = dragSourceDragEvent.getDragSourceContext().getComponent())) {
            JComponent jComponent = (JComponent)component;
            this.autoscrollState = new Boolean(jComponent.getAutoscrolls());
            jComponent.setAutoscrolls(false);
        }
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        JHDDragSourceListener.log("DragSourceDragEvent-dropActionChanged");
    }

    protected Undoable createSourceUndoActivity(DrawingView drawingView) {
        return new RemoveUndoActivity(drawingView);
    }

    protected void setSourceUndoActivity(Undoable undoable) {
        this.sourceUndoable = undoable;
    }

    protected Undoable getSourceUndoActivity() {
        return this.sourceUndoable;
    }

    private static void log(String string) {
    }

    public static class RemoveUndoActivity
    extends UndoableAdapter {
        private boolean undone = false;

        public RemoveUndoActivity(DrawingView drawingView) {
            super(drawingView);
            JHDDragSourceListener.log("RemoveUndoActivity created " + drawingView);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (this.isUndoable() && this.getAffectedFigures().hasNextFigure()) {
                JHDDragSourceListener.log("RemoveUndoActivity undo");
                this.getDrawingView().clearSelection();
                this.setAffectedFigures(this.getDrawingView().insertFigures(this.getAffectedFigures(), 0, 0, false));
                this.undone = true;
                return true;
            }
            return false;
        }

        public boolean redo() {
            if (this.isRedoable()) {
                JHDDragSourceListener.log("RemoveUndoActivity redo");
                DeleteFromDrawingVisitor deleteFromDrawingVisitor = new DeleteFromDrawingVisitor(this.getDrawingView().drawing());
                FigureEnumeration figureEnumeration = this.getAffectedFigures();
                while (figureEnumeration.hasNextFigure()) {
                    figureEnumeration.nextFigure().visit(deleteFromDrawingVisitor);
                }
                this.getDrawingView().clearSelection();
                this.setAffectedFigures(deleteFromDrawingVisitor.getDeletedFigures());
                this.undone = false;
                return true;
            }
            return false;
        }

        public void release() {
            if (!this.undone) {
                FigureEnumeration figureEnumeration = this.getAffectedFigures();
                while (figureEnumeration.hasNextFigure()) {
                    Figure figure = figureEnumeration.nextFigure();
                    this.getDrawingView().drawing().remove(figure);
                    figure.release();
                }
            }
            this.setAffectedFigures(FigureEnumerator.getEmptyEnumeration());
        }
    }
}

