/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib.dnd;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jhotdraw.contrib.dnd.DNDFiguresTransferable;
import org.jhotdraw.contrib.dnd.JHDDragSourceListener;
import org.jhotdraw.contrib.dnd.JHDDropTargetListener;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;

public abstract class DNDHelper {
    public static DataFlavor ASCIIFlavor = new DataFlavor("text/plain; charset=ascii", "ASCII text");
    private DragGestureRecognizer dgr;
    private DragGestureListener dragGestureListener;
    private DropTarget dropTarget;
    private DragSourceListener dragSourceListener;
    private DropTargetListener dropTargetListener;
    private boolean isDragSource = false;
    private boolean isDropTarget = false;

    public DNDHelper(boolean bl, boolean bl2) {
        this.isDragSource = bl;
        this.isDropTarget = bl2;
    }

    public void initialize(DragGestureListener dragGestureListener) {
        if (this.isDragSource) {
            this.setDragGestureListener(dragGestureListener);
            this.setDragSourceListener(this.createDragSourceListener());
            this.setDragGestureRecognizer(this.createDragGestureRecognizer(this.getDragGestureListener()));
        }
        if (this.isDropTarget) {
            this.setDropTargetListener(this.createDropTargetListener());
            this.setDropTarget(this.createDropTarget());
        }
    }

    public void deinitialize() {
        if (this.getDragSourceListener() != null) {
            this.destroyDragGestreRecognizer();
            this.setDragSourceListener(null);
        }
        if (this.getDropTargetListener() != null) {
            this.setDropTarget(null);
            this.setDropTargetListener(null);
        }
    }

    protected abstract DrawingView view();

    protected abstract DrawingEditor editor();

    protected static Object processReceivedData(DataFlavor dataFlavor, Transferable transferable) {
        Object object = null;
        if (transferable == null) {
            return null;
        }
        try {
            if (dataFlavor.equals(DataFlavor.stringFlavor)) {
                object = transferable.getTransferData(DataFlavor.stringFlavor);
            } else if (dataFlavor.equals(DataFlavor.javaFileListFlavor)) {
                List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                File[] fileArray = new File[list.size()];
                list.toArray(fileArray);
                object = fileArray;
            } else if (dataFlavor.equals(ASCIIFlavor)) {
                int n;
                byte[] byArray;
                InputStream inputStream = (InputStream)transferable.getTransferData(ASCIIFlavor);
                int n2 = inputStream.read(byArray = new byte[n = inputStream.available()]);
                if (n2 > 0) {
                    object = new String(byArray, 0, n2);
                }
            } else if (dataFlavor.equals(DNDFiguresTransferable.DNDFiguresFlavor)) {
                object = transferable.getTransferData(DNDFiguresTransferable.DNDFiguresFlavor);
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            System.err.println(unsupportedFlavorException);
        }
        catch (ClassCastException classCastException) {
            System.err.println(classCastException);
        }
        return object;
    }

    protected int getDragSourceActions() {
        return 3;
    }

    protected int getDropTargetActions() {
        return 3;
    }

    protected void setDragGestureListener(DragGestureListener dragGestureListener) {
        this.dragGestureListener = dragGestureListener;
    }

    protected DragGestureListener getDragGestureListener() {
        return this.dragGestureListener;
    }

    protected void setDragGestureRecognizer(DragGestureRecognizer dragGestureRecognizer) {
        this.dgr = dragGestureRecognizer;
    }

    protected DragGestureRecognizer getDragGestureRecognizer() {
        return this.dgr;
    }

    protected void setDropTarget(DropTarget dropTarget) {
        if (dropTarget == null && this.dropTarget != null) {
            this.dropTarget.setComponent(null);
            this.dropTarget.removeDropTargetListener(this.getDropTargetListener());
        }
        this.dropTarget = dropTarget;
    }

    protected DropTarget createDropTarget() {
        DropTarget dropTarget = null;
        if (Component.class.isInstance(this.view())) {
            try {
                dropTarget = new DropTarget((Component)((Object)this.view()), this.getDropTargetActions(), this.getDropTargetListener());
            }
            catch (NullPointerException nullPointerException) {
                System.err.println("View Failed to initialize to DND.");
                System.err.println("Container likely did not have peer before the DropTarget was added");
                System.err.println(nullPointerException);
                nullPointerException.printStackTrace();
            }
        }
        return dropTarget;
    }

    protected DragGestureRecognizer createDragGestureRecognizer(DragGestureListener dragGestureListener) {
        DragGestureRecognizer dragGestureRecognizer = null;
        if (Component.class.isInstance(this.view())) {
            Component component = (Component)((Object)this.view());
            dragGestureRecognizer = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(component, this.getDragSourceActions(), dragGestureListener);
        }
        return dragGestureRecognizer;
    }

    protected void destroyDragGestreRecognizer() {
        if (this.getDragGestureRecognizer() != null) {
            this.getDragGestureRecognizer().removeDragGestureListener(this.getDragGestureListener());
            this.getDragGestureRecognizer().setComponent(null);
            this.setDragGestureRecognizer(null);
        }
    }

    protected void setDropTargetListener(DropTargetListener dropTargetListener) {
        this.dropTargetListener = dropTargetListener;
    }

    protected DropTargetListener getDropTargetListener() {
        return this.dropTargetListener;
    }

    protected DropTargetListener createDropTargetListener() {
        return new JHDDropTargetListener(this.editor(), this.view());
    }

    public DragSourceListener getDragSourceListener() {
        return this.dragSourceListener;
    }

    protected void setDragSourceListener(DragSourceListener dragSourceListener) {
        this.dragSourceListener = dragSourceListener;
    }

    protected DragSourceListener createDragSourceListener() {
        return new JHDDragSourceListener(this.editor(), this.view());
    }
}

