/*
 * Decompiled with CFR 0.152.
 */
package org.kxml2.wap;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Vector;
import org.xmlpull.v1.XmlSerializer;

public class WbxmlSerializer
implements XmlSerializer {
    Hashtable stringTable = new Hashtable();
    OutputStream out;
    ByteArrayOutputStream buf = new ByteArrayOutputStream();
    ByteArrayOutputStream stringTableBuf = new ByteArrayOutputStream();
    String pending;
    int depth;
    String name;
    String namespace;
    Vector attributes = new Vector();
    Hashtable attrStartTable = new Hashtable();
    Hashtable attrValueTable = new Hashtable();
    Hashtable tagTable = new Hashtable();

    public XmlSerializer attribute(String namespace, String name, String value) {
        this.attributes.addElement(name);
        this.attributes.addElement(value);
        return this;
    }

    public void cdsect(String cdsect) throws IOException {
        this.text(cdsect);
    }

    public void comment(String comment) {
    }

    public void docdecl(String docdecl) {
        throw new RuntimeException("Cannot write docdecl for WBXML");
    }

    public void entityRef(String er) {
        throw new RuntimeException("EntityReference not supported for WBXML");
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean getFeature(String name) {
        return false;
    }

    public String getNamespace() {
        throw new RuntimeException("NYI");
    }

    public String getName() {
        throw new RuntimeException("NYI");
    }

    public String getPrefix(String nsp, boolean create) {
        throw new RuntimeException("NYI");
    }

    public Object getProperty(String name) {
        return null;
    }

    public void ignorableWhitespace(String sp) {
    }

    public void endDocument() throws IOException {
        WbxmlSerializer.writeInt(this.out, this.stringTableBuf.size());
        this.out.write(this.stringTableBuf.toByteArray());
        this.out.write(this.buf.toByteArray());
        this.out.flush();
    }

    public void flush() {
    }

    public void checkPending(boolean degenerated) throws IOException {
        if (this.pending == null) {
            return;
        }
        int len = this.attributes.size();
        Integer idx = (Integer)this.tagTable.get(this.pending);
        if (idx == null) {
            this.buf.write(len == 0 ? (degenerated ? 4 : 68) : (degenerated ? 132 : 196));
            this.writeStrT(this.pending);
        } else {
            this.buf.write(len == 0 ? (degenerated ? idx : idx | 0x40) : (degenerated ? idx | 0x80 : idx | 0xC0));
        }
        int i = 0;
        while (i < len) {
            idx = (Integer)this.attrStartTable.get(this.attributes.elementAt(i));
            if (idx == null) {
                this.buf.write(4);
                this.writeStrT((String)this.attributes.elementAt(i));
            } else {
                this.buf.write(idx);
            }
            idx = (Integer)this.attrValueTable.get(this.attributes.elementAt(++i));
            if (idx == null) {
                this.buf.write(3);
                WbxmlSerializer.writeStrI(this.buf, (String)this.attributes.elementAt(i));
            } else {
                this.buf.write(idx);
            }
            ++i;
        }
        if (len > 0) {
            this.buf.write(1);
        }
        this.pending = null;
        this.attributes.removeAllElements();
    }

    public void processingInstruction(String pi) {
        throw new RuntimeException("PI NYI");
    }

    public void setFeature(String name, boolean value) {
        throw new IllegalArgumentException("unknown feature " + name);
    }

    public void setOutput(Writer writer) {
        throw new RuntimeException("Wbxml requires an outputstream, no writer");
    }

    public void setOutput(OutputStream out, String encoding) throws IOException {
        if (encoding != null) {
            throw new IllegalArgumentException("encoding not supported for WBXML");
        }
        this.out = out;
        this.buf = new ByteArrayOutputStream();
        this.stringTableBuf = new ByteArrayOutputStream();
    }

    public void setPrefix(String prefix, String nsp) {
        throw new RuntimeException("NYI");
    }

    public void setProperty(String property, Object value) {
        throw new IllegalArgumentException("unknown property " + property);
    }

    public void startDocument(String s, Boolean b) throws IOException {
        this.out.write(1);
        this.out.write(1);
        this.out.write(4);
    }

    public XmlSerializer startTag(String namespace, String name) throws IOException {
        if (namespace != null && !"".equals(namespace)) {
            throw new RuntimeException("NSP NYI");
        }
        this.checkPending(false);
        this.pending = name;
        ++this.depth;
        return this;
    }

    public XmlSerializer text(char[] chars, int start, int len) throws IOException {
        this.checkPending(false);
        this.buf.write(3);
        WbxmlSerializer.writeStrI(this.buf, new String(chars, start, len));
        return this;
    }

    public XmlSerializer text(String text) throws IOException {
        this.checkPending(false);
        this.buf.write(3);
        WbxmlSerializer.writeStrI(this.buf, text);
        return this;
    }

    public XmlSerializer endTag(String namespace, String name) throws IOException {
        if (this.pending != null) {
            this.checkPending(true);
        } else {
            this.buf.write(1);
        }
        --this.depth;
        return this;
    }

    public void writeLegacy(int type, String data) {
    }

    static void writeInt(OutputStream out, int i) throws IOException {
        byte[] buf = new byte[5];
        int idx = 0;
        do {
            buf[idx++] = (byte)(i & 0x7F);
        } while ((i >>= 7) != 0);
        while (idx > 1) {
            out.write(buf[--idx] | 0x80);
        }
        out.write(buf[0]);
    }

    static void writeStrI(OutputStream out, String s) throws IOException {
        int i = 0;
        while (i < s.length()) {
            out.write((byte)s.charAt(i));
            ++i;
        }
        out.write(0);
    }

    void writeStrT(String s) throws IOException {
        Integer idx = (Integer)this.stringTable.get(s);
        if (idx == null) {
            idx = new Integer(this.stringTableBuf.size());
            this.stringTable.put(s, idx);
            WbxmlSerializer.writeStrI(this.stringTableBuf, s);
            this.stringTableBuf.flush();
        }
        WbxmlSerializer.writeInt(this.buf, idx);
    }

    public void setTagTable(int page, String[] tagTable) {
        int i = 0;
        while (i < tagTable.length) {
            if (tagTable[i] != null) {
                Integer idx = new Integer(i + 5);
                this.tagTable.put(tagTable[i], idx);
            }
            ++i;
        }
        if (page != 0) {
            throw new RuntimeException("code pages curr. not supp.");
        }
    }

    public void setAttrStartTable(int page, String[] attrStartTable) {
        int i = 0;
        while (i < attrStartTable.length) {
            if (attrStartTable[i] != null) {
                Integer idx = new Integer(i + 5);
                this.attrStartTable.put(attrStartTable[i], idx);
            }
            ++i;
        }
        if (page != 0) {
            throw new RuntimeException("code pages curr. not supp.");
        }
    }

    public void setAttrValueTable(int page, String[] attrValueTable) {
        int i = 0;
        while (i < attrValueTable.length) {
            if (attrValueTable[i] != null) {
                Integer idx = new Integer(i + 133);
                this.attrValueTable.put(attrValueTable[i], idx);
            }
            ++i;
        }
        if (page != 0) {
            throw new RuntimeException("code pages curr. not supp.");
        }
    }
}

