---------------------- M4 Operators --------------------------

INSERT INTO OPERATOR_T VALUES (34, 'MultiRelationalFeatureConstruction', 'NO', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  500,   34,    1,      1,    'TheInputConcept',    'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  501,   34,    1,   NULL,    'TheConcepts',        'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  502,   34,    1,   NULL,    'TheRelations',       'IN', 'REL', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  503,   34,    1,   NULL,    'TheChainedFeatures', 'IN', 'FEA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  504,   34,    1,      1,    'TheOutputConcept',  'OUT', 'CON', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  505, 34, 'COMP',     'TheInputConcept',  'TheRelations',     NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  506, 34, 'COMP',        'TheRelations',   'TheConcepts',     NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  507, 34,   'IN',  'TheChainedFeatures',  'TheOutputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  508, 34,   'IN',  'TheChainedFeatures',  'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  509, 34,   'IN',  'TheChainedFeatures',  'TheConcepts',      NULL, NULL);

-- no conditions

INSERT INTO OP_ASSERT_T VALUES (
  510, 34, 'PROJ', 'TheInputConcept', 'TheOutputConcept', NULL, NULL); 
-- input is proj of output
INSERT INTO OP_ASSERT_T VALUES (
  511, 34, 'PROJ', 'TheConcepts',     'TheOutputConcept', NULL, NULL); 
-- theConcepts are proj of output

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (37, 'RowSelectionByRandomSampling', 'NO', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  512,   37,    1,      1,     'TheInputConcept',   'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  513,   37,    1,      1,             'HowMany',   'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  514,   37,    1,      1,    'TheOutputConcept',  'OUT', 'CON', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  515, 37, 'SAME_FEAT', 'TheOutputConcept', 'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  516, 37,      'TYPE',          'HowMany',         'NUMERIC',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  517, 37,        'GE',          'HowMany',                 1,  NULL, NULL);

-- no conditions

INSERT INTO OP_ASSERT_T VALUES (
  518, 37, 'SUBSET', 'TheOutputConcept', 'TheInputConcept', NULL, NULL); 
-- output is subset of input

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (38, 'DeleteRecordsWithMissingValues', 'NO', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  519,   38,    1,      1,     'TheInputConcept',   'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  520,   38,    1,      1,  'TheTargetAttribute',   'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  521,   38,    1,      1,    'TheOutputConcept',  'OUT', 'CON', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  522, 38, 'SAME_FEAT',   'TheOutputConcept',  'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  523, 38, 'IN',        'TheTargetAttribute',  'TheInputConcept',  NULL, NULL);

-- no conditions

INSERT INTO OP_ASSERT_T VALUES (
  524, 38, 'SUBSET', 'TheOutputConcept', 'TheInputConcept', NULL, NULL); 
-- output is subset of input

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (39, 'RowSelectionByQuery', 'YES', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  525,   39,    1,      1,    'TheInputConcept',    'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  526,   39,    1,      1,   'TheLeftCondition',    'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  527,   39,    1,      1,'TheConditionOperator',   'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  528,   39,    1,      1,   'TheRightCondition',   'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  529,   39,    1,      1,    'TheOutputConcept',  'OUT', 'CON', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  530, 39, 'SAME_FEAT', 'TheOutputConcept', 'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  531, 39,        'IN', 'TheLeftCondition', 'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  532, 39, 'IS_LOOPED', 'TheLeftCondition',              NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  533, 39, 'IS_LOOPED', 'TheConditionOperator',          NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  534, 39, 'IS_LOOPED', 'TheRightCondition',             NULL,  NULL, NULL);

-- no conditions

INSERT INTO OP_ASSERT_T VALUES (
  535, 39, 'SUBSET', 'TheOutputConcept', 'TheInputConcept', NULL, NULL); 
-- output is subset of input

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (40, 'SegmentationStratified', 'NO', 'YES','YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  536,   40,    1,      1,     'TheInputConcept',   'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  537,   40,    1,      1,        'TheAttribute',   'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  538,   40,    1,      1,    'TheOutputConcept',  'OUT', 'CON', NULL);

-- 'TheAttribute' is missing in the OutputConcept:
-- INSERT INTO OP_CONSTR_T VALUES (
--   539, 40, 'SAME_FEAT', 'TheOutputConcept',  'TheInputConcept',  NULL, NULL);

INSERT INTO OP_CONSTR_T VALUES (
  540, 40,        'IN',     'TheAttribute',  'TheInputConcept',  NULL, NULL);

-- no conditions

INSERT INTO OP_ASSERT_T VALUES (
  541, 40, 'PROJ', 'TheOutputConcept', 'TheInputConcept', NULL, NULL); 
-- output is proj of input

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (42, 'SegmentationByPartitioning', 'NO', 'YES','YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  542,   42,    1,      1,     'TheInputConcept',   'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  543,   42,    1,      1,   'HowManyPartitions',   'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  544,   42,    1,      1,    'TheOutputConcept',  'OUT', 'CON', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  545, 42, 'SAME_FEAT',  'TheOutputConcept',  'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  546, 42,        'GE', 'HowManyPartitions',                  1,  NULL, NULL);

-- no conditions

INSERT INTO OP_ASSERT_T VALUES (
  547, 42, 'SUBSET', 'TheOutputConcept', 'TheInputConcept', NULL, NULL);

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (43, 'FeatureSelectionByAttributes', 'NO', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  548, 43, 1,    1,       'TheInputConcept',     'IN',  'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  549, 43, 1,    1,       'TheOutputConcept',    'OUT', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  550, 43, 1, NULL,       'TheSelectedFeatures', 'OUT', 'FEA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  551, 43, 'IN',         'TheOutputConcept',    'TheInputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  552, 43, 'IN',         'TheSelectedFeatures', 'TheInputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  553, 43, 'IN',         'TheSelectedFeatures', 'TheOutputConcept', NULL, NULL);

-- Add constraint:
-- OutputConcept is conceptually (set of features) a subset of InputConcept 

-- no conditions

INSERT INTO OP_ASSERT_T VALUES (
  554, 43, 'PROJ', 'TheOutputConcept', 'TheInputConcept', NULL, NULL); 
-- output is proj of input

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (44, 'LinearScaling', 'YES', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  555, 44, 1,    1,          'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  556, 44, 1,    1,       'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  557, 44, 1,    1,              'NewRangeMin',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  558, 44, 1,    1,              'NewRangeMax',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  559, 44, 1,    1,       'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  560, 44, 'IS_LOOPED',   'TheTargetAttribute',             NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  561, 44, 'IS_LOOPED',   'NewRangeMin',                    NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  562, 44, 'IS_LOOPED',   'NewRangeMax',                    NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  563, 44, 'IS_LOOPED',   'TheOutputAttribute',             NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  564, 44,        'IN',   'TheTargetAttribute',  'TheInputConcept',     NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  565, 44,        'IN',   'TheOutputAttribute',  'TheInputConcept',     NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  566, 44, 'SAME_TYPE',   'TheTargetAttribute',  'TheOutputAttribute',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  567, 44,      'TYPE',   'NewRangeMin',         'NUMERIC',             NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  568, 44,      'TYPE',   'NewRangeMax',         'NUMERIC',             NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  569, 44,        'GT',   'NewRangeMax',         'NewRangeMin',         NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  570, 44, 'NOT_NULL', 'TheTargetAttribute', NULL, NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  571, 44, 'NOT_NULL', 'TheOutputAttribute',          NULL, NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  572, 44, 'GE',       'TheOutputAttribute', 'NewRangeMin', NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  573, 44, 'LE',       'TheOutputAttribute', 'NewRangeMax', NULL, NULL);


-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (45, 'LogScaling', 'YES', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  574, 45, 1,    1,          'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  575, 45, 1,    1,       'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  576, 45, 1,    1,                  'LogBase',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  577, 45, 1,    1,       'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  578, 45, 'IS_LOOPED',   'TheTargetAttribute',             NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  579, 45, 'IS_LOOPED',   'LogBase',                        NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  580, 45, 'IS_LOOPED',   'TheOutputAttribute',             NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  581, 45,        'IN',   'TheTargetAttribute',  'TheInputConcept',     NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  582, 45,        'IN',   'TheOutputAttribute',  'TheInputConcept',     NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  583, 45, 'SAME_TYPE',   'TheTargetAttribute',  'TheOutputAttribute',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  584, 45,      'TYPE',   'LogBase',             'NUMERIC',             NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  585, 45,        'GT',   'LogBase',             0,                     NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  586, 45, 'NOT_NULL', 'TheTargetAttribute', NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  587, 45, 'LOWERBOUND',       'TheTargetAttribute', 0,    NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  588, 45, 'NOT_NULL', 'TheOutputAttribute', NULL, NULL, NULL);

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (46, 'AssignDefault', 'YES', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  589, 46, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  590, 46, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  591, 46, 1,   1,        'DefaultValue',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  592, 46, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  593, 46,        'IN',   'TheTargetAttribute',     'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  594, 46,        'IN',   'TheOutputAttribute',     'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  595, 46, 'IS_LOOPED',   'TheTargetAttribute',             NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  596, 46, 'IS_LOOPED',   'DefaultValue',                   NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  597, 46, 'IS_LOOPED',   'TheOutputAttribute',             NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  598, 46, 'SAME_TYPE',   'TheOutputAttribute',  'TheTargetAttribute',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  599, 46, 'TYPE',              'DefaultValue',             'NOMINAL',  NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  600, 46, 'HAS_NULLS', 'TheTargetAttribute', NULL, NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  601, 46, 'NOT_NULL', 'TheOutputAttribute', NULL, NULL, NULL);

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (47, 'AssignModalValue', 'YES', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  602, 47, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  603, 47, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  604, 47, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  605, 47, 'IS_LOOPED',   'TheTargetAttribute',             NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  606, 47, 'IS_LOOPED',   'TheOutputAttribute',             NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  607, 47,        'IN',   'TheTargetAttribute',  'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  608, 47,        'IN',   'TheOutputAttribute',  'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  609, 47, 'SAME_TYPE',   'TheTargetAttribute',  'TheOutputAttribute', NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  610, 47, 'HAS_NULLS', 'TheTargetAttribute', NULL, NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  611, 47, 'NOT_NULL', 'TheOutputAttribute', NULL, NULL, NULL);

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (48, 'AssignMedianValue', 'YES', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  612, 48, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  613, 48, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  614, 48, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  615, 48, 'IS_LOOPED',   'TheTargetAttribute',             NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  616, 48, 'IS_LOOPED',   'TheOutputAttribute',             NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  617, 48,        'IN',   'TheTargetAttribute',  'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  618, 48,        'IN',   'TheOutputAttribute',  'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  619, 48, 'SAME_TYPE',   'TheTargetAttribute',  'TheOutputAttribute', NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  620, 48, 'HAS_NULLS', 'TheTargetAttribute', NULL, NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  621, 48, 'NOT_NULL', 'TheOutputAttribute', NULL, NULL, NULL);

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (49, 'AssignAverageValue', 'YES', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  622, 49, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  623, 49, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  624, 49, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  625, 49, 'IS_LOOPED',   'TheTargetAttribute',             NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  626, 49, 'IS_LOOPED',   'TheOutputAttribute',             NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  627, 49,        'IN',   'TheTargetAttribute',  'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  628, 49,        'IN',   'TheOutputAttribute',  'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  629, 49, 'SAME_TYPE',   'TheTargetAttribute',  'TheOutputAttribute', NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  630, 49, 'HAS_NULLS', 'TheTargetAttribute', NULL, NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  631, 49, 'NOT_NULL', 'TheOutputAttribute', NULL, NULL, NULL);

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (50, 'AssignStochasticValue',  'YES', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  632, 50, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  633, 50, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  634, 50, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  635, 50, 'IS_LOOPED',   'TheTargetAttribute',             NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  636, 50, 'IS_LOOPED',   'TheOutputAttribute',             NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  637, 50,        'IN',   'TheTargetAttribute',     'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  638, 50,        'IN',   'TheOutputAttribute',     'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  639, 50, 'SAME_TYPE',   'TheTargetAttribute',  'TheOutputAttribute',  NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  640, 50, 'HAS_NULLS', 'TheTargetAttribute', NULL, NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  641, 50, 'NOT_NULL', 'TheOutputAttribute', NULL, NULL, NULL);

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (53, 'MissingValuesWithRegressionSVM', 'YES', 'NO', 'NO', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  642, 53, 1,    1,          'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  643, 53, 1,    1,       'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  644, 53, 1, NULL,  'ThePredictingAttributes',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  645, 53, 1,    1,               'KernelType',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  646, 53, 0,    1,               'SampleSize',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  647, 53, 1,    1,          'LossFunctionPos',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  648, 53, 1,    1,          'LossFunctionNeg',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  649, 53, 1,    1,                        'C',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  650, 53, 1,    1,                  'Epsilon',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  651, 53, 1,    1,       'TheOutputAttribute', 'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  652, 53, 0,    1,                'UseDB_SVM',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  653, 53, 0,    1,                   'TheKey',  'IN',  'BA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  654, 53, 'IS_LOOPED', 'TheTargetAttribute',      NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  655, 53, 'IS_LOOPED', 'ThePredictingAttributes', NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  656, 53, 'IS_LOOPED',        'KernelType',       NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  657, 53, 'IS_LOOPED',        'SampleSize',       NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  658, 53, 'IS_LOOPED',   'LossFunctionPos',       NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  659, 53, 'IS_LOOPED',   'LossFunctionNeg',       NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  660, 53, 'IS_LOOPED',                 'C',       NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  661, 53, 'IS_LOOPED',           'Epsilon',       NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  662, 53, 'IS_LOOPED','TheOutputAttribute',       NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  663, 53, 'IS_LOOPED',         'UseDB_SVM',       NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  664, 53, 'IS_LOOPED',            'TheKey',       NULL, NULL, NULL);

INSERT INTO OP_CONSTR_T VALUES (
  665, 53,        'IN',       'TheTargetAttribute', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  666, 53,        'IN',  'ThePredictingAttributes', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  667, 53,        'IN',       'TheOutputAttribute', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  668, 53, 'SAME_TYPE',       'TheTargetAttribute', 'TheOutputAttribute', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  669, 53,      'TYPE',  'ThePredictingAttributes',  'SCALAR',            NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  670, 53,      'TYPE',               'SampleSize',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  671, 53,      'TYPE',          'LossFunctionPos',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  672, 53,      'TYPE',          'LossFunctionNeg',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  673, 53,      'TYPE',                        'C',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  674, 53,      'TYPE',                  'Epsilon',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  675, 53,        'GE',               'SampleSize',          0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  676, 53,        'GE',          'LossFunctionPos',          0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  677, 53,        'GE',          'LossFunctionNeg',          0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  678, 53,        'GE',                        'C',          0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  679, 53,        'GE',                  'Epsilon',          0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  680, 53,    'ONE_OF',               'KernelType',
    'dot polynomial neural radial anova', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  681, 53,        'IN',                   'TheKey', 'TheInputConcept',    NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  682, 53, 'HAS_NULLS',     'TheTargetAttribute',      NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  683, 53, 'HAS_VALUES', 'TheTargetAttribute',      NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  684, 53, 'NOT_NULL',      'ThePredictingAttributes', NULL, NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  685, 53, 'NOT_NULL', 'TheOutputAttribute',      NULL, NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  686, 53, 'NOT_NULL', 'ThePredictingAttributes', NULL, NULL, NULL);

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (63, 'SupportVectorMachineForRegression', 'YES', 'NO', 'NO', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  687, 63, 1,    1,          'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  688, 63, 1,    1,       'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  689, 63, 1, NULL,  'ThePredictingAttributes',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  690, 63, 1,    1,               'KernelType',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  691, 63, 0,    1,               'SampleSize',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  692, 63, 1,    1,          'LossFunctionPos',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  693, 63, 1,    1,          'LossFunctionNeg',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  694, 63, 1,    1,                        'C',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  695, 63, 1,    1,                  'Epsilon',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  696, 63, 1,    1,       'TheOutputAttribute', 'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  697, 63, 0,    1,                'UseDB_SVM',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  698, 63, 0,    1,                   'TheKey',  'IN',  'BA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  699, 63, 'IS_LOOPED', 'TheTargetAttribute', NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  700, 63, 'IS_LOOPED', 'ThePredictingAttributes', NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  701, 63, 'IS_LOOPED',        'KernelType',  NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  702, 63, 'IS_LOOPED',        'SampleSize',  NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  703, 63, 'IS_LOOPED',   'LossFunctionPos',  NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  704, 63, 'IS_LOOPED',   'LossFunctionNeg',  NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  705, 63, 'IS_LOOPED',                 'C',  NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  706, 63, 'IS_LOOPED',           'Epsilon',  NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  707, 63, 'IS_LOOPED','TheOutputAttribute',  NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  708, 63, 'IS_LOOPED',         'UseDB_SVM',  NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  709, 63, 'IS_LOOPED',            'TheKey',  NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  710, 63,        'IN',       'TheTargetAttribute', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  711, 63,        'IN',  'ThePredictingAttributes', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  712, 63,        'IN',       'TheOutputAttribute', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  713, 63, 'SAME_TYPE',       'TheTargetAttribute', 'TheOutputAttribute', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  714, 63,      'TYPE',  'ThePredictingAttributes',  'SCALAR',            NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  715, 63,      'TYPE',               'SampleSize',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  716, 63,      'TYPE',          'LossFunctionPos',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  717, 63,      'TYPE',          'LossFunctionNeg',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  718, 63,      'TYPE',                        'C',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  719, 63,      'TYPE',                  'Epsilon',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  720, 63,        'GE',               'SampleSize',          0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  721, 63,        'GE',          'LossFunctionPos',          0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  722, 63,        'GE',          'LossFunctionNeg',          0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  723, 63,        'GE',                        'C',          0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  724, 63,        'GE',                  'Epsilon',          0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  725, 63,    'ONE_OF',               'KernelType',
    'dot polynomial neural radial anova', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  726, 63,        'IN',                   'TheKey', 'TheInputConcept',    NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  727, 63, 'HAS_NULLS',          'TheTargetAttribute', NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  728, 63, 'HAS_VALUES',         'TheTargetAttribute', NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  729, 63, 'NOT_NULL',      'ThePredictingAttributes', NULL, NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  730, 63, 'NOT_NULL', 'TheOutputAttribute',      NULL, NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  731, 63, 'NOT_NULL', 'ThePredictingAttributes', NULL, NULL, NULL);

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (67, 'Windowing', 'NO', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  732,   67,    1,    1,     'TheInputConcept',   'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  733,   67,    1,    1,      'TimeBaseAttrib',   'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  734,   67,    1,    1,     'ValueBaseAttrib',   'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  735,   67,    1,    1,          'WindowSize',   'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  736,   67,    1,    1,            'Distance',   'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  737,   67,    1,    1,   'OutputTimeStartBA',  'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  738,   67,    1,    1,     'OutputTimeEndBA',  'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  739,   67,    1, NULL,    'WindowedValuesBA',  'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  740,   67,    1,    1,    'TheOutputConcept',  'OUT', 'CON', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  741, 67,        'IN',   'TimeBaseAttrib',    'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  742, 67,        'IN',   'ValueBaseAttrib',   'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  743, 67,        'IN',   'OutputTimeStartBA', 'TheOutputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  744, 67,        'IN',   'OutputTimeEndBA',   'TheOutputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  745, 67,        'IN',   'WindowedValuesBA',  'TheOutputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  746, 67,      'TYPE',   'TimeBaseAttrib',                'TIME', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  747, 67, 'SAME_TYPE',   'OutputTimeStartBA',   'TimeBaseAttrib', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  748, 67, 'SAME_TYPE',   'OutputTimeEndBA',     'TimeBaseAttrib', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  749, 67, 'SAME_TYPE',   'ValueBaseAttrib',   'WindowedValuesBA', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  750, 67,      'TYPE',   'WindowSize',                 'NUMERIC', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  751, 67,      'TYPE',   'Distance',                   'NUMERIC', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  752, 67,        'GE',   'WindowSize',                        1,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  753, 67,        'GE',   'Distance',                          1,  NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  754, 67, 'NOT_NULL', 'TimeBaseAttrib',  NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  755, 67, 'UNIQUE',   'TimeBaseAttrib',  NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  756, 67, 'ORDERED',  'TimeBaseAttrib', 'INC', NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  757, 67, 'REL_N_1', 'TheOutputConcept',    'TheInputConcept',   NULL, NULL);
-- an n:1 relationship from output to input will model the foreign key relationship that holds
INSERT INTO OP_ASSERT_T VALUES (
  758, 67, 'REL_N_K', 'OutputTimeStartBA', NULL, NULL, NULL);
-- the key on the "many-side" is given by the start time index in the output
INSERT INTO OP_ASSERT_T VALUES (
  759, 67, 'REL_1_K',  'TimeBaseAttrib', NULL, NULL, NULL);
-- the key on the "one-side" is given by the time attribute in the input
INSERT INTO OP_ASSERT_T VALUES (
  760, 67, 'NOT_NULL', 'OutputTimeStartBA',  NULL,             NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  761, 67, 'UNIQUE',   'OutputTimeStartBA',  NULL,             NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  762, 67, 'ORDERED',  'OutputTimeStartBA',  'INC',            NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  763, 67, 'NOT_NULL', 'OutputTimeEndBA',    NULL,             NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  764, 67, 'UNIQUE',   'OutputTimeEndBA',    NULL,             NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  765, 67, 'ORDERED',  'OutputTimeEndBA',    'INC',            NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  766, 67, 'LT',       'OutputTimeStartBA', 'OutputTimeEndBA', NULL, NULL);

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (68, 'SignalToSymbolProcessing', 'NO', 'NO', 'NO', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  767,   68,    1,    1,     'TheInputConcept',   'IN',  'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  768,   68,    1,    1,         'InputTimeBA',   'IN',   'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  769,   68,    1,    1,        'InputValueBA',   'IN',   'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  770,   68,    1,    1,           'Tolerance',   'IN',    'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  771,   68,    1,    1,      'AverageValueBA',   'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  772,   68,    1,    1,     'IncreaseValueBA',   'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  773,   68,    1,    1,   'OutputTimeStartBA',   'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  774,   68,    1,    1,     'OutputTimeEndBA',   'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  775,   68,    1,    1,    'TheOutputConcept',   'OUT', 'CON', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  776, 68,        'IN',   'InputTimeBA',       'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  777, 68,        'IN',   'InputValueBA',      'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  778, 68,        'IN',   'AverageValueBA',    'TheOutputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  779, 68,        'IN',   'IncreaseValueBA',   'TheOutputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  780, 68,        'IN',   'OutputTimeStartBA', 'TheOutputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  781, 68,        'IN',   'OutputTimeEndBA',   'TheOutputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  782, 68,      'TYPE',   'InputTimeBA',                  'TIME',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  783, 68,      'TYPE',   'InputValueBA',               'SCALAR',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  784, 68, 'SAME_TYPE',   'OutputTimeStartBA',     'InputTimeBA',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  785, 68, 'SAME_TYPE',   'OutputTimeEndBA',       'InputTimeBA',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  786, 68, 'SAME_TYPE',   'AverageValueBA',       'InputValueBA',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  787, 68, 'SAME_TYPE',   'IncreaseValueBA',      'InputValueBA',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  788, 68,      'TYPE',   'Tolerance',                  'NUMERIC', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  789, 68,        'GE',   'Tolerance',                          1, NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  790, 68, 'NOT_NULL', 'InputTimeBA',  NULL,  NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  791, 68, 'UNIQUE',   'InputTimeBA',  NULL,  NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  792, 68, 'ORDERED',  'InputTimeBA',  'INC', NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  793, 68, 'NOT_NULL', 'InputValueBA', 'INC', NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  794, 68, 'NOT_NULL', 'OutputTimeStartBA', NULL,              NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  795, 68, 'UNIQUE',   'OutputTimeStartBA', NULL,              NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  796, 68, 'ORDERED',  'OutputTimeStartBA', 'INC',             NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  797, 68, 'NOT_NULL', 'OutputTimeEndBA',   NULL,              NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  798, 68, 'UNIQUE',   'OutputTimeEndBA',   NULL,              NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  799, 68, 'ORDERED',  'OutputTimeEndBA',   'INC',             NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  800, 68, 'LT',       'OutputTimeStartBA', 'OutputTimeEndBA', NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  801, 68, 'NOT_NULL', 'AverageValueBA',    NULL,              NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  802, 68, 'NOT_NULL', 'IncreaseValueBA',   NULL,              NULL, NULL);

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (70, 'SimpleMovingFunction', 'NO', 'NO', 'NO', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  803,   70,    1,    1,     'TheInputConcept',   'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  804,   70,    1,    1,         'InputTimeBA',   'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  805,   70,    1,    1,        'InputValueBA',   'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  806,   70,    1,    1,          'WindowSize',   'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  807,   70,    1,    1,            'Distance',   'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  808,   70,    1,    1,   'OutputTimeStartBA',  'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  809,   70,    1,    1,     'OutputTimeEndBA',  'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  810,   70,    1,    1,       'OutputValueBA',  'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  811,   70,    1,    1,    'TheOutputConcept',  'OUT', 'CON', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  812, 70,        'IN',   'InputTimeBA',       'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  813, 70,        'IN',   'InputValueBA',      'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  814, 70,        'IN',   'OutputTimeStartBA', 'TheOutputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  815, 70,        'IN',   'OutputTimeEndBA',   'TheOutputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  816, 70,        'IN',   'OutputValueBA',     'TheOutputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  817, 70,      'TYPE',   'InputTimeBA',                   'TIME', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  818, 70,      'TYPE',   'InputValueBA',                'SCALAR', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  819, 70, 'SAME_TYPE',   'OutputTimeStartBA',      'InputTimeBA', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  820, 70, 'SAME_TYPE',   'OutputTimeEndBA',        'InputTimeBA', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  821, 70, 'SAME_TYPE',   'InputValueBA',         'OutputValueBA', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  822, 70,      'TYPE',   'WindowSize',                 'NUMERIC', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  823, 70,      'TYPE',   'Distance',                   'NUMERIC', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  824, 70,        'GE',   'WindowSize',                        1,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  825, 70,        'GE',   'Distance',                          1,  NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  826, 70, 'NOT_NULL', 'InputTimeBA',  NULL,  NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  827, 70, 'UNIQUE',   'InputTimeBA',  NULL,  NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  828, 70, 'ORDERED',  'InputTimeBA',  'INC', NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  829, 70, 'NOT_NULL', 'InputValueBA', 'INC', NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  830, 70, 'NOT_NULL', 'OutputTimeStartBA', NULL,              NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  831, 70, 'UNIQUE',   'OutputTimeStartBA', NULL,              NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  832, 70, 'ORDERED',  'OutputTimeStartBA', 'INC',             NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  833, 70, 'NOT_NULL', 'OutputTimeEndBA',   NULL,              NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  834, 70, 'UNIQUE',   'OutputTimeEndBA',   NULL,              NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  835, 70, 'ORDERED',  'OutputTimeEndBA',   'INC',             NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  836, 70, 'LT',       'OutputTimeStartBA', 'OutputTimeEndBA', NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  837, 70, 'NOT_NULL', 'OutputValueBA',     NULL,              NULL, NULL);

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (71, 'WeightedMovingFunction', 'NO', 'NO', 'NO', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  838,   71,    1,    1,     'TheInputConcept',   'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  839,   71,    1,    1,         'InputTimeBA',   'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  840,   71,    1,    1,        'InputValueBA',   'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  841,   71,    1, NULL,             'Weights',   'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  842,   71,    1,    1,            'Distance',   'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  843,   71,    1,    1,   'OutputTimeStartBA',  'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  844,   71,    1,    1,     'OutputTimeEndBA',  'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  845,   71,    1,    1,       'OutputValueBA',  'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  846,   71,    1,    1,    'TheOutputConcept',  'OUT', 'CON', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  847, 71,        'IN',   'InputTimeBA',       'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  848, 71,        'IN',   'InputValueBA',      'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  849, 71,        'IN',   'OutputTimeStartBA', 'TheOutputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  850, 71,        'IN',   'OutputTimeEndBA',   'TheOutputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  851, 71,        'IN',   'OutputValueBA',     'TheOutputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  852, 71,      'TYPE',   'InputTimeBA',                   'TIME', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  853, 71,      'TYPE',   'InputValueBA',                'SCALAR', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  854, 71, 'SAME_TYPE',   'OutputTimeStartBA',     'InputTimeBA',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  855, 71, 'SAME_TYPE',   'OutputTimeEndBA',       'InputTimeBA',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  856, 71, 'SAME_TYPE',   'InputValueBA',         'OutputValueBA', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  857, 71,      'TYPE',   'Weights',                   'NUMERIC',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  858, 71,      'TYPE',   'Distance',                  'NUMERIC',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  859, 71,       'SUM',   'Weights',                           1,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  860, 71,        'GE',   'Distance',                          1,  NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  861, 71, 'NOT_NULL', 'InputTimeBA',  NULL,  NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  862, 71, 'UNIQUE',   'InputTimeBA',  NULL,  NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  863, 71, 'ORDERED',  'InputTimeBA',  'INC', NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  864, 71, 'NOT_NULL', 'InputValueBA', 'INC', NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  865, 71, 'NOT_NULL', 'OutputTimeStartBA', NULL,              NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  866, 71, 'UNIQUE',   'OutputTimeStartBA', NULL,              NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  867, 71, 'ORDERED',  'OutputTimeStartBA', 'INC',             NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  868, 71, 'NOT_NULL', 'OutputTimeEndBA',   NULL,              NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  869, 71, 'UNIQUE',   'OutputTimeEndBA',   NULL,              NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  870, 71, 'ORDERED',  'OutputTimeEndBA',   'INC',             NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  871, 71, 'LT',       'OutputTimeStartBA', 'OutputTimeEndBA', NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  872, 71, 'NOT_NULL', 'OutputValueBA',     NULL,              NULL, NULL);

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (72, 'ExponentialMovingFunction', 'NO', 'NO', 'NO', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  873,   72,    1,    1,     'TheInputConcept',   'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  874,   72,    1,    1,         'InputTimeBA',   'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  875,   72,    1,    1,        'InputValueBA',   'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  876,   72,    1,    1,          'HeadWeight',   'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  877,   72,    1,    1,          'TailWeight',   'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  878,   72,    1,    1,            'Distance',   'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  879,   72,    1,    1,        'OutputTimeBA',  'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  880,   72,    1,    1,       'OutputValueBA',  'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  881,   72,    1,    1,    'TheOutputConcept',  'OUT', 'CON', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  882, 72,        'IN',   'InputTimeBA',       'TheInputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  883, 72,        'IN',   'InputValueBA',      'TheInputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  884, 72,        'IN',   'OutputTimeBA',     'TheOutputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  885, 72,        'IN',   'OutputValueBA',    'TheOutputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  886, 72,      'TYPE',   'InputTimeBA',                  'TIME', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  887, 72,      'TYPE',   'InputValueBA',               'SCALAR', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  888, 72, 'SAME_TYPE',   'OutputTimeBA',          'InputTimeBA', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  889, 72, 'SAME_TYPE',   'InputValueBA',        'OutputValueBA', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  890, 72,      'TYPE',   'HeadWeight',                'NUMERIC', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  891, 72,      'TYPE',   'TailWeight',                'NUMERIC', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  892, 72,      'TYPE',   'Distance',                  'NUMERIC', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  893, 72,       'SUM',   'HeadWeight,TailWeight',             1, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  894, 72,        'GE',   'Distance',                          1, NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  895, 72, 'NOT_NULL', 'InputTimeBA',  NULL,  NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  896, 72, 'UNIQUE',   'InputTimeBA',  NULL,  NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  897, 72, 'ORDERED',  'InputTimeBA',  'INC', NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  898, 72, 'NOT_NULL', 'InputValueBA', 'INC', NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  899, 72, 'NOT_NULL', 'OutputTimeBA',  NULL,  NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  900, 72, 'UNIQUE',   'OutputTimeBA',  NULL,  NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  901, 72, 'ORDERED',  'OutputTimeBA',  'INC', NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  902, 72, 'NOT_NULL', 'OutputValueBA', NULL,  NULL, NULL);

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (73, 'ComputeSVMError', 'NO', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  903, 73, 1,    1,          'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  904, 73, 1,    1,       'TheTargetValueAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  905, 73, 1,    1,   'ThePredictedValueAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  906, 73, 0,    1,          'LossFunctionPos',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  907, 73, 0,    1,          'LossFunctionNeg',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  908, 73, 1,    1,                        'C',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  909, 73, 1,    1,                  'Epsilon',  'IN',   'V', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  910, 73,        'IN',      'TheTargetValueAttribute', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  911, 73,        'IN',   'ThePredictedValueAttribute', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  912, 73,       'TYPE',     'TheTargetValueAttribute',  'SCALAR',            NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  913, 73,       'TYPE',  'ThePredictedValueAttribute',  'SCALAR',            NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  914, 73,       'TYPE',         'LossFunctionPos',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  915, 73,       'TYPE',         'LossFunctionNeg',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  916, 73,       'TYPE',                       'C',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  917, 73,       'TYPE',                 'Epsilon',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  918, 73,         'GE',         'LossFunctionPos',          0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  919, 73,         'GE',         'LossFunctionNeg',          0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  920, 73,         'GE',                       'C',          0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  921, 73,         'GE',                 'Epsilon',          0,           NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  922, 73, 'NOT_NULL',      'ThePredictedValueAttribute', NULL, NULL, NULL);

-- no assertions
-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (74, 'Unsegment', 'NO', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  923,   74,    1,      1,    'TheInputConcept',    'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  924,   74,    1,      1,    'UnsegmentAttribute', 'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  925,   74,    1,      1,    'TheOutputConcept',   'OUT', 'CON', NULL);

-- constraint: 'UnsegmentAttribute' in 'TheOutputConcept' or pseudo-BA,
--       In one of the preceding steps: Segment by 'UnsegmentAttribute'
-- no conditions

INSERT INTO OP_ASSERT_T VALUES (
  926,  74, 'SUBSET', 'TheInputConcept', 'TheOutputConcept', NULL, NULL); 
-- input is subset of output

-------------------------------------------------------

INSERT INTO OPERATOR_T VALUES (76, 'JoinByKey', 'NO', 'NO', 'YES', NULL);

-- (the operator is not applied in loops but 
--  uses the loop mechanism for parameter specification)

INSERT INTO OP_PARAMS_T VALUES (
  927,   76,    2,   NULL,    'TheConcepts',        'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  928,   76,    2,   NULL,    'TheKeys',            'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  929,   76,    1,      1,    'TheOutputConcept',  'OUT', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  930,   76,    0,   NULL,    'MapInput',              'IN', 'FEA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  931,   76,    0,   NULL,    'MapOutput',            'OUT', 'FEA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  932, 76,   'IN',        'TheKeys',   'TheConcepts',      NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  933, 76,   'IN',        'MapInput',  'TheConcepts',      NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  934, 76, 'COORD', 'MapInput',  'MapOutput',	 NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  935, 76, 'COORD', 'TheKeys', 'TheConcepts',	 NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  936, 76,   'IN',        'MapOutput', 'TheOutputConcept', NULL, NULL);


-- no conditions
INSERT INTO OP_ASSERT_T VALUES (
  937, 76, 'PROJ',     'TheConcepts', 'TheOutputConcept', NULL, NULL); 
-- theConcepts are projs of output

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (77, 'SpecifiedStatistics', 'NO', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  938,   77,    1,   1,    'TheInputConcept',          'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  939,   77,    0,   NULL, 'GroupBy',                  'IN', 'BA',  NULL);
INSERT INTO OP_PARAMS_T VALUES (
  940,   77,    0,   NULL, 'AttributesComputeSum',     'IN', 'BA',  NULL);
INSERT INTO OP_PARAMS_T VALUES (
  941,   77,    0,   NULL, 'AttributesComputeCount',   'IN', 'BA',  NULL);
INSERT INTO OP_PARAMS_T VALUES (
  942,   77,    0,   NULL, 'AttributesComputeUnique',  'IN', 'BA',  NULL);
INSERT INTO OP_PARAMS_T VALUES (
  943,   77,    0,   NULL, 'AttributesComputeMin',     'IN', 'BA',  NULL);
INSERT INTO OP_PARAMS_T VALUES (
  944,   77,    0,   NULL, 'AttributesComputeMax',     'IN', 'BA',  NULL);
INSERT INTO OP_PARAMS_T VALUES (
  945,   77,    0,   NULL, 'AttributesComputeAvg',     'IN', 'BA',  NULL);
INSERT INTO OP_PARAMS_T VALUES (
  946,   77,    0,   NULL, 'AttributesComputeDistrib', 'IN', 'BA',  NULL);
INSERT INTO OP_PARAMS_T VALUES (
  947,   77,    0,   NULL, 'DistribValues',            'IN', 'V',   NULL);
INSERT INTO OP_PARAMS_T VALUES (
  948,   77,    1,      1, 'TheOutputConcept',        'OUT', 'CON', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  949,  77,  'IN',   'GroupBy',                  'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  950,  77,  'IN',   'AttributesComputeSum',     'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  951,  77,  'IN',   'AttributesComputeCount',   'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  952,  77,  'IN',   'AttributesComputeUnique',  'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  953,  77,  'IN',   'AttributesComputeDistrib', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  954,  77,  'IN',   'AttributesComputeMin',     'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  955,  77,  'IN',   'AttributesComputeMax',     'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  956,  77,  'IN',   'AttributesComputeAvg',     'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  957,  77, 'COORD', 'AttributesComputeDistrib', 'DistribValues',      NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  958,  77,  'TYPE', 'AttributesComputeSum',     'NUMERIC',            NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  959,  77,  'TYPE', 'AttributesComputeAvg',     'NUMERIC',            NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  960,  77,  'TYPE', 'AttributesComputeMin',     'ORDINAL',            NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  961,  77,  'TYPE', 'AttributesComputeMax',     'ORDINAL',            NULL, NULL);

-- no conditions

INSERT INTO OP_ASSERT_T VALUES (
  962, 77, 'REL_N_1', 'TheInputConcept',    'TheOutputConcept',   NULL, NULL);
-- an n:1 relationship from input to output exists (if there are any group-by attributes)
INSERT INTO OP_ASSERT_T VALUES (
  963, 77, 'REL_N_K', 'GroupBy',            NULL, NULL, NULL);
-- the keys on the "many-side" are given by the GroupBy attributes
INSERT INTO OP_ASSERT_T VALUES (
  964, 77, 'REL_1_K', 'GroupBy',            NULL, NULL, NULL);
-- the keys on the "one-side" are given by the GroupBy attributes

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (84, 'Apriori', 'NO', 'NO', 'NO', NULL);

INSERT INTO OP_PARAMS_T VALUES (
965, 84, 1, 1, 'TheInputConcept',  'IN',  'CON', NULL );
INSERT INTO OP_PARAMS_T VALUES (
966, 84, 1, 1, 'TheOutputConcept', 'OUT', 'CON', NULL );
INSERT INTO OP_PARAMS_T VALUES (
967, 84, 1, 1, 'CustID',           'IN',  'BA',  NULL );
INSERT INTO OP_PARAMS_T VALUES (
968, 84, 1, 1, 'TransID',          'IN',  'BA',  NULL );
INSERT INTO OP_PARAMS_T VALUES (
969, 84, 1, 1, 'Item',             'IN',  'BA',  NULL );
INSERT INTO OP_PARAMS_T VALUES (
970, 84, 1, 1, 'MinSupport',       'IN',  'V',   NULL );
INSERT INTO OP_PARAMS_T VALUES (
971, 84, 1, 1, 'MinConfidence',    'IN',  'V',   NULL );
INSERT INTO OP_PARAMS_T VALUES (
972, 84, 1, 1, 'SampleSize',       'IN',  'V',   NULL );
INSERT INTO OP_PARAMS_T VALUES (
973, 84, 1, 1, 'PremiseBA',       'OUT', 'BA',   NULL );
INSERT INTO OP_PARAMS_T VALUES (
974, 84, 1, 1, 'ConclusionBA',    'OUT', 'BA',   NULL );

INSERT INTO OP_CONSTR_T VALUES (
  975, 84,        'IN',   'CustID',       'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  976, 84,        'IN',   'TransID',      'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  977, 84,        'IN',   'Item',         'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  978, 84,        'IN',   'PremiseBA',    'TheOutputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  979, 84,        'IN',   'ConclusionBA', 'TheOutputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  980, 84,        'TYPE', 'PremiseBA',    'NOMINAL',          NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  981, 84,        'TYPE', 'ConclusionBA', 'NOMINAL',          NULL, NULL );
INSERT INTO OP_CONSTR_T VALUES (
  982, 84, 'GE', 'MinSupport',    0, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  983, 84, 'GE', 'MinConfidence',    0, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  984, 84, 'LE', 'MinConfidence',    1, NULL, NULL);

-- further constraints still missing
-- conditions still missing
-- assertions still missing
-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (85, 'StatisticalFeatureSelection','NO','NO','NO',NULL);

-- Parameters

INSERT INTO OP_PARAMS_T VALUES (
  985, 85, 1,    1,          'TheInputConcept',  'IN',  'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  986, 85, 1,    NULL,       'TheAttributes',    'IN',   'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  987, 85, 1,    1,               'SampleSize',  'IN',    'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  988, 85, 1,    1,       'TheOutputConcept',   'OUT',  'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  989, 85, 1,    1,               'Threshold',   'IN',    'V', NULL);

-- Constraints

INSERT INTO OP_CONSTR_T VALUES (
  990, 85,      'IN',    'TheAttributes',  'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  991, 85,      'TYPE',  'TheAttributes',  'SCALAR',             NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  992, 85,      'TYPE',  'TheAttributes',  'CATEGORIAL',         NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  993, 85,      'TYPE',  'TheAttributes',  'ORDINAL',            NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  994, 85,      'TYPE',  'SampleSize',     'NUMERIC',            NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  995, 85,      'TYPE',  'Threshold',      'NUMERIC',            NULL, NULL);

INSERT INTO OP_CONSTR_T VALUES (
  996, 85, 'SAME_FEAT', 'TheOutputConcept', 'TheInputConcept',  NULL, NULL);

-- conditions still missing

INSERT INTO OP_ASSERT_T VALUES (
  997, 85, 'PROJ', 'TheOutputConcept', 'TheInputConcept', NULL, NULL); 
-- output is proj of input
-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (86, 'GeneticFeatureSelection','NO','NO','NO',NULL);

-- Parameters

INSERT INTO OP_PARAMS_T VALUES (
  998, 86, 1,    1,          'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  999, 86, 1,    NULL,       'TheAttributes',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1000, 86, 1,    1,       'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1001, 86, 1,    1,               'SampleSize',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1002, 86, 1,    1,       'TheOutputConcept', 'OUT',  'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1003, 86, 1,    1,               'PopDim',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1004, 86, 1,    1,               'StepNum',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1005, 86, 1,    1,               'ProbMut',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1006, 86, 1,    1,               'ProbCross',  'IN',   'V', NULL);

-- Constraints

INSERT INTO OP_CONSTR_T VALUES (
  1007, 86,        'IN',  'TheAttributes',       'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1008, 86,        'IN',  'TheTargetAttribute',  'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1009, 86,      'TYPE',  'TheTargetAttribute',  'CATEGORIAL',       NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1010, 86,      'TYPE',  'TheAttributes',       'SCALAR',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1011, 86,      'TYPE',  'TheAttributes',       'CATEGORIAL',       NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1012, 86,      'TYPE',  'TheAttributes',       'ORDINAL',          NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1013, 86,      'TYPE',  'SampleSize',          'NUMERIC',          NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1014, 86,      'TYPE',  'PopDim',              'NUMERIC',          NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1015, 86,      'TYPE',  'StepNum',             'NUMERIC',          NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1016, 86,      'TYPE',  'ProbMut',             'NUMERIC',          NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1017, 86,      'TYPE',  'ProbCross',           'NUMERIC',          NULL, NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1018, 86, 'SAME_FEAT', 'TheOutputConcept', 'TheInputConcept',  NULL, NULL);

-- conditions still missing

INSERT INTO OP_ASSERT_T VALUES (
  1019, 86, 'PROJ', 'TheOutputConcept', 'TheInputConcept', NULL, NULL); 
-- output is proj of input
-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (87, 'SGFeatureSelection','NO','NO','NO',NULL);

-- Parameters

INSERT INTO OP_PARAMS_T VALUES (
  1020, 87, 1,    1,       'TheInputConcept',  'IN',  'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1021, 87, 1,    NULL,    'TheAttributes',    'IN',   'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1022, 87, 1,    1,       'TheTargetAttribute', 'IN', 'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1023, 87, 1,    1,       'SampleSize',       'IN',   'V',  NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1024, 87, 1,    1,       'TheOutputConcept', 'OUT',  'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1025, 87, 1,    1,       'Threshold',        'IN',   'V',  NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1026, 87, 1,    1,       'PopDim',           'IN',   'V',  NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1027, 87, 1,    1,       'StepNum',          'IN',   'V',  NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1028, 87, 1,    1,       'ProbMut',          'IN',   'V',  NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1029, 87, 1,    1,       'ProbCross',        'IN',   'V',  NULL);

-- Constraints

INSERT INTO OP_CONSTR_T VALUES (
  1030, 87,        'IN',  'TheAttributes',       'TheInputConcept',   NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1031, 87,        'IN',  'TheTargetAttribute',  'TheInputConcept',   NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1032, 87,      'TYPE',  'TheTargetAttribute',  'CATEGORIAL',        NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1033, 87,      'TYPE',  'TheAttributes',       'SCALAR',            NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1034, 87,      'TYPE',  'TheAttributes',       'CATEGORIAL',        NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1035, 87,      'TYPE',  'TheAttributes',       'ORDINAL',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1036, 87,      'TYPE',  'SampleSize',          'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1037, 87,      'TYPE',  'PopDim',              'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1038, 87,      'TYPE',  'StepNum',             'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1039, 87,      'TYPE',  'ProbMut',             'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1040, 87,      'TYPE',  'ProbCross',           'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1041, 87,      'TYPE',  'Threshold',           'NUMERIC',           NULL, NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1042, 87, 'SAME_FEAT', 'TheOutputConcept', 'TheInputConcept',  NULL, NULL);

-- conditions still missing

INSERT INTO OP_ASSERT_T VALUES (
  1043, 87, 'PROJ', 'TheOutputConcept', 'TheInputConcept', NULL, NULL); 
-- output is proj of input
-------------------------------------------------------

INSERT INTO OPERATOR_T VALUES (88, 'FeatureSelectionWithSVM', 'NO', 'NO', 'NO', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1044, 88, 1,    1,          'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1045, 88, 1,    1,       'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1046, 88, 1, NULL,            'TheAttributes',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1047, 88, 1,    1,               'KernelType',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1048, 88, 1,    1,                        'C',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1049, 88, 1,    1,                  'Epsilon',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1050, 88, 1,    1,          'SearchDirection',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1051, 88, 1,    1,      'PositiveTargetValue',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1052, 88, 1,    1,                   'TheKey',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1053, 88, 1,    1,       'TheOutputConcept',   'OUT', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1054, 88, 0,    1,               'SampleSize',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1055, 88, 0,    1,                'UseDB_SVM',  'IN',   'V', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1056, 88,        'IN',       'TheTargetAttribute', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1057, 88,        'IN',            'TheAttributes', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1058, 88, 'SAME_TYPE',       'TheTargetAttribute', 'TheOutputAttribute', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1059, 88,      'TYPE',                        'C',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1060, 88,      'TYPE',                  'Epsilon',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1061, 88,      'TYPE',               'SampleSize',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1062, 88,        'GE',                        'C',          0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1063, 88,        'GE',                  'Epsilon',          0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1064, 88,        'GE',               'SampleSize',          0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1065, 88,    'ONE_OF',               'KernelType',   'dot polynomial neural radial anova', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1066, 88,    'ONE_OF',          'SearchDirection',   'backward forward', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1067, 88,    'ONE_OF',                'UseDB_SVM',      'true false',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1068, 88,        'IN',                   'TheKey', 'TheInputConcept',    NULL, NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1069, 88, 'SAME_FEAT', 'TheOutputConcept', 'TheInputConcept',  NULL, NULL);

-- no conditions

INSERT INTO OP_ASSERT_T VALUES (
  1070, 88, 'PROJ', 'TheOutputConcept', 'TheInputConcept', NULL, NULL);
-- output is proj of input
-------------------------------------------------------

INSERT INTO OPERATOR_T VALUES (89, 'SupportVectorMachineForClassification', 'YES', 'NO', 'NO', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1071, 89, 1,    1,          'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1072, 89, 1,    1,       'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1073, 89, 1, NULL,  'ThePredictingAttributes',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1074, 89, 1,    1,               'KernelType',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1075, 89, 0,    1,               'SampleSize',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1076, 89, 1,    1,                        'C',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1077, 89, 1,    1,                  'Epsilon',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1078, 89, 1,    1,       'TheOutputAttribute', 'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1079, 89, 1,    1,      'PositiveTargetValue',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1080, 89, 0,    1,                'UseDB_SVM',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1081, 89, 0,    1,                   'TheKey',  'IN',  'BA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1082, 89, 'IS_LOOPED',  'TheTargetAttribute',      NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1083, 89, 'IS_LOOPED',  'ThePredictingAttributes', NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1084, 89, 'IS_LOOPED',         'KernelType',       NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1085, 89, 'IS_LOOPED',         'SampleSize',       NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1086, 89, 'IS_LOOPED',                  'C',       NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1087, 89, 'IS_LOOPED',            'Epsilon',       NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1088, 89, 'IS_LOOPED', 'TheOutputAttribute',       NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1089, 89, 'IS_LOOPED', 'PositiveTargetValue',      NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1090, 89, 'IS_LOOPED',         'UseDB_SVM',        NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1091, 89, 'IS_LOOPED',            'TheKey',        NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1092, 89,        'IN',       'TheTargetAttribute', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1093, 89,        'IN',  'ThePredictingAttributes', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1094, 89,        'IN',       'TheOutputAttribute', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1095, 89, 'SAME_TYPE',       'TheTargetAttribute', 'TheOutputAttribute', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1096, 89,      'TYPE',  'ThePredictingAttributes',  'SCALAR',            NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1097, 89,      'TYPE',               'SampleSize',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1098, 89,      'TYPE',                        'C',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1099, 89,      'TYPE',                  'Epsilon',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1100, 89,        'GE',               'SampleSize',          0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1101, 89,        'GE',                        'C',          0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1102, 89,        'GE',                  'Epsilon',          0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1103, 89,    'ONE_OF',               'KernelType',
    'dot polynomial neural radial anova', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1104, 89,        'IN',                   'TheKey', 'TheInputConcept',    NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  1105, 89, 'HAS_NULLS',          'TheTargetAttribute', NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  1106, 89, 'HAS_VALUES',         'TheTargetAttribute', NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  1107, 89, 'NOT_NULL',      'ThePredictingAttributes', NULL, NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  1108, 89, 'NOT_NULL', 'TheOutputAttribute',      NULL, NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  1109, 89, 'NOT_NULL', 'ThePredictingAttributes', NULL, NULL, NULL);
-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (90, 'GenericFeatureConstruction', 'YES', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1110, 90, 1,    1,           'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1111, 90, 1,    1,        'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1112, 90, 1,    1,                'SQL_String',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1113, 90, 1,    1,        'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1114, 90,         'IN', 'TheTargetAttribute',  'TheInputConcept',     NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1115, 90,         'IN', 'TheOutputAttribute',  'TheInputConcept',     NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1116, 90,  'SAME_TYPE', 'TheOutputAttribute',  'TheTargetAttribute',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1117, 90, 'IS_LOOPED',  'TheTargetAttribute',  NULL,                  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1118, 90, 'IS_LOOPED',  'SQL_String',          NULL,                  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1119, 90, 'IS_LOOPED',  'TheOutputAttribute',  NULL,                  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1120, 90,      'TYPE',  'SQL_String',          'NOMINAL',             NULL, NULL);


-- no conditions
-- no assertions
-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (91, 'UnionByKey', 'NO', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1121,	91,	2,	NULL,	'TheConcepts',		'IN',	'CON',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1122,	91,	2,	NULL,	'TheKeys',		'IN',	'BA',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1123,	91,	0,	NULL,	'MapInput',		'IN',	'FEA',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1124,	91,	0,	NULL,	'MapOutput',		'OUT',	'FEA',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1125,	91,	1,	1,	'TheOutputConcept',	'OUT',	'CON',	NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1126, 91,   'IN',       'TheKeys',    'TheConcepts',      NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1127, 91,   'IN',       'MapInput',   'TheConcepts',      NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1128, 91,'COORD', 'MapInput',   'MapOutput',        NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1129, 91,'COORD', 'TheKeys',  'TheConcepts',        NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1130, 91,   'IN',       'MapOutput',  'TheOutputConcept', NULL, NULL);

-- no conditions

INSERT INTO OP_ASSERT_T VALUES (
  1131, 91, 'SUBSET', 'TheConcepts',     'TheOutputConcept', NULL, NULL); 
-- TheConcepts are subsets of output

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (92, 'TimeIntervalManualDiscretization', 'NO', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1132,	92,	1,	1,	'TheInputConcept',	'IN',	'CON',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1133,	92,	1,	1,	'TheTargetAttribute',	'IN',	'BA',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1134,	92,	1,	NULL,	'IntervalStart',	'IN',	'V',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1135,	92,	1,	NULL,	'IntervalEnd',		'IN',	'V',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1136,	92,	1,	NULL,	'MapTo',		'IN',	'V',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1137,	92,	1,	NULL,	'StartIncExc',		'IN',	'V',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1138,	92,	1,	NULL,	'EndIncExc',		'IN',	'V',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1139,	92,	1,	1,	'DefaultValue',		'IN',	'V',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1140,	92,	1,	1,	'TimeFormat',		'IN',	'V',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1141,	92,	1,	1,	'TheOutputAttribute',	'OUT',	'BA',	NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1142, 92,   'IN',     'TheTargetAttribute', 'TheInputConcept',      NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1143, 92,   'IN',     'TheOutputAttribute', 'TheInputConcept',      NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1144, 92,   'TYPE',   'TheTargetAttribute',  'TIME',                NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1145, 92,   'TYPE',	'IntervalStart',    'TIME',                NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1146, 92,   'TYPE',	'IntervalEnd',      'TIME',                NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1147, 92,   'TYPE',	'MapTo',            'NOMINAL',             NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1148, 92,   'TYPE',	'StartIncExc',      'CATEGORIAL',          NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1149, 92,   'TYPE',	'EndIncExc',        'CATEGORIAL',          NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1150, 92, 'COORD', 'IntervalStart',    'IntervalEnd',         NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1151, 92, 'COORD', 'IntervalEnd',      'StartIncExc',         NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1152, 92, 'COORD', 'StartIncExc',      'EndIncExc',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1153, 92, 'COORD', 'EndIncExc',        'MapTo',               NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1154, 92,   'TYPE',	'DefaultValue',     'NOMINAL',             NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1155, 92,   'TYPE',	'TimeFormat',       'NOMINAL',             NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1156, 92,   'TYPE',   'TheOutputAttribute',  'CATEGORIAL',          NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1157, 92,   'ONE_OF', 'StartIncExc',         'I E',                 NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1158, 92,   'ONE_OF', 'EndIncExc',           'I E',                 NULL, NULL);

-- conditions still missing
-- assertions still missing
-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (93, 'NumericalIntervalManualDiscretization', 'NO', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1159,	93,	1,	1,	'TheInputConcept',	'IN',	'CON',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1160,	93,	1,	1,	'TheTargetAttribute',	'IN',	'BA',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1161,	93,	1,	NULL,	'IntervalStart',	'IN',	'V',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1162,	93,	1,	NULL,	'IntervalEnd',		'IN',	'V',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1163,	93,	1,	NULL,	'MapTo',		'IN',	'V',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1164,	93,	1,	NULL,	'StartIncExc',		'IN',	'V',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1165,	93,	1,	NULL,	'EndIncExc',		'IN',	'V',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1166,	93,	1,	1,	'DefaultValue',		'IN',	'V',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1167,	93,	1,	1,	'TheOutputAttribute',	'OUT',	'BA',	NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1168, 93,   'IN',     'TheTargetAttribute', 'TheInputConcept',      NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1169, 93,   'IN',     'TheOutputAttribute', 'TheInputConcept',      NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1170, 93,   'ONE_OF', 'StartIncExc',         'I E',                 NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1171, 93,   'ONE_OF', 'EndIncExc',           'I E',                 NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1172, 93,   'TYPE',   'TheTargetAttribute',  'ORDINAL',             NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1173, 93,   'TYPE',	'IntervalStart',    'ORDINAL',             NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1174, 93,   'TYPE',	'IntervalEnd',      'ORDINAL',             NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1175, 93,   'TYPE',	'MapTo',            'NOMINAL',             NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1176, 93,   'TYPE',	'StartIncExc',      'CATEGORIAL',          NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1177, 93,   'TYPE',	'EndIncExc',        'CATEGORIAL',          NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1178, 93, 'COORD', 'IntervalStart',    'IntervalEnd',         NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1179, 93, 'COORD', 'IntervalEnd',      'StartIncExc',         NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1180, 93, 'COORD', 'StartIncExc',      'EndIncExc',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1181, 93, 'COORD', 'EndIncExc',        'MapTo',               NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1182, 93,   'TYPE',	'DefaultValue',     'NOMINAL',             NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1183, 93,   'TYPE',   'TheOutputAttribute',  'CATEGORIAL',          NULL, NULL);

-- conditions still missing
-- assertions still missing

----------------------------------------------------------------------
---------------------- M4 Operators from UEP -------------------------
----------------------------------------------------------------------

-------------------------------------------------------
-- WP16: 1.1.1
INSERT INTO OPERATOR_T VALUES (95, 'EquidistantDiscretizationGivenWidth', 'YES', 'NO', 'YES', 
NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1184, 95, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1185, 95, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1186, 95, 0,   1,  'StartPoint',          'IN',  'V',  NULL);   
INSERT INTO OP_PARAMS_T VALUES (
  1187, 95, 0,   1,  'EndPoint',            'IN',  'V',  NULL);   
INSERT INTO OP_PARAMS_T VALUES (  
  1188, 95, 1,   1,  'IntervalWidth',       'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (  
  1189, 95, 1,   1,   'ClosedTo',           'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1190, 95, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1191, 95, 'IN',        'TheTargetAttribute', 'TheInputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1192, 95, 'IN',        'TheOutputAttribute', 'TheInputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1193, 95, 'TYPE',      'TheTargetAttribute', 'NUMERIC',         NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1194, 95, 'ONE_OF',    'ClosedTo',           'left right',      NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1195, 95, 'TYPE',      'IntervalWidth',      'NUMERIC',         NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1196, 95, 'GT',        'IntervalWidth',      0,                 NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1197, 95, 'TYPE',      'StartPoint',         'NUMERIC',         NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1198, 95, 'TYPE',      'EndPoint',           'NUMERIC',         NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1199, 95, 'GT',        'EndPoint',           'StartPoint',      NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1200, 95, 'TYPE',      'TheOutputAttribute', 'CATEGORIAL',      NULL, NULL);

INSERT INTO DOCU_T VALUES (
  1201, 95, 'OPERATOR', 
'This operator divides the range of TheTargetAttribute into intervals with given width IntWidth starting at StartPoint and ending at EndPoint. The first and the last interval cover also the out of range values. Values of TheOutputAattribute can be specified in Labels ');


-------------------------------------------------------
-- WP16: 1.1.2
INSERT INTO OPERATOR_T VALUES (96, 'EquidistantDiscretizationGivenNoOfIntervals', 'YES', 'NO', 'YES', 
NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1202, 96, 1,   1,  'TheInputConcept',    'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1203, 96, 1,   1,  'TheTargetAttribute', 'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (  
  1204, 96, 1,   1,  'NoOfIntervals',      'IN',   'V', NULL);  
INSERT INTO OP_PARAMS_T VALUES (  
  1205, 96, 1,   1,  'ClosedTo',           'IN',   'V', NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1206, 96, 0, NULL, 'Labels',             'IN',   'V', NULL);    
INSERT INTO OP_PARAMS_T VALUES (
  1207, 96, 1,   1,  'TheOutputAttribute', 'OUT', 'BA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1208, 96, 'IN',   'TheTargetAttribute',  'TheInputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1209, 96, 'IN',   'TheOutputAttribute',  'TheInputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1210, 96, 'TYPE', 'TheTargetAttribute',  'NUMERIC',         NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1211, 96,  'ONE_OF',  'ClosedTo',        'left right',      NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1212, 96, 'TYPE', 'NoOfIntervals',       'NUMERIC',         NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1213, 96, 'GT', 'NoOfIntervals',         1,                 NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1214, 96, 'TYPE', 'Labels',              'CATEGORIAL',      NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1215, 96, 'TYPE', 'TheOutputAttribute',  'CATEGORIAL',      NULL, NULL);

INSERT INTO DOCU_T VALUES (
  1216, 96, 'OPERATOR', 
'This operator divides the range of TheTargetAttribute into given number of intervals NoOfIntervals with the same width. The first and the last interval cover also the out of range values. Values of TheOutputAattribute can be specified in Labels.');


-------------------------------------------------------
-- WP16: 1.1.3
INSERT INTO OPERATOR_T VALUES (97, 'EquifrequentDiscretizationGivenCardinality', 'YES', 'NO', 'YES', 
NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1217, 97, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1218, 97, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1219, 97, 1,   1,  'Cardinality', 'IN',  'V',  NULL);   
INSERT INTO OP_PARAMS_T VALUES (  
  1220, 97, 1,   1,  'CardinalityType', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (  
  1221, 97, 1,   1,   'ClosedTo', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1222, 97, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1223, 97, 'IN',   'TheTargetAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1224, 97, 'IN',   'TheOutputAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1225, 97, 'TYPE', 'TheTargetAttribute', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1226, 97,  'ONE_OF',  'ClosedTo', 'left right',
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1227, 97, 'TYPE', 'Cardinality', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1228, 97, 'GT', 'Cardinality', 0, 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1229, 97, 'ONE_OF', 'CardinalityType', 'absolute relative', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1230, 97, 'TYPE', 'TheOutputAttribute', 'CATEGORIAL', 
NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  1231, 97, 'NOT_NULL', 'TheTargetAttribute', 
NULL, NULL, NULL);

INSERT INTO DOCU_T VALUES (
  1232, 97, 'OPERATOR', 
'This operator divides the range of TheTargetAttribute into intervals with given cardinality Cardinality (number of examples with values within the interval). The first and the last interval cover also the out of range values. Values of TheOutputAattribute can be specified in Labels (this makes sense only if CardinalityType is relative.');


-------------------------------------------------------
-- WP16: 1.1.4
INSERT INTO OPERATOR_T VALUES (98, 'EquifrequentDiscretizationGivenNoOfIntervals', 'YES', 'NO', 'YES', 
NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1233, 98, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1234, 98, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (  
  1235, 98, 1,   1,  'NoOfIntervals', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (  
  1236, 98, 1,   1,   'ClosedTo', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1237, 98, 0,   NULL,   'Labels', 'IN',  'V',  NULL);    
INSERT INTO OP_PARAMS_T VALUES (
  1238, 98, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);
 
INSERT INTO OP_CONSTR_T VALUES (
  1239, 98, 'IN',   'TheTargetAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1240, 98, 'IN',   'TheOutputAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1241, 98, 'TYPE', 'TheTargetAttribute', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1242, 98,  'ONE_OF',  'ClosedTo', 'left right',
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1243, 98, 'TYPE', 'NoOfIntervals', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1244, 98, 'GT', 'NoOfIntervals', 1, 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1245, 98, 'TYPE', 'Labels', 'CATEGORIAL', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1246, 98, 'TYPE', 'TheOutputAttribute', 'CATEGORIAL', 
NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  1247, 98, 'NOT_NULL', 'TheTargetAttribute', 
NULL, NULL, NULL);

INSERT INTO DOCU_T VALUES (
  1248, 98, 'OPERATOR', 
'This operator divides the range of TheTargetAttribute into given number of intervals NoOfIntervals. The intervals have the same cardinality (number of examples with values within the interval). The first and the last interval cover also the out of range values. Values of TheOutputAattribute can be specified in Labels.');


-------------------------------------------------------
-- WP16: 1.1.5
INSERT INTO OPERATOR_T VALUES (99, 'UserDefinedDiscretization', 'NO', 'NO', 'YES', 
NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1249, 99, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1250, 99, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (  
  1251, 99, 1,   1,   'ClosedTo', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (  
  1252, 99, 1,   NULL,   'TheCutpoints', 'IN',  'V',  NULL);    
INSERT INTO OP_PARAMS_T VALUES (
  1253, 99, 0,   NULL,   'Labels', 'IN',  'V',  NULL);    
INSERT INTO OP_PARAMS_T VALUES (
  1254, 99, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);
 
INSERT INTO OP_CONSTR_T VALUES (
  1255, 99, 'IN',   'TheTargetAttribute',  'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1256, 99, 'IN',   'TheOutputAttribute',  'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1257, 99, 'TYPE', 'TheTargetAttribute', 'NUMERIC',             NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1258, 99,  'ONE_OF',  'ClosedTo', 'left right',                NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1259, 99, 'TYPE', 'TheCutpoints', 'NUMERIC',                   NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1260, 99, 'ORDERED', 'TheCutpoints', 'INC',                    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1261, 99, 'COORD', 'TheCutpoints',    'Labels',          NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1262, 99, 'TYPE', 'Labels', 'CATEGORIAL',                      NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1263, 99, 'TYPE', 'TheOutputAttribute', 'CATEGORIAL',          NULL, NULL);

INSERT INTO DOCU_T VALUES (
  1264, 99, 'OPERATOR', 
'This operator divides the range of TheTargetAttribute into intervals according to user given cutpoints TheCutpoints. Values of TheOutputAttribute can be specified in Labels.');


-------------------------------------------------------
-- WP16: 1.2.1
INSERT INTO OPERATOR_T VALUES (100, 'ImplicitErrorBasedDiscretization', 'YES', 'NO', 'NO', 
NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1265, 100, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1266, 100, 1,   1,  'TheClassAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1267, 100, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);  
INSERT INTO OP_PARAMS_T VALUES (  
  1268, 100, 1,   1,   'FullMerge', 'IN',  'V',  NULL);      
INSERT INTO OP_PARAMS_T VALUES (  
  1269, 100, 1,   1,   'ClosedTo', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (  
  1270, 100, 0,   1,   'SampleSize', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1271, 100, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);
 
INSERT INTO OP_CONSTR_T VALUES (
  1272, 100, 'IN',   'TheTargetAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1273, 100, 'IN',   'TheOutputAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1274, 100, 'TYPE', 'TheTargetAttribute', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1275, 100, 'IN',   'TheClassAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1276, 100, 'TYPE', 'TheClassAttribute', 'CATEGORIAL', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1277, 100,  'ONE_OF',  'FullMerge', 'yes no',
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1278, 100,  'ONE_OF',  'ClosedTo', 'left right',
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1279, 100, 'TYPE', 'SampleSize', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1280, 100, 'GT', 'SampleSize', 0, 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1281, 100, 'TYPE', 'TheOutputAttribute', 'CATEGORIAL', 
NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  1282, 100, 'NOT_NULL', 'TheTargetAttribute', 
NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  1283, 100, 'NOT_NULL', 'TheClassAttribute', 
NULL, NULL, NULL);

INSERT INTO DOCU_T VALUES (
  1284, 100, 'OPERATOR', 
'This operator divides the range of TheTargetAttribute into intervals by merging subsequent values with the same majority class (or classes) given in TheClassAttribute. The resulting intervals  minimize the classification error. If FullMerge is set to yes, then an interval with two or more majority classes is merged with its neighbour, if both intervals share the same majority class.');



-------------------------------------------------------
-- WP16: 2.1.1
INSERT INTO OPERATOR_T VALUES (101, 'GroupingGivenMinCardinality', 'YES', 'NO', 'YES', 
NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1285, 101, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1286, 101, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1287, 101, 1,   1,  'MinCardinality', 'IN',  'V',  NULL);   
INSERT INTO OP_PARAMS_T VALUES (  
  1288, 101, 1,   1,  'MinCardinalityType', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1289, 101, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1290, 101, 'IN',   'TheTargetAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1291, 101, 'IN',   'TheOutputAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1292, 101, 'TYPE', 'TheTargetAttribute', 'CATEGORIAL', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1293, 101, 'TYPE', 'MinCardinality', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1294, 101, 'GT', 'MinCardinality', 0, 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1295, 101, 'ONE_OF', 'MinCardinalityType', 'absolute relative', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1296, 101, 'TYPE', 'TheOutputAttribute', 'CATEGORIAL', 
NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  1297, 101, 'NOT_NULL', 'TheTargetAttribute', 
NULL, NULL, NULL);

INSERT INTO DOCU_T VALUES (
  1298, 101, 'OPERATOR', 
'This operator groups values of TheTargetAttribute by iteratively merging in each step two groups with the lowest frequencies until all groups have the cardinality (number of examples with values within the interval) at least MinCardinality.');


-------------------------------------------------------
-- WP16: 2.1.2
INSERT INTO OPERATOR_T VALUES (102, 'GroupingGivenNoOfGroups', 'YES', 'NO', 'YES', 
NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1299, 102, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1300, 102, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (  
  1301, 102, 1,   1,  'NoOfGroups', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1302, 102, 0,   NULL,   'Labels', 'IN',  'V',  NULL);       
INSERT INTO OP_PARAMS_T VALUES (
  1303, 102, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1304, 102, 'IN',   'TheTargetAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1305, 102, 'IN',   'TheOutputAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1306, 102, 'TYPE', 'TheTargetAttribute', 'CATEGORIAL', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1307, 102, 'TYPE', 'NoOfGroups', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1308, 102, 'GT', 'NoOfGroups', 1, 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1309, 102, 'TYPE', 'Labels', 'CATEGORIAL', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1310, 102, 'TYPE', 'TheOutputAttribute', 'CATEGORIAL', 
NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  1311, 102, 'NOT_NULL', 'TheTargetAttribute', 
NULL, NULL, NULL);

INSERT INTO DOCU_T VALUES (
  1312, 102, 'OPERATOR', 
'This operator groups values of TheTargetAttribute by iteratively  merging in each step two groups with the lowest frequencies until the number of groups NoOfGroups is reached. Values of TheOutputAttribute can be specified in Labels.');


-------------------------------------------------------
-- WP16: 2.1.3
INSERT INTO OPERATOR_T VALUES (103, 'UserDefinedGrouping', 'NO', 'NO', 'YES', 
NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1313, 103, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1314, 103, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (  
  1315, 103, 1,   NULL,  'TheGroupings', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1316, 103, 0,   NULL,   'Labels', 'IN',  'V',  NULL);       
INSERT INTO OP_PARAMS_T VALUES (
  1317, 103, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1318, 103, 'IN',   'TheTargetAttribute',  'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1319, 103, 'IN',   'TheOutputAttribute',  'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1320, 103, 'TYPE', 'TheTargetAttribute', 'CATEGORIAL', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1321, 103, 'TYPE', 'TheGroupings', 'CATEGORIAL', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1322, 103, 'TYPE', 'Labels', 'CATEGORIAL', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1323, 103, 'COORD', 'TheGroupings',    'Labels',    NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  1324, 103, 'TYPE', 'TheOutputAttribute', 'CATEGORIAL',    NULL, NULL);

-- no conditions 

INSERT INTO DOCU_T VALUES (
  1325, 103, 'OPERATOR', 
'This operator creates groups of TheTargetAttribute according to specifications given by the user in TheGroupings. Values not specified for grouping retain their original values. Values of TheOutputAttribute can be specified in Labels.');


-------------------------------------------------------
-- WP16: 2.1.4
INSERT INTO OPERATOR_T VALUES (104, 'UserDefinedGroupingWithDefaultValue', 'YES', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1326, 104, 1,   1,     'TheInputConcept',  'IN', 'CON',  NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1327, 104, 1,   1,  'TheTargetAttribute',  'IN',  'BA',  NULL);
INSERT INTO OP_PARAMS_T VALUES (  
  1328, 104, 0,   1,             'Default',  'IN',   'V',  NULL);    
INSERT INTO OP_PARAMS_T VALUES (  
  1329, 104, 1,   NULL,     'TheGroupings',  'IN',   'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1330, 104, 0,   NULL,           'Labels',  'IN',   'V',  NULL);       
INSERT INTO OP_PARAMS_T VALUES (
  1331, 104, 1,   1,  'TheOutputAttribute', 'OUT',  'BA',  NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1332, 104, 'IN',   'TheTargetAttribute',  'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1333, 104, 'IN',   'TheOutputAttribute',  'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1334, 104, 'TYPE', 'TheTargetAttribute',  'CATEGORIAL',       NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1335, 104, 'TYPE', 'Default',             'CATEGORIAL',       NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1336, 104, 'TYPE', 'TheGroupings',        'CATEGORIAL',       NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1337, 104, 'TYPE', 'Labels',              'CATEGORIAL',       NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1338, 104, 'COORD', 'TheGroupings', 'Labels',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1339, 104, 'TYPE', 'TheOutputAttribute',  'CATEGORIAL',       NULL, NULL);

-- no conditions 

INSERT INTO DOCU_T VALUES (
  1340, 104, 'OPERATOR', 
'This operator creates groups of TheTargetAttribute according to specifications given by the user in TheGroupings. Values not specified for grouping are grouped into default group Default. Values of TheOutputAttribute can be specified in Labels.');


-------------------------------------------------------
-- WP16: 1.2.2
INSERT INTO OPERATOR_T VALUES (105, 'ErrorBasedDiscretizationGivenMinCardinality', 'YES', 'NO', 'NO', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1341, 105, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1342, 105, 1,   1,  'TheClassAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1343, 105, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1344, 105, 1,   1,  'MinCardinality', 'IN',  'V',  NULL);   
INSERT INTO OP_PARAMS_T VALUES (  
  1345, 105, 1,   1,  'MinCardinalityType', 'IN',  'V',  NULL);        
INSERT INTO OP_PARAMS_T VALUES (  
  1346, 105, 1,   1,   'ClosedTo', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (  
  1347, 105, 0,   1,   'SampleSize', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1348, 105, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);
 
INSERT INTO OP_CONSTR_T VALUES (
  1349, 105, 'IN',   'TheTargetAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1350, 105, 'IN',   'TheOutputAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1351, 105, 'TYPE', 'TheTargetAttribute', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1352, 105, 'IN',   'TheClassAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1353, 105, 'TYPE', 'TheClassAttribute', 'CATEGORIAL', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1354, 105,  'ONE_OF',  'ClosedTo', 'left right',
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1355, 105, 'TYPE', 'MinCardinality', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1356, 105, 'GT', 'MinCardinality', 0, 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1357, 105, 'ONE_OF', 'MinCardinalityType', 'absolute relative', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1358, 105, 'TYPE', 'SampleSize', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1359, 105, 'GT', 'SampleSize', 0, 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1360, 105, 'TYPE', 'TheOutputAttribute', 'CATEGORIAL', 
NULL, NULL);

-- If CardinalityType is 'relative', then Cardinality < 0.5

INSERT INTO OP_COND_T VALUES (
  1361, 105, 'NOT_NULL', 'TheTargetAttribute', 
NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  1362, 105, 'NOT_NULL', 'TheClassAttribute', 
NULL, NULL, NULL);
-- If CardinalityType is 'absolute', then Cardinality < TheTargetAttribute.allNumber/2

INSERT INTO DOCU_T VALUES (
  1363, 105, 'OPERATOR', 
'This operator divides the range of TheTargetAttribute into intervals with cardinality greater or equal to MinCardinality. The numeric attribute is divided into intervals with respect to TheClassAttribute, but unlike the implicit discretization, intervals with single majority class are further merged if they do not have the required cardinality. This will increase the classification error.');


-------------------------------------------------------
-- WP16: 1.2.3
INSERT INTO OPERATOR_T VALUES (106, 'ErrorBasedDiscretizationGivenNoOfIntervals', 'YES', 'NO', 'NO', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1364, 106, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1365, 106, 1,   1,  'TheClassAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1366, 106, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);  
INSERT INTO OP_PARAMS_T VALUES (  
  1367, 106, 1,   1,  'NoOfIntervals', 'IN',  'V',  NULL);       
INSERT INTO OP_PARAMS_T VALUES (  
  1368, 106, 1,   1,   'ClosedTo', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (  
  1369, 106, 0,   1,   'SampleSize', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1370, 106, 0,   NULL,   'Labels', 'IN',  'V',  NULL);      
INSERT INTO OP_PARAMS_T VALUES (
  1371, 106, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);
 
INSERT INTO OP_CONSTR_T VALUES (
  1372, 106, 'IN',   'TheTargetAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1373, 106, 'IN',   'TheOutputAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1374, 106, 'TYPE', 'TheTargetAttribute', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1375, 106, 'IN',   'TheClassAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1376, 106, 'TYPE', 'TheClassAttribute', 'CATEGORIAL', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1377, 106,  'ONE_OF',  'ClosedTo', 'left right',
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1378, 106, 'TYPE', 'NoOfIntervals', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1379, 106, 'GT', 'NoOfIntervals', 1, 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1380, 106, 'TYPE', 'SampleSize', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1381, 106, 'GT', 'SampleSize', 0, 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1382, 106, 'TYPE', 'Labels', 'CATEGORIAL', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1383, 106, 'TYPE', 'TheOutputAttribute', 'CATEGORIAL', 
NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  1384, 106, 'NOT_NULL', 'TheTargetAttribute', 
NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  1385, 106, 'NOT_NULL', 'TheClassAttribute', 
NULL, NULL, NULL);
-- INSERT INTO OP_COND_T VALUES (2369, 106, 'LT', 'NoOfIntervals', TheTargetAttribute.unique, NULL, NULL);

INSERT INTO DOCU_T VALUES (
  1386, 106, 'OPERATOR', 
'This operator divides the range of TheTargetAttribute into at most NoOfIntervals intervals. The numeric attribute is divided into intervals with respect to TheClassAttribute, but unlike the implicit discretization, if the number of interval exceeds NoOfIntervals, intervals are further merged. This will increase the classification error. Values of TheOutputAttribute can be specified in Labels.');


-------------------------------------------------------
-- WP16: 2.2.1
INSERT INTO OPERATOR_T VALUES (107, 'ImplicitErrorBasedGrouping', 'YES', 'NO', 'NO', 
NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1387, 107, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1388, 107, 1,   1,  'TheClassAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1389, 107, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);  
INSERT INTO OP_PARAMS_T VALUES (  
  1390, 107, 1,   1,   'FullMerge', 'IN',  'V',  NULL);      
INSERT INTO OP_PARAMS_T VALUES (  
  1391, 107, 0,   1,   'SampleSize', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1392, 107, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);
 
INSERT INTO OP_CONSTR_T VALUES (
  1393, 107, 'IN',   'TheTargetAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1394, 107, 'IN',   'TheOutputAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1395, 107, 'TYPE', 'TheTargetAttribute', 'CATEGORIAL', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1396, 107, 'IN',   'TheClassAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1397, 107, 'TYPE', 'TheClassAttribute', 'CATEGORIAL', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1398, 107,  'ONE_OF',  'FullMerge', 'yes no',
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1399, 107, 'TYPE', 'SampleSize', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1400, 107, 'GT', 'SampleSize', 0, 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1401, 107, 'TYPE', 'TheOutputAttribute', 'CATEGORIAL', 
NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  1402, 107, 'NOT_NULL', 'TheTargetAttribute', 
NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  1403, 107, 'NOT_NULL', 'TheClassAttribute', 
NULL, NULL, NULL);

INSERT INTO DOCU_T VALUES (
  1404, 107, 'OPERATOR', 
'This operator merges the values of TheTargetAttribute into groups with the same majority class (or classes) given in TheClassAttribute. If FullMerge is set to yes, then a group with two or more majority classes is merged with a group that have the same majority class. The resulting grouping  minimize the classification error.');


-------------------------------------------------------
-- WP16: 2.2.2
INSERT INTO OPERATOR_T VALUES (108, 'ErrorBasedGroupingGivenMinCardinality', 'YES', 'NO', 'NO', 
NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1405, 108, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1406, 108, 1,   1,  'TheClassAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1407, 108, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1408, 108, 1,   1,  'MinCardinality', 'IN',  'V',  NULL);   
INSERT INTO OP_PARAMS_T VALUES (  
  1409, 108, 1,   1,  'MinCardinalityType', 'IN',  'V',  NULL);        
INSERT INTO OP_PARAMS_T VALUES (  
  1410, 108, 0,   1,   'SampleSize', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1411, 108, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);
 
INSERT INTO OP_CONSTR_T VALUES (
  1412, 108, 'IN',   'TheTargetAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1413, 108, 'IN',   'TheOutputAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1414, 108, 'TYPE', 'TheTargetAttribute', 'CATEGORIAL', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1415, 108, 'IN',   'TheClassAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1416, 108, 'TYPE', 'TheClassAttribute', 'CATEGORIAL', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1417, 108, 'TYPE', 'MinCardinality', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1418, 108, 'GT', 'MinCardinality', 0, 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1419, 108, 'ONE_OF', 'MinCardinalityType', 'absolute relative', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1420, 108, 'TYPE', 'SampleSize', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1421, 108, 'GT', 'SampleSize', 0, 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1422, 108, 'TYPE', 'TheOutputAttribute', 'CATEGORIAL', 
NULL, NULL);
-- If CardinalityType is 'relative', then Cardinality < 0.5

INSERT INTO OP_COND_T VALUES (
  1423, 108, 'NOT_NULL', 'TheTargetAttribute', 
NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  1424, 108, 'NOT_NULL', 'TheClassAttribute', 
NULL, NULL, NULL);
-- If CardinalityType is 'absolute', then Cardinality < TheTargetAttribute.allNumber/2

INSERT INTO DOCU_T VALUES (
  1425, 108, 'OPERATOR', 
'This operator merges the values of TheTargetAttribute into groups with the cardinality above given threshold MinCardinality. The grouping is performed with respect to TheClassAttribute, but unlike implicit grouping, groups with single majority class are further merged if they do not have the required cardinality. This will increase the classification error.');


-------------------------------------------------------
-- WP16: 2.2.3
INSERT INTO OPERATOR_T VALUES (109, 'ErrorBasedGroupingGivenNoOfGroups', 'YES', 'NO', 'NO', 
NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1426, 109, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1427, 109, 1,   1,  'TheClassAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1428, 109, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);  
INSERT INTO OP_PARAMS_T VALUES (  
  1429, 109, 1,   1,  'NoOfGroups', 'IN',  'V',  NULL);       
INSERT INTO OP_PARAMS_T VALUES (  
  1430, 109, 0,   1,   'SampleSize', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1431, 109, 0,   NULL,   'Labels', 'IN',  'V',  NULL);      
INSERT INTO OP_PARAMS_T VALUES (
  1432, 109, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);
 
INSERT INTO OP_CONSTR_T VALUES (
  1433, 109, 'IN',   'TheTargetAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1434, 109, 'IN',   'TheOutputAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1435, 109, 'TYPE', 'TheTargetAttribute', 'CATEGORIAL', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1436, 109, 'IN',   'TheClassAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1437, 109, 'TYPE', 'TheClassAttribute', 'CATEGORIAL', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1438, 109, 'TYPE', 'NoOfGroups', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1439, 109, 'GT', 'NoOfGroups', 1, 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1440, 109, 'TYPE', 'SampleSize', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1441, 109, 'GT', 'SampleSize', 0, 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1442, 109, 'TYPE', 'Labels', 'CATEGORIAL', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1443, 109, 'TYPE', 'TheOutputAttribute', 'CATEGORIAL', 
NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  1444, 109, 'NOT_NULL', 'TheTargetAttribute', 
NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  1445, 109, 'NOT_NULL', 'TheClassAttribute', 
NULL, NULL, NULL);
-- INSERT INTO OP_COND_T VALUES (2717, 109, 'LT', 'NoOfGroups', TheTargetAttribute.unique, NULL, NULL);

INSERT INTO DOCU_T VALUES (
  1446, 109, 'OPERATOR', 
'This operator merges the values of TheTargetAttribute into at most  NoOfGropus groups. The grouping is performed with respect to TheClassAttribute, but unlike the implicit discretization, if the number of groups exceeds NoOfGroups, groups are further merged. Values of TheOutputAttribute can be specified in Labels.');



---------------------- M4 Operators from UEP--------------------------
----------------------------------------------------------------------

-------------------------------------------------------
-- WP14: 1.1
INSERT INTO OPERATOR_T VALUES (110, 'SimpleForwardFeatureSelectionGivenNoOfAttributes', 'NO', 'NO', 'NO', 
NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1447, 110, 1,   1,    'TheInputConcept',    'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (  
  1448, 110, 1,   1,    'NoOfAttributes',     'IN',   'V', NULL);   
INSERT INTO OP_PARAMS_T VALUES (  
  1449, 110, 0,   1,    'SampleSize',         'IN',   'V', NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1450, 110, 1,   NULL, 'TheAttributes',      'IN',  'BA', NULL);    
INSERT INTO OP_PARAMS_T VALUES (
  1451, 110, 1,   1,    'TheClassAttribute',  'IN',  'BA', NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1452, 110, 1,   1,    'TheOutputConcept',  'OUT', 'CON', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1453, 110, 'IN',   'TheClassAttribute', 'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1454, 110, 'TYPE', 'TheClassAttribute', 'CATEGORIAL',       NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1455, 110, 'IN',   'TheAttributes',     'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1456, 110, 'TYPE', 'TheAttributes',     'CATEGORIAL',       NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1457, 110, 'TYPE', 'NoOfAttributes',    'NUMERIC',          NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1458, 110, 'GT',   'NoOfAttributes',    0,                  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1459, 110, 'TYPE', 'SampleSize',       'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1460, 110, 'GT',   'SampleSize',        0,                  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1461, 110, 'SAME_FEAT', 'TheOutputConcept', 'TheInputConcept',  NULL, NULL);

-- INSERT INTO OP_COND_T VALUES (2762, 110, 'LT', 'NoOfAttributes', TheInputConcept.NoOfCollumns, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  1462, 110, 'NOT_NULL', 'TheAttributes',     NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  1463, 110, 'NOT_NULL', 'TheClassAttribute', NULL, NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  1464, 110, 'PROJ', 'TheOutputConcept', 'TheInputConcept', NULL, NULL); 
-- output is proj of input

INSERT INTO DOCU_T VALUES (
  1465, 110, 'OPERATOR', 
'This operator adds one feature a time starting from empty set until the required number of features NoOfAttributes is reached. The attributes are selected with respect to TheClassAttribute, the group optimises the information dependence criterion. Use this operator if only a small number of original attributes is to be selected. The selection is done from the set of TheAttributes, attributes not specified in this set are selected automatically.');


-------------------------------------------------------
-- WP14: 1.2
INSERT INTO OPERATOR_T VALUES (111, 'SimpleBackwardFeatureSelectionGivenNoOfAttributes', 'NO', 'NO', 'NO', 
NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1466, 111,    1,      1,    'TheInputConcept',   'IN', 'CON',  NULL);
INSERT INTO OP_PARAMS_T VALUES (  
  1467, 111, 1,   1,          'NoOfAttributes',    'IN',   'V',  NULL);   
INSERT INTO OP_PARAMS_T VALUES (  
  1468, 111, 0,   1,          'SampleSize',        'IN',   'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1469, 111, 1,   NULL,       'TheAttributes',     'IN',  'BA',  NULL);    
INSERT INTO OP_PARAMS_T VALUES (
  1470, 111, 1,   1,          'TheClassAttribute', 'IN',  'BA',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1471, 111, 1,   1,          'TheOutputConcept',  'OUT', 'CON', NULL);
  
INSERT INTO OP_CONSTR_T VALUES (
  1472, 111, 'IN',   'TheClassAttribute',  'TheInputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1473, 111, 'TYPE', 'TheClassAttribute',  'CATEGORIAL',      NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1474, 111, 'IN',   'TheAttributes',      'TheInputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1475, 111, 'TYPE', 'TheAttributes',      'CATEGORIAL',      NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1476, 111, 'TYPE', 'NoOfAttributes',     'NUMERIC',         NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1477, 111, 'GT',   'NoOfAttributes',     0,                 NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1478, 111, 'TYPE', 'SampleSize',         'NUMERIC',         NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1479, 111, 'GT',   'SampleSize',         0,                 NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1480, 111, 'SAME_FEAT', 'TheOutputConcept', 'TheInputConcept',  NULL, NULL);

-- INSERT INTO OP_COND_T VALUES (2812, 111, 'LT', 'NoOfIntervals', TheInputConcept.NoOfCollumns, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  1481, 111, 'NOT_NULL', 'TheAttributes',     NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  1482, 111, 'NOT_NULL', 'TheClassAttribute', NULL, NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  1483, 111, 'PROJ', 'TheOutputConcept', 'TheInputConcept', NULL, NULL);
-- output is proj of input

INSERT INTO DOCU_T VALUES (
  1484, 111, 'OPERATOR', 
'This operator removes one feature a time starting from all attributes until the required number of features NoOfAttributes is reached. The attributes are selected with respect to TheClassAttribute, the group optimises the information dependence criterion. Use this operator if  a large number of original attributes is to be selected. The selection is done from the set of TheAttributes, attributes not specified in this set are selected automatically.');


-------------------------------------------------------
-- WP14: 1.3
INSERT INTO OPERATOR_T VALUES (112, 'FloatingForwardFeatureSelectionGivenNoOfAttributes', 'NO', 'NO', 'NO', 
NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1485, 112, 1,   1,     'TheInputConcept',   'IN',  'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (  
  1486, 112, 1,   1,     'NoOfAttributes',    'IN',    'V', NULL);   
INSERT INTO OP_PARAMS_T VALUES (  
  1487, 112, 0,   1,     'SampleSize',        'IN',    'V', NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1488, 112, 1,   NULL,  'TheAttributes',     'IN',  'BA', NULL);    
INSERT INTO OP_PARAMS_T VALUES (
  1489, 112, 1,   1,     'TheClassAttribute', 'IN',  'BA', NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1490, 112, 1,   1,     'TheOutputConcept',  'OUT', 'CON', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1491, 112, 'IN',   'TheClassAttribute',  'TheInputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1492, 112, 'TYPE', 'TheClassAttribute',  'CATEGORIAL', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1493, 112, 'IN',   'TheAttributes',      'TheInputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1494, 112, 'TYPE', 'TheAttributes',      'CATEGORIAL', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1495, 112, 'TYPE', 'NoOfAttributes',     'NUMERIC', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1496, 112, 'GT',   'NoOfAttributes',             0, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1497, 112, 'TYPE', 'SampleSize',         'NUMERIC', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1498, 112, 'GT', 'SampleSize',                   0, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1499, 112, 'SAME_FEAT', 'TheOutputConcept', 'TheInputConcept',  NULL, NULL);

-- INSERT INTO OP_COND_T VALUES (2862, 112, 'LT', 'NoOfIntervals', TheInputConcept.NoOfCollumns, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  1500, 112, 'NOT_NULL', 'TheAttributes', 
NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  1501, 112, 'NOT_NULL', 'TheClassAttribute', 
NULL, NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  1502, 112, 'PROJ', 'TheOutputConcept', 'TheInputConcept', NULL, NULL); 
-- output is proj of input

INSERT INTO DOCU_T VALUES (
  1503, 112, 'OPERATOR', 
'This operator adds one feature a time starting from empty set until the required number of features NoOfAttributes is reached. The attributes are selected with respect to TheClassAttribute, the group optimises the information dependence criterion. Unlike the simple operator, after adding a feature a check is performed if another feature should be removed. Use this operator if only a small number of original attributes is to be selected. The selection is done from the set of TheAttributes, attributes not specified in this set are selected automatically.');


-------------------------------------------------------
-- WP14: 1.4
INSERT INTO OPERATOR_T VALUES (113, 'FloatingBackwardFeatureSelectionGivenNoOfAttributes', 'NO', 'NO', 'NO', 
NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1504, 113, 1,   1,    'TheInputConcept',   'IN', 'CON',  NULL);
INSERT INTO OP_PARAMS_T VALUES (  
  1505, 113, 1,   1,    'NoOfAttributes',    'IN',  'V',   NULL);   
INSERT INTO OP_PARAMS_T VALUES (  
  1506, 113, 0,   1,    'SampleSize',        'IN',  'V',   NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1507, 113, 1,   NULL, 'TheAttributes',     'IN', 'BA',  NULL);    
INSERT INTO OP_PARAMS_T VALUES (
  1508, 113, 1,   1,    'TheClassAttribute', 'IN', 'BA',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1509, 113, 1,   1,    'TheOutputConcept',  'OUT', 'CON', NULL);
  
INSERT INTO OP_CONSTR_T VALUES (
  1510, 113, 'IN',   'TheClassAttribute',  'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1511, 113, 'TYPE', 'TheClassAttribute',  'CATEGORIAL',       NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1512, 113, 'IN',   'TheAttributes',      'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1513, 113, 'TYPE', 'TheAttributes',      'CATEGORIAL',       NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1514, 113, 'TYPE', 'NoOfAttributes',     'NUMERIC',          NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1515, 113, 'GT', 'NoOfAttributes',       0,                  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1516, 113, 'TYPE', 'SampleSize',         'NUMERIC',          NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1517, 113, 'GT', 'SampleSize',           0,                  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1518, 113, 'SAME_FEAT', 'TheOutputConcept', 'TheInputConcept',  NULL, NULL);

-- INSERT INTO OP_COND_T VALUES (2912, 113, 'LT', 'NoOfAttributes', TheInputConcept.NoOfCollumns, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  1519, 113, 'NOT_NULL', 'TheAttributes', 
NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  1520, 113, 'NOT_NULL', 'TheClassAttribute', 
NULL, NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  1521, 113, 'PROJ', 'TheOutputConcept', 'TheInputConcept', NULL, NULL); 
-- output is proj of input

INSERT INTO DOCU_T VALUES (
  1522, 113, 'OPERATOR', 
'This operator removes one feature a time starting from all attributes until the required number of features NoOfAttributes is reached. The attributes are selected with respect to TheClassAttribute, the group optimises the information dependence criterion. Unlike the simple operator, after removing a feature a check is performed if another feature should be added. Use this operator if  a large number of original attributes is to be selected. The selection is done from the set of TheAttributes, attributes not specified in this set are selected automatically.');

-------------------------------------------------------
-- WP14: 1.5
INSERT INTO OPERATOR_T VALUES (114, 'UserDefinedFeatureSelection', 'NO', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1523, 114,    1,      1,    'TheInputConcept',        'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1524, 114,    1,      1,    'TheOutputConcept',      'OUT', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (  
  1525, 114,    1,   NULL,    'TheSelectedAttributes', 'OUT',  'BA', NULL);   
  
INSERT INTO OP_CONSTR_T VALUES (
  1526, 114, 'IN',   'TheOutputConcept',       'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1527, 114, 'IN',   'TheSelectedAttributes',  'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1528, 114, 'IN',   'TheSelectedAttributes',  'TheOutputConcept', NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  1529, 114, 'PROJ', 'TheOutputConcept', 'TheInputConcept', NULL, NULL); 
-- output is proj of input

INSERT INTO DOCU_T VALUES (
  1530, 114, 'OPERATOR', 
'This operator selects the attributes TheSelectedAttributes given by the user.');

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (115, 'FeatureConstructionWithTFIDF', 'NO', 'NO', 'NO', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1531, 115, 1,    1,	    'TheInputConcept',        'IN',  'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1532, 115, 1,    1,           'TheTimeStamp',           'OUT', 'BA',  NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1533, 115, 1,    1,           'TheKey',                 'OUT', 'BA',  NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1534, 115, 1,    1,           'TheOutputConcept',       'OUT', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1535, 115, 1,    NULL,        'TheSelectedAttributes',  'OUT', 'BA',  NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1536, 115,        'IN',      'TheTimeStamp',          'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1537, 115,        'IN',      'TheKey',                'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1538, 115,        'IN',      'TheSelectedAttributes', 'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1539, 115,        'IN',      'TheTimeStamp',          'TheOutputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1540, 115,        'IN',      'TheKey',                'TheOutputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1541, 115,        'IN',      'TheSelectedAttributes', 'TheOutputConcept', NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  1542, 115, 'PROJ', 'TheOutputConcept', 'TheInputConcept', NULL, NULL); 
-- output is proj of input

--------------------------------------------------------------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (116, 'EvaluateAdvantageOfTFIDFTransformation', 'NO', 'NO', 'NO', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1543, 116, 1,    1,          'TheInputConcept',        'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1544, 116, 1,    1,          'TheTimeStamp',           'IN', 'BA',  NULL); 
INSERT INTO OP_PARAMS_T VALUES (
  1545, 116, 1,    1,          'TheKey',                 'IN', 'BA',  NULL); 
INSERT INTO OP_PARAMS_T VALUES (
  1546, 116, 1,    NULL,       'TheSelectedAttributes',  'IN', 'BA',  NULL); 

INSERT INTO OP_CONSTR_T VALUES (
  1547, 116,        'IN',     'TheTimeStamp',          'TheInputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1548, 116,        'IN',     'TheKey',                'TheInputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1549, 116,        'IN',     'TheSelectedAttributes', 'TheInputConcept', NULL, NULL);

--------------------------------------------------------------------------------------------------------------

INSERT INTO OPERATOR_T VALUES (117, 'Union', 'NO', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1550,	117,	1,	1,	'TheInputConcept',	'IN',	'CON',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1551,	117,	1,	NULL,	'FurtherConcepts',	'IN',	'CON',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1552,	117,	1,	1,	'DataMode',		'IN',	'V',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1553,	117,	1,	1,	'TheOutputConcept',	'OUT',	'CON',	NULL);


INSERT INTO OP_CONSTR_T VALUES (
  1554, 117, 'SAME_FEAT', 'TheOutputConcept', 'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1555, 117, 'SAME_FEAT', 'FurtherConcepts',  'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1556, 117,    'ONE_OF', 'DataMode',         'set multi-set',    NULL, NULL);

-- no conditions

INSERT INTO OP_ASSERT_T VALUES (
  1557, 117, 'SUBSET', 'TheInputConcept', 'TheOutputConcept', NULL, NULL); 
-- input is subset of output
INSERT INTO OP_ASSERT_T VALUES (
  1558, 117, 'SUBSET', 'FurtherConcepts', 'TheOutputConcept', NULL, NULL); 
-- furtherCons are subsets of output

--------------------------------------------------------------------------------------------------------------

INSERT INTO OPERATOR_T VALUES (118, 'Materialize', 'NO', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1559,	118,	1,	1,	'TheInputConcept',	'IN',	'CON',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1560,	118,	0,	1,	'TableName',		'IN',	'V',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1561,	118,	1,	1,	'TheOutputConcept',	'OUT',	'CON',	NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1562, 118, 'SAME_FEAT', 'TheOutputConcept', 'TheInputConcept',  NULL, NULL);

-- no conditions

INSERT INTO OP_ASSERT_T VALUES (
  1563, 118, 'SUBSET', 'TheInputConcept', 'TheOutputConcept', NULL, NULL); 
-- input concept is subset of output concept 
-- (output is also subset of input but we want only one direction)  

--------------------------------------------------------------------------------------------------------------

INSERT INTO OPERATOR_T VALUES (119, 'DateToNumeric', 'YES', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1564, 119, 1,    1,           'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1565, 119, 1,    1,        'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1566, 119, 1,    1,                'OutputFormat',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1567, 119, 1,    1,        'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1568, 119,         'IN', 'TheTargetAttribute',  'TheInputConcept',     NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1569, 119,         'IN', 'TheOutputAttribute',  'TheInputConcept',     NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1570, 119,      'TYPE', 'TheOutputAttribute',   'NUMERIC',             NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1571, 119, 'IS_LOOPED',  'TheTargetAttribute',  NULL,                  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1572, 119, 'IS_LOOPED',  'OutputFormat',        NULL,                  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1573, 119, 'IS_LOOPED',  'TheOutputAttribute',  NULL,                  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1574, 119,    'ONE_OF',  'OutputFormat',
    'Year_YYYY Year_YY Month_of_Year Day_of_Month Hour_of_Day Minute_of_Hour Second_of_Minute',
  NULL, NULL);

-- no conditions
-- no assertions
-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (120, 'YaleModelApplier', 'YES', 'NO', 'NO', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1575, 120, 1,    1,             'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1576, 120, 1, NULL,                  'PrimaryKey',  'IN', 'FEA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1577, 120, 1, NULL,        'PredictingAttributes',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1578, 120, 1,    1,                   'ModelFile',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1579, 120, 1,    1,          'PredictedAttribute', 'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1580, 120, 1,    1,            'TheOutputConcept', 'OUT', 'CON', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1581, 120,         'IN', 'PrimaryKey',            'TheInputConcept',      NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1582, 120,         'IN', 'PredictingAttributes',  'TheInputConcept',      NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1583, 120,         'IN', 'PrimaryKey',            'TheOutputConcept',     NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1584, 120,         'IN', 'PredictingAttributes',  'TheOutputConcept',     NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1585, 120,         'IN', 'PredictedAttribute',    'TheOutputConcept',     NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1586, 120,      'TYPE', 'PredictedAttribute',     'NUMERIC',              NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1587, 120,      'TYPE', 'ModelFile',              'NOMINAL',              NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1588, 120, 'IS_LOOPED', 'ModelFile',               NULL,                  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1589, 120, 'IS_LOOPED', 'PredictedAttribute',      NULL,                  NULL, NULL);

-- no conditions
-- no assertions
-------------------------------------------------------

INSERT INTO OPERATOR_T VALUES (121, 'CreatePrimaryKey', 'NO', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1590,	121,	1,	1,	'TheInputConcept',	'IN',	'CON',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1591,	121,	1,	1,	'AllowDuplicates',	'IN',	'V',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1592,	121,	1,	1,	'PrimaryKey',		'OUT',	'BA',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1593,	121,	1,	1,	'TheOutputConcept',	'OUT',	'CON',	NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1594, 121, 'SAME_FEAT', 'TheOutputConcept', 'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1595, 121, 'IN',        'PrimaryKey',       'TheOutputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1596, 121, 'TYPE',      'PrimaryKey',       'KEYATTRIB',        NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1597, 121, 'ONE_OF',    'AllowDuplicates',  'true false',       NULL, NULL);
-- no conditions

INSERT INTO OP_ASSERT_T VALUES (
  1598, 121, 'PROJ', 'TheInputConcept', 'TheOutputConcept', NULL, NULL); 
-- input is proj of output
-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (122, 'Repeat', 'NO', 'YES','YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1599,   122,    1,      1,     'TheInputConcept',   'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1600,   122,    1,      1,            'HowOften',   'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1601,   122,    1,      1,    'TheOutputConcept',  'OUT', 'CON', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1602, 122, 'SAME_FEAT',  'TheOutputConcept',  'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1603, 122,        'GE',  'HowOften',                          1,  NULL, NULL);

-- no conditions

-- Following assertion is deleted because the input and output are conceptually
-- equal, only the output is present several times
-- INSERT INTO OP_ASSERT_T VALUES (
--   1604, 122, 'SUBSET', 'TheInputConcept', 'TheOutputConcept', NULL,
-- NULL);

-------------------------------------------------------

INSERT INTO OPERATOR_T VALUES (123, 'Pivotize', 'NO', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1605, 123, 1,    1,          'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1606, 123, 1, NULL,       'TheIndexAttributes',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1607, 123, 1,    1,        'ThePivotAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1608, 123, 0, NULL,     'TheGroupByAttributes',  'IN', 'FEA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1609, 123, 1,    1,         'TheOutputConcept', 'OUT', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1610, 123, 1, NULL,              'IndexValues',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1611, 123, 1,    1,      'AggregationOperator',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1612, 123, 0,    1,               'NullOrZero',  'IN',   'V', NULL);


INSERT INTO OP_CONSTR_T VALUES (
  1613, 123, 'IN',   'TheIndexAttributes',  'TheInputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1614, 123, 'IN',    'ThePivotAttribute',  'TheInputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1615, 123, 'IN', 'TheGroupByAttributes',  'TheInputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1616, 123, 'IN', 'TheGroupByAttributes', 'TheOutputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1617, 123, 'ONE_OF','AggregationOperator', 'NONE SUM AVG MIN MAX COUNT', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1618, 123, 'ONE_OF','NullOrZero', 'Null Zero', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1619, 123, 'COORD', 'IndexValues', 'TheIndexAttributes', NULL, NULL);

-- no conditions

INSERT INTO OP_ASSERT_T VALUES (
  1620, 123, 'REL_N_1', 'TheInputConcept',    'TheOutputConcept',   NULL, NULL);
-- an n:1 relationship from input to output exists (if there are any group-by attributes)
INSERT INTO OP_ASSERT_T VALUES (
  1621, 123, 'REL_N_K', 'TheGroupByAttributes', NULL, NULL, NULL);
-- the keys on the "many-side" are given by the GroupBy attributes 
INSERT INTO OP_ASSERT_T VALUES (
  1622, 123, 'REL_1_K',  'TheGroupByAttributes', NULL, NULL, NULL);
-- the keys on the "one-side" are given by the GroupBy attributes


-------------------------------------------------------

INSERT INTO OPERATOR_T VALUES (124, 'PrepareForYale', 'NO', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
 1623, 124, 1,    1,    'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
 1624, 124, 0,    1,    'QueryFilePrefix',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
 1625, 124, 1,    1, 'ExperimentFileName',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
 1626, 124, 0,    1,           'TheLabel',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
 1627, 124, 0,    1,      'ThePrimaryKey',  'IN',  'BA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1628, 124, 'IN',      'TheLabel', 'TheInputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1629, 124, 'IN', 'ThePrimaryKey', 'TheInputConcept', NULL, NULL);

-- no conditions
-- no assertions

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (125, 'RemoveDuplicates', 'NO', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1630,   125,    1,      1,    'TheInputConcept',    'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1631,   125,    1,      1,    'TheOutputConcept',  'OUT', 'CON', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1632, 125, 'SAME_FEAT', 'TheOutputConcept', 'TheInputConcept',  NULL, NULL);

-- no conditions

INSERT INTO OP_ASSERT_T VALUES (
  1633, 125, 'SUBSET', 'TheOutputConcept', 'TheInputConcept', NULL, NULL); 
-- output is subset of input

-------------------------------------------------------

INSERT INTO OPERATOR_T VALUES (126, 'Binarify', 'YES', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1634, 126, 1,    1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1635, 126, 1,    1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1636, 126, 1,    1,  'TheOutputAttribute', 'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1637, 126, 1,    1,         'TargetValue',  'IN',   'V', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1638, 126, 'IS_LOOPED',   'TargetValue',               NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1639, 126, 'IS_LOOPED',   'TheOutputAttribute',        NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1640, 126,        'IN',   'TheTargetAttribute',  'TheInputConcept',     NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1641, 126,        'IN',   'TheOutputAttribute',  'TheInputConcept',     NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1642, 126,      'TYPE',   'TheOutputAttribute',  'BINARY',              NULL, NULL);

-- no conditions

INSERT INTO OP_ASSERT_T VALUES (
  1643, 126, 'GE',       'TheOutputAttribute', '0', NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  1644, 126, 'LE',       'TheOutputAttribute', '1', NULL, NULL);


-------------------------------------------------------

INSERT INTO OPERATOR_T VALUES (127, 'ReversePivotize', 'NO', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1645, 127, 1,    1,          'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1646, 127, 1, NULL,    'ThePivotizedAttributes', 'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1647, 127, 0, 1,              'TheKeyAttribute', 'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1648, 127, 1,    1,         'TheOutputConcept', 'OUT', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1649, 127, 1, NULL,              'IndexValues',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1650, 127, 1, 1,       'NameForPivotAttribute',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1651, 127, 1, NULL,  'NamesForIndexAttributes',  'IN',   'V', NULL);


INSERT INTO OP_CONSTR_T VALUES (
  1652, 127, 'IN',   'ThePivotizedAttributes',  'TheInputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1653, 127, 'IN',          'TheKeyAttribute',  'TheInputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1654, 127, 'COORD',     'IndexValues', 'ThePivotizedAttributes', NULL, NULL);

-- no conditions

INSERT INTO OP_ASSERT_T VALUES (
  1655, 127, 'REL_N_1', 'TheOutputConcept',    'TheInputConcept',   NULL, NULL);
-- an n:1 relationship from output to input exists (if there is a key attribute)
INSERT INTO OP_ASSERT_T VALUES (
  1656, 127, 'REL_N_K', 'TheKeyAttribute', NULL, NULL, NULL);
-- the key on the "many-side" is given by the Key attribute 
INSERT INTO OP_ASSERT_T VALUES (
  1657, 127, 'REL_1_K',  'TheKeyAttribute', NULL, NULL, NULL);
-- the key on the "one-side" is given by the Key attribute


-------------------------------------------------------
----                Operator Groups                ----
-------------------------------------------------------

-- Missing Values
INSERT INTO OP_GROUP_T VALUES (10, NULL, NULL, 'Handle Missing Values');

INSERT INTO OP_GROUP_T VALUES (1658, 10, 46,  'Assign a default');
INSERT INTO OP_GROUP_T VALUES (1659, 10, 47,  'Assign modal');
INSERT INTO OP_GROUP_T VALUES (1660, 10, 48,  'Assign median');
INSERT INTO OP_GROUP_T VALUES (1661, 10, 49,  'Assign average');
INSERT INTO OP_GROUP_T VALUES (1662, 10, 50,  'Assign stochastic');
INSERT INTO OP_GROUP_T VALUES (1663, 10, 53,  'Learn with regression SVM');
INSERT INTO OP_GROUP_T VALUES (1664, 10, 38,  'Delete incomplete records');

-- RowSelection / Segmentation
INSERT INTO OP_GROUP_T VALUES (11, NULL, NULL, 'Row Selection and Segmentation');

INSERT INTO OP_GROUP_T VALUES (1665, 11, 39,  'Row Selection - Query');
INSERT INTO OP_GROUP_T VALUES (1666, 11, 37,  'Row Selection - Random Sampling');
INSERT INTO OP_GROUP_T VALUES (1667, 11, 40,  'Segmentation - Stratified');
INSERT INTO OP_GROUP_T VALUES (1668, 11, 42,  'Segmentation - Partitioning');
INSERT INTO OP_GROUP_T VALUES (1669, 11, 122, 'Loop the following steps');
INSERT INTO OP_GROUP_T VALUES (1670, 11, 74,  'Undo a Segmentation');
INSERT INTO OP_GROUP_T VALUES (1671, 11, 125, 'Remove duplicate rows');

-- Time Operators
INSERT INTO OP_GROUP_T VALUES (12, NULL, NULL, 'Operators for time series');

INSERT INTO OP_GROUP_T VALUES (1672, 12, 67, 'Windowing');
INSERT INTO OP_GROUP_T VALUES (1673, 12, 68, 'Signal To Symbol');
INSERT INTO OP_GROUP_T VALUES (1674, 12, 70, 'Moving function');
INSERT INTO OP_GROUP_T VALUES (1675, 12, 71, 'Weighted moving function');
INSERT INTO OP_GROUP_T VALUES (1676, 12, 72, 'Exponential moving function');

-- Combining Multiple Concepts
INSERT INTO OP_GROUP_T VALUES (13, NULL, NULL, 'Combining Multiple Concepts');

INSERT INTO OP_GROUP_T VALUES (1677, 13, 34,  'MultiRelationalFeatureConstruction');
INSERT INTO OP_GROUP_T VALUES (1678, 13, 117, 'Union');
INSERT INTO OP_GROUP_T VALUES (1679, 13, 91,  'UnionByKey');
INSERT INTO OP_GROUP_T VALUES (1680, 13, 76,  'JoinByKey');

-- Feature Selection
INSERT INTO OP_GROUP_T VALUES (14, NULL, NULL, 'Feature Selection');

INSERT INTO OP_GROUP_T VALUES (1681, 14, 43,  'FeatureSelectionByAttributes');
INSERT INTO OP_GROUP_T VALUES (1682, 14, 88,  'FeatureSelectionWithSVM');
INSERT INTO OP_GROUP_T VALUES (1683, 14, 110, 'SimpleForwardFeatureSelectionGivenNoOfAttributes');
INSERT INTO OP_GROUP_T VALUES (1684, 14, 111, 'SimpleBackwardFeatureSelectionGivenNoOfAttributes');
INSERT INTO OP_GROUP_T VALUES (1685, 14, 112, 'FloatingForwardFeatureSelectionGivenNoOfAttributes');
INSERT INTO OP_GROUP_T VALUES (1686, 14, 113, 'FloatingBackwardFeatureSelectionGivenNoOfAttributes');
INSERT INTO OP_GROUP_T VALUES (1687, 14, 114, 'UserDefinedFeatureSelection');

-- Feature Construction
INSERT INTO OP_GROUP_T VALUES (15, NULL, NULL, 'Feature Construction');

INSERT INTO OP_GROUP_T VALUES (1688, 15, 90,  'GenericFeatureConstruction');
INSERT INTO OP_GROUP_T VALUES (1689, 15, 119, 'DateToNumeric');
INSERT INTO OP_GROUP_T VALUES (1690, 15, 126, 'Binarify');

---- Scaling
INSERT INTO OP_GROUP_T VALUES (16, 15, NULL, 'Scaling');

INSERT INTO OP_GROUP_T VALUES (1691, 16, 44,  'LinearScaling');
INSERT INTO OP_GROUP_T VALUES (1692, 16, 45,  'LogScaling');

---- Grouping
INSERT INTO OP_GROUP_T VALUES (18, NULL, NULL, 'Grouping');

INSERT INTO OP_GROUP_T VALUES (1693, 18, 101, 'GroupingGivenMinCardinality');
INSERT INTO OP_GROUP_T VALUES (1694, 18, 102, 'GroupingGivenNoOfGroups');
INSERT INTO OP_GROUP_T VALUES (1695, 18, 103, 'UserDefinedGrouping');
INSERT INTO OP_GROUP_T VALUES (1696, 18, 104, 'UserDefinedGroupingWithDefaultValue');
INSERT INTO OP_GROUP_T VALUES (1697, 18, 108, 'ErrorBasedGroupingGivenMinCardinality');
INSERT INTO OP_GROUP_T VALUES (1698, 18, 109, 'ErrorBasedGroupingGivenNoOfGroups');
INSERT INTO OP_GROUP_T VALUES (1699, 18, 107, 'ImplicitErrorBasedGrouping');

---- Discretization
INSERT INTO OP_GROUP_T VALUES (19, NULL, NULL, 'Discretization');

INSERT INTO OP_GROUP_T VALUES (1700, 19, 92,  'TimeIntervalManualDiscretization');
INSERT INTO OP_GROUP_T VALUES (1701, 19, 93,  'NumericalIntervalManualDiscretization');
INSERT INTO OP_GROUP_T VALUES (1702, 19, 95,  'EquidistantDiscretizationGivenWidth');
INSERT INTO OP_GROUP_T VALUES (1703, 19, 96,  'EquidistantDiscretizationGivenNoOfIntervals');
INSERT INTO OP_GROUP_T VALUES (1704, 19, 97,  'EquifrequentDiscretizationGivenCardinality');
INSERT INTO OP_GROUP_T VALUES (1705, 19, 98,  'EquifrequentDiscretizationGivenNoOfIntervals');
INSERT INTO OP_GROUP_T VALUES (1706, 19, 99,  'UserDefinedDiscretization');
INSERT INTO OP_GROUP_T VALUES (1707, 19, 100, 'ImplicitErrorBasedDiscretization');
INSERT INTO OP_GROUP_T VALUES (1708, 19, 105, 'ErrorBasedDiscretizationGivenMinCardinality');
INSERT INTO OP_GROUP_T VALUES (1709, 19, 106, 'ErrorBasedDiscretizationGivenNoOfIntervals');

-- Misc for single InputConcept
INSERT INTO OP_GROUP_T VALUES (20, NULL, NULL, 'Misc - single InputConcept');

INSERT INTO OP_GROUP_T VALUES (1710, 20, 77,  'SpecifiedStatistics');
INSERT INTO OP_GROUP_T VALUES (1711, 20, 115, 'FeatureConstructionWithTFIDF');
INSERT INTO OP_GROUP_T VALUES (1712, 20, 118, 'Materialize');
INSERT INTO OP_GROUP_T VALUES (1713, 20, 120, 'Apply a Yale model');
INSERT INTO OP_GROUP_T VALUES (1714, 20, 121, 'Create a primary key');
INSERT INTO OP_GROUP_T VALUES (1715, 20, 123, 'Pivotize');
INSERT INTO OP_GROUP_T VALUES (1716, 20, 124, 'Prepare a Yale experiment');
INSERT INTO OP_GROUP_T VALUES (1717, 20, 127, 'ReversePivotize');

-- Data Mining Step
INSERT INTO OP_GROUP_T VALUES (21, NULL, NULL, 'Data Mining Step');

INSERT INTO OP_GROUP_T VALUES (1718, 21, 84,  'Apriori');
INSERT INTO OP_GROUP_T VALUES (1719, 21, 89,  'SupportVectorMachineForClassification');
INSERT INTO OP_GROUP_T VALUES (1720, 21, 63,  'SupportVectorMachineForRegression');

-- Evaluation
INSERT INTO OP_GROUP_T VALUES (22, NULL, NULL, 'Evaluation');

INSERT INTO OP_GROUP_T VALUES (1721, 22, 73,  'ComputeSVMError');
INSERT INTO OP_GROUP_T VALUES (1722, 22, 116, 'EvaluateAdvantageOfTFIDFTransformation');

-------------------------------------------------------
