/*
 * Decompiled with CFR 0.152.
 */
package org.musoft.limo.print;

import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Vector;
import javax.print.PrintService;
import javax.print.attribute.EnumSyntax;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.Size2DSyntax;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.SheetCollate;
import org.musoft.limo.application.Application;
import org.musoft.limo.print.PrinterDialog;
import org.musoft.limo.print.PrinterSource;
import org.musoft.limo.print.PrinterTask;
import org.musoft.limo.util.LogFile;
import org.musoft.limo.util.Preferences;

public class Printer {
    private Application application;
    private Preferences preferences;
    private PrintService[] services;
    private PrinterJob pjob;
    private HashPrintRequestAttributeSet attributes;
    private boolean fitToPage;
    private PrinterSource[] printables;
    private boolean[] selection;
    static /* synthetic */ Class class$javax$print$attribute$standard$MediaPrintableArea;
    static /* synthetic */ Class class$javax$print$attribute$standard$Media;
    static /* synthetic */ Class class$javax$print$attribute$standard$OrientationRequested;
    static /* synthetic */ Class class$javax$print$attribute$standard$Copies;
    static /* synthetic */ Class class$javax$print$attribute$standard$SheetCollate;

    public Printer(Application application) {
        this.application = application;
        this.preferences = application.getPreferences();
    }

    public void startJob(PrinterSource[] printerSourceArray, boolean[] blArray) {
        if (this.services == null) {
            this.services = PrinterJob.lookupPrintServices();
        }
        this.pjob = PrinterJob.getPrinterJob();
        this.attributes = new HashPrintRequestAttributeSet();
        String string = this.preferences.getString("PrinterName");
        if (string != null) {
            for (int i = 0; i < this.services.length; ++i) {
                if (!this.services[i].getName().equals(string)) continue;
                try {
                    this.pjob.setPrintService(this.services[i]);
                }
                catch (PrinterException printerException) {}
                break;
            }
        }
        PageFormat pageFormat = this.pjob.defaultPage();
        float f = this.preferences.getFloat("PrinterImgX", (float)(pageFormat.getImageableX() * 25.4 / 72.0));
        float f2 = this.preferences.getFloat("PrinterImgY", (float)(pageFormat.getImageableY() * 25.4 / 72.0));
        float f3 = this.preferences.getFloat("PrinterImgWidth", (float)(pageFormat.getImageableWidth() * 25.4 / 72.0));
        float f4 = this.preferences.getFloat("PrinterImgHeight", (float)(pageFormat.getImageableHeight() * 25.4 / 72.0));
        float f5 = this.preferences.getFloat("PrinterPageWidth", (float)(pageFormat.getWidth() * 25.4 / 72.0));
        float f6 = this.preferences.getFloat("PrinterPageHeight", (float)(pageFormat.getHeight() * 25.4 / 72.0));
        String string2 = this.preferences.getString("PrinterPageOrientation", "portrait");
        int n = this.preferences.getInt("PrinterCopies", 1);
        int n2 = this.preferences.getInt("PrinterCollate", 1);
        if ("landscape".equals(string2)) {
            this.attributes.add(OrientationRequested.LANDSCAPE);
        } else if ("reverse-landscape".equals(string2)) {
            this.attributes.add(OrientationRequested.REVERSE_LANDSCAPE);
        } else if ("reverse-portrait".equals(string2)) {
            this.attributes.add(OrientationRequested.REVERSE_PORTRAIT);
        } else {
            this.attributes.add(OrientationRequested.PORTRAIT);
        }
        this.attributes.add(new Copies(n));
        this.attributes.add(n2 == 1 ? SheetCollate.COLLATED : SheetCollate.UNCOLLATED);
        this.attributes.add(new MediaPrintableArea(f, f2, f3, f4, 1000));
        this.attributes.add(MediaSize.findMedia(f5, f6, 1000));
        this.attributes.add(new JobName(this.application.getModel().getName(), null));
        this.fitToPage = this.preferences.getInt("PrinterFitToPage", 1) == 1;
        this.printables = printerSourceArray;
        this.selection = blArray;
    }

    public boolean showSelectionDialog() {
        PrinterDialog printerDialog = new PrinterDialog(this.application, this.printables);
        printerDialog.setSelection(this.selection);
        printerDialog.setFitToPage(this.fitToPage);
        printerDialog.setVisible(true);
        boolean bl = printerDialog.getResult();
        if (bl) {
            this.fitToPage = printerDialog.getFitToPage();
            this.preferences.putInt("PrinterFitToPage", this.fitToPage ? 1 : 0);
            this.selection = printerDialog.getSelection();
        }
        return bl;
    }

    public boolean showPrinterDialog() {
        boolean bl = this.pjob.printDialog(this.attributes);
        if (bl) {
            SheetCollate sheetCollate;
            Copies copies;
            Cloneable cloneable;
            String string = this.pjob.getPrintService().getName();
            this.preferences.putString("PrinterName", string);
            MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)this.attributes.get(class$javax$print$attribute$standard$MediaPrintableArea == null ? (class$javax$print$attribute$standard$MediaPrintableArea = Printer.class$("javax.print.attribute.standard.MediaPrintableArea")) : class$javax$print$attribute$standard$MediaPrintableArea);
            float f = mediaPrintableArea.getX(1000);
            float f2 = mediaPrintableArea.getY(1000);
            float f3 = mediaPrintableArea.getWidth(1000);
            float f4 = mediaPrintableArea.getHeight(1000);
            this.preferences.putFloat("PrinterImgX", f);
            this.preferences.putFloat("PrinterImgY", f2);
            this.preferences.putFloat("PrinterImgWidth", f3);
            this.preferences.putFloat("PrinterImgHeight", f4);
            Media media = (Media)this.attributes.get(class$javax$print$attribute$standard$Media == null ? (class$javax$print$attribute$standard$Media = Printer.class$("javax.print.attribute.standard.Media")) : class$javax$print$attribute$standard$Media);
            if (media instanceof MediaSizeName) {
                cloneable = MediaSize.getMediaSizeForName((MediaSizeName)media);
                this.preferences.putFloat("PrinterPageWidth", ((Size2DSyntax)cloneable).getX(1000));
                this.preferences.putFloat("PrinterPageHeight", ((Size2DSyntax)cloneable).getY(1000));
            }
            if ((cloneable = (OrientationRequested)this.attributes.get(class$javax$print$attribute$standard$OrientationRequested == null ? (class$javax$print$attribute$standard$OrientationRequested = Printer.class$("javax.print.attribute.standard.OrientationRequested")) : class$javax$print$attribute$standard$OrientationRequested)) != null) {
                this.preferences.putString("PrinterPageOrientation", ((EnumSyntax)cloneable).toString());
            }
            if ((copies = (Copies)this.attributes.get(class$javax$print$attribute$standard$Copies == null ? (class$javax$print$attribute$standard$Copies = Printer.class$("javax.print.attribute.standard.Copies")) : class$javax$print$attribute$standard$Copies)) != null) {
                this.preferences.putInt("PrinterCopies", copies.getValue());
            }
            if ((sheetCollate = (SheetCollate)this.attributes.get(class$javax$print$attribute$standard$SheetCollate == null ? (class$javax$print$attribute$standard$SheetCollate = Printer.class$("javax.print.attribute.standard.SheetCollate")) : class$javax$print$attribute$standard$SheetCollate)) != null) {
                this.preferences.putInt("PrinterCollate", sheetCollate.getValue());
            }
        }
        return bl;
    }

    public void print() {
        Vector<PrinterSource> vector = new Vector<PrinterSource>();
        for (int i = 0; i < this.printables.length; ++i) {
            if (!this.selection[i]) continue;
            vector.add(this.printables[i]);
        }
        this.pjob.setPrintable(new PrinterTask(vector.toArray(new PrinterSource[vector.size()]), 0.75, this.fitToPage));
        try {
            this.pjob.print(this.attributes);
        }
        catch (PrinterException printerException) {
            this.application.showStatus("Fehler: " + printerException.getMessage() + " (" + printerException.getClass().getName() + ")");
            LogFile.log(printerException);
        }
    }

    public void endJob() {
        this.pjob.cancel();
        this.pjob = null;
        this.attributes = null;
        this.printables = null;
        this.selection = null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

