/*
 * Decompiled with CFR 0.152.
 */
package org.musoft.limo.model;

import java.awt.Color;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.musoft.limo.model.ModelAttribute;
import org.musoft.limo.model.ModelElement;
import org.musoft.limo.model.ModelException;

public class ModelPrimitiveAttribute
extends ModelAttribute {
    public static final Class TYPE_BOOLEAN = class$java$lang$Boolean == null ? (class$java$lang$Boolean = ModelPrimitiveAttribute.class$("java.lang.Boolean")) : class$java$lang$Boolean;
    public static final Class TYPE_INTEGER = class$java$lang$Integer == null ? (class$java$lang$Integer = ModelPrimitiveAttribute.class$("java.lang.Integer")) : class$java$lang$Integer;
    public static final Class TYPE_STRING = class$java$lang$String == null ? (class$java$lang$String = ModelPrimitiveAttribute.class$("java.lang.String")) : class$java$lang$String;
    public static final Class TYPE_COLOR = class$java$awt$Color == null ? (class$java$awt$Color = ModelPrimitiveAttribute.class$("java.awt.Color")) : class$java$awt$Color;
    public static final Class TYPE_DATE = class$java$util$Date == null ? (class$java$util$Date = ModelPrimitiveAttribute.class$("java.util.Date")) : class$java$util$Date;
    public static final Class TYPE_URL = class$java$net$URL == null ? (class$java$net$URL = ModelPrimitiveAttribute.class$("java.net.URL")) : class$java$net$URL;
    private Class type;
    private Object value;
    private DateFormat dFormatter = DateFormat.getDateInstance(3);
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$net$URL;

    public ModelPrimitiveAttribute(ModelElement modelElement, String string, int n, Class clazz) {
        super(modelElement, string, n);
        this.type = clazz;
        this.dFormatter.setLenient(true);
        this.clear();
    }

    public Class getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        block19: {
            if (object instanceof String && this.type != TYPE_STRING) {
                try {
                    if (this.type == TYPE_BOOLEAN) {
                        if ("true".equals(object)) {
                            object = Boolean.TRUE;
                            break block19;
                        }
                        if ("false".equals(object)) {
                            object = Boolean.FALSE;
                            break block19;
                        }
                        throw new IllegalArgumentException();
                    }
                    if (this.type == TYPE_INTEGER) {
                        try {
                            object = new Integer((String)object);
                            break block19;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new IllegalArgumentException();
                        }
                    }
                    if (this.type == TYPE_COLOR) {
                        object = Color.decode(object.toString());
                        break block19;
                    }
                    if (this.type == TYPE_DATE) {
                        try {
                            object = this.dFormatter.parse((String)object);
                            break block19;
                        }
                        catch (ParseException parseException) {
                            throw new IllegalArgumentException(parseException.getMessage());
                        }
                    }
                    if (this.type != TYPE_URL) break block19;
                    try {
                        object = this.convertStringToURL((String)object);
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw new IllegalArgumentException(malformedURLException.getMessage());
                    }
                }
                catch (Exception exception) {
                    throw new ModelException("Illegaler Wert \"" + object + "\" f\ufffdr Attribut \"" + this.name + "\"", exception);
                }
            }
        }
        if (object != null && !this.type.isInstance(object)) {
            throw new ModelException("Illegaler Wert f\ufffdr Attribut \"" + this.name + "\"");
        }
        this.value = object;
        if (this.parent != null) {
            for (int i = 0; i < this.parent.getListenerCount(); ++i) {
                this.parent.getListener(i).onSetAttribute(this.parent, this);
                this.parent.getListener(i).onSetAttribute(this.parent, this.name, object);
            }
        }
        this.changed();
        if (this.parent != null) {
            this.parent.primitiveAttributeChanged(this);
        }
    }

    private URL convertStringToURL(String string) throws MalformedURLException {
        if (!string.startsWith("file:") && !string.startsWith("http:")) {
            string = "file:" + string;
        }
        return new URL(string);
    }

    public String toString() {
        if (this.isEmpty()) {
            return this.name + " = (null)";
        }
        return "name = " + this.value.toString();
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public void clear() {
        if (this.type == TYPE_BOOLEAN) {
            this.setValue(new Boolean(false));
        } else if (this.type == TYPE_INTEGER) {
            this.setValue(null);
        } else if (this.type == TYPE_STRING) {
            this.setValue(new String(""));
        } else if (this.type == TYPE_DATE) {
            this.setValue(new Date());
        } else {
            this.setValue(null);
        }
    }

    public boolean getBoolean() {
        if (this.value == null) {
            return false;
        }
        return (Boolean)this.value;
    }

    public int getInteger() {
        return this.value == null ? 0 : Integer.parseInt(this.value.toString());
    }

    private String toHex(int n, int n2) {
        String string = Integer.toHexString(n);
        while (string.length() < n2) {
            string = "0" + string;
        }
        return string;
    }

    public String getString() {
        if (this.value == null) {
            return null;
        }
        if (this.type == TYPE_COLOR) {
            Color color = (Color)this.value;
            return "0x" + this.toHex(color.getRed(), 2) + this.toHex(color.getGreen(), 2) + this.toHex(color.getBlue(), 2);
        }
        if (this.type == TYPE_DATE) {
            System.out.println("DateString von ModelPrimitiveAttribute: " + this.dFormatter.format(this.getDate()));
            return this.dFormatter.format(this.getDate());
        }
        return this.value.toString();
    }

    public Color getColor() {
        return this.value == null ? null : (Color)this.value;
    }

    public Date getDate() {
        return this.value == null ? null : (Date)this.value;
    }

    public URL getURL() {
        return this.value == null ? null : (URL)this.value;
    }

    public void setBoolean(boolean bl) {
        this.setValue(new Boolean(bl));
    }

    public void setInteger(int n) {
        this.setValue(new Integer(n));
    }

    public void setString(String string) {
        this.setValue(string);
    }

    public void setColor(Color color) {
        this.setValue(color);
    }

    public void setDate(Date date) {
        this.setValue(date);
    }

    public void setURL(URL uRL) {
        this.setValue(uRL);
    }

    public boolean canSetValue(Object object) {
        if (object == null) {
            return true;
        }
        if (this.type == (class$java$util$Date == null ? (class$java$util$Date = ModelPrimitiveAttribute.class$("java.util.Date")) : class$java$util$Date)) {
            if (!(object instanceof Date) && !(object instanceof String)) {
                return false;
            }
            if (object instanceof String) {
                try {
                    this.dFormatter.parse((String)object);
                }
                catch (ParseException parseException) {
                    return false;
                }
            }
            return true;
        }
        if (this.type == (class$java$lang$String == null ? (class$java$lang$String = ModelPrimitiveAttribute.class$("java.lang.String")) : class$java$lang$String)) {
            return object instanceof String || object == null;
        }
        if (this.type == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = ModelPrimitiveAttribute.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return true;
        }
        if (this.type == (class$java$lang$Integer == null ? (class$java$lang$Integer = ModelPrimitiveAttribute.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            if (!(object instanceof Integer) && !(object instanceof String)) {
                return false;
            }
            try {
                Integer.parseInt((String)object);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        if (this.type == (class$java$awt$Color == null ? (class$java$awt$Color = ModelPrimitiveAttribute.class$("java.awt.Color")) : class$java$awt$Color)) {
            return true;
        }
        if (this.type == (class$java$net$URL == null ? (class$java$net$URL = ModelPrimitiveAttribute.class$("java.net.URL")) : class$java$net$URL)) {
            try {
                this.convertStringToURL((String)object);
                return true;
            }
            catch (MalformedURLException malformedURLException) {
                return false;
            }
        }
        return false;
    }

    public Object[] getPossibleValues() {
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

