/*
 * Decompiled with CFR 0.152.
 */
package org.musoft.limo.model;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.kxml2.io.KXmlParser;
import org.kxml2.kdom.Document;
import org.kxml2.kdom.Element;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelAssociationEnd;
import org.musoft.limo.model.ModelAttribute;
import org.musoft.limo.model.ModelConnectionElement;
import org.musoft.limo.model.ModelElement;
import org.musoft.limo.model.ModelException;
import org.musoft.limo.model.ModelFigureElement;
import org.musoft.limo.model.ModelPrimitiveAttribute;
import org.musoft.limo.util.LogFile;
import org.xmlpull.v1.XmlPullParserException;

public class ModelLoader {
    private String[] prefix;
    private Hashtable unresolved;
    private Hashtable elements;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HH:mm:ss");

    public ModelLoader(String[] stringArray) {
        this.prefix = stringArray;
    }

    private ModelElement createInstance(String string) throws ModelException {
        for (int i = 0; i < this.prefix.length; ++i) {
            String string2 = this.prefix[i] + string;
            try {
                ModelElement modelElement = (ModelElement)Class.forName(string2).newInstance();
                return modelElement;
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            catch (InstantiationException instantiationException) {
                continue;
            }
            catch (Exception exception) {
                LogFile.log(exception);
            }
        }
        throw new ModelException("Unbekanntes XML-Element \"" + string + "\".");
    }

    private ModelElement traverse(Element element, ModelFigureElement modelFigureElement) throws ModelException {
        int n;
        Object object;
        String string;
        String string2 = element.getName();
        ModelElement modelElement = this.createInstance(string2);
        String string3 = element.getAttributeValue(null, "id");
        if (string3 != null) {
            if (this.elements.containsKey(string3)) {
                LogFile.log("Warnung: Doppelte ID " + string3, LogFile.WARNING);
            }
            this.elements.put(string3, modelElement);
        }
        if (modelElement instanceof ModelFigureElement) {
            string = element.getAttributeValue(null, "name");
            object = new Rectangle(0, 0, 0, 0);
            try {
                int n2 = Integer.parseInt(element.getAttributeValue(null, "x"));
                int n3 = Integer.parseInt(element.getAttributeValue(null, "y"));
                int n4 = Integer.parseInt(element.getAttributeValue(null, "width"));
                n = Integer.parseInt(element.getAttributeValue(null, "height"));
                object = new Rectangle(n2, n3, n4, n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            modelElement.setName(string);
            ((ModelFigureElement)modelElement).setBounds((Rectangle)object);
            ((ModelFigureElement)modelElement).setParent(modelFigureElement);
        } else if (modelElement instanceof ModelConnectionElement) {
            ((ModelConnectionElement)modelElement).setModel((Model)modelFigureElement);
            string = element.getAttributeValue(null, "name");
            ((ModelConnectionElement)modelElement).setName(string);
            object = new Point();
            Point point = new Point();
            Vector<Cloneable> vector = new Vector<Cloneable>();
            for (int i = 0; i < element.getChildCount(); ++i) {
                int n5;
                int n6;
                Element element2 = element.getElement(i);
                if (element2 == null) continue;
                if ("Start".equals(element2.getName())) {
                    n6 = Integer.parseInt(element2.getAttributeValue(null, "x"));
                    n5 = Integer.parseInt(element2.getAttributeValue(null, "y"));
                    object = new Point(n6, n5);
                    continue;
                }
                if ("Point".equals(element2.getName())) {
                    n6 = Integer.parseInt(element2.getAttributeValue(null, "x"));
                    n5 = Integer.parseInt(element2.getAttributeValue(null, "y"));
                    vector.add(new Point(n6, n5));
                    continue;
                }
                if (!"End".equals(element2.getName())) continue;
                n6 = Integer.parseInt(element2.getAttributeValue(null, "x"));
                n5 = Integer.parseInt(element2.getAttributeValue(null, "y"));
                point = new Point(n6, n5);
            }
            vector.insertElementAt((Cloneable)object, 0);
            vector.addElement(point);
            Point[] pointArray = new Point[vector.size()];
            for (n = 0; n < pointArray.length; ++n) {
                pointArray[n] = (Point)vector.elementAt(n);
            }
            ((ModelConnectionElement)modelElement).setPoints(pointArray);
        } else {
            throw new ModelException("XML-Element \"" + string2 + "\" pa\ufffdt nicht in Hierarchie.");
        }
        this.loadAttributes(element, modelElement);
        for (int i = 0; i < element.getChildCount(); ++i) {
            object = element.getElement(i);
            if (object == null || "Attribute".equals(((Element)object).getName()) || "Start".equals(((Element)object).getName()) || "Point".equals(((Element)object).getName()) || "End".equals(((Element)object).getName())) continue;
            this.traverse((Element)object, (ModelFigureElement)modelElement);
        }
        return modelElement;
    }

    private void loadAttributes(Element element, ModelElement modelElement) {
        for (int i = 0; i < element.getChildCount(); ++i) {
            Object object;
            Object object2;
            ModelAttribute modelAttribute;
            Element element2 = element.getElement(i);
            if (element2 == null || !"Attribute".equals(element2.getName())) continue;
            String string = element2.getAttributeValue(null, "name");
            int n = modelElement.indexOfAttribute(string);
            if (n == -1) {
                LogFile.log("Warnung: Ignoriere unbekanntes Attribut " + string + ".", LogFile.WARNING);
                continue;
            }
            ModelAttribute modelAttribute2 = modelElement.getAttribute(n);
            if (modelAttribute2 instanceof ModelPrimitiveAttribute) {
                modelAttribute = (ModelPrimitiveAttribute)modelAttribute2;
                object2 = element2.getAttributeValue(null, "value");
                if (object2 == null) {
                    object2 = "";
                    for (int j = 0; j < element2.getChildCount(); ++j) {
                        object = element2.getText(j);
                        if (object == null) continue;
                        object2 = (String)object2 + (String)object;
                    }
                    if ("".equals(object2)) {
                        object2 = null;
                    }
                }
                if (((ModelPrimitiveAttribute)modelAttribute).getType() == ModelPrimitiveAttribute.TYPE_DATE && object2 != null) {
                    try {
                        Date date = dateFormat.parse((String)object2);
                        ((ModelPrimitiveAttribute)modelAttribute).setDate(date);
                    }
                    catch (ParseException parseException) {
                        try {
                            object = DateFormat.getDateInstance(3, Locale.GERMAN);
                            ((ModelPrimitiveAttribute)modelAttribute).setDate(((DateFormat)object).parse((String)object2));
                        }
                        catch (ParseException parseException2) {
                            ((ModelPrimitiveAttribute)modelAttribute).setValue(object2);
                        }
                    }
                    continue;
                }
                ((ModelPrimitiveAttribute)modelAttribute).setValue(object2);
                continue;
            }
            if (!(modelAttribute2 instanceof ModelAssociationEnd)) continue;
            modelAttribute = (ModelAssociationEnd)modelAttribute2;
            if (((ModelAssociationEnd)modelAttribute).isMultiple()) {
                object2 = new Vector();
                for (int j = 0; j < element2.getChildCount(); ++j) {
                    object = element2.getElement(j);
                    if (object == null || !"Item".equals(((Element)object).getName())) continue;
                    String string2 = ((Element)object).getAttributeValue(null, "href");
                    if (string2 != null) {
                        ((Vector)object2).addElement(string2);
                        continue;
                    }
                    ((Vector)object2).addElement(((Element)object).getAttributeValue(null, "value"));
                }
                this.unresolved.put(modelAttribute, object2);
                continue;
            }
            object2 = element2.getAttributeValue(null, "href");
            if (object2 != null) {
                this.unresolved.put(modelAttribute, object2);
                continue;
            }
            this.unresolved.put(modelAttribute, element2.getAttributeValue(null, "value"));
        }
    }

    protected void resolve(Model model) {
        int n;
        Vector vector;
        ModelAssociationEnd modelAssociationEnd;
        Enumeration enumeration = this.unresolved.keys();
        while (enumeration.hasMoreElements()) {
            modelAssociationEnd = (ModelAssociationEnd)enumeration.nextElement();
            if (!(modelAssociationEnd.getParent() instanceof ModelFigureElement)) continue;
            if (modelAssociationEnd.isMultiple()) {
                vector = (Vector)this.unresolved.get(modelAssociationEnd);
                for (n = 0; n < vector.size(); ++n) {
                    if (!(vector.elementAt(n) instanceof String)) continue;
                    vector.setElementAt(this.resolve(model, (String)vector.elementAt(n)), n);
                }
                modelAssociationEnd.setValue(vector, false);
                continue;
            }
            modelAssociationEnd.setValue(this.resolve(model, (String)this.unresolved.get(modelAssociationEnd)), false);
        }
        enumeration = this.unresolved.keys();
        while (enumeration.hasMoreElements()) {
            modelAssociationEnd = (ModelAssociationEnd)enumeration.nextElement();
            if (!(modelAssociationEnd.getParent() instanceof ModelConnectionElement)) continue;
            if (modelAssociationEnd.isMultiple()) {
                vector = (Vector)this.unresolved.get(modelAssociationEnd);
                for (n = 0; n < vector.size(); ++n) {
                    if (!(vector.elementAt(n) instanceof String)) continue;
                    vector.setElementAt(this.resolve(model, (String)vector.elementAt(n)), n);
                }
                modelAssociationEnd.setValue(vector, false);
                continue;
            }
            modelAssociationEnd.setValue(this.resolve(model, (String)this.unresolved.get(modelAssociationEnd)), false);
        }
    }

    private Object resolve(Model model, String string) {
        ModelElement modelElement = string.startsWith("#") ? this.elements.get(string.substring(1)) : model.getElement(string);
        if (modelElement == null) {
            LogFile.log("Warnung: Kann Referenz auf " + string + " nicht aufl\ufffdsen.", LogFile.WARNING);
        }
        return modelElement;
    }

    public Model load(String string) throws IOException, XmlPullParserException {
        LogFile.log("Loading model \"" + string + "\"...");
        this.unresolved = new Hashtable();
        this.elements = new Hashtable();
        KXmlParser kXmlParser = new KXmlParser();
        Document document = new Document();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        kXmlParser.setInput(bufferedInputStream, "utf-8");
        LogFile.log("Parsing XML file...");
        document.parse(kXmlParser);
        ((InputStream)bufferedInputStream).close();
        LogFile.log("Traversing DOM tree...");
        for (int i = 0; i < document.getChildCount(); ++i) {
            Element element = document.getElement(i);
            if (element == null) continue;
            Model model = (Model)this.traverse(element, null);
            LogFile.log("Resolving references...");
            this.resolve(model);
            LogFile.log("Ok.");
            return model;
        }
        throw new IOException("Empty file.");
    }
}

