/*
 * Decompiled with CFR 0.152.
 */
package org.musoft.limo.inspector;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.musoft.limo.application.Application;
import org.musoft.limo.application.Resource;
import org.musoft.limo.inspector.MultipleAssociationsEndEditor;
import org.musoft.limo.model.ModelAssociationEnd;
import org.musoft.limo.model.ModelElement;

public class AssociatesChooser
extends JDialog {
    private ModelElement[] oldAssociates;
    private ModelElement[] newAssociates;
    private ModelElement[] posVal;
    private JList posList;
    private JList selList;
    private Application parent;
    private ModelAssociationEnd mae;
    public MultipleAssociationsEndEditor editor;

    public AssociatesChooser(Application application, String string, boolean bl, ModelElement[] modelElementArray, ModelElement[] modelElementArray2, MultipleAssociationsEndEditor multipleAssociationsEndEditor) {
        super(application, string, bl);
        this.parent = application;
        this.editor = multipleAssociationsEndEditor;
        this.oldAssociates = modelElementArray;
        this.posVal = modelElementArray2;
        this.createUI();
    }

    private void createUI() {
        this.getContentPane().add(this.createContentPanel());
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(this.parent);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AssociatesChooser.this.cancelAction();
            }
        });
    }

    private JPanel createContentPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(20, 20));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)this.createListPanel(), "Center");
        jPanel.add((Component)this.createButtonPanel(), "South");
        return jPanel;
    }

    private JPanel createListPanel() {
        DefaultListModel<ModelElement> defaultListModel = new DefaultListModel<ModelElement>();
        for (int i = 0; i < this.oldAssociates.length; ++i) {
            defaultListModel.addElement(this.oldAssociates[i]);
        }
        this.selList = new JList(defaultListModel);
        this.selList.setCellRenderer(new ElementListCellRenderer());
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new Dimension(400, 350));
        jScrollPane.setMaximumSize(new Dimension(400, 350));
        jScrollPane.setMinimumSize(new Dimension(400, 350));
        jScrollPane.setViewportView(this.selList);
        DefaultListModel<ModelElement> defaultListModel2 = new DefaultListModel<ModelElement>();
        for (int i = 0; i < this.posVal.length; ++i) {
            if (defaultListModel.contains(this.posVal[i])) continue;
            defaultListModel2.addElement(this.posVal[i]);
        }
        this.posList = new JList(defaultListModel2);
        this.posList.setCellRenderer(new ElementListCellRenderer());
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.setPreferredSize(new Dimension(400, 350));
        jScrollPane2.setMaximumSize(new Dimension(400, 350));
        jScrollPane2.setMinimumSize(new Dimension(400, 350));
        jScrollPane2.setViewportView(this.posList);
        JButton jButton = new JButton(">");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (AssociatesChooser.this.posList.getSelectedIndex() != -1) {
                    Object[] objectArray = AssociatesChooser.this.posList.getSelectedValues();
                    for (int i = 0; i < objectArray.length; ++i) {
                        ((DefaultListModel)AssociatesChooser.this.selList.getModel()).addElement((ModelElement)objectArray[i]);
                        ((DefaultListModel)AssociatesChooser.this.posList.getModel()).removeElement((ModelElement)objectArray[i]);
                    }
                }
            }
        });
        JButton jButton2 = new JButton("<");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (AssociatesChooser.this.selList.getSelectedIndex() != -1) {
                    Object[] objectArray = AssociatesChooser.this.selList.getSelectedValues();
                    for (int i = 0; i < objectArray.length; ++i) {
                        ((DefaultListModel)AssociatesChooser.this.posList.getModel()).addElement((ModelElement)objectArray[i]);
                        ((DefaultListModel)AssociatesChooser.this.selList.getModel()).removeElement((ModelElement)objectArray[i]);
                    }
                }
            }
        });
        Box box = Box.createVerticalBox();
        box.add(Box.createVerticalStrut(115));
        box.add(jButton);
        box.add(Box.createVerticalStrut(30));
        box.add(jButton2);
        box.add(Box.createVerticalStrut(115));
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(60, 350));
        jPanel.setMinimumSize(new Dimension(60, 350));
        jPanel.setMaximumSize(new Dimension(60, 350));
        jPanel.add(box);
        jPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jScrollPane2, "West");
        jPanel2.add((Component)jPanel, "Center");
        jPanel2.add((Component)jScrollPane, "East");
        return jPanel2;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1, 30, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 10, 5));
        JButton jButton = new JButton(Resource.getString("ACHOOSER_CANCEL"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AssociatesChooser.this.cancelAction();
            }
        });
        jButton.setPreferredSize(new Dimension(120, 25));
        jButton.setPreferredSize(new Dimension(120, 25));
        jButton.setPreferredSize(new Dimension(120, 25));
        JButton jButton2 = new JButton(Resource.getString("ACHOOSER_OK"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AssociatesChooser.this.okAction();
            }
        });
        jButton2.setPreferredSize(new Dimension(120, 25));
        jButton2.setPreferredSize(new Dimension(120, 25));
        jButton2.setPreferredSize(new Dimension(120, 25));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        return jPanel;
    }

    protected void okAction() {
        ListModel listModel = this.selList.getModel();
        this.newAssociates = new ModelElement[listModel.getSize()];
        for (int i = 0; i < listModel.getSize(); ++i) {
            this.newAssociates[i] = (ModelElement)listModel.getElementAt(i);
        }
        this.editor.newAssociates = this.newAssociates;
        this.dispose();
    }

    private void cancelAction() {
        this.newAssociates = this.oldAssociates;
        this.dispose();
    }

    public ModelElement[] getSelection() {
        return this.newAssociates;
    }

    class ElementListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        ElementListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object != null) {
                String string = ((ModelElement)object).getFullName();
                this.setText(string);
                if (bl) {
                    this.setBackground(jList.getSelectionBackground());
                    this.setForeground(jList.getSelectionForeground());
                } else {
                    this.setBackground(jList.getBackground());
                    this.setForeground(jList.getForeground());
                }
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            this.setOpaque(true);
            return this;
        }
    }
}

