/*
 * Decompiled with CFR 0.152.
 */
package org.musoft.limo.hypertext;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import org.musoft.limo.application.Application;
import org.musoft.limo.application.Resource;
import org.musoft.limo.hypertext.HypertextToolBar;
import org.musoft.limo.hypertext.HypertextViewer;
import org.musoft.limo.util.LogFile;
import org.musoft.limo.util.SimpleFileFilter;

public class HypertextEditor
extends JPanel
implements KeyListener {
    private static final String HTMLBODY = "<HTML>\n<BODY>\n</BODY>\n</HTML>\n";
    private JTextArea textarea;
    private Application parent;
    private URL fileurl = null;
    private boolean modified = false;
    private SyntaxHighlighter mySyntaxHighlighter = new SyntaxHighlighter();
    private HypertextViewer previewViewer;
    private JLabel titleLabel;

    public void highlight(JTextComponent jTextComponent) {
        this.removeHighlights(jTextComponent);
        try {
            Highlighter highlighter = jTextComponent.getHighlighter();
            Document document = jTextComponent.getDocument();
            String string = document.getText(0, document.getLength());
            int n = 0;
            while ((n = string.indexOf("<", n)) >= 0) {
                highlighter.addHighlight(n, string.indexOf(">", n) + 1, this.mySyntaxHighlighter);
                n = string.indexOf(">", n) + 1;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void removeHighlights(JTextComponent jTextComponent) {
        Highlighter highlighter = jTextComponent.getHighlighter();
        Highlighter.Highlight[] highlightArray = highlighter.getHighlights();
        for (int i = 0; i < highlightArray.length; ++i) {
            if (!(highlightArray[i].getPainter() instanceof SyntaxHighlighter)) continue;
            highlighter.removeHighlight(highlightArray[i]);
        }
    }

    public HypertextEditor(Application application) {
        super(new BorderLayout());
        this.parent = application;
        this.textarea = new JTextArea(10, 10);
        this.textarea.setEditable(true);
        this.textarea.addKeyListener(this);
        this.titleLabel = new JLabel("");
        this.add((Component)new HypertextToolBar(this), "North");
        this.add((Component)new JScrollPane(this.textarea), "Center");
        this.add((Component)this.titleLabel, "South");
    }

    public boolean setPage(URL uRL) {
        this.fileurl = uRL;
        try {
            int n;
            FileReader fileReader = new FileReader(new File(uRL.getFile()));
            char[] cArray = new char[4096];
            this.textarea.setText("");
            while ((n = fileReader.read(cArray)) != -1) {
                this.textarea.append(new String(cArray, 0, n));
            }
            this.textarea.setCaretPosition(0);
            this.highlight(this.textarea);
            this.setModified(false);
            return true;
        }
        catch (Exception exception) {
            LogFile.log(exception);
            this.parent.showStatus(exception.getMessage());
            return false;
        }
    }

    public URL getPage() {
        return this.fileurl;
    }

    public void preview() {
        if (this.previewViewer != null) {
            this.parent.removeComponentFromTab(this.previewViewer);
        }
        if (this.modified) {
            this.promptSaveAs();
        }
        this.previewViewer = new HypertextViewer(this.parent, Resource.getString("HTML_PREVIEW"));
        this.previewViewer.setPage(this.fileurl);
        this.parent.showComponentInTab(this.previewViewer, 1, true);
    }

    public void promptNew() {
        if (!this.askBeforeClose()) {
            return;
        }
        this.textarea.setText(HTMLBODY);
        this.highlight(this.textarea);
        this.setModified(false);
    }

    public void promptOpen() {
        if (!this.askBeforeClose()) {
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setDialogTitle(Resource.getString("DLG_HTMLLOAD"));
        jFileChooser.setFileFilter(new SimpleFileFilter(Resource.getString("FILE_EXTENSION_HTML"), Resource.getString("FILE_DESCRIPTION_HTML")));
        if (this.fileurl != null) {
            jFileChooser.setCurrentDirectory(new File(this.fileurl.getFile()));
        }
        if (jFileChooser.showOpenDialog(this) == 0) {
            try {
                String string = jFileChooser.getSelectedFile().toURL().getFile();
                if (!string.endsWith(Resource.getString("FILE_EXTENSION_HTML"))) {
                    string = string + "." + Resource.getString("FILE_EXTENSION_HTML");
                    this.setPage(new URL("file://" + string));
                } else {
                    this.setPage(jFileChooser.getSelectedFile().toURL());
                }
            }
            catch (Exception exception) {
                LogFile.log(exception);
            }
        }
    }

    public void promptSaveAs() {
        if (this.fileurl != null) {
            try {
                FileWriter fileWriter = new FileWriter(new File(this.fileurl.getFile()));
                fileWriter.write(this.textarea.getText());
                fileWriter.close();
                this.setModified(false);
                return;
            }
            catch (IOException iOException) {
                LogFile.log(iOException);
            }
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setDialogTitle(Resource.getString("DLG_HTMLSAVE"));
        jFileChooser.setFileFilter(new SimpleFileFilter(Resource.getString("FILE_EXTENSION_HTML"), Resource.getString("FILE_DESCRIPTION_HTML")));
        if (this.fileurl != null) {
            jFileChooser.setCurrentDirectory(new File(this.fileurl.getFile()));
            jFileChooser.setSelectedFile(new File(this.fileurl.getFile()));
        }
        if (jFileChooser.showSaveDialog(this) == 0) {
            try {
                String string = jFileChooser.getSelectedFile().toURL().getFile();
                if (!string.endsWith(Resource.getString("FILE_EXTENSION_HTML"))) {
                    string = string + "." + Resource.getString("FILE_EXTENSION_HTML");
                }
                FileWriter fileWriter = new FileWriter(string);
                fileWriter.write(this.textarea.getText());
                fileWriter.close();
                this.fileurl = new URL("file://" + string);
                this.setModified(false);
            }
            catch (Exception exception) {
                LogFile.log(exception);
            }
        }
    }

    private boolean askBeforeClose() {
        if (!this.modified) {
            return true;
        }
        int n = JOptionPane.showConfirmDialog(this, Resource.getString("QUEST_HTMLSAVECLOSE"), Resource.getString("HTML_CLOSE"), 1);
        if (n == 2) {
            return false;
        }
        if (n == 0) {
            this.promptSaveAs();
        }
        return true;
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.highlight(this.textarea);
        this.setModified(true);
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void setModified(boolean bl) {
        this.modified = bl;
        if (this.parent != null) {
            String string = bl ? "*" : "";
            string = this.fileurl != null ? string + this.fileurl.getFile() : string + Resource.getString("PRJ_UNTITLED");
            this.titleLabel.setText(string);
        }
    }

    public String toString() {
        return Resource.getString("COMP_HTMLEDITOR");
    }

    class SyntaxHighlighter
    extends DefaultHighlighter.DefaultHighlightPainter {
        public SyntaxHighlighter() {
            super(new Color(220, 215, 215));
        }
    }
}

