/*
 * Decompiled with CFR 0.152.
 */
package org.musoft.limo.drawing;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.jhotdraw.figures.PolyLineHandle;
import org.jhotdraw.figures.RectangleFigure;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.framework.Handle;
import org.jhotdraw.standard.ChangeConnectionEndHandle;
import org.jhotdraw.standard.ChangeConnectionStartHandle;
import org.jhotdraw.standard.HandleTracker;
import org.jhotdraw.util.ColorMap;
import org.musoft.limo.drawing.ModelConnection;
import org.musoft.limo.drawing.ModelFigure;
import org.musoft.limo.model.ModelConnectionElement;
import org.musoft.limo.model.ModelFigureElement;

public class ModelHandleTracker
extends HandleTracker {
    private static int CHANGE_START = 1;
    private static int CHANGE_END = 2;
    private static int CHANGE_POINT = 3;
    private Handle handle;
    private int type;
    private ModelConnectionElement element;
    private Figure lastFigure;
    private ModelFigureElement parent;
    private Figure borderFigure;

    public ModelHandleTracker(DrawingEditor drawingEditor, Handle handle) {
        super(drawingEditor, handle);
        this.handle = handle;
        if (handle instanceof ChangeConnectionStartHandle) {
            this.type = CHANGE_START;
        } else if (handle instanceof ChangeConnectionEndHandle) {
            this.type = CHANGE_END;
        } else if (handle instanceof PolyLineHandle) {
            this.type = CHANGE_POINT;
        }
    }

    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
        super.mouseDrag(mouseEvent, n, n2);
        if (this.type == CHANGE_START || this.type == CHANGE_END) {
            Figure figure = this.drawing().findFigureWithout(n, n2, this.handle.owner());
            if (figure == this.borderFigure) {
                figure = this.lastFigure;
            } else {
                this.lastFigure = figure;
            }
            if (figure instanceof ModelFigure) {
                ModelFigureElement modelFigureElement = ((ModelFigure)figure).getElement();
                ModelConnection modelConnection = (ModelConnection)this.handle.owner();
                boolean bl = this.type == CHANGE_START ? modelConnection.canConnect(figure, modelConnection.endFigure()) : modelConnection.canConnect(modelConnection.startFigure(), figure);
                this.setDecoration(modelFigureElement, bl ? Color.GREEN : Color.RED);
            } else {
                this.setDecoration(null, null);
            }
        }
    }

    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
        PolyLineHandle polyLineHandle;
        super.mouseUp(mouseEvent, n, n2);
        this.setDecoration(null, null);
        if (this.type == CHANGE_POINT && (polyLineHandle = (PolyLineHandle)this.handle).owner() instanceof ModelConnection) {
            ModelConnection modelConnection = (ModelConnection)polyLineHandle.owner();
            modelConnection.checkPoint(new Point(n, n2));
        }
    }

    private void setDecoration(ModelFigureElement modelFigureElement, Color color) {
        if (modelFigureElement != this.parent) {
            if (this.parent != null) {
                this.parent = null;
                this.drawing().orphan(this.borderFigure);
                this.borderFigure.release();
                this.borderFigure = null;
            }
            if (modelFigureElement != null) {
                this.parent = modelFigureElement;
                this.borderFigure = new RectangleFigure();
                Rectangle rectangle = modelFigureElement.getBounds();
                this.borderFigure.displayBox(new Rectangle(rectangle.x - 4, rectangle.y - 4, rectangle.width + 8, rectangle.height + 8));
                this.borderFigure.setAttribute(FigureAttributeConstant.getConstant("FrameColor"), (Object)color);
                this.borderFigure.setAttribute(FigureAttributeConstant.getConstant("FillColor"), (Object)ColorMap.color("None"));
                this.drawing().add(this.borderFigure);
                this.drawing().sendToBack(this.borderFigure);
            }
        }
    }
}

