/*
 * Decompiled with CFR 0.152.
 */
package org.musoft.limo.drawing;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.standard.StandardDrawing;
import org.musoft.limo.drawing.ModelConnection;
import org.musoft.limo.drawing.ModelFigure;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelAssociationEnd;
import org.musoft.limo.model.ModelAttribute;
import org.musoft.limo.model.ModelConnectionElement;
import org.musoft.limo.model.ModelElement;
import org.musoft.limo.model.ModelFigureElement;
import org.musoft.limo.model.ModelListener;
import org.musoft.limo.model.ModelPrimitiveAttribute;

public class ModelDrawing
extends StandardDrawing
implements ModelListener {
    private Model model;
    private Hashtable elements = new Hashtable();
    private Hashtable connections = new Hashtable();

    public ModelDrawing(Model model) {
        this.model = model;
        this.model.addListener(this);
        this.addChildFigures(model);
        this.addChildFigures2(model);
        this.addConnectionFigures(model);
    }

    private void addChildFigures(ModelFigureElement modelFigureElement) {
        for (int i = 0; i < modelFigureElement.getChildCount(); ++i) {
            ModelFigureElement modelFigureElement2 = modelFigureElement.getChild(i);
            this.onCreateChild(modelFigureElement, modelFigureElement2);
            ModelFigure modelFigure = this.getElementFigure(modelFigureElement2);
            if (modelFigure != null) {
                modelFigure.onSetParent(modelFigureElement);
                modelFigure.onSetBounds(modelFigureElement2);
                modelFigure.onSetName(modelFigureElement2);
            }
            if (modelFigureElement2 instanceof Model) continue;
            this.addChildFigures(modelFigureElement2);
        }
    }

    private void addChildFigures2(ModelFigureElement modelFigureElement) {
        for (int i = 0; i < modelFigureElement.getChildCount(); ++i) {
            ModelFigureElement modelFigureElement2 = modelFigureElement.getChild(i);
            ModelFigure modelFigure = this.getElementFigure(modelFigureElement2);
            if (modelFigure != null) {
                for (int j = 0; j < modelFigureElement2.getAttributeCount(); ++j) {
                    ModelAttribute modelAttribute;
                    ModelAttribute modelAttribute2 = modelFigureElement2.getAttribute(j);
                    if (modelAttribute2.isEmpty()) continue;
                    if (modelAttribute2 instanceof ModelPrimitiveAttribute) {
                        modelAttribute = (ModelPrimitiveAttribute)modelAttribute2;
                        modelFigure.onSetAttribute(modelFigureElement2, modelAttribute.getName(), ((ModelPrimitiveAttribute)modelAttribute).getValue());
                        continue;
                    }
                    if (!(modelAttribute2 instanceof ModelAssociationEnd)) continue;
                    modelAttribute = (ModelAssociationEnd)modelAttribute2;
                    if (((ModelAssociationEnd)modelAttribute).isMultiple()) {
                        Vector vector = (Vector)((ModelAssociationEnd)modelAttribute).getValue();
                        for (int k = 0; k < vector.size(); ++k) {
                            modelFigure.onAddAssociate(modelFigureElement2, (ModelAssociationEnd)modelAttribute, (ModelElement)vector.elementAt(k));
                        }
                        continue;
                    }
                    modelFigure.onAddAssociate(modelFigureElement2, (ModelAssociationEnd)modelAttribute, (ModelElement)((ModelAssociationEnd)modelAttribute).getValue());
                }
            }
            if (modelFigureElement2 instanceof Model) continue;
            this.addChildFigures2(modelFigureElement2);
        }
    }

    private void addConnectionFigures(Model model) {
        for (int i = 0; i < model.getConnectionCount(); ++i) {
            ModelConnectionElement modelConnectionElement = model.getConnection(i);
            this.onCreateConnection(model, modelConnectionElement);
            ModelConnection modelConnection = this.getConnectionFigure(modelConnectionElement);
            if (modelConnection == null) continue;
            modelConnection.restoreLabelPosition();
        }
    }

    public Figure orphan(Figure figure) {
        if (figure instanceof ModelFigure && ((ModelFigure)figure).getElement() != null) {
            ModelFigure modelFigure = (ModelFigure)figure;
            if (modelFigure.getElement().canDestroy()) {
                ((ModelFigure)figure).getElement().destroy();
            }
        } else if (figure instanceof ModelConnection && ((ModelConnection)figure).getElement() != null) {
            ModelConnection modelConnection = (ModelConnection)figure;
            if (modelConnection.getElement().canDestroy()) {
                ((ModelConnection)figure).getElement().destroy();
            }
        } else if (figure instanceof ModelConnection.Label) {
            if (((ModelConnection.Label)figure).canDelete()) {
                super.orphan(figure);
            }
        } else {
            super.orphan(figure);
        }
        return figure;
    }

    public void putElementFigure(ModelElement modelElement, ModelFigure modelFigure) {
        if (modelFigure == null) {
            this.elements.remove(modelElement);
        } else {
            this.elements.put(modelElement, modelFigure);
        }
    }

    public ModelFigure getElementFigure(ModelElement modelElement) {
        return (ModelFigure)this.elements.get(modelElement);
    }

    public void putConnectionFigure(ModelConnectionElement modelConnectionElement, ModelConnection modelConnection) {
        if (modelConnection == null) {
            this.connections.remove(modelConnectionElement);
        } else {
            this.connections.put(modelConnectionElement, modelConnection);
        }
    }

    public ModelConnection getConnectionFigure(ModelConnectionElement modelConnectionElement) {
        return (ModelConnection)this.connections.get(modelConnectionElement);
    }

    public boolean containsNoFigures() {
        return this.elements.isEmpty() && this.connections.isEmpty();
    }

    public void destroy() {
        ModelElement modelElement;
        Enumeration enumeration = this.elements.keys();
        Enumeration enumeration2 = this.connections.keys();
        this.model.removeListener(this);
        while (enumeration.hasMoreElements()) {
            modelElement = (ModelElement)enumeration.nextElement();
            modelElement.removeListener((ModelFigure)this.elements.get(modelElement));
        }
        while (enumeration2.hasMoreElements()) {
            modelElement = (ModelElement)enumeration2.nextElement();
            modelElement.removeListener((ModelConnection)this.connections.get(modelElement));
        }
    }

    public void onAddChild(ModelFigureElement modelFigureElement, ModelElement modelElement) {
    }

    public void onCreateChild(ModelFigureElement modelFigureElement, ModelElement modelElement) {
    }

    public void onDestroy(ModelElement modelElement) {
    }

    public void onRemoveChild(ModelFigureElement modelFigureElement, ModelElement modelElement) {
    }

    public void onSetAttribute(ModelElement modelElement, String string, Object object) {
    }

    public void onSetBounds(ModelFigureElement modelFigureElement) {
    }

    public void onSetName(ModelElement modelElement) {
    }

    public void onSetParent(ModelFigureElement modelFigureElement) {
    }

    public void onSetPosition(ModelFigureElement modelFigureElement, int n, int n2) {
    }

    public Model getModel() {
        return this.model;
    }

    public void onAddAssociate(ModelElement modelElement, ModelAssociationEnd modelAssociationEnd, ModelElement modelElement2) {
    }

    public void onRemoveAssociate(ModelElement modelElement, ModelAssociationEnd modelAssociationEnd, ModelElement modelElement2) {
    }

    public void onCreateConnection(Model model, ModelConnectionElement modelConnectionElement) {
    }

    public void onSetConnectionStart(ModelConnectionElement modelConnectionElement) {
    }

    public void onSetConnectionEnd(ModelConnectionElement modelConnectionElement) {
    }

    public void onSetConnectionPoints(ModelConnectionElement modelConnectionElement) {
    }

    public void onSetAttribute(ModelElement modelElement, ModelPrimitiveAttribute modelPrimitiveAttribute) {
    }

    public void onSetDirty() {
    }
}

