/*
 * Decompiled with CFR 0.152.
 */
package org.musoft.limo.drawing;

import java.awt.Point;
import java.awt.event.MouseEvent;
import org.jhotdraw.figures.LineConnection;
import org.jhotdraw.framework.ConnectionFigure;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.standard.ConnectionTool;
import org.musoft.limo.application.Application;
import org.musoft.limo.application.Resource;
import org.musoft.limo.drawing.ModelConnection;
import org.musoft.limo.drawing.ModelDrawing;
import org.musoft.limo.drawing.ModelFigure;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelAssociationEnd;
import org.musoft.limo.model.ModelAttribute;
import org.musoft.limo.model.ModelConnectionElement;
import org.musoft.limo.model.ModelElement;
import org.musoft.limo.model.ModelFigureElement;
import org.musoft.limo.util.LogFile;

public abstract class ModelConnectionTool
extends ConnectionTool {
    private Application parent;
    private Class startType;
    private String startName;
    private Class endType;
    private String endName;
    private Class modelClass;
    private ModelConnectionElement newElement;

    public ModelConnectionTool(Application application, Class clazz, Class clazz2, String string, Class clazz3, String string2) {
        super(application, null);
        this.parent = application;
        this.startType = clazz2;
        this.startName = string;
        this.endType = clazz3;
        this.endName = string2;
        this.modelClass = clazz;
    }

    protected ConnectionFigure createConnection() {
        LineConnection lineConnection = new LineConnection();
        lineConnection.setStartDecoration(null);
        lineConnection.setEndDecoration(null);
        return lineConnection;
    }

    protected abstract ModelConnectionElement createElement(Model var1, ModelElement var2, ModelElement var3);

    private ModelConnection getConflictingConnection(ModelConnectionElement modelConnectionElement) {
        ModelFigureElement modelFigureElement = modelConnectionElement.getStart();
        ModelFigureElement modelFigureElement2 = modelConnectionElement.getEnd();
        for (int i = 0; i < modelFigureElement.getAttributeCount(); ++i) {
            ModelAttribute modelAttribute = modelFigureElement.getAttribute(i);
            if (!(modelAttribute instanceof ModelAssociationEnd)) continue;
            ModelAssociationEnd modelAssociationEnd = (ModelAssociationEnd)modelAttribute;
            for (int j = 0; j < modelAssociationEnd.getAssociateCount(); ++j) {
                ModelElement modelElement = modelAssociationEnd.getAssociate(j);
                if (!(modelElement instanceof ModelConnectionElement)) continue;
                ModelConnectionElement modelConnectionElement2 = (ModelConnectionElement)modelElement;
                ModelFigureElement modelFigureElement3 = modelConnectionElement2.getStart();
                ModelFigureElement modelFigureElement4 = modelConnectionElement2.getEnd();
                if (modelConnectionElement2 == modelConnectionElement || modelConnectionElement2.getPoints() != null && modelConnectionElement2.getPoints().length >= 3 || (modelFigureElement3 != modelFigureElement || modelFigureElement4 != modelFigureElement2) && (modelFigureElement3 != modelFigureElement2 || modelFigureElement4 != modelFigureElement)) continue;
                return ((ModelDrawing)this.drawing()).getConnectionFigure(modelConnectionElement2);
            }
        }
        return null;
    }

    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
        block12: {
            ConnectionFigure connectionFigure = (ConnectionFigure)this.getAddedFigure();
            super.mouseUp(mouseEvent, n, n2);
            this.newElement = null;
            if (connectionFigure != null) {
                ModelFigure modelFigure = (ModelFigure)connectionFigure.startFigure();
                ModelFigure modelFigure2 = (ModelFigure)connectionFigure.endFigure();
                if (modelFigure != null && modelFigure2 != null) {
                    ModelFigureElement modelFigureElement = modelFigure.getElement();
                    ModelFigureElement modelFigureElement2 = modelFigure2.getElement();
                    this.drawing().remove(connectionFigure);
                    connectionFigure.release();
                    try {
                        ModelConnectionElement modelConnectionElement = (ModelConnectionElement)this.modelClass.newInstance();
                        if (modelConnectionElement.canConnect(modelFigureElement, modelFigureElement2)) {
                            this.newElement = this.createElement(((ModelDrawing)this.drawing()).getModel(), modelFigureElement, modelFigureElement2);
                            ModelConnection modelConnection = this.getConflictingConnection(this.newElement);
                            if (modelConnection != null) {
                                ModelConnection modelConnection2 = ((ModelDrawing)this.drawing()).getConnectionFigure(this.newElement);
                                Point point = modelConnection2.startPoint();
                                Point point2 = modelConnection2.endPoint();
                                Point point3 = modelConnection2.center();
                                double d = Math.abs(Math.abs(point.x - point2.x));
                                double d2 = Math.abs(Math.abs(point.y - point2.y));
                                double d3 = Math.sqrt(d * d + d2 * d2);
                                double d4 = Math.atan(d2 / d);
                                int n3 = (int)(Math.sin(d4) * d3 / 2.0);
                                int n4 = (int)(Math.cos(d4) * d3 / 2.0);
                                Point point4 = new Point(point3.x + n3, point3.y + n4);
                                modelConnection2.insertPointAt(point4, 1);
                                Point point5 = new Point(point3.x - n3, point3.y - n4);
                                modelConnection.insertPointAt(point5, 1);
                            }
                            break block12;
                        }
                        this.parent.showStatus(Resource.getString("TXT_ILLEGAL_CONNECTION") + ": " + modelFigureElement.getName() + " --> " + modelFigureElement2.getName());
                        this.parent.getToolkit().beep();
                    }
                    catch (Exception exception) {
                        LogFile.log(exception);
                    }
                } else if (modelFigure == null && modelFigure2 == null) {
                    this.drawing().remove(connectionFigure);
                    connectionFigure.release();
                    Figure figure = this.drawing().findFigure(n, n2);
                    if (figure instanceof ModelFigure) {
                        try {
                            ModelFigureElement modelFigureElement = ((ModelFigure)figure).getElement();
                            ModelConnectionElement modelConnectionElement = (ModelConnectionElement)this.modelClass.newInstance();
                            if (modelConnectionElement.canConnect(modelFigureElement, modelFigureElement)) {
                                this.newElement = this.createElement(((ModelDrawing)this.drawing()).getModel(), modelFigureElement, modelFigureElement);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    public ModelConnectionElement getElement() {
        return this.newElement;
    }

    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
        super.mouseDrag(mouseEvent, n, n2);
        this.parent.followPointer(n, n2);
    }
}

