/*
 * Decompiled with CFR 0.152.
 */
package org.musoft.limo.application;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.JHotDrawRuntimeException;
import org.jhotdraw.framework.Tool;
import org.jhotdraw.standard.AbstractTool;
import org.jhotdraw.standard.ToolButton;
import org.jhotdraw.util.Iconkit;
import org.musoft.limo.application.Application;
import org.musoft.limo.application.ApplicationListener;
import org.musoft.limo.application.MyToolButton;
import org.musoft.limo.application.Resource;
import org.musoft.limo.application.StaticJButton;
import org.musoft.limo.drawing.ModelConnection;
import org.musoft.limo.drawing.ModelDrawing;
import org.musoft.limo.drawing.ModelFigure;
import org.musoft.limo.drawing.ModelSelectionTool;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelConnectionElement;
import org.musoft.limo.model.ModelElement;
import org.musoft.limo.model.ModelFigureElement;

public class ToolBar
extends JToolBar
implements ApplicationListener {
    public static final int ACTIVE = 0;
    public static final int INACTIVE = 1;
    public static final int INVISIBLE = 2;
    protected Application parent;
    private Hashtable groupButtons;
    private Hashtable groupState;
    private Hashtable tools;
    private StaticJButton printButton;

    public ToolBar(Application application) {
        this.parent = application;
        this.parent.addListener(this);
        this.setOrientation(0);
        this.groupButtons = new Hashtable();
        this.groupState = new Hashtable();
        this.tools = new Hashtable();
        this.createGeneralTools();
        this.addGroup("general");
        this.showGroup("general", 0);
        this.createDrawingTools();
        this.addGroup("drawing");
        this.showGroup("drawing", 0);
    }

    public void addButton(String string, JButton jButton) {
        if (this.groupButtons.containsKey(string)) {
            ((Vector)this.groupButtons.get(string)).add(jButton);
        } else {
            Vector<JButton> vector = new Vector<JButton>();
            vector.add(jButton);
            this.groupState.put(string, new Integer(0));
            this.groupButtons.put(string, vector);
        }
        this.tools.put(jButton.getToolTipText(), jButton);
    }

    public void addJComponent(String string, JComponent jComponent) {
        if (this.groupButtons.containsKey(string)) {
            ((Vector)this.groupButtons.get(string)).add(jComponent);
        } else {
            Vector<JComponent> vector = new Vector<JComponent>();
            vector.add(jComponent);
            this.groupState.put(string, new Integer(0));
            this.groupButtons.put(string, vector);
        }
    }

    public void showGroup(String string, int n) {
        if (!this.groupButtons.containsKey(string)) {
            return;
        }
        if (n != 2) {
            Vector vector = (Vector)this.groupButtons.get(string);
            boolean bl = n == 0;
            for (int i = 0; i < vector.size(); ++i) {
                ((JComponent)vector.get(i)).setVisible(true);
                ((JComponent)vector.get(i)).setEnabled(bl);
            }
        } else {
            Vector vector = (Vector)this.groupButtons.get(string);
            boolean bl = false;
            for (int i = 0; i < vector.size(); ++i) {
                ((JComponent)vector.get(i)).setVisible(bl);
            }
        }
    }

    public void addGroup(String string) {
        this.addJComponent(string, new JToolBar.Separator());
        if (!this.groupButtons.containsKey(string)) {
            return;
        }
        Vector vector = (Vector)this.groupButtons.get(string);
        for (int i = 0; i < vector.size(); ++i) {
            this.add((JComponent)vector.get(i));
            ((JComponent)vector.get(i)).setEnabled(true);
        }
    }

    private void selectButton(JButton jButton) {
        jButton.setSelected(true);
    }

    protected void createGeneralTools() {
        Iconkit iconkit = Iconkit.instance();
        if (iconkit == null) {
            throw new JHotDrawRuntimeException("Iconkit instance isn't set");
        }
        StaticJButton staticJButton = new StaticJButton(Resource.getString("TOOL_NEWPROJECT"), new ImageIcon(iconkit.loadImageResource(Resource.getString("TOOLIMG_NEWPROJECT") + ".png")));
        staticJButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToolBar.this.parent.promptNew();
            }
        });
        this.addButton("general", staticJButton);
        staticJButton = new StaticJButton(Resource.getString("TOOL_LOAD"), new ImageIcon(iconkit.loadImageResource(Resource.getString("TOOLIMG_LOAD") + ".png")));
        staticJButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToolBar.this.parent.promptOpen();
            }
        });
        this.addButton("general", staticJButton);
        staticJButton = new StaticJButton(Resource.getString("TOOL_SAVE"), new ImageIcon(iconkit.loadImageResource(Resource.getString("TOOLIMG_SAVE") + ".png")));
        staticJButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToolBar.this.parent.saveModel();
            }
        });
        this.addButton("general", staticJButton);
        staticJButton = new StaticJButton(Resource.getString("TOOL_PRINT"), new ImageIcon(iconkit.loadImageResource(Resource.getString("TOOLIMG_PRINT") + ".png")));
        staticJButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToolBar.this.parent.promptPrint(false);
            }
        });
        this.addButton("general", staticJButton);
    }

    protected void createDrawingTools() {
        AbstractTool abstractTool = new ModelSelectionTool(this.parent);
        MyToolButton myToolButton = this.createDefaultToolButton(Resource.getString("TOOLIMG_SEL"), Resource.getString("TOOL_SEL"), abstractTool);
        this.parent.setDefaultToolButton(myToolButton);
        this.addButton("drawing", myToolButton);
        abstractTool = new AbstractTool(this.parent){

            public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
                ModelConnectionElement modelConnectionElement;
                super.mouseDown(mouseEvent, n, n2);
                Figure figure = this.drawing().findFigure(n, n2);
                if (figure instanceof ModelFigure) {
                    ModelFigureElement modelFigureElement = ((ModelFigure)figure).getElement();
                    if (modelFigureElement.canDestroy()) {
                        modelFigureElement.destroy();
                    }
                } else if (figure instanceof ModelConnection && (modelConnectionElement = ((ModelConnection)figure).getElement()).canDestroy()) {
                    modelConnectionElement.destroy();
                }
                this.editor().toolDone();
            }
        };
        this.addButton("drawing", this.createMyToolButton(Resource.getString("TOOLIMG_DELETE"), Resource.getString("TOOL_DELETE"), abstractTool));
    }

    protected ToolButton createToolButton(String string, String string2, Tool tool) {
        return new ToolButton(this.parent, string, string2, tool);
    }

    protected MyToolButton createMyToolButton(String string, String string2, Tool tool) {
        MyToolButton myToolButton = new MyToolButton(this.parent, string, string2, tool, false);
        return myToolButton;
    }

    protected MyToolButton createDefaultToolButton(String string, String string2, Tool tool) {
        MyToolButton myToolButton = new MyToolButton(this.parent, string, string2, tool, true);
        return myToolButton;
    }

    protected MyToolButton createBToolButton(String string, String string2, Tool tool) {
        MyToolButton myToolButton = new MyToolButton(this.parent, "/images/BlankoButtonG", string2, tool, false);
        return myToolButton;
    }

    protected ModelFigureElement getPotentialParent(int n, int n2, Drawing drawing) {
        Figure figure = drawing.findFigure(n, n2);
        if (figure instanceof ModelFigure) {
            ModelFigure modelFigure = (ModelFigure)figure;
            ModelFigureElement modelFigureElement = modelFigure.getElement();
            return modelFigureElement;
        }
        return ((ModelDrawing)drawing).getModel();
    }

    protected void checkParent(ModelFigureElement modelFigureElement, Drawing drawing) {
        ModelFigure modelFigure;
        ModelFigureElement modelFigureElement2;
        int n = modelFigureElement.getBounds().x;
        int n2 = modelFigureElement.getBounds().y;
        Figure figure = drawing.findFigure(n, n2);
        if (figure instanceof ModelFigure && ((ModelFigure)figure).getElement() == modelFigureElement) {
            figure = drawing.findFigureWithout(n, n2, figure);
        }
        if (figure instanceof ModelFigure && (modelFigureElement2 = (modelFigure = (ModelFigure)figure).getElement()).canAddChild(modelFigureElement) && modelFigureElement.canSetParent(modelFigureElement2)) {
            modelFigureElement.setParent(modelFigureElement2);
            return;
        }
        modelFigureElement.setParent(((ModelDrawing)drawing).getModel());
    }

    public Application getParentApplication() {
        return this.parent;
    }

    public void enableTool(String string, boolean bl) {
        JComponent jComponent = (JComponent)this.tools.get(string);
        if (jComponent != null) {
            jComponent.setEnabled(bl);
        }
    }

    public void onModelCreated(Application application, Model model) {
    }

    public void onModelDestroying(Application application, Model model) {
    }

    public void onModelLoaded(Application application, Model model) {
    }

    public void onModelSaved(Application application, Model model) {
    }

    public void onModelSelectionChanged(Application application, Model model, ModelElement[] modelElementArray) {
    }

    public void onStateChanged(Application application) {
    }
}

