/*
 * Decompiled with CFR 0.152.
 */
package org.musoft.limo.application;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.standard.GridConstrainer;
import org.musoft.limo.application.Application;
import org.musoft.limo.application.Resource;
import org.musoft.limo.drawing.DrawingPanel;
import org.musoft.limo.drawing.ModelDrawing;
import org.musoft.limo.drawing.ModelDrawingView;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelAdapter;
import org.musoft.limo.model.ModelElement;
import org.musoft.limo.model.ModelFigureElement;
import org.musoft.limo.util.ComponentPane;

public class MainPane
extends ComponentPane
implements Runnable {
    private Application parent;
    private DrawingView drawingView;
    private boolean showDrawingView = true;
    private boolean hasGrid;
    private boolean allowClosing = false;
    private MouseListener closingMouseListener;

    public MainPane(Application application) {
        this.setAlignmentX(0.0f);
        this.parent = application;
        this.closingMouseListener = this.createMouseListenerForClosingTab();
        this.setAllowClosing(true);
        new Thread(this).start();
    }

    protected MouseListener createMouseListenerForClosingTab() {
        return new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                JTabbedPane jTabbedPane = (JTabbedPane)mouseEvent.getSource();
                if (mouseEvent.getButton() == 2 || mouseEvent.getButton() == 3 && jTabbedPane.indexAtLocation(mouseEvent.getPoint().x, mouseEvent.getPoint().y) != -1) {
                    Component component = jTabbedPane.getComponent(jTabbedPane.indexAtLocation(mouseEvent.getPoint().x, mouseEvent.getPoint().y));
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    jPopupMenu.add(new AbstractAction(this, Resource.getString("TMNU_CLOSE"), jTabbedPane, component){
                        private final /* synthetic */ JTabbedPane val$pane;
                        private final /* synthetic */ Component val$tab;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$pane = jTabbedPane;
                            this.val$tab = component;
                        }

                        public void actionPerformed(ActionEvent actionEvent) {
                            this.val$pane.remove(this.val$tab);
                        }
                    });
                    jPopupMenu.add(new AbstractAction(this, Resource.getString("TMNU_CLOSEALL"), jTabbedPane){
                        private final /* synthetic */ JTabbedPane val$pane;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$pane = jTabbedPane;
                        }

                        public void actionPerformed(ActionEvent actionEvent) {
                            this.val$pane.removeAll();
                        }
                    });
                    jPopupMenu.add(new AbstractAction(this, Resource.getString("TMNU_CLOSEALLBUT"), component){
                        private final /* synthetic */ Component val$tab;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$tab = component;
                        }

                        public void actionPerformed(ActionEvent actionEvent) {
                            1.access$000(this.this$1).removeAllBut(this.val$tab);
                        }
                    });
                    jPopupMenu.show(jTabbedPane, mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            static /* synthetic */ MainPane access$000(1 var0) {
                return var0.MainPane.this;
            }
        };
    }

    protected void setDrawingView(DrawingView drawingView) {
        DrawingView drawingView2 = this.drawingView;
        this.drawingView = drawingView;
        this.parent.fireViewSelectionChangedEvent(drawingView2, this.drawingView);
    }

    public DrawingView getDrawingView() {
        return this.drawingView;
    }

    public JPanel getCurrentPanel() {
        return (JPanel)this.getSelectedComponent();
    }

    public void showDrawingView(boolean bl) {
        this.showDrawingView = bl;
    }

    public boolean getShowDrawingView() {
        return this.showDrawingView;
    }

    public DrawingPanel createDrawingViewTab(DrawingView drawingView, String string, String string2) {
        DrawingPanel drawingPanel = new DrawingPanel(drawingView);
        return this.createDrawingViewTab(drawingPanel, string, string2);
    }

    public DrawingPanel createDrawingViewTab(DrawingPanel drawingPanel, String string, String string2) {
        DrawingView drawingView = drawingPanel.getDrawingView();
        this.setDrawingView(drawingView);
        if (this.showDrawingView) {
            drawingPanel.addComponentListener(this.parent);
            if (string2 != null && !string2.equals("")) {
                this.addTab(string, null, drawingPanel, string2);
            } else {
                this.addTab(string, drawingPanel);
            }
            this.setSelectedComponent(drawingPanel);
            drawingPanel.setVisible(true);
        }
        if (drawingView.drawing() instanceof ModelDrawing) {
            Model model = ((ModelDrawing)drawingView.drawing()).getModel();
            model.addListener(new ModelAdapter(){

                public void onDestroy(ModelElement modelElement) {
                    MainPane.this.remove((Model)modelElement);
                }

                public void onRemoveChild(ModelFigureElement modelFigureElement, ModelElement modelElement) {
                    DrawingView drawingView = MainPane.this.getDrawingView();
                    if (drawingView.drawing() instanceof ModelDrawing && ((ModelDrawing)drawingView.drawing()).containsNoFigures() && modelFigureElement.getParent() != null) {
                        MainPane.this.remove((Model)modelFigureElement);
                    }
                }
            });
        }
        if (drawingView instanceof ModelDrawingView) {
            ((ModelDrawingView)drawingView).setConstrainer(this.hasGrid ? new GridConstrainer(10, 10) : null);
        }
        return drawingPanel;
    }

    public DrawingPanel createDrawingViewTab(DrawingView drawingView, String string) {
        return this.createDrawingViewTab(drawingView, string, null);
    }

    public DrawingPanel createDrawingViewTab(DrawingView drawingView) {
        return this.createDrawingViewTab(drawingView, this.parent.getCurrentTabTitle(drawingView), this.parent.getCurrentTabTitleTooltip(drawingView));
    }

    public void remove(Component component) {
        component.removeComponentListener(this.parent);
        super.remove(component);
        if (component instanceof DrawingPanel) {
            System.out.println("DrawingPanel goes away...");
        }
    }

    public void remove(Model model) {
        for (int i = this.getTabCount() - 1; i >= 0; --i) {
            DrawingPanel drawingPanel;
            Drawing drawing;
            if (!(this.getComponentAt(i) instanceof DrawingPanel) || !((drawing = (drawingPanel = (DrawingPanel)this.getComponentAt(i)).getDrawing()) instanceof ModelDrawing) || ((ModelDrawing)drawing).getModel() != model) continue;
            drawingPanel.removeComponentListener(this.parent);
            this.remove(i);
        }
    }

    public void removeAll() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            this.getComponentAt(i).removeComponentListener(this.parent);
        }
        super.removeAll();
    }

    public void removeAllBut(Component component) {
        Component component2;
        int n;
        Vector<Component> vector = new Vector<Component>();
        for (n = 0; n < this.getTabCount(); ++n) {
            component2 = this.getComponentAt(n);
            if (component2 == component) continue;
            vector.add(component2);
        }
        for (n = 0; n < vector.size(); ++n) {
            component2 = (Component)vector.get(n);
            super.remove(component2);
            component2.removeComponentListener(this.parent);
        }
    }

    public boolean getGrid() {
        return this.hasGrid;
    }

    public void setGrid(boolean bl) {
        this.hasGrid = bl;
        GridConstrainer gridConstrainer = this.hasGrid ? new GridConstrainer(10, 10) : null;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            DrawingView drawingView;
            Component component = this.getComponentAt(i);
            if (!(component instanceof DrawingPanel) || !((drawingView = ((DrawingPanel)component).getDrawingView()) instanceof ModelDrawingView)) continue;
            ((ModelDrawingView)drawingView).setConstrainer(gridConstrainer);
        }
    }

    public boolean isAllowClosing() {
        return this.allowClosing;
    }

    public void setAllowClosing(boolean bl) {
        if (this.allowClosing != bl) {
            this.allowClosing = bl;
            if (bl) {
                this.addMouseListener(this.closingMouseListener);
            } else {
                this.removeMouseListener(this.closingMouseListener);
            }
        }
    }

    public Dimension getViewableSize() {
        Dimension dimension;
        JPanel jPanel = this.getCurrentPanel();
        if (jPanel instanceof DrawingPanel) {
            DrawingPanel drawingPanel = (DrawingPanel)jPanel;
            dimension = drawingPanel.getScrollpane().getViewportBorderBounds().getSize();
        } else {
            dimension = this.getSize();
        }
        return dimension;
    }

    public void run() {
        while (true) {
            DrawingPanel drawingPanel;
            DrawingView drawingView;
            JPanel jPanel;
            if ((jPanel = this.getCurrentPanel()) instanceof DrawingPanel && (drawingView = (drawingPanel = (DrawingPanel)jPanel).getDrawingView()) instanceof ModelDrawingView) {
                ((ModelDrawingView)drawingView).checkSize(this.getViewableSize());
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

