/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.storedProcedures;

import edu.udo.cs.miningmart.storedProcedures.Attribute;
import edu.udo.cs.miningmart.storedProcedures.BusinessDbConnectionSource;
import edu.udo.cs.miningmart.storedProcedures.DataType;
import edu.udo.cs.miningmart.storedProcedures.DbConnector;
import edu.udo.cs.miningmart.storedProcedures.OutputColumnset;
import edu.udo.cs.miningmart.storedProcedures.TimeOperatorException;
import edu.udo.cs.miningmart.storedProcedures.Windowing;
import java.sql.SQLException;
import java.util.Vector;

public class ToWindow {
    private final DbConnector connector;
    private final Windowing window;
    private final OutputColumnset out;
    private final int windowSize;

    protected Windowing getWindow() {
        return this.window;
    }

    protected OutputColumnset getOutputColumnset() {
        return this.out;
    }

    protected int getWindowSize() {
        return this.windowSize;
    }

    public ToWindow(BusinessDbConnectionSource dbc, String source, String time, String column, String target, String outTimeStart, String outTimeEnd, String[] targetColumns, int distance) throws SQLException, TimeOperatorException {
        this.connector = new DbConnector(dbc);
        this.windowSize = targetColumns.length;
        String timeDT = DataType.getColumnDataType(source, time, this.connector);
        String columnDT = DataType.getColumnDataType(source, column, this.connector);
        Attribute timeAttr = new Attribute(time, timeDT, timeDT);
        Attribute columnAttr = new Attribute(column, columnDT, dbc.getNameOfNumericDatatype());
        if (!timeAttr.isConvertable()) {
            DataType.wrongDataType(target, timeAttr);
        }
        if (!columnAttr.isConvertable()) {
            DataType.wrongDataType(target, columnAttr);
        }
        Attribute timeStart = new Attribute(outTimeStart, timeDT, timeDT);
        Attribute timeEnd = new Attribute(outTimeEnd, timeDT, timeDT);
        Attribute[] allAttributes = new Attribute[targetColumns.length + 2];
        allAttributes[0] = timeStart;
        allAttributes[1] = timeEnd;
        for (int i = 0; i < targetColumns.length; ++i) {
            allAttributes[i + 2] = new Attribute(targetColumns[i], columnDT, columnDT);
        }
        this.out = new OutputColumnset(target, allAttributes, this.connector.getConnection());
        this.window = new Windowing(targetColumns.length, distance, this.connector);
        if (!this.window.open("SELECT " + columnAttr.getConvertedInput() + ", " + timeAttr.getConvertedInput() + " FROM " + source)) {
            DbConnector.infoOutput("Error while opening " + source);
            throw new TimeOperatorException("Could not read from table '" + source + "'!");
        }
    }

    public void calc() throws TimeOperatorException {
        String[] ret = null;
        do {
            ret = this.getWindow().getNextWnd();
            String start = this.window.getTimeFirstEntry();
            String end = this.window.getTimeLastEntry();
            this.insert(start, end, ret);
        } while (ret != null);
        this.getWindow().close();
        this.connector.close();
    }

    private void insert(String start, String end, String[] value) throws TimeOperatorException {
        if (value == null) {
            return;
        }
        Object[] allValues = new String[this.getWindowSize() + 2];
        allValues[0] = start;
        allValues[1] = end;
        for (int i = 0; i < value.length; ++i) {
            allValues[i + 2] = value[i];
        }
        this.getOutputColumnset().insert(allValues);
    }

    public static void dbWindow(Object dbc, String sourceTable, String timeAttrib, String valueAttrib, String targetTable, String outTimeStart, String outTimeEnd, String outWindowedCols, int distance) throws SQLException, TimeOperatorException {
        String[] tcArray = ToWindow.parseNamesList(outWindowedCols);
        BusinessDbConnectionSource dbcCasted = dbc instanceof BusinessDbConnectionSource ? (BusinessDbConnectionSource)dbc : null;
        ToWindow tw = new ToWindow(dbcCasted, sourceTable, timeAttrib, valueAttrib, targetTable, outTimeStart, outTimeEnd, tcArray, distance);
        tw.calc();
        tw = null;
    }

    private static String[] parseNamesList(String s) {
        if (s == null) {
            return null;
        }
        Vector<String> values = new Vector<String>();
        int stop = 0;
        int from = 0;
        while (from < s.length() && (from = ToWindow.nextNonWhitespace(s, from)) != s.length()) {
            stop = ToWindow.nextWhitespace(s, from);
            String sub = s.substring(from, stop);
            values.add(sub);
            from = stop;
        }
        String[] names = new String[values.size()];
        for (int arg = 0; arg < names.length; ++arg) {
            names[arg] = (String)values.elementAt(arg);
        }
        return names;
    }

    private static int nextNonWhitespace(String s, int index) {
        while (index < s.length() && Character.isWhitespace(s.charAt(index))) {
            ++index;
        }
        return index;
    }

    private static int nextWhitespace(String s, int index) {
        while (index < s.length() && !Character.isWhitespace(s.charAt(index))) {
            ++index;
        }
        return index;
    }
}

