/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.storedProcedures;

import edu.udo.cs.miningmart.storedProcedures.Attribute;
import edu.udo.cs.miningmart.storedProcedures.DbConnector;
import edu.udo.cs.miningmart.storedProcedures.TimeOperatorException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

class OutputColumnset {
    private final String tableName;
    private final Attribute[] attributes;
    private final Connection connection;

    private Connection getConnection() {
        return this.connection;
    }

    private String getTableName() {
        return this.tableName;
    }

    private int getAttributesSize() {
        return this.attributes.length;
    }

    private Attribute getAttribute(int i) {
        if (i >= 0 && i < this.getAttributesSize()) {
            return this.attributes[i];
        }
        return null;
    }

    public OutputColumnset(String tableName, Attribute[] attributes, Connection connection) throws TimeOperatorException {
        boolean created;
        this.tableName = tableName;
        this.attributes = attributes;
        this.connection = connection;
        if (this.tableName == null) {
            throw new TimeOperatorException("No table name specified in constructor of OutputColumnset.");
        }
        if (this.attributes == null) {
            throw new TimeOperatorException("No columns specified in constructor of OutputColumnset.");
        }
        for (int i = 0; i < this.attributes.length; ++i) {
            if (this.attributes[i] != null) continue;
            throw new TimeOperatorException("Null value found in array argument to constructor of OutputColumnset.");
        }
        if (this.connection == null) {
            throw new TimeOperatorException("No database connection specified in constructor of OutputColumnset.");
        }
        boolean deletionWorked = this.deleteDatabaseTable();
        if (!deletionWorked) {
            this.executeUpdateClose("COMMIT");
        }
        if (!(created = this.createDatabaseTable())) {
            throw new TimeOperatorException("Could not create target table '" + this.getTableName() + "' in constructor of OutputColumnset.");
        }
    }

    public void insert(Object[] values) throws TimeOperatorException {
        if (values == null) {
            throw new TimeOperatorException("Trying to insert an array of <null> into table '" + this.getTableName() + "'.");
        }
        if (values.length != this.getAttributesSize()) {
            throw new TimeOperatorException("Trying to insert an array of wrong length into table '" + this.getTableName() + "'.");
        }
        String sql = "INSERT INTO " + this.getTableName() + " VALUES ( ";
        for (int i = 0; i < values.length; ++i) {
            String val = this.getAttribute(i).getConvertedOutput(values[i]);
            if (val == null) {
                throw new TimeOperatorException("Trying to insert an object of unconvertable type into table '" + this.getTableName() + "'.");
            }
            sql = sql + val + (i < values.length - 1 ? ", " : " )");
        }
        DbConnector.infoOutput("DB Query: " + sql);
        if (!this.executeUpdateClose(sql)) {
            throw new TimeOperatorException("An error occurred trying to insert values into table '" + this.getTableName() + "'\nInsert statement was: " + sql);
        }
    }

    public boolean createIndexOn(int i) {
        String attrName = this.getAttribute(i).getName();
        if (attrName == null) {
            return false;
        }
        String sql = "CREATE INDEX " + this.getTableName() + "_idx ON " + this.getTableName() + " ( " + attrName + " )";
        return this.executeUpdateClose(sql);
    }

    public boolean createIndexOn(int i, int j) {
        if (i == j) {
            return this.createIndexOn(i);
        }
        String attrName1 = this.getAttribute(i).getName();
        String attrName2 = this.getAttribute(j).getName();
        if (attrName1 == null || attrName2 == null) {
            return false;
        }
        String sql = "CREATE INDEX " + this.getTableName() + "_idx ON " + this.getTableName() + " ( " + attrName1 + ", " + attrName2 + " )";
        return this.executeUpdateClose(sql);
    }

    private boolean deleteDatabaseTable() {
        String delSql = "DROP TABLE " + this.getTableName();
        DbConnector.infoOutput("INFO: Deleting " + this.getTableName());
        return this.executeUpdateClose(delSql);
    }

    private boolean createDatabaseTable() {
        String sql = "CREATE TABLE " + this.getTableName() + " (";
        int size = this.getAttributesSize();
        for (int i = 0; i < size; ++i) {
            String attrName = this.getAttribute(i).getName();
            String attrType = this.getAttribute(i).getDataTypeName();
            sql = sql + attrName + " " + attrType + (i < size - 1 ? ", " : ")");
        }
        DbConnector.infoOutput("INFO: Creating " + sql);
        return this.executeUpdateClose(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeUpdateClose(String sql) {
        if (sql == null) {
            return false;
        }
        boolean ret = true;
        Statement stmt = null;
        try {
            stmt = this.getConnection().createStatement();
            stmt.executeUpdate(sql);
        }
        catch (SQLException e) {
            DbConnector.infoOutput(e.getMessage());
            ret = false;
        }
        finally {
            OutputColumnset.closeStatement(stmt);
        }
        return ret;
    }

    private static void closeStatement(Statement statement) {
        if (statement == null) {
            return;
        }
        try {
            statement.close();
            statement = null;
        }
        catch (SQLException e) {
            DbConnector.infoOutput(e.getMessage());
        }
    }
}

