/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.schemamatching;

import edu.udo.cs.miningmart.schemamatching.SchemaMatchException;
import edu.udo.cs.miningmart.schemamatching.StringBasedSchemaMatcher;

public class NgramMatcher
extends StringBasedSchemaMatcher {
    private int n = 3;

    public NgramMatcher(int n) {
        this.n = n;
    }

    public double getStringSimilarity(String str1, String str2) throws SchemaMatchException {
        if (str1 == null || str2 == null) {
            return 0.0;
        }
        if (str1.length() <= this.n && str2.length() <= this.n) {
            return this.getNgramSimilarity(str1, str2);
        }
        String longestString = str1.length() > str2.length() ? str1 : str2;
        int numberOfPossibleMatches = longestString.length() - this.n + 1;
        int numberOfActualMatches = 0;
        for (int i = 0; i < str1.length(); ++i) {
            int maxIndex = Math.min(i + this.n, str1.length());
            String first = str1.substring(i, maxIndex);
            for (int j = 0; j < str2.length(); ++j) {
                maxIndex = Math.min(j + this.n, str2.length());
                String second = str2.substring(j, maxIndex);
                if (!(this.getNgramSimilarity(first, second) > 0.0)) continue;
                ++numberOfActualMatches;
            }
        }
        if (numberOfActualMatches > numberOfPossibleMatches) {
            return 1.0;
        }
        return (double)numberOfActualMatches / (double)numberOfPossibleMatches;
    }

    private double getNgramSimilarity(String ngram1, String ngram2) {
        String n1 = ngram1.toLowerCase();
        String n2 = ngram2.toLowerCase();
        if (n1.length() < n2.length() && n2.startsWith(n1)) {
            return 0.75;
        }
        if (n1.length() > n2.length() && n1.startsWith(n2)) {
            return 0.75;
        }
        if (n1.length() == n2.length() && n2.equals(n1)) {
            return 1.0;
        }
        return 0.0;
    }
}

