/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.schemamatching;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.schemamatching.MatchingResult;
import edu.udo.cs.miningmart.schemamatching.SchemaMatchException;
import java.util.Collection;
import java.util.Iterator;

public abstract class MmSchemaMatcher {
    private double thresholdForComparingAttribs = 0.5;
    private double thresholdForComparingConcepts = 0.5;

    public double getThresholdForComparingAttributes() {
        return this.thresholdForComparingAttribs;
    }

    public double getThresholdForComparingConcepts() {
        return this.thresholdForComparingConcepts;
    }

    public abstract double getDirectSimilarity(BaseAttribute var1, BaseAttribute var2) throws SchemaMatchException;

    public abstract double getDirectSimilarity(Concept var1, Concept var2) throws SchemaMatchException;

    public abstract double getSimilarityInvolvingConcepts(BaseAttribute var1, BaseAttribute var2) throws SchemaMatchException;

    public double getSimilarity(Concept con1, Concept con2) throws SchemaMatchException {
        try {
            boolean conceptNamesMatch = false;
            double conceptSimilarity = this.getDirectSimilarity(con1, con2);
            conceptNamesMatch = conceptSimilarity >= this.getThresholdForComparingConcepts();
            boolean numberOfFeaturesMatches = false;
            if (con1.getFeatures().size() == con2.getFeatures().size()) {
                numberOfFeaturesMatches = true;
            }
            Collection basOfCon1 = con1.getAllBaseAttributes();
            Collection basOfCon2 = con2.getAllBaseAttributes();
            int maximumNumberOfMatches = basOfCon1.size() * basOfCon2.size();
            int countOfMatchingFeatures = 0;
            Iterator it1 = con1.getAllBaseAttributes().iterator();
            while (it1.hasNext()) {
                BaseAttribute myBa1 = (BaseAttribute)it1.next();
                Iterator it2 = con2.getAllBaseAttributes().iterator();
                while (it2.hasNext()) {
                    BaseAttribute myBa2 = (BaseAttribute)it2.next();
                    if (!(this.getDirectSimilarity(myBa1, myBa2) >= this.getThresholdForComparingAttributes())) continue;
                    ++countOfMatchingFeatures;
                }
            }
            if (countOfMatchingFeatures > maximumNumberOfMatches) {
                throw new M4Exception("MmSchemaMatcher.getSimilarity: found more matches than possible!");
            }
            double ratio = (double)countOfMatchingFeatures / (double)maximumNumberOfMatches;
            if (conceptNamesMatch && numberOfFeaturesMatches && ratio >= 0.99) {
                return 1.0;
            }
            if (conceptNamesMatch || numberOfFeaturesMatches) {
                return 1.5 * ratio >= 0.99 ? 1.0 : 1.5 * ratio;
            }
            return ratio;
        }
        catch (M4Exception m4e) {
            throw new SchemaMatchException("StringEqualityMatcher.getSimilarity(Concept, Concept): M4Exception caught: " + m4e.getMessage());
        }
    }

    public MatchingResult[][] getSimilarityMatrix(Concept con1, Concept con2) throws SchemaMatchException {
        try {
            int n = con1.getAllBaseAttributes().size();
            int m = con2.getAllBaseAttributes().size();
            MatchingResult[][] result = new MatchingResult[n][m];
            Iterator it1 = con1.getAllBaseAttributes().iterator();
            int n_index = 0;
            int m_index = 0;
            while (it1.hasNext()) {
                BaseAttribute myBa1 = (BaseAttribute)it1.next();
                Iterator it2 = con2.getAllBaseAttributes().iterator();
                m_index = 0;
                while (it2.hasNext()) {
                    BaseAttribute myBa2 = (BaseAttribute)it2.next();
                    result[n_index][m_index] = new MatchingResult();
                    result[n_index][m_index].setBaOfFirstSchema(myBa1);
                    result[n_index][m_index].setBaOfSecondSchema(myBa2);
                    result[n_index][m_index].setSimilarity(this.getDirectSimilarity(myBa1, myBa2));
                    ++m_index;
                }
                ++n_index;
            }
            return result;
        }
        catch (M4Exception m4e) {
            throw new SchemaMatchException("StringEqualityMatcher.getSimilarityMatrix: M4Exception caught: " + m4e.getMessage());
        }
    }
}

