/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.schemamatching;

import edu.udo.cs.miningmart.schemamatching.SchemaMatchException;
import edu.udo.cs.miningmart.schemamatching.StringBasedSchemaMatcher;

public class EditDistanceMatcher
extends StringBasedSchemaMatcher {
    public double getStringSimilarity(String str1, String str2) throws SchemaMatchException {
        int levenshteinDistance = this.getLevenshteinDistance(str1, str2);
        if (levenshteinDistance == 0) {
            return 1.0;
        }
        String longestString = str1.length() > str2.length() ? str1 : str2;
        return 1 - 1 / longestString.length() * levenshteinDistance;
    }

    public int getLevenshteinDistance(String s, String t) {
        int j;
        int i;
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[][] d = new int[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            char s_i = s.charAt(i - 1);
            for (j = 1; j <= m; ++j) {
                char t_j = t.charAt(j - 1);
                int cost = s_i == t_j ? 0 : 1;
                d[i][j] = this.minimum(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1] + cost);
            }
        }
        return d[n][m];
    }

    private int minimum(int a, int b, int c) {
        int min = a;
        if (b < min) {
            min = b;
        }
        if (c < min) {
            min = c;
        }
        return min;
    }
}

