/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator.uep;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Feature;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.operator.FeatureSelection;
import java.util.ArrayList;

public abstract class UepFeatureSelection
extends FeatureSelection {
    protected Column theClassAttribute;
    String[] ClassAttrEl;

    public BaseAttribute getTheClassAttribute() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter("TheClassAttribute");
    }

    public Value getNoOfAttributes() throws M4CompilerError {
        return (Value)this.getSingleParameter("NoOfAttributes");
    }

    protected myData selectTheBestAttr(ArrayList selected, ArrayList removed) throws M4CompilerError {
        Feature[] tmpF = new Feature[selected.size() + 1];
        for (int i = 0; i < selected.size(); ++i) {
            tmpF[i] = (Feature)selected.get(i);
        }
        double Max = -1.0;
        int MaxID = -1;
        for (int i = 0; i < removed.size(); ++i) {
            tmpF[tmpF.length - 1] = (Feature)removed.get(i);
            double MI = this.getMutualInforation(new myTable(this.getM4Db().getFrquencyTable(this.theClassAttribute, tmpF, this.ClassAttrEl)));
            if (!(MI > Max)) continue;
            Max = MI;
            MaxID = i;
        }
        return new myData(Max, MaxID);
    }

    protected myData selectTheWorstAttr(ArrayList selected) throws M4CompilerError {
        Feature[] tmpF = new Feature[selected.size() - 1];
        for (int i = 1; i < selected.size(); ++i) {
            tmpF[i - 1] = (Feature)selected.get(i);
        }
        double Max = this.getMutualInforation(new myTable(this.getM4Db().getFrquencyTable(this.theClassAttribute, tmpF, this.ClassAttrEl)));
        int MaxID = 0;
        for (int i = 0; i < selected.size() - 1; ++i) {
            tmpF[i] = (Feature)selected.get(i);
            double MI = this.getMutualInforation(new myTable(this.getM4Db().getFrquencyTable(this.theClassAttribute, tmpF, this.ClassAttrEl)));
            if (!(MI > Max)) continue;
            Max = MI;
            MaxID = i + 1;
        }
        return new myData(Max, MaxID);
    }

    protected double getMutualInforation(myTable tbl) {
        int rs = tbl.Rows();
        int cs = tbl.Columns();
        double x = 0.0;
        for (int r = 0; r < rs - 1; ++r) {
            for (int c = 1; c < cs - 1; ++c) {
                if (tbl.Cell(r, c) <= 0L) continue;
                double t1 = (double)tbl.Cell(r, c) / (double)tbl.Cell(rs - 1, cs - 1);
                double t2 = (double)tbl.Cell(rs - 1, cs - 1) * (double)tbl.Cell(r, c) / ((double)tbl.Cell(r, cs - 1) * (double)tbl.Cell(rs - 1, c));
                double t3 = Math.log(t2);
                x += t1 * t3;
            }
        }
        return x;
    }

    protected class myData {
        public double MI;
        public int Index;

        public myData(double MutualInformation, int ID) {
            this.MI = MutualInformation;
            this.Index = ID;
        }
    }

    protected class myTable {
        private ArrayList Rs = new ArrayList();
        private myColumn[] Cs;

        public myTable(long Columns) {
            this.Cs = new myColumn[(int)Columns];
        }

        myTable(String[][] TableData) {
            this.Cs = new myColumn[TableData[0].length - 1];
            for (int i = 0; i < TableData.length; ++i) {
                long[] Vals = new long[TableData[0].length - 1];
                for (int n = 1; n < TableData[0].length; ++n) {
                    Vals[n - 1] = Long.parseLong(TableData[i][n]);
                }
                this.addRow(TableData[i][0], Vals);
            }
        }

        public boolean addRow(String Name, long[] Values2) {
            if (Values2.length == this.Cs.length) {
                myRow row = new myRow(Name, Values2, this.Cs);
                this.Rs.add(row);
                for (int i = 0; i < this.Cs.length; ++i) {
                    myCell cell = row.cells[i];
                    this.Cs[i] = new myColumn();
                    this.Cs[i].cells.add(cell);
                }
                return true;
            }
            return false;
        }

        public void print() {
            for (int i = 0; i < this.Rs.size(); ++i) {
                myRow row = (myRow)this.Rs.get(i);
                String s = row.name;
                for (int n = 0; n < row.cells.length; ++n) {
                    s = s + "\t" + row.cells[n].value;
                }
                UepFeatureSelection.this.doPrint(Print.MAX, s);
            }
        }

        public int Rows() {
            return this.Rs.size();
        }

        public int Columns() {
            return this.Cs.length;
        }

        public long Cell(int Row, int Column2) {
            return ((myRow)this.Rs.get((int)Row)).cells[Column2].value;
        }

        public long Cell(String Row, String Column2) {
            int i = 0;
            myRow row = (myRow)this.Rs.get(i);
            while (!row.equals(Row)) {
                row = (myRow)this.Rs.get(++i);
            }
            i = 0;
            while (!this.Cs[i].equals(Column2)) {
                ++i;
            }
            return row.cells[i].value;
        }

        private class myColumn {
            ArrayList cells = new ArrayList();
            String name;

            private myColumn() {
            }
        }

        private class myRow {
            myCell[] cells;
            String name;

            myRow(String Name, long[] Values2, myColumn[] Cs) {
                this.name = Name;
                this.cells = new myCell[Values2.length];
                for (int i = 0; i < Values2.length; ++i) {
                    this.cells[i] = new myCell();
                    this.cells[i].row = this;
                    this.cells[i].col = Cs[i];
                    this.cells[i].value = Values2[i];
                }
            }
        }

        private class myCell {
            myRow row;
            myColumn col;
            long value;

            private myCell() {
            }
        }
    }
}

